<?php $__env->startSection('content'); ?>
<div class="app-page-title">
  <div class="page-title-wrapper">
    <div class="page-title-heading">
      <div class="page-title-icon">
        <i class="pe-7s-car icon-gradient bg-mean-fruit"></i>
      </div>
      <div>
        <?php if(Auth::user()->hasRole('admin_marshal') || Auth::user()->hasRole('admin')): ?>
        Dashboard
        <?php elseif(Auth::user()->hasRole('site_marshal') || Auth::user()->hasRole('sitemarshal')): ?>
        Marshal's Portal
        <?php elseif(Auth::user()->hasRole('vendor')): ?>
        Vendor's Portal
        <?php elseif(Auth::user()->hasRole('client')): ?>
        Client's Portal
        <?php endif; ?>
        <div class="page-title-subheading">
          Welcome <strong><?php echo e(Auth::user()->name); ?></strong> <code><?php echo e(Auth::user()->getRoleNames()); ?></code>
        </div>
      </div>
    </div>
  </div>
</div>

<?php if(Auth::user()->hasRole('admin')): ?>
<div id="pp_table1_admin_dash" class="row">
  <div class="col-md">
    <div class="card card-user shadow-sm">

      <div class="card-body">
        <div class="table-responsive px-2">
          
          <?php
//          echo "<pre>";
//          print_r($clients);
//          echo "</pre>";
//          exit;
          ?>

          <table id="table1AdminDas" class="table table-striped table-bordered" style="width:100%">
            <thead>
              <tr style="background: #2458b6;">
                <th>Client</th>
                <th>Assigned Vendor</th>
                <th>Assigned Marshall</th>
                <th>Commission</th>
                <th>Issue Raised</th>
                <th>Average Ticket Size</th>
              </tr>
            </thead>
            <tbody>
              <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e($client->clientname); ?></td>
                <td><?php echo e($client->vendorname); ?></td>
                <td><?php echo e($client->marshalname); ?></td>
                <td><?php echo e($client->vendor_aggregation); ?></td>
                <td>
                  <?php 
                  $raiseaconcers = App\RaiseConcern::where('clientId', $client->clientId)->where('status', 'Processing')->first();
                  //print_r($raiseaconcers);
                  if(isset($raiseaconcers) && $raiseaconcers->status == "Processing") {
                  ?>
                  <a href="<?php echo e(url('all/concern')); ?>" style="color: red; font-weight: bold; font-size: 22px;">Yes</a>
                  <?php } else { ?>
                  <span style="color: green; font-weight: bold; font-size: 22px;">NO</span>
                  <?php } ?>
                </td>
                <td>-</td>
              </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
<!--            <tfoot>
              <tr>
                <th>Name</th>
                <th>Position</th>
                <th>Office</th>
                <th>Age</th>
                <th>Start date</th>
                <th>Salary</th>
              </tr>
            </tfoot>-->
          </table>

        </div>
      </div>

    </div>
  </div>
</div>

<?php $__env->startSection('customscript'); ?>
<link href="<?php echo e(asset('public/dataTable/dataTables.bootstrap.min.css')); ?>" rel="stylesheet">
<!--<link href="https://cdn.datatables.net/1.10.22/css/jquery.dataTables.min.css" rel="stylesheet">-->
<script type="text/javascript" src="<?php echo e(asset('public/dataTable/jquery.dataTables.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('public/dataTable/jquery-3.5.1.js')); ?>"></script>
<script>
  $(document).ready(function() {
    $.noConflict();
    $('#table1AdminDas').DataTable();
  } );
</script>
<?php $__env->stopSection(); ?>

<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.masterDashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp7.4\htdocs\foodycraft\resources\views/components/content.blade.php ENDPATH**/ ?>