
<?php $__env->startSection('content'); ?>
<?php
    $roleName = isset($result['foodscraftRole']) && !empty($result['foodscraftRole']) ? strtolower($result['foodscraftRole']) : (isset($roleType) && !empty($roleType) ? strtolower($roleType) : '');
    // dd($result, $roleName);
    if(isset($result)){
        $hasAuditRatingOrNot = isset($result['auditRating']) && !empty($result['auditRating']);
        $rating = "";
        switch($result['auditRating']){
            case "lessFive":
                $rating = "Less than 5";
                break;
            case "fiveToSeven":
                $rating = "5-7";
                break;
            case "sevenToNine":
                $rating = "7-9";
                break;
            case "aboveNine":
                $rating = "More than 9";
                break;
            default:
                $rating = $result['auditRating'];
        }
    }
?>
<div class="row">
    <div class="col-md-12">
        <div class="main-card mb-3 card">
            <div class="card-header p-2">
                <h3 class="w-100 text-center">View Vendor Profile</h3>
            </div>
            <div class="card-body">
                <form class="fkformlabel">
                    <?php echo csrf_field(); ?>
                    <input
                        type="hidden"
                        name="id"
                        value="<?php echo e(isset($result['vendorId']) ? $result['vendorId'] : null); ?>"
                    />
                    <input
                        id="foodscraftRole"
                        type="hidden"
                        name="foodscraftRole"
                        value="Vendor"
                        readonly
                    />
                    <div class="row">
                        <div class="col-md-4 col-sm-12 pr-md-1">
                            <div class="form-group">
                                <label for="name">Name of the Company</label>
                                <span class="required-field">*</span>
                                <input
                                    type="text"
                                    id="name"
                                    class="form-control"
                                    autocomplete="off"
                                    name="name"
                                    value="<?php echo e(isset($result['name']) ? $result['name'] : null); ?>"
                                    readonly
                                />
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-12 px-md-1">
                            <div class="form-group">
                                <label for="username">Vendor Code</label>
                                <span class="required-field">*</span>
                                <input
                                    type="text"
                                    id="username"
                                    class="form-control"
                                    autocomplete="off"
                                    name="username"
                                    value="<?php echo e(isset($result['username']) ? $result['username'] : null); ?>"
                                    readonly
                                />
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-12 pl-md-1">
                            <div class="form-group">
                                <label for="email">Email address</label>
                                <span class="required-field">*</span>
                                <input
                                    type="email"
                                    id="email"
                                    class="form-control"
                                    name="email"
                                    required
                                    autocomplete="off"
                                    value="<?php echo e(isset($result['email']) ? $result['email'] : null); ?>"
                                    readonly
                                />
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4 col-sm-12 pr-md-1">
                            <div class="form-group">
                                <label for="contactName">Contact person name</label>
                                <span class="required-field">*</span>
                                <input
                                    id="contactName"
                                    type="text"
                                    class="form-control"
                                    name="contactName"
                                    autocomplete="off"
                                    value="<?php echo e(isset($result['contactName']) ? $result['contactName'] : null); ?>"
                                    readonly
                                />
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-12 px-md-1">
                            <div class="form-group">
                                <label for="contactNumber">Contact Person Number</label>
                                <span class="required-field">*</span>
                                <input
                                    id="contactNumber"
                                    type="tel"
                                    pattern="^[0-9]{10}$"
                                    data-toggle="tooltip"
                                    title="10 Digit Mobile Number Only"
                                    class="form-control"
                                    name="contactNumber"
                                    autocomplete="off"
                                    value="<?php echo e(isset($result['contactNumber']) ? $result['contactNumber'] : null); ?>"
                                    readonly
                                />
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-12 pl-md-1">
                            <div class="form-group">
                                <label for="address">Address</label>
                                <span class="required-field">*</span>
                                <input
                                    id="address"
                                    type="text"
                                    class="form-control"
                                    name="address"
                                    autocomplete="off"
                                    value="<?php echo e(isset($result['address']) ? $result['address'] : null); ?>"
                                    readonly
                                />
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4 col-sm-12 pr-md-1">
                            <div class="form-group">
                                <label for="companyRole">Designation</label>
                                <span class="required-field">*</span>
                                <input
                                    id="companyRole"
                                    type="text"
                                    class="form-control"
                                    name="companyRole"
                                    value="<?php echo e(isset($result['companyRole']) ? $result['companyRole'] : null); ?>"
                                    readonly
                                />
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-12 px-md-1">
                            <div class="form-group">
                                <label for="employeeNumber">No. of employees</label>
                                <span class="required-field">*</span>
                                <input
                                    id="employeeNumber"
                                    type="text"
                                    class="form-control"
                                    name="employeeNumber"
                                    value="<?php echo e(isset($result['employeeNumber']) ? $result['employeeNumber'] : null); ?>"
                                    readonly
                                />
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-12 pl-md-1">
                            <div class="form-group">
                                <label for="yearExp">Years of experience</label>
                                <span class="required-field">*</span>
                                <input
                                    id="yearExp"
                                    type="text"
                                    class="form-control"
                                    pattern="^[1-9]{1|2}$"
                                    data-toggle="tooltip"
                                    title=""
                                    name="yearExp"
                                    value="<?php echo e(isset($result['yearExp']) ? $result['yearExp'] : null); ?>"
                                    readonly
                                />
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4 col-sm-12 pr-md-1">
                            <div class="form-group">
                                <label for="companyType">Company type</label>
                                <span class="required-field">*</span>
                                <select class="form-control" name="companyType" id="companyType" disabled>
                                    <option value=""><?php echo e(isset($result['companyType']) && !empty($result['companyType']) ? $result['companyType'] : 'Select'); ?></option>
                                    <option value="proprietor">Proprietor</option>
                                    <option value="partnership">partnership</option>
                                    <option value="LLP">LLP</option>
                                    <option value="Pvt">PVT LTD.</option>
                                </select>
                            </div>
                        </div>
<!--                        <div class="col-md-4 col-sm-12 px-md-1">
                            <div class="form-group">
                                <label for="vendorScope">Scope of vendor</label>
                                <span class="required-field">*</span>
                                <select class="form-control" name="vendorScope" id="vendorScope" disabled>
                                    <option value=""><?php echo e(isset($result['vendorScope']) && !empty($result['vendorScope']) ? $result['vendorScope'] : 'Select'); ?></option>
                                    <option value="mainMeal">main meal</option>
                                    <option value="tuckShop">tuck shop</option>
                                    <option value="liveMeals">live meals</option>
                                    <option value="mrp">mrp</option>
                                    <option value="beverages">beverages</option>
                                    <option value="healthyMealsSnacks">healthy meals/snacks</option>
                                    <option value="customizedMeals">customized meals</option>
                                    <option value="specializedServices">specialized services</option>
                                    <option value="ODC">ODC</option>
                                    <option value="CorporateEvents">Corporate events</option>
                                </select>
                            </div>
                        </div>-->
                        <div class="col-md-4 col-sm-12 pl-md-1">
                            <div class="form-group">
                                <label for="auditRating">Kitchen audit rating</label>
                                <span class="required-field">*</span>
                                <select class="form-control" name="auditRating" id="auditRating" disabled>
                                    <option value="" checked><?php echo e(isset($hasAuditRatingOrNot) ? $result['auditRating'] : 'Select'); ?></option>
                                    <option value="lessFive">Less than 5</option>
                                    <option value="fiveToSeven">5-7</option>
                                    <option value="sevenToNine">7-9</option>
                                    <option value="aboveNine">More than 9</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-3 col-sm-12 pr-md-1">
                            <div class="form-group">
                                <label for="kitchenArea">Kitchen area</label>
                                <span class="required-field">*</span>
                                <input
                                    id="kitchenArea"
                                    type="text"
                                    class="form-control"
                                    pattern="^[0-9]{1|2|3|4}$"
                                    data-toggle="tooltip"
                                    title="Digits Only"
                                    placeholder="In Sq.ft."
                                    name="kitchenArea"
                                    value="<?php echo e(isset($result['kitchenArea']) ? $result['kitchenArea'] : null); ?>"
                                    readonly
                                />
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-12 px-md-1">
                            <div class="form-group">
                                <label for="mealCapacity">Meal capacity</label>
                                <span class="required-field">*</span>
                                <input
                                    id="mealCapacity"
                                    type="text"
                                    class="form-control"
                                    pattern="[0-9]+"
                                    data-toggle="tooltip"
                                    title="Digits Only"
                                    placeholder="In numbers per day."
                                    name="mealCapacity"
                                    value="<?php echo e(isset($result['mealCapacity']) ? $result['mealCapacity'] : null); ?>"
                                    readonly
                                />
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-12 px-md-1">
                            <div class="form-group">
                                <label for="cameraNumber">No. of camera’s</label>
                                <span class="required-field">*</span>
                                <input
                                    id="cameraNumber"
                                    type="text"
                                    class="form-control"
                                    name="cameraNumber"
                                    value="<?php echo e(isset($result['cameraNumber']) ? $result['cameraNumber'] : null); ?>"
                                    readonly
                                />
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-12 pl-md-1">
                            <div class="form-group">
                                <label for="cameraMegaPixel">Camera Mega Pixel</label>
                                <span class="required-field">*</span>
                                <input
                                    id="cameraMegaPixel"
                                    type="text"
                                    class="form-control"
                                    name="cameraMegaPixel"
                                    value="<?php echo e(isset($result['cameraMegaPixel']) ? $result['cameraMegaPixel'] : null); ?>"
                                    readonly
                                />
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                      <div class="col-sm-12 col-md-12">
                            <div class="form-group">

                                <h6 class="text-center d-flex justify-content-center">
                                    <span class="border-bottom-span border-bottom">Scope of vendor</span>
                                    <span class="required-field">*</span>
                                </h6>

                                <input
                                    class="inp-cbx"
                                    id="mainMeal"
                                    type="checkbox"
                                    name="vendorScope[]"
                                    value="mainMeal"
                                    <?php echo!isset($result['vendorScope']) && empty($result['vendorScope']) ? '' : (in_array("mainMeal", explode(", ", $result["vendorScope"])) ? 'checked disabled' : 'disabled') ?>
                                />
                                <label class="cbx" for="mainMeal">
                                    <span>
                                        <svg width="12px" height="11px" viewBox="0 0 12 11">
                                            <polyline points="1 6.29411765 4.5 10 11 1"></polyline>
                                        </svg>
                                    </span>
                                    <span>Main Meal</span>
                                </label>

                                <input
                                    class="inp-cbx"
                                    id="tuckShop"
                                    type="checkbox"
                                    name="vendorScope[]"
                                    value="tuckShop"
                                    <?php echo!isset($result['vendorScope']) && empty($result['vendorScope']) ? '' : (in_array("tuckShop", explode(", ", $result["vendorScope"])) ? 'checked disabled' : 'disabled') ?>
                                />
                                <label class="cbx" for="tuckShop">
                                    <span>
                                        <svg width="12px" height="11px" viewBox="0 0 12 11">
                                            <polyline points="1 6.29411765 4.5 10 11 1"></polyline>
                                        </svg>
                                    </span>
                                    <span>Tuck Shop</span>
                                </label>

                                <input
                                    class="inp-cbx"
                                    id="livemeals"
                                    type="checkbox"
                                    name="vendorScope[]"
                                    value="livemeals"
                                    <?php echo!isset($result['vendorScope']) && empty($result['vendorScope']) ? '' : (in_array("livemeals", explode(", ", $result["vendorScope"])) ? 'checked disabled' : 'disabled') ?>
                                />
                                <label class="cbx" for="livemeals">
                                    <span>
                                        <svg width="12px" height="11px" viewBox="0 0 12 11">
                                            <polyline points="1 6.29411765 4.5 10 11 1"></polyline>
                                        </svg>
                                    </span>
                                    <span>Live Meals</span>
                                </label>

                                <input
                                    class="inp-cbx"
                                    id="mrp"
                                    type="checkbox"
                                    name="vendorScope[]"
                                    value="mrp"
                                    <?php echo!isset($result['vendorScope']) && empty($result['vendorScope']) ? '' : (in_array("mrp", explode(", ", $result["vendorScope"])) ? 'checked disabled' : 'disabled') ?>
                                />
                                <label class="cbx" for="mrp">
                                    <span>
                                        <svg width="12px" height="11px" viewBox="0 0 12 11">
                                            <polyline points="1 6.29411765 4.5 10 11 1"></polyline>
                                        </svg>
                                    </span>
                                    <span>MRP</span>
                                </label>

                                <input
                                    class="inp-cbx"
                                    id="beverages"
                                    type="checkbox"
                                    name="vendorScope[]"
                                    value="beverages"
                                    <?php echo!isset($result['vendorScope']) && empty($result['vendorScope']) ? '' : (in_array("beverages", explode(", ", $result["vendorScope"])) ? 'checked disabled' : 'disabled') ?>
                                />
                                <label class="cbx" for="beverages">
                                    <span>
                                        <svg width="12px" height="11px" viewBox="0 0 12 11">
                                            <polyline points="1 6.29411765 4.5 10 11 1"></polyline>
                                        </svg>
                                    </span>
                                    <span>Beverages</span>
                                </label>

                                <input
                                    class="inp-cbx"
                                    id="healthyMealsSnacks"
                                    type="checkbox"
                                    name="vendorScope[]"
                                    value="healthyMealsSnacks"
                                    <?php echo!isset($result['vendorScope']) && empty($result['vendorScope']) ? '' : (in_array("healthyMealsSnacks", explode(", ", $result["vendorScope"])) ? 'checked disabled' : 'disabled') ?>
                                />
                                <label class="cbx" for="healthyMealsSnacks">
                                    <span>
                                        <svg width="12px" height="11px" viewBox="0 0 12 11">
                                            <polyline points="1 6.29411765 4.5 10 11 1"></polyline>
                                        </svg>
                                    </span>
                                    <span>Healthy Meals/Snacks</span>
                                </label>
                                
                                <input
                                    class="inp-cbx"
                                    id="customizedMeals"
                                    type="checkbox"
                                    name="vendorScope[]"
                                    value="customizedMeals"
                                    <?php echo!isset($result['vendorScope']) && empty($result['vendorScope']) ? '' : (in_array("customizedMeals", explode(", ", $result["vendorScope"])) ? 'checked disabled' : 'disabled') ?>
                                />
                                <label class="cbx" for="customizedMeals">
                                    <span>
                                        <svg width="12px" height="11px" viewBox="0 0 12 11">
                                            <polyline points="1 6.29411765 4.5 10 11 1"></polyline>
                                        </svg>
                                    </span>
                                    <span>Customized Meals</span>
                                </label>
                                
                                <input
                                    class="inp-cbx"
                                    id="specializedServices"
                                    type="checkbox"
                                    name="vendorScope[]"
                                    value="specializedServices"
                                    <?php echo!isset($result['vendorScope']) && empty($result['vendorScope']) ? '' : (in_array("specializedServices", explode(", ", $result["vendorScope"])) ? 'checked disabled' : 'disabled') ?>
                                />
                                <label class="cbx" for="specializedServices">
                                    <span>
                                        <svg width="12px" height="11px" viewBox="0 0 12 11">
                                            <polyline points="1 6.29411765 4.5 10 11 1"></polyline>
                                        </svg>
                                    </span>
                                    <span>Specialized Services</span>
                                </label>
                                
                                <input
                                    class="inp-cbx"
                                    id="odc"
                                    type="checkbox"
                                    name="vendorScope[]"
                                    value="odc"
                                    <?php echo!isset($result['vendorScope']) && empty($result['vendorScope']) ? '' : (in_array("odc", explode(", ", $result["vendorScope"])) ? 'checked disabled' : 'disabled') ?>
                                />
                                <label class="cbx" for="odc">
                                    <span>
                                        <svg width="12px" height="11px" viewBox="0 0 12 11">
                                            <polyline points="1 6.29411765 4.5 10 11 1"></polyline>
                                        </svg>
                                    </span>
                                    <span>ODC</span>
                                </label>
                                
                                <input
                                    class="inp-cbx"
                                    id="corporateEvents"
                                    type="checkbox"
                                    name="vendorScope[]"
                                    value="corporateEvents"
                                    <?php echo!isset($result['vendorScope']) && empty($result['vendorScope']) ? '' : (in_array("corporateEvents", explode(", ", $result["vendorScope"])) ? 'checked disabled' : 'disabled') ?>
                                />
                                <label class="cbx" for="corporateEvents">
                                    <span>
                                        <svg width="12px" height="11px" viewBox="0 0 12 11">
                                            <polyline points="1 6.29411765 4.5 10 11 1"></polyline>
                                        </svg>
                                    </span>
                                    <span>Corporate Events</span>
                                </label>
                            </div>                            
                        </div>
                    </div>  
                    
                    <div class="row">
                      <?php if(isset($result)): ?>
                      <div class="col-md-12 mb-4 p-1 <?php echo e(isset($result['documents']) && !empty($result['documents']) ? '' : 'd-flex justify-content-center'); ?>">
                        <?php if(isset($result['documents']) && !empty($result['documents'])): ?>
                        <?php
                        $url = asset('storage/app/public/documents/vendors') . '/' . $result['vendorId'] . '/';
                        $elements = $result['documents'][0];
                        ?>
<!--                        <div class="row mb-4">
                          <?php if(!empty($elements['companyProfile'])): ?>
                          <div class="col-md-4 col-sm-12 pr-md-1 d-flex justify-content-center">
                            <button class="btn btn-info w-50" data-toggle="tooltip" title="<?php echo e($elements['companyProfile']); ?>">
                              <a class="text-decoration-none text-white" href="<?php echo e($url.$elements['companyProfile']); ?>" target="_blank">Company Profile</a>
                            </button>
                          </div>
                          <?php endif; ?>
                          <?php if(!empty($elements['fssai'])): ?>
                          <div class="col-md-4 col-sm-12 px-md-1 d-flex justify-content-center">
                            <button class="btn btn-info w-50" data-toggle="tooltip" title="<?php echo e($elements['fssai']); ?>">
                              <a class="text-decoration-none text-white" href="<?php echo e($url.$elements['fssai']); ?>" target="_blank">Fssai</a>
                            </button>
                          </div>
                          <?php endif; ?>
                          <?php if(!empty($elements['gst'])): ?>
                          <div class="col-md-4 col-sm-12 pl-md-1 d-flex justify-content-center">
                            <button class="btn btn-info w-50" data-toggle="tooltip" title="<?php echo e($elements['gst']); ?>">
                              <a class="text-decoration-none text-white" href="<?php echo e($url.$elements['gst']); ?>" target="_blank">GST</a>
                            </button>
                          </div>
                          <?php endif; ?>
                        </div>
                        <div class="row mt-4">
                          <?php if(!empty($elements['panCard'])): ?>
                          <div class="col-md-4 col-sm-12 pr-md-1 d-flex justify-content-center">
                            <button class="btn btn-info w-50" data-toggle="tooltip" title="<?php echo e($elements['panCard']); ?>">
                              <a class="text-decoration-none text-white" href="<?php echo e($url.$elements['panCard']); ?>" target="_blank">Pan Card</a>
                            </button>
                          </div>
                          <?php endif; ?>
                          <?php if(!empty($elements['companyReg'])): ?>
                          <div class="col-md-4 col-sm-12 px-md-1 d-flex justify-content-center">
                            <button class="btn btn-info w-50" data-toggle="tooltip" title="<?php echo e($elements['companyReg']); ?>">
                              <a class="text-decoration-none text-white" href="<?php echo e($url.$elements['companyReg']); ?>" target="_blank">Company Registration</a>
                            </button>
                          </div>
                          <?php endif; ?>
                          <?php if(!empty($elements['pf'])): ?>
                          <div class="col-md-4 col-sm-12 pl-md-1 d-flex justify-content-center">
                            <button class="btn btn-info w-50" data-toggle="tooltip" title="<?php echo e($elements['pf']); ?>">
                              <a class="text-decoration-none text-white" href="<?php echo e($url.$elements['pf']); ?>" target="_blank">Provident Fund</a>
                            </button>
                          </div>
                          <?php endif; ?>
                        </div>
                        <div class="row mt-4">
                          <?php if(!empty($elements['labourLicense'])): ?>
                          <div class="col-md-4 col-sm-12 pr-md-1 d-flex justify-content-center">
                            <button class="btn btn-info w-50" data-toggle="tooltip" title="<?php echo e($elements['labourLicense']); ?>">
                              <a class="text-decoration-none text-white" href="<?php echo e($url.$elements['labourLicense']); ?>" target="_blank">Labour License</a>
                            </button>
                          </div>
                          <?php endif; ?>
                          <?php if(!empty($elements['workerHealth'])): ?>
                          <div class="col-md-4 col-sm-12 px-md-1 d-flex justify-content-center">
                            <button class="btn btn-info w-50" data-toggle="tooltip" title="<?php echo e($elements['workerHealth']); ?>">
                              <a class="text-decoration-none text-white" href="<?php echo e($url.$elements['workerHealth']); ?>" target="_blank">Worker Health</a>
                            </button>
                          </div>
                          <?php endif; ?>
                          <?php if(!empty($elements['foodTestReport'])): ?>
                          <div class="col-md-4 col-sm-12 pl-md-1 d-flex justify-content-center">
                            <button class="btn btn-info w-50" data-toggle="tooltip" title="<?php echo e($elements['foodTestReport']); ?>">
                              <a class="text-decoration-none text-white" href="<?php echo e($url.$elements['foodTestReport']); ?>" target="_blank">Food Test Report</a>
                            </button>
                          </div>
                          <?php endif; ?>
                        </div>
                        <div class="row mt-4">
                          <?php if(!empty($elements['waterTestReport'])): ?>
                          <div class="col-md-4 col-sm-12 pr-md-1 d-flex justify-content-center">
                            <button class="btn btn-info w-50" data-toggle="tooltip" title="<?php echo e($elements['waterTestReport']); ?>">
                              <a class="text-decoration-none text-white" href="<?php echo e($url.$elements['waterTestReport']); ?>" target="_blank">Water Test Report</a>
                            </button>
                          </div>
                          <?php endif; ?>
                          <?php if(!empty($elements['pestControlReport'])): ?>
                          <div class="col-md-4 col-sm-12 px-md-1 d-flex justify-content-center">
                            <button class="btn btn-info w-50" data-toggle="tooltip" title="<?php echo e($elements['pestControlReport']); ?>">
                              <a class="text-decoration-none text-white" href="<?php echo e($url.$elements['pestControlReport']); ?>" target="_blank">Pest Control Report</a>
                            </button>
                          </div>
                          <?php endif; ?>
                          <?php if(!empty($elements['kitchenAuditReport'])): ?>
                          <div class="col-md-4 col-sm-12 pl-md-1 d-flex justify-content-center">
                            <button class="btn btn-info w-50" data-toggle="tooltip" title="<?php echo e($elements['kitchenAuditReport']); ?>">
                              <a class="text-decoration-none text-white" href="<?php echo e($url.$elements['kitchenAuditReport']); ?>" target="_blank">Kitchen Audit Report</a>
                            </button>
                          </div>
                          <?php endif; ?>
                        </div>
                        <div class="row mt-4">
                          <?php if(!empty($elements['policeVerificationReport'])): ?>
                          <div class="col-md-6 col-sm-12 pr-md-1 d-flex justify-content-center">
                            <button class="btn btn-info w-50" data-toggle="tooltip" title="<?php echo e($elements['policeVerificationReport']); ?>">
                              <a class="text-decoration-none text-white" href="<?php echo e($url.$elements['policeVerificationReport']); ?>" target="_blank">Police Verification Report</a>
                            </button>
                          </div>
                          <?php endif; ?>
                          <?php if(!empty($elements['cancelledCheque'])): ?>
                          <div class="col-md-6 col-sm-12 px-md-1 d-flex justify-content-center">
                            <button class="btn btn-info w-50" data-toggle="tooltip" title="<?php echo e($elements['cancelledCheque']); ?>">
                              <a class="text-decoration-none text-white" href="<?php echo e($url.$elements['cancelledCheque']); ?>" target="_blank">Cancelled Cheque</a>
                            </button>
                          </div>
                          <?php endif; ?>
                        </div>-->
                        
                        
                        
                        <div class="row justify-content-center">
                          <?php if(!empty($elements['companyProfile'])): ?>
                              <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                  <div class="form-group mb-1">
                                      <a
                                          class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                          data-toggle="tooltip"
                                          target="_blank"
                                          title="<?php echo e($elements['companyProfile']); ?>"
                                          href="<?php echo e($url.$elements['companyProfile']); ?>"
                                      >
                                          Company Profile
                                      </a>
                                  </div>
                              </div>
                          <?php endif; ?>
                      </div>
                      <div class="row justify-content-center">
                          <?php if(!empty($elements['fssai'])): ?>
                              <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                  <a
                                      class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                      data-toggle="tooltip"
                                      target="_blank"
                                      title="<?php echo e($elements['fssai']); ?>"
                                      href="<?php echo e($url.$elements['fssai']); ?>"
                                  >
                                      Fssai
                                  </a>
                              </div>
                              <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                  <div class="custom-file">
                                      <div class="input-group p-0 shadow-sm">
                                          <input class="form-control shadow-sm" id="fssai_expiry_date" type="text" name="fssai_expiry_date" value="<?php echo e($elements['fssai_expiry_date']); ?>" readonly>
                                      </div>
                                  </div>
                              </div>
                          <?php endif; ?>
                      </div>
                      <div class="row justify-content-center">
                          <?php if(!empty($elements['gst'])): ?>
                              <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                  <a
                                      class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                      data-toggle="tooltip"
                                      target="_blank"
                                      title="<?php echo e($elements['gst']); ?>"
                                      href="<?php echo e($url.$elements['gst']); ?>"
                                  >
                                      GST
                                  </a>
                              </div>
                              <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                  <div class="custom-file">
                                      <div class="input-group p-0 shadow-sm">
                                          <input class="form-control shadow-sm" id="gst_expiry_date" type="text" name="gst_expiry_date" value="<?php echo e($elements['gst_expiry_date']); ?>" readonly>
                                      </div>
                                  </div>
                              </div>
                          <?php endif; ?>
                      </div>
                      <div class="row justify-content-center">
                          <?php if(!empty($elements['panCard'])): ?>
                              <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                  <a
                                      class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                      data-toggle="tooltip"
                                      target="_blank"
                                      title="<?php echo e($elements['panCard']); ?>"
                                      href="<?php echo e($url.$elements['panCard']); ?>"
                                  >
                                      Pan Card
                                  </a>
                              </div>
                              <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                  <div class="custom-file">
                                      <div class="input-group p-0 shadow-sm">
                                          <input class="form-control shadow-sm" id="pancard_expiry_date" type="text" name="pancard_expiry_date" value="<?php echo e($elements['pancard_expiry_date']); ?>" readonly>
                                      </div>
                                  </div>
                              </div>
                          <?php endif; ?>
                      </div>
                      <div class="row justify-content-center">
                          <?php if(!empty($elements['companyReg'])): ?>
                              <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                  <a
                                      class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                      data-toggle="tooltip"
                                      target="_blank"
                                      title="<?php echo e($elements['companyReg']); ?>"
                                      href="<?php echo e($url.$elements['companyReg']); ?>"
                                  >
                                      Company Registration
                                  </a>
                              </div>
                              <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                  <div class="custom-file">
                                      <div class="input-group p-0 shadow-sm">
                                          <input class="form-control shadow-sm" id="cr_expiry_date" type="text" name="cr_expiry_date" value="<?php echo e($elements['cr_expiry_date']); ?>" readonly>
                                      </div>
                                  </div>
                              </div>
                          <?php endif; ?>
                      </div>
                      <div class="row justify-content-center">
                        <?php if(!empty($elements['pf'])): ?>
                          <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                              <!--<div class="form-group">-->
                                  <a
                                      class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                      data-toggle="tooltip"
                                      target="_blank"
                                      title="<?php echo e($elements['pf']); ?>"
                                      href="<?php echo e($url.$elements['pf']); ?>"
                                  >
                                      PF
                                  </a>
                              <!--</div>-->
                          </div>
                          <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                            <div class="custom-file">
                                <div class="input-group p-0 shadow-sm">
                                    <input class="form-control shadow-sm" id="pf_expiry_date" type="text" name="pf_expiry_date" value="<?php echo e($elements['pf_expiry_date']); ?>" readonly>
                                </div>
                            </div>
                          </div>
                        <?php endif; ?>
                      </div>
                      <div class="row justify-content-center">
                      <?php if(!empty($elements['labourLicense'])): ?>
                          <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                              <!--<div class="form-group">-->
                                  <a
                                      class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                      data-toggle="tooltip"
                                      target="_blank"
                                      title="<?php echo e($elements['labourLicense']); ?>"
                                      href="<?php echo e($url.$elements['labourLicense']); ?>"
                                  >
                                      Labour License
                                  </a>
                              <!--</div>-->
                          </div>
                          <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                              <div class="custom-file">
                                  <div class="input-group p-0 shadow-sm">
                                      <input class="form-control shadow-sm" id="labourLicense_expiry_date" type="text" name="labourLicense_expiry_date" value="<?php echo e($elements['labourLicense_expiry_date']); ?>" readonly>
                                  </div>
                              </div>
                          </div>
                      <?php endif; ?>
                      </div>
                      <div class="row justify-content-center">
                      <?php if(!empty($elements['workerHealth'])): ?>
                          <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                              <!--<div class="form-group">-->
                                  <a
                                      class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                      data-toggle="tooltip"
                                      target="_blank"
                                      title="<?php echo e($elements['workerHealth']); ?>"
                                      href="<?php echo e($url.$elements['workerHealth']); ?>"
                                  >
                                      Worker Health
                                  </a>
                              <!--</div>-->
                          </div>
                          <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                              <div class="custom-file">
                                  <div class="input-group p-0 shadow-sm">
                                      <input class="form-control shadow-sm" id="workerHealth_expiry_date" type="text" name="workerHealth_expiry_date" value="<?php echo e($elements['workerHealth_expiry_date']); ?>" readonly>
                                  </div>
                              </div>
                          </div>
                      <?php endif; ?>
                      </div>
                      <div class="row justify-content-center">
                      <?php if(!empty($elements['foodTestReport'])): ?>
                          <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                              <!--<div class="form-group">-->
                                  <a
                                      class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                      data-toggle="tooltip"
                                      target="_blank"
                                      title="<?php echo e($elements['foodTestReport']); ?>"
                                      href="<?php echo e($url.$elements['foodTestReport']); ?>"
                                  >
                                      Food Test Report
                                  </a>
                              <!--</div>-->
                          </div>
                          <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                            <div class="custom-file">
                                <div class="input-group p-0 shadow-sm">
                                    <input class="form-control shadow-sm" id="foodTestReport_expiry_date" type="text" name="foodTestReport_expiry_date" value="<?php echo e($elements['foodTestReport_expiry_date']); ?>" readonly>
                                </div>
                            </div>
                        </div>
                      <?php endif; ?>
                      </div>
                      <div class="row justify-content-center">
                      <?php if(!empty($elements['waterTestReport'])): ?>
                          <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                              <!--<div class="form-group">-->
                                  <a
                                      class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                      data-toggle="tooltip"
                                      target="_blank"
                                      title="<?php echo e($elements['waterTestReport']); ?>"
                                      href="<?php echo e($url.$elements['waterTestReport']); ?>"
                                  >
                                      Water Test Report
                                  </a>
                              <!--</div>-->
                          </div>
                      <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                            <div class="custom-file">
                                <div class="input-group p-0 shadow-sm">
                                    <input class="form-control shadow-sm" id="waterTestReport_expiry_date" type="text" name="waterTestReport_expiry_date" value="<?php echo e($elements['waterTestReport_expiry_date']); ?>" readonly>
                                </div>
                            </div>
                        </div>
                      <?php endif; ?>
                      </div>
                      <div class="row justify-content-center">
                      <?php if(!empty($elements['pestControlReport'])): ?>
                          <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                              <!--<div class="form-group">-->
                                  <a
                                      class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                      data-toggle="tooltip"
                                      target="_blank"
                                      title="<?php echo e($elements['pestControlReport']); ?>"
                                      href="<?php echo e($url.$elements['pestControlReport']); ?>"
                                  >
                                      Pest Control Report
                                  </a>
                              <!--</div>-->
                          </div>
                      <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                            <div class="custom-file">
                                <div class="input-group p-0 shadow-sm">
                                    <input class="form-control shadow-sm" id="pestControlReport_expiry_date" type="text" name="pestControlReport_expiry_date" value="<?php echo e($elements['pestControlReport_expiry_date']); ?>" readonly>
                                </div>
                            </div>
                        </div>
                      <?php endif; ?>
                      </div>
                      <div class="row justify-content-center">
                      <?php if(!empty($elements['kitchenAuditReport'])): ?>
                          <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                              <!--<div class="form-group">-->
                                  <a
                                      class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                      data-toggle="tooltip"
                                      target="_blank"
                                      title="<?php echo e($elements['kitchenAuditReport']); ?>"
                                      href="<?php echo e($url.$elements['kitchenAuditReport']); ?>"
                                  >
                                      Kitchen Audit Report
                                  </a>
                              <!--</div>-->
                          </div>
                      <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                            <div class="custom-file">
                                <div class="input-group p-0 shadow-sm">
                                    <input class="form-control shadow-sm" id="kitchenAuditReport_expiry_date" type="text" name="kitchenAuditReport_expiry_date" value="<?php echo e($elements['kitchenAuditReport_expiry_date']); ?>" readonly>
                                </div>
                            </div>
                        </div>
                      <?php endif; ?>
                      </div>
                      <div class="row justify-content-center">
                      <?php if(!empty($elements['policeVerificationReport'])): ?>
                          <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                              <!--<div class="form-group">-->
                                  <a
                                      class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                      data-toggle="tooltip"
                                      target="_blank"
                                      title="<?php echo e($elements['policeVerificationReport']); ?>"
                                      href="<?php echo e($url.$elements['policeVerificationReport']); ?>"
                                  >
                                      Police Verification Report
                                  </a>
                              <!--</div>-->
                          </div>
                      <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                            <div class="custom-file">
                                <div class="input-group p-0 shadow-sm">
                                    <input class="form-control shadow-sm" id="policeVerificationReport_expiry_date" type="text" name="policeVerificationReport_expiry_date" value="<?php echo e($elements['policeVerificationReport_expiry_date']); ?>" readonly>
                                </div>
                            </div>
                        </div>
                      <?php endif; ?>
                      </div>
                      <div class="row justify-content-center">
                      <?php if(!empty($elements['cancelledCheque'])): ?>
                          <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                              <!--<div class="form-group">-->
                                  <a
                                      class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                      data-toggle="tooltip"
                                      target="_blank"
                                      title="<?php echo e($elements['cancelledCheque']); ?>"
                                      href="<?php echo e($url.$elements['cancelledCheque']); ?>"
                                  >
                                      Cancelled Cheque
                                  </a>
                              <!--</div>-->
                          </div>
                      <?php endif; ?>
                      </div>
                        
                        
                        
                        
                        
                        <?php else: ?>
                        <div class="badge badge-warning">Documents have not been submitted yet!</div>
                        <?php endif; ?>
                      </div>
                      <?php endif; ?>
                    </div>  

                    <?php if(isset($type) && $type == "view" && isset($listMapfirstdata) && isset($listMapseconddata)): ?>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <h5 class="text-center d-flex justify-content-center">
                                        <span class="border-bottom-span border-bottom">Mapped Client List</span>
                                    </h5>
                                    <div class="card-body">
                                        <div class="table-responsive px-2" style="overflow-x: scroll; overflow-y: hidden;">
                                            <table class="table table-hover">
                                                <thead class="text-dark">
                                                    <tr>
                                                        <th class="text-left" scope="col">S.No.</th> 
                                                        <th class="text-left" scope="col">Name</th>
                                                        <th class="text-left" scope="col">Client Code</th>
                                                        <th class="text-left" scope="col">Contact Number</th>
                                                        <th class="text-left" scope="col">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $__empty_1 = true; $__currentLoopData = $listMapseconddata; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                        <tr>
                                                            <th class="text-left" scope="row"><?php echo e(++$key); ?></th>
                                                            <td class="text-left"><?php echo e($value[0]['name']); ?></td>
                                                            <td class="text-left"><?php echo e($value[0]['username']); ?></td>
                                                            <td class="text-left"><?php echo e($value[0]['contactNumber']); ?></td>
                                                            <td class="d-flex">
                                                                <div class="peterriver" onclick="viewOrEdit('<?php echo e(url('viewOrEditRole')); ?>', 'view', '<?php echo e($value[0]['clientId']); ?>');">View</div> 
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                        <tr>
                                                            <td colspan="7" align="center" class="tablemotfounditem">Not Found any</td>
                                                        </tr>
                                                    <?php endif; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <h5 class="text-center d-flex justify-content-center">
                                        <span class="border-bottom-span border-bottom">Mapped Site Marshall List</span>
                                    </h5>
                                    <div class="card-body">
                                        <div class="table-responsive px-2" style="overflow-x: scroll; overflow-y: hidden;">
                                            <table class="table table-hover">
                                                <thead class="text-dark">
                                                    <tr>
                                                        <th class="text-left" scope="col">S.No.</th> 
                                                        <th class="text-left" scope="col">Name</th>
                                                        <th class="text-left" scope="col">Employee ID</th>
                                                        <th class="text-left" scope="col">Contact Number</th>
                                                        <th class="text-left" scope="col">Designation</th>
                                                        <th class="text-left" scope="col">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $__empty_1 = true; $__currentLoopData = $listMapfirstdata; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                        <tr>
                                                            <th class="text-left" scope="row"><?php echo e(++$key); ?></th>
                                                            <td class="text-left"><?php echo e($value[0]['name']); ?></td>
                                                            <td class="text-left"><?php echo e($value[0]['employeeId']); ?></td>
                                                            <td class="text-left"><?php echo e($value[0]['contactNumber']); ?></td>
                                                            <td class="text-left"><?php echo e($value[0]['designation']); ?></td>
                                                            <td class="d-flex">
                                                                <div class="peterriver" onclick="viewOrEdit('<?php echo e(url('viewOrEditRole')); ?>', 'view', '<?php echo e($value[0]['marshalId']); ?>');">View</div> 
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                        <tr>
                                                            <td colspan="7" align="center" class="tablemotfounditem">Not Found any</td>
                                                        </tr>
                                                    <?php endif; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <div class="row">
                        <div class="update ml-auto mr-auto">
                            <div
                                class="wetasphalt"
                                onclick="redirection('<?php echo e(url()->previous()); ?>');"
                            >
                                Back
                            </div>
                            <div
                                class="sunflower"
                                onclick="viewOrEdit('<?php echo e(url('viewOrEditRole')); ?>', 'edit', '<?php echo e($result['vendorId']); ?>');"
                            >
                                Edit
                            </div>
                            <div
                                class="alizarin"
                                id="confirmRoleDelete"
                                onclick="deleteModal('<?php echo e(url('deleteRole')); ?>', '<?php echo e($result['vendorId']); ?>');"
                            >
                                Delete
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.masterDashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nexaipaybr/public_html/foodycraft/app/Modules/Admin/Views/register/read/read_vendor.blade.php ENDPATH**/ ?>