<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/send/email', 'HomeController@sendMail');

Route::get('/', function () {
    return view('index');
    // return Redirect::to('login');
})->middleware('guest')->name('welcome');

Route::get('/home', function () {
    return view('index');
});

Route::get('/about', function () {
    return view('about');
});

Route::get('/contact', function () {
    return view('contact');
});

Route::get('/make-donation', function () {
    return view('make-donation');
});


Route::get('change-password', 'ChangePasswordController@index');
Route::post('change-password', 'ChangePasswordController@store')->name('change.password');

Auth::routes();

//I-Manage Dashboard
Route::get('/home/{search?}', 'HomeController@index')->name('home');

//I-Count Dashboard
Route::group(['prefix' => 'ICount'], function() {
//    Route::get('{filetoken}', 'CommonController@downloadFiles');
    Route::get('/I-count', 'HomeController@iCount')->name('I-count');
});

Route::any('qr/decode', 'HomeController@qr_decode');
Route::get('view_profile', 'HomeController@view_profile');
Route::get('edit_profile', 'HomeController@edit_profile');
Route::post('update_profile', 'HomeController@update_profile');

Route::get('/FK-app-section', 'HomeController@fkappsection')->name('FK-app-section');

//Import Excel Sheet
Route::get('/import_excel', 'HomeController@importexcel');
Route::post('/import_excel/import', 'HomeController@import');
