<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAIFeedsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('a_i_feeds', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('clientId');
            $table->string('vendorId');
            $table->string('cameraId');
            $table->string('cameraLocation')->references('cameraLocation')->on('vendorcameras');
            $table->string('ai_Feed_Id');
            $table->string('ai_Feed_Type');
            $table->string('ai_Feed_Time');
            $table->string('ai_Feed_ROI');
            $table->string('ai_Feed_Color');
            $table->string('imageLink');
            $table->string('videoId');
            $table->string('videoLink');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ai_feeds');
    }
}
