<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVendorCamerasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('vendor_cameras', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('vendorId')->references('id')->on('users');
            $table->integer('clientId')->references('id')->on('users');
            $table->string('cameraId')->unique();
            $table->string('cameraLocation');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vendor_cameras');
    }
}
