<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMealRateListsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('meal_rate_lists', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('client_id')->references('id')->on('users');
            $table->string('client_code')->unique()->references('username')->on('users');
            $table->bigInteger('breakfast1')->nullable();
            $table->bigInteger('breakfast2')->nullable();
            $table->bigInteger('breakfast3')->nullable();
            $table->bigInteger('lunch1')->nullable();
            $table->bigInteger('lunch2')->nullable();
            $table->bigInteger('lunch3')->nullable();
            $table->bigInteger('dinner1')->nullable();
            $table->bigInteger('dinner2')->nullable();
            $table->bigInteger('dinner3')->nullable();
            $table->bigInteger('snacks1')->nullable();
            $table->bigInteger('snacks2')->nullable();
            $table->bigInteger('snacks3')->nullable();

            $table->char('breakfast_from', 50)->nullable();
            $table->char('breakfast_to', 50)->nullable();
            $table->char('lunch_from', 50)->nullable();
            $table->char('lunch_to', 50)->nullable();
            $table->char('dinner_from', 50)->nullable();
            $table->char('dinner_to', 50)->nullable();
            $table->char('snacks_from', 50)->nullable();
            $table->char('snacks_to', 50)->nullable();

            $table->char('others_name', 50)->nullable();
            $table->bigInteger('others')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('meal_rate_lists');
    }
}
