<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRaiseConcernsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('raise_concerns', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('clientId');
            $table->string('description');
            $table->string('vendorEmail');
            $table->longText('comment')->nullable();
            $table->char('images', 200)->nullable();
            $table->char('videos', 200)->nullable();
            $table->string('status');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('raise_concerns');
    }
}
