<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVendorDocsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('vendor_docs', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('vendorId');
            $table->string('companyProfile')->nullable();
            $table->string('fssai')->nullable();
            $table->string('gst')->nullable();
            $table->string('panCard')->nullable();
            $table->string('companyReg')->nullable();
            $table->string('pf')->nullable();
            $table->string('labourLicense')->nullable();
            $table->string('workerHealth')->nullable();
            $table->string('foodTestReport')->nullable();
            $table->string('waterTestReport')->nullable();
            $table->string('pestControlReport')->nullable();
            $table->string('kitchenAuditReport')->nullable();
            $table->string('policeVerificationReport')->nullable();
            $table->string('cancelledCheque')->nullable();
            $table->string('fssai_expiry_date')->nullable();
            $table->string('gst_expiry_date')->nullable();
            $table->string('pancard_expiry_date')->nullable();
            $table->string('cr_expiry_date')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vendor_docs');
    }
}
