<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVendorsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('vendors', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('vendorId')->references('id')->on('users');
            $table->string('username')->unique()->references('username')->on('users');
            $table->string('contactName');
            $table->string('companyRole');
            $table->bigInteger('employeeNumber');
            $table->bigInteger('yearExp');
            $table->bigInteger('kitchenArea');
            $table->bigInteger('mealCapacity');
            $table->string('companyType');
            $table->string('vendorScope');
            $table->char('auditRating', 100);
            $table->bigInteger('cameraNumber');
            $table->bigInteger('cameraMegaPixel');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vendors');
    }
}
