@extends('layouts.masterDashboard')
@section('content')
    <div class="row">
        <div class="col-md">
            <div class="card card-user" id="reloadCard">
                <div class="card-header pt-4" style="align-self: center;justify-content: center;width: 75%;border-bottom: none;">
                    <h3>Invoices List</h3>
                </div>
                <div class="card-body py-1">
                    <div class="table-responsive px-2" style="overflow-x: scroll; overflow-y: hidden;">
                        <table class="table table-hover">
                            <thead class="text-dark">
                                <tr>
                                    <th class="text-left" scope="col">S.No.</th> 
                                    <th class="text-left" scope="col">Client (Name - Code)</th>
                                    <th class="text-left" scope="col">Meal Rate Total</th>
                                    <th class="text-left" scope="col">Meal Count Total</th>
                                    <th class="text-left" scope="col">Date Range</th>
                                    <th class="text-left" scope="col">Total</th>
                                    <th class="text-center" scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($invoices as $invoice)
                                    <tr>
                                        <th class="text-left" scope="col">{{ $loop->iteration }}</th> 
                                        <th class="text-left" scope="col">{{ $invoice->client_name . ' - ' . $invoice->client_code }}</th>
                                        <th class="text-left" scope="col">{{ round($invoice->meal_rate_total - ($invoice->meal_rate_total * ($vendor_aggregation/100))) }}</th>
                                        <th class="text-left" scope="col">{{ $invoice->meal_count_total }}</th>
                                        <th class="text-left" scope="col">
                                            {{
                                                (isset($invoice->date_from) ? $invoice->date_from : 'N/D')
                                                . ' - ' .
                                                (isset($invoice->date_to) ? $invoice->date_to : 'N/D')
                                            }}
                                        </th>
                                        <th class="text-left" scope="col">{{ round($invoice->total - ($invoice->total * ($vendor_aggregation/100))) }}</th>
                                        <th class="text-center" scope="col">
                                            <form action="{{ url('vendor/ICount/I-count/export_invoice') }}" method="post">
                                                @csrf
                                                <input type="hidden" name="client_code" value="{{ $invoice->client_code }}">
                                                <input type="hidden" name="invoice_id" value="{{ $invoice->id }}">
                                                <input type="hidden" name="date_from" value="{{ $invoice->date_from }}">
                                                <input type="hidden" name="date_to" value="{{ $invoice->date_to }}">
                                                <input type="hidden" name="vendor_aggregation" value="{{ $vendor_aggregation }}">
                                                <input type="submit" value="Export" class="carrot w-auto py-0 px-2">
                                            </form>
                                        </th>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center"></td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer p-0 my-2 border-bottom-0 border-top-0 text-center d-flex justify-content-center" style="align-self: center;color: #d45353;">
                    <h6>{{ isset($invoices) ? $invoices->links() : '' }}</h6>
                </div>
            </div>
        </div>
    </div>
@endsection
