@extends('layouts.masterDashboard')
@section('content')
    <div class="row">
        <div class="col-md">
            <div class="card card-user shadow-sm">
                <div class="card-header d-flex justify-content-center border-0 pt-4">
                    <h3>Edit Vendor Documents</h3>
                </div>
                <div class="card-body">
                    @if($type == "new" || $type == "resubmit")
                        <form method="POST" action="{{ url('vendor/submit/documents') }}" enctype='multipart/form-data'>
                            @csrf
                            <input type="hidden" id="docredirect" name="docredirect" value="docresubmit">
                            @if($type == "resubmit")
                                <h5><strong>Note: </strong><i>Please resubmit the document which is required.</i></h5>
                            @endif
                            <div class="row">
                                
                                <div class="col-md-6 col-sm-12 px-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="companyProfile" lang="es" name="companyProfile" onchange="putName(this);" accept=".doc, .docx, .pdf, .jpg, .jpeg, .png"  />
                                            <label class="custom-file-label" for="companyProfile">Company Profile</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12">
<!--                                    <div class="form-group">
                                        <div class="custom-file">
                                            <div class="input-group p-0 shadow-sm datepicker date">
                                                <input class="form-control shadow-sm" id="fssai_expiry_date" type="text" name="fssai_expiry_date" placeholder="Fssai expiry date" autocomplete="off">
                                                <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                            </div>
                                        </div>
                                    </div>-->
                                </div>
                                
                                <div class="col-md-6 col-sm-12 px-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="fssai" lang="es" name="fssai" onchange="putName(this);" accept=".doc, .docx, .pdf, .jpg, .jpeg, .png"  />
                                            <label class="custom-file-label" for="fssai">Fssai</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <div class="input-group p-0 shadow-sm datepicker date">
                                                <input class="form-control shadow-sm" id="fssai_expiry_date" type="text" name="fssai_expiry_date" placeholder="Fssai expiry date" autocomplete="off">
                                                <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="col-md-6 col-sm-12 px-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="gst" lang="es" name="gst" onchange="putName(this);" accept=".doc, .docx, .pdf, .jpg, .jpeg, .png"  />
                                            <label class="custom-file-label" for="gst">GST</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <div class="input-group p-0 shadow-sm datepicker date">
                                                <input class="form-control shadow-sm" id="gst_expiry_date" type="text" name="gst_expiry_date" placeholder="GST expiry date" autocomplete="off">
                                                <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6 col-sm-12 px-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="panCard" lang="es" name="panCard" onchange="putName(this);" accept=".doc, .docx, .pdf, .jpg, .jpeg, .png"  />
                                            <label class="custom-file-label" for="panCard">Pan Card</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12">
<!--                                    <div class="form-group">
                                        <div class="custom-file">
                                            <div class="input-group p-0 shadow-sm datepicker date">
                                                <input class="form-control shadow-sm" id="pancard_expiry_date" type="text" name="pancard_expiry_date" placeholder="Pan Card expiry date" autocomplete="off">
                                                <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                            </div>
                                        </div>
                                    </div>-->
                                </div>
                                
                                <div class="col-md-6 col-sm-12 px-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="companyReg" lang="es" name="companyReg" onchange="putName(this);" accept=".doc, .docx, .pdf, .jpg, .jpeg, .png"  />
                                            <label class="custom-file-label" for="companyReg">Company Registration</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12">
<!--                                    <div class="form-group">
                                        <div class="custom-file">
                                            <div class="input-group p-0 shadow-sm datepicker date">
                                                <input class="form-control shadow-sm" id="cr_expiry_date" type="text" name="cr_expiry_date" placeholder="Company Registration expiry date" autocomplete="off">
                                                <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                            </div>
                                        </div>
                                    </div>-->
                                </div>
                                
                                <div class="col-md-6 col-sm-12 px-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="pf" lang="es" name="pf" onchange="putName(this);" accept=".doc, .docx, .pdf, .jpg, .jpeg, .png" />
                                            <label class="custom-file-label" for="pf">Provident Fund</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12">
<!--                                  <div class="form-group">
                                    <div class="custom-file">
                                      <div class="input-group p-0 shadow-sm datepicker date">
                                        <input class="form-control shadow-sm" id="pf_expiry_date" type="text" name="pf_expiry_date" placeholder="Provident Fund expiry date" autocomplete="off">
                                        <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                      </div>
                                    </div>
                                  </div>-->
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6 col-sm-12 px-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="labourLicense" lang="es" name="labourLicense" onchange="putName(this);" accept=".doc, .docx, .pdf, .jpg, .jpeg, .png"  />
                                            <label class="custom-file-label" for="labourLicense">Labour License</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12">
<!--                                  <div class="form-group">
                                    <div class="custom-file">
                                      <div class="input-group p-0 shadow-sm datepicker date">
                                        <input class="form-control shadow-sm" id="labourLicense_expiry_date" type="text" name="labourLicense_expiry_date" placeholder="Labour License expiry date" autocomplete="off">
                                        <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                      </div>
                                    </div>
                                  </div>-->
                                </div>
                              
                                <div class="col-md-6 col-sm-12 px-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="workerHealth" lang="es" name="workerHealth" onchange="putName(this);" accept=".doc, .docx, .pdf, .jpg, .jpeg, .png"  />
                                            <label class="custom-file-label" for="workerHealth">Worker Health</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12">
                                  <div class="form-group">
                                    <div class="custom-file">
                                      <div class="input-group p-0 shadow-sm datepicker date">
                                        <input class="form-control shadow-sm" id="workerHealth_expiry_date" type="text" name="workerHealth_expiry_date" placeholder="Worker Health expiry date" autocomplete="off">
                                        <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                                
                                <div class="col-md-6 col-sm-12 px-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="foodTestReport" lang="es" name="foodTestReport" onchange="putName(this);" accept=".doc, .docx, .pdf, .jpg, .jpeg, .png"  />
                                            <label class="custom-file-label" for="foodTestReport">Food Test Report</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12">
                                  <div class="form-group">
                                    <div class="custom-file">
                                      <div class="input-group p-0 shadow-sm datepicker date">
                                        <input class="form-control shadow-sm" id="foodTestReport_expiry_date" type="text" name="foodTestReport_expiry_date" placeholder="Food Test Report expiry date" autocomplete="off">
                                        <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6 col-sm-12 px-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="waterTestReport" lang="es" name="waterTestReport" onchange="putName(this);" accept=".doc, .docx, .pdf, .jpg, .jpeg, .png"  />
                                            <label class="custom-file-label" for="waterTestReport">Water Test Report</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12">
                                  <div class="form-group">
                                    <div class="custom-file">
                                      <div class="input-group p-0 shadow-sm datepicker date">
                                        <input class="form-control shadow-sm" id="waterTestReport_expiry_date" type="text" name="waterTestReport_expiry_date" placeholder="Water Test Report expiry date" autocomplete="off">
                                        <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              
                                <div class="col-md-6 col-sm-12 px-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="pestControlReport" lang="es" name="pestControlReport" onchange="putName(this);" accept=".doc, .docx, .pdf, .jpg, .jpeg, .png"  />
                                            <label class="custom-file-label" for="pestControlReport">Pest Control Report</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12">
                                  <div class="form-group">
                                    <div class="custom-file">
                                      <div class="input-group p-0 shadow-sm datepicker date">
                                        <input class="form-control shadow-sm" id="pestControlReport_expiry_date" type="text" name="pestControlReport_expiry_date" placeholder="Pest Control Report expiry date" autocomplete="off">
                                        <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              
                                <div class="col-md-6 col-sm-12 px-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="kitchenAuditReport" lang="es" name="kitchenAuditReport" onchange="putName(this);" accept=".doc, .docx, .pdf, .jpg, .jpeg, .png"  />
                                            <label class="custom-file-label" for="kitchenAuditReport">Kitchen Audit Report</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12">
                                  <div class="form-group">
                                    <div class="custom-file">
                                      <div class="input-group p-0 shadow-sm datepicker date">
                                        <input class="form-control shadow-sm" id="kitchenAuditReport_expiry_date" type="text" name="kitchenAuditReport_expiry_date" placeholder="Kitchen Audit Report expiry date" autocomplete="off">
                                        <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6 col-sm-12 px-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="policeVerificationReport" lang="es" name="policeVerificationReport" onchange="putName(this);" accept=".doc, .docx, .pdf, .jpg, .jpeg, .png"  />
                                            <label class="custom-file-label" for="policeVerificationReport">Police Verification Report</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12">
<!--                                  <div class="form-group">
                                    <div class="custom-file">
                                      <div class="input-group p-0 shadow-sm datepicker date">
                                        <input class="form-control shadow-sm" id="policeVerificationReport_expiry_date" type="text" name="policeVerificationReport_expiry_date" placeholder="Police Verification Report expiry date" autocomplete="off">
                                        <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                      </div>
                                    </div>
                                  </div>-->
                                </div>
                              
                                <div class="col-md-6 col-sm-12 px-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="cancelledCheque" lang="es" name="cancelledCheque" onchange="putName(this);" accept=".doc, .docx, .pdf, .jpg, .jpeg, .png"  />
                                            <label class="custom-file-label" for="cancelledCheque">Cancelled Cheque</label>
                                        </div>
                                    </div>
                                </div>
<!--                                <div class="col-md-6 col-sm-12">
                                  <div class="form-group">
                                    <div class="custom-file">
                                      <div class="input-group p-0 shadow-sm datepicker date">
                                        <input class="form-control shadow-sm" id="cancelledCheque_expiry_date" type="text" name="cancelledCheque_expiry_date" placeholder="Cancelled Cheque expiry date" autocomplete="off">
                                        <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                      </div>
                                    </div>
                                  </div>
                                </div>-->
                            </div>
                            <div class="row d-flex justify-content-center">
                                <div class="response">
                                    <button type="submit" class="wetasphalt w-100" style="font-weight: bolder;font-size: medium;padding: 0.4rem 1.4rem;">Submit Documents</button>
                                </div>
                            </div>
                        </form>
                    @elseif($type == "submitted")
                        <div>
                            @if(isset($elements) && !empty($elements))
                                <?php
                                    // dd($elements);
                                    $url = asset('storage/app/public/documents/vendors').'/'.Auth::user()->id.'/';
                                ?>
                                <!-- <div class="row mb-4">
                                    <div class="col-md-4 col-sm-12 pr-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['companyProfile'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['companyProfile'] }}" target="_blank">Company Profile</a>
                                        </button>
                                    </div>
                                    <div class="col-md-4 col-sm-12 px-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['fssai'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['fssai'] }}" target="_blank">Fssai</a>
                                        </button>
                                    </div>
                                    <div class="col-md-4 col-sm-12 pl-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['gst'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['gst'] }}" target="_blank">GST</a>
                                        </button>
                                    </div>
                                </div>
                                <div class="row mt-4">
                                    <div class="col-md-4 col-sm-12 pr-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['panCard'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['panCard'] }}" target="_blank">Pan Card</a>
                                        </button>
                                    </div>
                                    <div class="col-md-4 col-sm-12 px-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['companyReg'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['companyReg'] }}" target="_blank">Company Registration</a>
                                        </button>
                                    </div>
                                    <div class="col-md-4 col-sm-12 pl-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['pf'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['pf'] }}" target="_blank">Provident Fund</a>
                                        </button>
                                    </div>
                                </div>
                                <div class="row mt-4">
                                    <div class="col-md-4 col-sm-12 pr-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['labourLicense'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['labourLicense'] }}" target="_blank">Labour License</a>
                                        </button>
                                    </div>
                                    <div class="col-md-4 col-sm-12 px-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['workerHealth'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['workerHealth'] }}" target="_blank">Worker Health</a>
                                        </button>
                                    </div>
                                    <div class="col-md-4 col-sm-12 pl-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['foodTestReport'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['foodTestReport'] }}" target="_blank">Food Test Report</a>
                                        </button>
                                    </div>
                                </div>
                                <div class="row mt-4">
                                    <div class="col-md-4 col-sm-12 pr-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['waterTestReport'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['waterTestReport'] }}" target="_blank">Water Test Report</a>
                                        </button>
                                    </div>
                                    <div class="col-md-4 col-sm-12 px-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['pestControlReport'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['pestControlReport'] }}" target="_blank">Pest Control Report</a>
                                        </button>
                                    </div>
                                    <div class="col-md-4 col-sm-12 pl-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['kitchenAuditReport'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['kitchenAuditReport'] }}" target="_blank">Kitchen Audit Report</a>
                                        </button>
                                    </div>
                                </div>
                                <div class="row mt-4">
                                    <div class="col-md-6 col-sm-12 pr-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['policeVerificationReport'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['policeVerificationReport'] }}" target="_blank">Police Verification Report</a>
                                        </button>
                                    </div>
                                    <div class="col-md-6 col-sm-12 px-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['cancelledCheque'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['cancelledCheque'] }}" target="_blank">Cancelled Cheque</a>
                                        </button>
                                    </div>
                                </div> -->
                                <!-- <div class="row mb-4"> -->
                                <div class="row justify-content-center">
                                    @if($elements['companyProfile'])
                                        <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                            <div class="form-group mb-1">
                                                <a
                                                    class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                                    data-toggle="tooltip"
                                                    target="_blank"
                                                    title="{{ $elements['companyProfile'] }}"
                                                    href="{{ $url.$elements['companyProfile'] }}"
                                                >
                                                    Company Profile
                                                </a>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                                <div class="row justify-content-center">
                                    @if($elements['fssai'])
                                        <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                            <a
                                                class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                                data-toggle="tooltip"
                                                target="_blank"
                                                title="{{ $elements['fssai'] }}"
                                                href="{{ $url.$elements['fssai'] }}"
                                            >
                                                Fssai
                                            </a>
                                        </div>
                                        <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                            <div class="custom-file">
                                                <div class="input-group p-0 shadow-sm">
                                                    <input class="form-control shadow-sm" id="fssai_expiry_date" type="text" name="fssai_expiry_date" value="{{ $elements['fssai_expiry_date'] }}" readonly>
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                                <div class="row justify-content-center">
                                    @if($elements['gst'])
                                        <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                            <a
                                                class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                                data-toggle="tooltip"
                                                target="_blank"
                                                title="{{ $elements['gst'] }}"
                                                href="{{ $url.$elements['gst'] }}"
                                            >
                                                GST
                                            </a>
                                        </div>
                                        <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                            <div class="custom-file">
                                                <div class="input-group p-0 shadow-sm">
                                                    <input class="form-control shadow-sm" id="gst_expiry_date" type="text" name="gst_expiry_date" value="{{ $elements['gst_expiry_date'] }}" readonly>
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                                <div class="row justify-content-center">
                                    @if($elements['panCard'])
                                        <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                            <a
                                                class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                                data-toggle="tooltip"
                                                target="_blank"
                                                title="{{ $elements['panCard'] }}"
                                                href="{{ $url.$elements['panCard'] }}"
                                            >
                                                Pan Card
                                            </a>
                                        </div>
                                        <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                            <div class="custom-file">
                                                <div class="input-group p-0 shadow-sm">
                                                    <input class="form-control shadow-sm" id="pancard_expiry_date" type="text" name="pancard_expiry_date" value="{{ $elements['pancard_expiry_date'] }}" readonly>
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                                <div class="row justify-content-center">
                                    @if($elements['companyReg'])
                                        <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                            <a
                                                class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                                data-toggle="tooltip"
                                                target="_blank"
                                                title="{{ $elements['companyReg'] }}"
                                                href="{{ $url.$elements['companyReg'] }}"
                                            >
                                                Company Registration
                                            </a>
                                        </div>
                                        <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                            <div class="custom-file">
                                                <div class="input-group p-0 shadow-sm">
                                                    <input class="form-control shadow-sm" id="cr_expiry_date" type="text" name="cr_expiry_date" value="{{ $elements['cr_expiry_date'] }}" readonly>
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                                <div class="row justify-content-center">
                                  @if($elements['pf'])
                                    <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                        <!--<div class="form-group">-->
                                            <a
                                                class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                                data-toggle="tooltip"
                                                target="_blank"
                                                title="{{ $elements['pf'] }}"
                                                href="{{ $url.$elements['pf'] }}"
                                            >
                                                PF
                                            </a>
                                        <!--</div>-->
                                    </div>
                                    <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                      <div class="custom-file">
                                          <div class="input-group p-0 shadow-sm">
                                              <input class="form-control shadow-sm" id="pf_expiry_date" type="text" name="pf_expiry_date" value="{{ $elements['pf_expiry_date'] }}" readonly>
                                          </div>
                                      </div>
                                    </div>
                                  @endif
                                </div>
                                <div class="row justify-content-center">
                                @if($elements['labourLicense'])
                                    <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                        <!--<div class="form-group">-->
                                            <a
                                                class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                                data-toggle="tooltip"
                                                target="_blank"
                                                title="{{ $elements['labourLicense'] }}"
                                                href="{{ $url.$elements['labourLicense'] }}"
                                            >
                                                Labour License
                                            </a>
                                        <!--</div>-->
                                    </div>
                                    <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                        <div class="custom-file">
                                            <div class="input-group p-0 shadow-sm">
                                                <input class="form-control shadow-sm" id="labourLicense_expiry_date" type="text" name="labourLicense_expiry_date" value="{{ $elements['labourLicense_expiry_date'] }}" readonly>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                                </div>
                                <div class="row justify-content-center">
                                @if($elements['workerHealth'])
                                    <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                        <!--<div class="form-group">-->
                                            <a
                                                class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                                data-toggle="tooltip"
                                                target="_blank"
                                                title="{{ $elements['workerHealth'] }}"
                                                href="{{ $url.$elements['workerHealth'] }}"
                                            >
                                                Worker Health
                                            </a>
                                        <!--</div>-->
                                    </div>
                                    <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                        <div class="custom-file">
                                            <div class="input-group p-0 shadow-sm">
                                                <input class="form-control shadow-sm" id="workerHealth_expiry_date" type="text" name="workerHealth_expiry_date" value="{{ $elements['workerHealth_expiry_date'] }}" readonly>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                                </div>
                                <div class="row justify-content-center">
                                @if($elements['foodTestReport'])
                                    <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                        <!--<div class="form-group">-->
                                            <a
                                                class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                                data-toggle="tooltip"
                                                target="_blank"
                                                title="{{ $elements['foodTestReport'] }}"
                                                href="{{ $url.$elements['foodTestReport'] }}"
                                            >
                                                Food Test Report
                                            </a>
                                        <!--</div>-->
                                    </div>
                                    <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                      <div class="custom-file">
                                          <div class="input-group p-0 shadow-sm">
                                              <input class="form-control shadow-sm" id="foodTestReport_expiry_date" type="text" name="foodTestReport_expiry_date" value="{{ $elements['foodTestReport_expiry_date'] }}" readonly>
                                          </div>
                                      </div>
                                  </div>
                                @endif
                                </div>
                                <div class="row justify-content-center">
                                @if($elements['waterTestReport'])
                                    <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                        <!--<div class="form-group">-->
                                            <a
                                                class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                                data-toggle="tooltip"
                                                target="_blank"
                                                title="{{ $elements['waterTestReport'] }}"
                                                href="{{ $url.$elements['waterTestReport'] }}"
                                            >
                                                Water Test Report
                                            </a>
                                        <!--</div>-->
                                    </div>
                                <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                      <div class="custom-file">
                                          <div class="input-group p-0 shadow-sm">
                                              <input class="form-control shadow-sm" id="waterTestReport_expiry_date" type="text" name="waterTestReport_expiry_date" value="{{ $elements['waterTestReport_expiry_date'] }}" readonly>
                                          </div>
                                      </div>
                                  </div>
                                @endif
                                </div>
                                <div class="row justify-content-center">
                                @if($elements['pestControlReport'])
                                    <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                        <!--<div class="form-group">-->
                                            <a
                                                class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                                data-toggle="tooltip"
                                                target="_blank"
                                                title="{{ $elements['pestControlReport'] }}"
                                                href="{{ $url.$elements['pestControlReport'] }}"
                                            >
                                                Pest Control Report
                                            </a>
                                        <!--</div>-->
                                    </div>
                                <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                      <div class="custom-file">
                                          <div class="input-group p-0 shadow-sm">
                                              <input class="form-control shadow-sm" id="pestControlReport_expiry_date" type="text" name="pestControlReport_expiry_date" value="{{ $elements['pestControlReport_expiry_date'] }}" readonly>
                                          </div>
                                      </div>
                                  </div>
                                @endif
                                </div>
                                <div class="row justify-content-center">
                                @if($elements['kitchenAuditReport'])
                                    <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                        <!--<div class="form-group">-->
                                            <a
                                                class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                                data-toggle="tooltip"
                                                target="_blank"
                                                title="{{ $elements['kitchenAuditReport'] }}"
                                                href="{{ $url.$elements['kitchenAuditReport'] }}"
                                            >
                                                Kitchen Audit Report
                                            </a>
                                        <!--</div>-->
                                    </div>
                                <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                      <div class="custom-file">
                                          <div class="input-group p-0 shadow-sm">
                                              <input class="form-control shadow-sm" id="kitchenAuditReport_expiry_date" type="text" name="kitchenAuditReport_expiry_date" value="{{ $elements['kitchenAuditReport_expiry_date'] }}" readonly>
                                          </div>
                                      </div>
                                  </div>
                                @endif
                                </div>
                                <div class="row justify-content-center">
                                @if($elements['policeVerificationReport'])
                                    <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                        <!--<div class="form-group">-->
                                            <a
                                                class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                                data-toggle="tooltip"
                                                target="_blank"
                                                title="{{ $elements['policeVerificationReport'] }}"
                                                href="{{ $url.$elements['policeVerificationReport'] }}"
                                            >
                                                Police Verification Report
                                            </a>
                                        <!--</div>-->
                                    </div>
                                <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                      <div class="custom-file">
                                          <div class="input-group p-0 shadow-sm">
                                              <input class="form-control shadow-sm" id="policeVerificationReport_expiry_date" type="text" name="policeVerificationReport_expiry_date" value="{{ $elements['policeVerificationReport_expiry_date'] }}" readonly>
                                          </div>
                                      </div>
                                  </div>
                                @endif
                                </div>
                                <div class="row justify-content-center">
                                @if($elements['cancelledCheque'])
                                    <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                        <!--<div class="form-group">-->
                                            <a
                                                class="btn btn-lg btn-info w-100 font-weight-bold text-decoration-none"
                                                data-toggle="tooltip"
                                                target="_blank"
                                                title="{{ $elements['cancelledCheque'] }}"
                                                href="{{ $url.$elements['cancelledCheque'] }}"
                                            >
                                                Cancelled Cheque
                                            </a>
                                        <!--</div>-->
                                    </div>
<!--                                <div class="form-group mx-1 col-md-4 col-sm-12 px-md-1">
                                      <div class="custom-file">
                                          <div class="input-group p-0 shadow-sm">
                                              <input class="form-control shadow-sm" id="cancelledCheque_expiry_date" type="text" name="cancelledCheque_expiry_date" value="{{ $elements['cancelledCheque_expiry_date'] }}" readonly>
                                          </div>
                                      </div>
                                  </div>-->
                                @endif
                                </div>
                                
                                <br/>
                                <div class="row d-flex justify-content-around">
                                  <button class="wetasphalt w-25" onclick="redirection('{{ url('vendor/edit/documents/resubmit') }}');">Edit Documents</button>
                                </div>
                                
                            @else
                                <div class="badge badge-danger">Something Went Wrong!</div>
                            @endif
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection
