@extends('layouts.masterDashboard')
@section('content')
<div class="row">
    <style>
        .peterriver{
            width: 120px;
        }
        a.custom_a span.custom_span {
        max-width: 0;
        font-weight: bold;
        -webkit-transition: max-width .2s;
        transition: max-width .2s;
        display: inline-block;
        vertical-align: top;
        white-space: nowrap;
        overflow: hidden;
        }

        a.custom_a:hover span.custom_span {
        max-width: 7rem;
        }
    </style>
    <div class="col-md">
        <div class="card card-user shadow-sm">
            <div class="card-header d-flex justify-content-center border-0 pt-4">
                <h3>Client List</h3>
            </div>
            <div id="pp_table1_admin_dash" class="card-body py-1">
                <div class="table-responsive px-2">
                    <table id="example" class="table table-striped table-bordered" style="width:100%">
                        <thead>
                            <tr>
                                <th>Id</th>
                                <th>Client ID</th>
                                <th>Client Name</th>
                                <th>Contact Person</th>
                                <th>Number of Camera</th>
                                <th class="text-left" scope="col">Action</th>
                            </tr>
                        </thead>
                        <tbody id="role_list">
                            @foreach ( $clientDetails as $client )
                                <tr>
                                    <td>{{ $client->id }}</td>
                                    <td>{{ $client->clientId }}</td>
                                    <td>{{ $client->clientName }}</td>
                                    <td>{{ $client->contactName }}</td>
                                    <td>{{ $vendor->cameraNumber }}</td>
                                    <td>
                                        <a class="text-decoration-none text-white peterriver p-0"
                                            href="{{ url('vendor/viewAICamera/'. $client->clientId ) }}"
                                        >
                                            View Camera
                                        </a>
                                    </td>
                                </tr>    
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

@section('customscript')
<link href="{{ asset('public/dataTable/dataTables.bootstrap.min.css') }}" rel="stylesheet">
<!--<link href="https://cdn.datatables.net/1.10.22/css/jquery.dataTables.min.css" rel="stylesheet">-->
<script type="text/javascript" src="{{ asset('public/dataTable/jquery.dataTables.min.js') }}"></script>
<script type="text/javascript" src="{{ asset('public/dataTable/jquery-3.5.1.js') }}"></script>
<script>
  $(document).ready(function() {
    $.noConflict();
    $('#example').DataTable();
  });
</script>
@endsection

@endsection

