<?php

Route::group(['module' => 'Sitemarshal', 'prefix' => 'sitemarshal', 'middleware' => ['web', 'auth', 'role:sitemarshal'], 'namespace' => 'App\Modules\Sitemarshal\Controllers'], function() {

    Route::resource('sitemarshal', 'SitemarshalController');

    Route::get('client_list', 'SitemarshalController@client_list');

    Route::get('vendor_list', 'SitemarshalController@vendor_list');

    Route::get('view/role/{id}', 'SitemarshalController@view_role');

    Route::get('mapped/{type}/{id}', 'SitemarshalController@mapped_roles');
    
    Route::get('menus', 'SitemarshalController@menus');
    Route::post('menus', 'SitemarshalController@menu_detail');

    Route::get('events/{event_id?}', 'SitemarshalController@event_list');

    Route::get('submit/documents/{type}', 'SitemarshalController@marshalDocuments');
    Route::post('submit/documents', 'SitemarshalController@saveMarshalDocuments');

    Route::get('concerns/{id?}', 'SitemarshalController@all_concern');
    Route::post('concern/msg', 'SitemarshalController@concern_message_input');
    Route::get('change/concern/{id}', 'SitemarshalController@change_status');

    Route::get('feedbacks/{vendorId?}/{clientId?}', 'SitemarshalController@feedback');
    
    Route::get('edit/documents/{type}', 'SitemarshalController@editmarshalDocuments');

});
