@extends('layouts.masterDashboard')
@section('content')
    <div class="row">
        <div class="col-md">
            <div class="card card-user shadow-sm">
                <div class="card-header d-flex justify-content-center border-0 pt-4">
                    <h3>Vendor List</h3>
                </div>
                <div class="card-body">
                    <div class="table-responsive px-2" style="overflow-x: scroll; overflow-y: hidden;">
                        <table class="table table-hover">
                            <thead class="text-dark">
                                <tr>
                                    <th class="text-left" scope="col">S.No.</th>
                                    <th class="text-left" scope="col">Vendor (Name - Code)</th>
                                    <th class="text-left" scope="col">Contact Person</th>
                                    <th class="text-left" scope="col">Mobile Number</th>
                                    <th scope="col" class="d-flex justify-content-center">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($vendors as $list)
                                    <tr>
                                        <th class="text-left" scope="row">{{ $loop->iteration }}</th>
                                        <td class="text-left">{{ $list->vendor_name . ' - ' . $list->vendor_code }}</td>
                                        <td class="text-left">{{ $list->contact_person }}</td>
                                        <td class="text-left">{{ $list->vendor_number }}</td>
                                        <td class="d-flex justify-content-center">
                                            <?php
                                                $id = isset($list->vendor_id) ? $list->vendor_id : '';
                                            ?>
                                            <a href="{{ url('sitemarshal/view/role').'/'.$id }}" class="btn btn-info font-weight-bold mx-2">View</a>
                                            @if(isset($list->vendor_id))
                                                <a href="{{ url('sitemarshal/mapped/client').'/'.$id }}" class="btn btn-info font-weight-bold mx-2">Mapped With</a>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" align="center">Not Found any</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection