@extends('layouts.masterDashboard')
@section('content')
    <?php
        $roleName = isset($result['foodscraftRole']) && !empty($result['foodscraftRole']) ? strtolower($result['foodscraftRole']) : (isset($roleType) && !empty($roleType) ? strtolower($roleType) : '');
    ?>
    <div class="row">
        <div class="col-md-12">
            <div class="main-card mb-3 card">
                <div class="card-header pt-4" style="align-self: center;justify-content: center;width: 75%;border-bottom: none;">
                    @if(isset($result) && $roleName !== 'sitemarshal')
                        <h3>{{ 'VIEW '. $roleName .' PROFILE' }}</h3>
                    @endif
                </div>
                <div class="card-body">
                    <form method="POST" class="fkformlabel" action=<?php echo isset($type) && $type == "edit" ? url('editRole') : url('create') ?> enctype='multipart/form-data'>
                        @csrf
                        @if($roleName == "sitemarshal" && isset($type) && $type == "view")
                            <?php
                                $picture = $result['assignedSite'] !== 'default_foodscraft.png' ? asset('public/storage/avatars/marshals') . '/' . $result['marshalId'] . '/' . $result['assignedSite'] : asset('public/images/default_foodscraft.png');
                            ?>
                            <div class="row px-3">
                                <img class="rounded" width="200" height="100" src="{{ $picture }}" alt="Profile Picture" />
                            </div>
                        @endif
                        <div class="row">
                            <div class="col-md-4 col-sm-12 pr-md-1">
                                <div class="form-group">
                                    <label for="name">{{ $roleName == "client" ? "Client's Name" : 'Name of the Company' }}</label><span class="required-field">*</span>
                                    <input type="text" id="name" class="form-control" autocomplete="off" name="name" value="{{ isset($result['name']) ? $result['name'] : '' }}" required <?php echo!isset($result['name']) && empty($result['name']) ? '' : ($type == "edit" ? '' : ($type == "view" ? 'disabled' : '')) ?> />
                                </div>
                            </div>
                            @if($roleName == "vendor")
                                <div class="col-md-4 col-sm-12 px-md-1">
                                    <div class="form-group">
                                        <label for="username">Vendor Code</label><span class="required-field">*</span>
                                        <input type="text" id="username" class="form-control" autocomplete="off" name="username" value="{{ isset($result['username']) ? $result['username'] : '' }}" required <?php echo!isset($result['username']) && empty($result['username']) ? '' : ($type == "edit" ? 'readonly' : ($type == "view" ? 'disabled' : '')) ?> />
                                    </div>
                                </div>
                            @elseif($roleName == "client")
                                <div class="col-md-4 col-sm-12 px-md-1">
                                    <div class="form-group">
                                        <label for="username">Client Code</label><span class="required-field">*</span>
                                        <input type="text" id="username" class="form-control" autocomplete="off" name="username" value="{{ isset($result['username']) ? $result['username'] : '' }}" required <?php echo!isset($result['username']) && empty($result['username']) ? '' : ($type == "edit" ? 'readonly' : ($type == "view" ? 'disabled' : '')) ?> />
                                    </div>
                                </div>
                            @endif
                            <div class="col-md-4 col-sm-12 pl-md-1">
                                <div class="form-group">
                                    <label for="email">Email address</label><span class="required-field">*</span>
                                    <input type="email" id="email" class="form-control" name="email" required autocomplete="off" value="{{ isset($result['email']) ? $result['email'] : '' }}" required <?php echo!isset($result['email']) && empty($result['email']) ? '' : ($type == "edit" ? '' : ($type == "view" ? 'disabled' : '')) ?> />
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            @if($roleName == "vendor")
                                <div class="col-md-4 col-sm-12 pr-md-1">
                                    <div class="form-group">
                                        <label for="contactName">Contact person name</label><span class="required-field">*</span>
                                        <input id="contactName" type="text" class="form-control" name="contactName" autocomplete="off" value="{{ isset($result['contactName']) && !empty($result['contactName']) ? $result['contactName'] : '' }}" required <?php echo!isset($result['contactName']) && empty($result['contactName']) ? '' : ($type == "edit" ? '' : ($type == "view" ? 'disabled' : '')) ?> />
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-12 px-md-1">
                                    <div class="form-group">
                                        <label for="contactNumber">{{ $roleName == "vendor" ? 'Contact person number' : 'Mobile number' }}</label><span class="required-field">*</span>
                                        <input id="contactNumber" type="tel" pattern="^[0-9]{10}$" data-toggle="tooltip" title="10 Digit Mobile Number Only" class="form-control" name="contactNumber" autocomplete="off" value="{{ isset($result['contactNumber']) && !empty($result['contactNumber']) ? $result['contactNumber'] : '' }}" required <?php echo!isset($result['contactNumber']) && empty($result['contactNumber']) ? '' : ($type == "edit" ? '' : ($type == "view" ? 'disabled' : '')) ?> />
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-12 pl-md-1">
                                    <div class="form-group">
                                        <label for="address">{{ $roleName .' address' }}</label><span class="required-field">*</span>
                                        <input id="address" type="text" class="form-control" name="address" autocomplete="off" value="{{ isset($result['address']) && !empty($result['address']) ? $result['address'] : '' }}" required <?php echo!isset($result['address']) && empty($result['address']) ? '' : ($type == "edit" ? '' : ($type == "view" ? 'disabled' : '')) ?> />
                                    </div>
                                </div>
                            @endif
                        </div>

                        <?php
                            // dd($roleName);
                        ?>
                        @if($roleName == 'client')
                            @php
                                $explode_names = isset($result['contactName']) && !empty($result['contactName']) ? explode(", ", $result['contactName']) : '';
                                $explode_number = isset($result['contactNumber']) && !empty($result['contactNumber']) ? explode(", ", $result['contactNumber']) : '';
                            @endphp
                            <div class="row">
                                <div class="col-md-4 col-sm-12 pr-md-1">
                                    <div class="form-group">
                                        <label for="contactName">Contact person name</label><span class="required-field">*</span>
                                        <input id="contactName" type="text" class="form-control" name="contactName[]" autocomplete="off" value="{{ is_array($explode_names) ? (isset($explode_names[0]) ? $explode_names[0] : '') : '' }}" required <?php echo!isset($result['contactName']) && empty($result['contactName']) ? '' : ($type == "edit" ? '' : ($type == "view" ? 'disabled' : '')) ?> />
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-12 px-md-1">
                                    <div class="form-group">
                                        <label for="contactName">Contact person name (1)</label>
                                        <input id="contactName" type="text" class="form-control" name="contactName[]" autocomplete="off" value="{{ is_array($explode_names) ? (isset($explode_names[1]) ? $explode_names[1] : '') : '' }}" <?php echo!isset($result['contactName']) && empty($result['contactName']) ? '' : ($type == "edit" ? '' : ($type == "view" ? 'disabled' : '')) ?> />
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-12 pl-md-1">
                                    <div class="form-group">
                                        <label for="contactName">Contact person name (2)</label>
                                        <input id="contactName" type="text" class="form-control" name="contactName[]" autocomplete="off" value="{{ is_array($explode_names) ? (isset($explode_names[2]) ? $explode_names[2] : '') : '' }}" <?php echo!isset($result['contactName']) && empty($result['contactName']) ? '' : ($type == "edit" ? '' : ($type == "view" ? 'disabled' : '')) ?> />
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-4 col-sm-12 pr-md-1">
                                    <div class="form-group">
                                        <label for="contactNumber">Contact person number</label><span class="required-field">*</span>
                                        <input id="contactNumber" type="tel" pattern="^[0-9]{10}$" data-toggle="tooltip" title="10 Digit Mobile Number Only" class="form-control" name="contactNumber[]" autocomplete="off" value="{{ is_array($explode_number) ? (isset($explode_number[0]) ? $explode_number[0] : '') : '' }}" required <?php echo!isset($result['contactNumber']) && empty($result['contactNumber']) ? '' : ($type == "edit" ? '' : ($type == "view" ? 'disabled' : '')) ?> />
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-12 px-md-1">
                                    <div class="form-group">
                                        <label for="contactNumber">Contact person number (1)</label>
                                        <input id="contactNumber" type="tel" pattern="^[0-9]{10}$" data-toggle="tooltip" title="10 Digit Mobile Number Only" class="form-control" name="contactNumber[]" autocomplete="off" value="{{ is_array($explode_number) ? (isset($explode_number[1]) ? $explode_number[1] : '') : '' }}" <?php echo!isset($result['contactNumber']) && empty($result['contactNumber']) ? '' : ($type == "edit" ? '' : ($type == "view" ? 'disabled' : '')) ?> />
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-12 pl-md-1">
                                    <div class="form-group">
                                        <label for="contactNumber">Contact person number (2)</label>
                                        <input id="contactNumber" type="tel" pattern="^[0-9]{10}$" data-toggle="tooltip" title="10 Digit Mobile Number Only" class="form-control" name="contactNumber[]" autocomplete="off" value="{{ is_array($explode_number) ? (isset($explode_number[2]) ? $explode_number[2] : '') : '' }}" <?php echo!isset($result['contactNumber']) && empty($result['contactNumber']) ? '' : ($type == "edit" ? '' : ($type == "view" ? 'disabled' : '')) ?> />
                                    </div>
                                </div>
                            </div>
                        @endif

                        @if($roleName == "client")
                            @include('Sitemarshal::role_client_detail')
                        @elseif($roleName == "vendor")
                            @include('Sitemarshal::role_vendor_detail')
                        @endif

                        @if(isset($result))
                            @if($type == "view")
                                @if($roleName == "vendor")
                                    <div class="mb-4 p-1 {{ isset($result['documents']) && !empty($result['documents']) ? '' : 'd-flex justify-content-center' }}">
                                        @if(isset($result['documents']) && !empty($result['documents']))
                                            <?php
                                                $url = asset('storage/documents/vendors') . '/' . $result['vendorId'] . '/';
                                                $elements = $result['documents'][0];
                                            ?>
                                            <div class="row mb-4">
                                                <div class="col-md-4 col-sm-12 pr-md-1 d-flex justify-content-center">
                                                    <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['companyProfile'] }}">
                                                        <a class="text-decoration-none text-white" href="{{ $url.$elements['companyProfile'] }}" target="_blank">Company Profile</a>
                                                    </button>
                                                </div>
                                                <div class="col-md-4 col-sm-12 px-md-1 d-flex justify-content-center">
                                                    <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['fssai'] }}">
                                                        <a class="text-decoration-none text-white" href="{{ $url.$elements['fssai'] }}" target="_blank">Fssai</a>
                                                    </button>
                                                </div>
                                                <div class="col-md-4 col-sm-12 pl-md-1 d-flex justify-content-center">
                                                    <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['gst'] }}">
                                                        <a class="text-decoration-none text-white" href="{{ $url.$elements['gst'] }}" target="_blank">GST</a>
                                                    </button>
                                                </div>
                                            </div>
                                            <div class="row mt-4">
                                                <div class="col-md-4 col-sm-12 pr-md-1 d-flex justify-content-center">
                                                    <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['panCard'] }}">
                                                        <a class="text-decoration-none text-white" href="{{ $url.$elements['panCard'] }}" target="_blank">Pan Card</a>
                                                    </button>
                                                </div>
                                                <div class="col-md-4 col-sm-12 px-md-1 d-flex justify-content-center">
                                                    <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['companyReg'] }}">
                                                        <a class="text-decoration-none text-white" href="{{ $url.$elements['companyReg'] }}" target="_blank">Company Registration</a>
                                                    </button>
                                                </div>
                                                <div class="col-md-4 col-sm-12 pl-md-1 d-flex justify-content-center">
                                                    <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['pf'] }}">
                                                        <a class="text-decoration-none text-white" href="{{ $url.$elements['pf'] }}" target="_blank">Provident Fund</a>
                                                    </button>
                                                </div>
                                            </div>
                                            <div class="row mt-4">
                                                <div class="col-md-4 col-sm-12 pr-md-1 d-flex justify-content-center">
                                                    <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['labourLicense'] }}">
                                                        <a class="text-decoration-none text-white" href="{{ $url.$elements['labourLicense'] }}" target="_blank">Labour License</a>
                                                    </button>
                                                </div>
                                                <div class="col-md-4 col-sm-12 px-md-1 d-flex justify-content-center">
                                                    <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['workerHealth'] }}">
                                                        <a class="text-decoration-none text-white" href="{{ $url.$elements['workerHealth'] }}" target="_blank">Worker Health</a>
                                                    </button>
                                                </div>
                                                <div class="col-md-4 col-sm-12 pl-md-1 d-flex justify-content-center">
                                                    <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['foodTestReport'] }}">
                                                        <a class="text-decoration-none text-white" href="{{ $url.$elements['foodTestReport'] }}" target="_blank">Food Test Report</a>
                                                    </button>
                                                </div>
                                            </div>
                                            <div class="row mt-4">
                                                <div class="col-md-4 col-sm-12 pr-md-1 d-flex justify-content-center">
                                                    <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['waterTestReport'] }}">
                                                        <a class="text-decoration-none text-white" href="{{ $url.$elements['waterTestReport'] }}" target="_blank">Water Test Report</a>
                                                    </button>
                                                </div>
                                                <div class="col-md-4 col-sm-12 px-md-1 d-flex justify-content-center">
                                                    <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['pestControlReport'] }}">
                                                        <a class="text-decoration-none text-white" href="{{ $url.$elements['pestControlReport'] }}" target="_blank">Pest Control Report</a>
                                                    </button>
                                                </div>
                                                <div class="col-md-4 col-sm-12 pl-md-1 d-flex justify-content-center">
                                                    <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['kitchenAuditReport'] }}">
                                                        <a class="text-decoration-none text-white" href="{{ $url.$elements['kitchenAuditReport'] }}" target="_blank">Kitchen Audit Report</a>
                                                    </button>
                                                </div>
                                            </div>
                                            <div class="row mt-4">
                                                <div class="col-md-6 col-sm-12 pr-md-1 d-flex justify-content-center">
                                                    <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['policeVerificationReport'] }}">
                                                        <a class="text-decoration-none text-white" href="{{ $url.$elements['policeVerificationReport'] }}" target="_blank">Police Verification Report</a>
                                                    </button>
                                                </div>
                                                <div class="col-md-6 col-sm-12 px-md-1 d-flex justify-content-center">
                                                    <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['cancelledCheque'] }}">
                                                        <a class="text-decoration-none text-white" href="{{ $url.$elements['cancelledCheque'] }}" target="_blank">Cancelled Cheque</a>
                                                    </button>
                                                </div>
                                            </div>
                                        @else
                                            <div class="badge badge-warning">Documents have not been submitted yet!</div>
                                        @endif
                                    </div>
                                @endif
                            @endif
                        @endif
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection