@extends('layouts.masterDashboard')
@section('content')
    <dov class="row">
        <div class="col-md">
            <div class="card card-user">
                <div class="card-header pt-4" style="align-self: center;justify-content: center;width: 75%;border-bottom: none;">
                    <h3>{{ $menu->vendor_name }} Menu Detail</h3>
                </div>
                <div class="card-body">
                    @if(isset($menu))
                        <form>
                            <!-- Client Info -->
                            <div class="row">
                                @php
                                    $datetime_from = Carbon\Carbon::parse($menu->from_time)->format('d-m-Y h:m');
                                    $datetime_to = Carbon\Carbon::parse($menu->from_time)->format('d-m-Y h:m');
                                @endphp
                                <div class="form-group col">
                                    <label for="clientId">Vendor (Name - Code)</label>
                                    <input class="form-control" type="text" value="{{ $menu->vendor_name.' - '.$menu->vendor_code }}" readonly />
                                </div>
                                <div class="form-group col">
                                    <label for="clientId">Client (Name - Code)</label>
                                    <input class="form-control" type="text" value="{{ $menu->client_name.' - '.$menu->client_code }}" readonly />
                                </div>
                                <div class="form-group col">
                                    <label for="fromtime">Client Menu From</label>
                                    <input class="form-control" type="text" name="from_time" value="{{ $datetime_from }}" readonly />
                                </div>
                                <div class="form-group col">
                                    <label for="totime">Client Menu To</label>
                                    <input class="form-control" type="text" name="to_time" value="{{ $datetime_to }}" readonly />
                                </div>
                            </div>
                            <!-- Morning -->
                            <div class="row">
                                <div class="form-group col">
                                    <label for="morning_meal">Morning Meal</label>
                                    <input class="form-control" type="text" name="morning_meal" value="{{ $menu->morning_meal }}" readonly />
                                </div>
                                <div class="form-group col">
                                    <label for="morning_description">Morning Description</label>
                                    <textarea class="form-control" type="text" name="morning_description" readonly>{{ $menu->morning_description }}</textarea>
                                </div>
                            </div>
                            <!-- Afternoon -->
                            <div class="row">
                                <div class="form-group col">
                                    <label for="afternoon_meal">Afternoon Meal</label>
                                    <input class="form-control" type="text" name="afternoon_meal" value="{{ $menu->afternoon_meal }}" readonly />
                                </div>
                                <div class="form-group col">
                                    <label for="afternoon_description">Afternoon Description</label>
                                    <textarea class="form-control" type="text" name="afternoon_description" readonly>{{ $menu->afternoon_description }}</textarea>
                                </div>
                            </div>
                            <!-- Evening -->
                            <div class="row">
                                <div class="form-group col">
                                    <label for="snacks">Evening Snacks</label>
                                    <input class="form-control" type="text" name="evening_snacks" value="{{ $menu->evening_snacks }}" readonly />
                                </div>
                                <div class="form-group col">
                                    <label for="snacks_description">Snacks Description</label>
                                    <textarea class="form-control" type="text" name="snacks_description" readonly>{{ $menu->snacks_description }}</textarea>
                                </div>
                            </div>
                            <!-- Dinner -->
                            <div class="row">
                                <div class="form-group col">
                                    <label for="dinner_meal">Dinner Meal</label>
                                    <input type="text" name="dinner_meal" class="form-control" value="{{ $menu->dinner_meal }}" readonly />
                                </div>
                                <div class="form-group col">
                                    <label for="dinner_description">Dinner Description</label>
                                    <textarea type="text" name="dinner_description" class="form-control" id="dinner_description" readonly>{{ $menu->dinner_description }}</textarea>
                                </div>
                            </div>
                        </form>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection