@extends('layouts.masterDashboard')
@section('content')
    <div class="row">
        <div class="col-md">
            <div class="card card-user shadow-sm">
                <div class="card-header d-flex justify-content-center border-0 pt-4">
                    <h3>All Associated Events</h3>
                </div>
                <div class="card-body">
                    <div class="table-responsive px-2" style="overflow-x: scroll; overflow-y: hidden;">
                        <table class="table table-hover">
                            <thead class="text-dark">
                                <tr>
                                    <th class="text-center" scope="col">S.No.</th> 
                                    <th class="text-center" scope="col">Client Name</th>
                                    <th class="text-center" scope="col">Client Code</th>
                                    <th class="text-center" scope="col">Event Type</th>
                                    <th scope="col" class="d-flex justify-content-center">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($allEvents as $event)
                                    <tr>
                                        <th class="text-center" scope="row">{{ $loop->iteration }}</th>
                                        <td class="text-center">{{ $event->client_name }}</td>
                                        <td class="text-center">{{ $event->client_code }}</td>
                                        <td class="text-center">{{ $event->type_of_event }}</td>
                                        <td class="d-flex justify-content-center">
                                            <a href="{{ url('sitemarshal/events', $event->id) }}" class="btn btn-info px-4 font-weight-bold">View</a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" align="center">Not Found any</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer p-0" style="align-self: center;text-align: center;border-bottom: none;border-top: none;color: #d45353;display: flex;justify-content: center;">
                    <h6>{{ $allEvents->links() }}</h6>
                </div>
            </div>
        </div>
    </div>
@endsection