@extends('layouts.masterDashboard')
@section('content')
    <style>
        .filter-option{
            background: white;
        }
    </style>
    <div class="row">
        <div class="col-md">
            <div class="card card-user">
                <div class="card-header pt-4" style="align-self: center;justify-content: center;width: 75%;border-bottom: none;">
                    <h3>Event</h3>
                </div>
                <div class="card-body">
                    @if(isset($event))
                        <div class="container">
                            <div class="row">
                                <div class="col-md-4 col-sm-12">
                                    <div class="form-group">
                                        <label for="settled">Settled Plate Rate</label>
                                        <input type="tel" name="settled" id="settled" class="form-control" value="{{ isset($event->settled_rate) ? $event->settled_rate : $event->rate_per_plate }}" readonly />
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-12">
                                    <div class="form-group d-flex flex-column">
                                        <label for="existingVendor">Chosen Vendor</label>
                                        <input type="text" name="vendor" class="form-control" value="{{ isset($event->vendor_name) ? $event->vendor_name->name : '' }}" readonly />
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-12">
                                    <div class="form-group d-flex flex-column">
                                        <label for="existingVendor">Client Name</label>
                                        <input type="text" name="vendor" class="form-control" value="{{ $event->client_name }}" readonly />
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-4 col-sm-12 pr-md-1">
                                    <div class="form-group">
                                        <label for="reservation_date">Date of Event</label>
                                        <div class="input-group p-0 shadow-sm">
                                            <input type="text" name="reservation_date" class="form-control" value="{{ date('d/m/Y', $event->event_date) }}" readonly />
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-12">
                                    <div class="form-group">
                                        <label for="guests_num">Guests Number</label>
                                        <input type="text" name="guests_num" class="form-control" value="{{ $event->guest_number }}" readonly />
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-12">
                                    <div class="form-group">
                                        <label for="plateRate">Rates Per Plate</label>
                                        <input class="form-control shadow-sm" name="plateRate" value="{{ $event->rate_per_plate }}" readonly />
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="plate_rate">Type of Event</label>
                                        <input class="form-control shadow-sm" name="plate_rate" value="{{ $event->type_of_event }}" readonly />
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <h5 class="text-center d-flex justify-content-center"><span class="border-bottom">Decoration needed</span></h5>
                                        <div class="d-flex justify-content-around flex-wrap">
                                            <label class="radio mx-4 my-2">
                                                <input type="radio" name="eventDecoration" value="yes" <?php echo empty($event->decoration_needed) ? "" : ($event->decoration_needed == "yes" ? "checked disabled" : "disabled") ?> />
                                                <span>Yes</span>
                                            </label>
                                            <label class="radio mx-4 my-2">
                                                <input type="radio" name="eventDecoration" value="no" <?php echo empty($event->decoration_needed) ? "" : ($event->decoration_needed == "no" ? "checked disabled" : "disabled") ?> />
                                                <span>No</span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection