@extends('layouts.masterDashboard')
@section('content')
    <div class="row">
        <div class="col-md">
            <div class="card card-user shadow-sm">
                <div class="card-header d-flex justify-content-center border-0 pt-4">
                    <h3>Marshal Documents</h3>
                </div>
                <div class="card-body">
                    @if($type == "new" || $type == "resubmit")
                        <form method="POST" action="{{ url('sitemarshal/submit/documents') }}" enctype='multipart/form-data'>
                            @csrf
                            <input type="hidden" id="docredirect" name="docredirect" value="docresubmit">
                            @if($type == "resubmit")
                                <h5><strong>Note: </strong><i>Please resubmit the document which is required.</i></h5>
                                <br/>
                            @endif
                            <div class="row">
                                <div class="col-md-4 col-sm-12 pr-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="resume" lang="es" name="resume" onchange="putName(this);" accept=".doc, .pdf" />
                                            <label class="custom-file-label" for="resume">Resume</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-12 px-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="first_gov_id" lang="es" name="first_gov_id" onchange="putName(this);" accept="doc, .pdf, .jpg, .jpeg, .png" />
                                            <label class="custom-file-label" for="first_gov_id" style="color: #000;">First Government ID</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-12 pl-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="second_gov_id" lang="es" name="second_gov_id" onchange="putName(this);" accept="doc, .pdf, .jpg, .jpeg, .png" />
                                            <label class="custom-file-label" for="second_gov_id" style="color: #000;">Second Government ID</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-4 col-sm-12 pr-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                          <input type="file" class="custom-file-input" id="pro_pic" lang="es" name="pro_pic" onchange="putName(this);" accept=".jpg, .jpeg, .png" />
                                          <label class="custom-file-label" for="pro_pic" style="color: #000;">Profile Picture</label>
                                        </div>
                                    </div>
                                </div>
<!--                                <div class="col-md-4 col-sm-12 px-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="highSchool" lang="es" name="highSchool" onchange="putName(this);" accept=".doc, .pdf" required />
                                            <label class="custom-file-label" for="highSchool">High School</label>
                                        </div>
                                    </div>
                                </div>-->
<!--                                <div class="col-md-4 col-sm-12 pl-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="workExp" lang="es" name="workExp" onchange="putName(this);" accept=".doc, .pdf" required />
                                            <label class="custom-file-label" for="workExp">Work Experience</label>
                                        </div>
                                    </div>
                                </div>-->
                            </div>
                            <div class="row d-flex justify-content-center">
                                <div class="response">
                                    <button type="submit" class="wetasphalt w-100" style="font-weight: bolder;font-size: medium;padding: 0.4rem 1.4rem;">Submit Documents</button>
                                </div>
                            </div>
                        </form>
                    @elseif($type == "submitted")
                        <div>
                            @if(isset($elements) && !empty($elements))
                                <?php
                                    $url = asset('public/storage/documents/marshals').'/'.Auth::user()->id.'/';
                                ?>
                                <div class="row mb-4">
                                    <div class="col-md-4 col-sm-12 pr-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['resume'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['resume'] }}" target="_blank">Resume</a>
                                        </button>
                                    </div>
                                    <div class="col-md-4 col-sm-12 px-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['first_gov_id'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['first_gov_id'] }}" target="_blank">First Government ID</a>
                                        </button>
                                    </div>
                                    <div class="col-md-4 col-sm-12 pl-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['second_gov_id'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['second_gov_id'] }}" target="_blank">Second Government ID</a>
                                        </button>
                                    </div>
                                </div>
                                <div class="row mt-4">
<!--                                    <div class="col-md-4 col-sm-12 pr-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['pro_pic'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['pro_pic'] }}" target="_blank">Profile Picture</a>
                                        </button>
                                    </div>-->
                                   <?php
                                        $picture = $elements['pro_pic'] !== 'default_foodscraft.png' ? asset('public/storage/documents/marshals') . '/' . $elements['marshalId'] . '/' . $elements['pro_pic'] : asset('public/images/default_foodscraft.png');
                                    ?>
                                    <div class="row px-3">
                                        <img class="rounded" width="200" height="100" src="{{ $picture }}" alt="Profile Picture" />
                                    </div>
<!--                                    <div class="col-md-4 col-sm-12 px-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['highSchool'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['highSchool'] }}" target="_blank">High School</a>
                                        </button>
                                    </div>
                                    <div class="col-md-4 col-sm-12 pl-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['workExp'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['workExp'] }}" target="_blank">Work Experience</a>
                                        </button>
                                    </div>-->
                                </div>
                            
                            <br/>
                                <div class="row d-flex justify-content-around">
                                  <button class="wetasphalt w-25" onclick="redirection('{{ url('sitemarshal/edit/documents/resubmit') }}');">Edit Documents</button>
                                </div>
                            
                            @else
                                <div class="badge badge-danger">Something Went Wrong!</div>
                            @endif
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection