@extends('layouts.masterDashboard')
@section('content')
    <div class="row">
        <div class="col-md">
            <div class="card card-user shadow-sm">
                <div class="card-header d-flex justify-content-center border-0 pt-4">
                    <h3>Client List</h3>
                </div>
                <div class="card-body">
                    <div class="table-responsive px-2" style="overflow-x: scroll; overflow-y: hidden;">
                        <table class="table table-hover">
                            <thead class="text-dark">
                                <tr>
                                    <th class="text-left" scope="col">S.No.</th>
                                    <th class="text-left" scope="col">Client (Name - Code)</th>
                                    <th class="text-left" scope="col">Contact Person</th>
                                    <th class="text-left" scope="col">Contact Number</th>
                                    <th scope="col" class="d-flex justify-content-center">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($clients as $client)
                                    <tr>
                                        <th class="text-left" scope="row">{{ $loop->iteration }}</th>
                                        <td class="text-left">{{ $client->client_name . ' - ' . $client->client_code }}</td>
                                        <td class="text-left">{{ $client->contact_person }}</td>
                                        <td class="text-left">
                                            {{
                                                rtrim(preg_replace('/\W\w+\s*(\W*)$/', '$1', $client->client_number), ",")
                                            }}
                                        </td>
                                        <td class="d-flex justify-content-center">
                                            <?php
                                                $id = isset($client->client_id) ? $client->client_id : '';
                                            ?>
                                            <a href="{{ url('sitemarshal/view/role').'/'.$id }}" class="btn btn-info font-weight-bold mx-2">View</a>
                                            <a href="{{ url('sitemarshal/mapped/vendor').'/'.$id }}" class="btn btn-info font-weight-bold mx-2">Mapped Vendor</a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" align="center">Not Found any</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection