<?php

namespace App\Modules\Sitemarshal\Controllers;

use App\Http\Controllers\Controller;
use Spatie\Permission\Models\Role;
use Illuminate\Http\Request;
use App\MarshalDocs;
use App\RolesEvent;
use App\MapRole;
use App\Marshal;
use App\Vendor;
use App\Client;
use App\MealMenu;
use App\RaiseConcern;
use App\ConcernMessage;
use App\VendorDocs;
use Validator;
use App\User;
use Storage;
use Auth;
use Hash;
use DB;


class SitemarshalController extends Controller
{

    public function __construct()
    {
        $this->middleware(['role:sitemarshal', 'auth']);
    }

    protected function errorBag(array $errors)
    {
        $message = ["message" => implode(" ", $errors), "alert-type" => "error"];
        return $message;
    }

    protected function userInfo($id)
    {
        return User::where('id', $id)
            ->select('id', 'name', 'email', 'username', 'contactNumber', 'address')
            ->first()->toArray();
    }

    protected function vendorDetails($user)
    {
        return Vendor::where([
                ['vendorId', '=', $user['id']],
                ['username', '=', $user['username']]
            ]);
    }

    protected function clientDetails($user)
    {
        return Client::where([
                ['clientId', '=', $user['id']],
                ['username', '=', $user['username']]
            ]);
    }

    /*
        Provides Client's list mapped with this Marshal
    */
    public function client_list()
    {
        $clients = [];
        $joinQuery = array("clientId" => 'map_roles.clientId');
        foreach($joinQuery as $key => $value){
            $clients = MapRole::where('marshalId', Auth::user()->id)
                ->join('users', $value, '=', 'users.id')
                ->join('clients', 'users.id', '=', 'clients.clientId')
                ->select(
                        'users.name as client_name',
                        'users.username as client_code',
                        'clients.contactName as contact_person',
                        'users.contactNumber as client_number',
                        'map_roles.clientId as client_id'
                    )
                ->get();
        }
        // dd($clients);
        return view('Sitemarshal::client_list', compact('clients'));
    }

    /*
        Provides Vendor's list mapped with this Marshal
    */
    public function vendor_list()
    {
        // dd(Auth::user()->id);
        $vendors = [];
        $joinQuery = array("vendorId" => 'map_roles.vendorId');
        foreach($joinQuery as $key => $value){
            $vendors = MapRole::where('marshalId', Auth::user()->id)
                ->join('users', $value, '=', 'users.id')
                ->join('vendors', 'users.id', '=', 'vendors.vendorId')
                ->select(
                        'users.name as vendor_name',
                        'users.username as vendor_code',
                        'vendors.contactName as contact_person',
                        'users.contactNumber as vendor_number',
                        'map_roles.vendorId as vendor_id'
                    )
                ->distinct()
                ->get();
        }
        // dd($vendors);
        return view('Sitemarshal::vendor_list', compact('vendors'));
    }

    /*
        Provides mapped-roles associated with each other.
    */
    public function mapped_roles(string $type, int $id)
    {
        // dd($type, $id, Auth::user()->id);
        if($type == "vendor"){
            $vendors = MapRole::where('map_roles.marshalId', Auth::user()->id)
                ->where('map_roles.clientId', $id)
                ->join('users', 'map_roles.vendorId', '=', 'users.id')
                ->join('vendors', 'users.id', '=', 'vendors.vendorId')
                ->select(
                    'users.name as vendor_name',
                    'users.username as vendor_code',
                    'vendors.contactName as contact_person',
                    'users.contactNumber as vendor_number',
                    'map_roles.vendorId as vendor_id'
                )
                ->get();
            // dd($vendors);
            return view('Sitemarshal::vendor_list', compact('vendors'));
        }elseif($type == "client"){
            $clients = MapRole::where('marshalId', Auth::user()->id)
                ->where('vendorId', $id)
                ->join('users', 'map_roles.clientId', '=', 'users.id')
                ->join('clients', 'users.id', '=', 'clients.clientId')
                ->select(
                    'users.name as client_name',
                    'users.username as client_code',
                    'clients.contactName as contact_person',
                    'users.contactNumber as client_number',
                    'map_roles.clientId as client_id'
                )
                ->get();
            // dd($clients);
            return view('Sitemarshal::client_list', compact('clients'));
        }
    }

    /*
        Provides role's private details.
    */
    public function view_role(int $id)
    {
        // dd($id);
        $user = $this->userInfo($id);
        $role['foodscraftRole'] = User::find($id)->getRoleNames()->toArray()[0];
        $details = [];
        if($role['foodscraftRole'] == "vendor"){
            $details = $this->vendorDetails($user)->first()->toArray();
        }elseif($role['foodscraftRole'] == "client"){
            $details = $this->clientDetails($user)->first()->toArray();
        }
        $result = array_merge($user, array_merge($details, $role));
        if($role['foodscraftRole'] == "vendor"){
            $docs['documents'] = VendorDocs::where('vendorId', $result['vendorId'])->get()->toArray();
            $result = array_merge($result, $docs);
        }
        $type = "view";
        return view("Sitemarshal::role_detail", compact('result', 'type'));
    }

    /*
        Provides vendor-client associated menus.
    */
    public function menus()
    {
        // dd('Menus');
        $menu_list = MapRole::where('map_roles.marshalId', Auth::user()->id)
            ->join('meal_menus', function($join){
                $join->on('map_roles.clientId', '=', 'meal_menus.clientId')
                    ->on('map_roles.vendorId', '=', 'meal_menus.vendorId');
            })
            ->join('users as u1', 'meal_menus.clientId', '=', 'u1.id')
            ->join('users as u2', 'meal_menus.vendorId', '=', 'u2.id')
            ->select(
                'meal_menus.id as meal_id',
                'meal_menus.vendorId as vendor_id',
                'meal_menus.clientId as client_id',
                'u1.name as client_name',
                'u1.username as client_code',
                'u2.name as vendor_name',
                'u2.username as vendor_code',
                'meal_menus.from_time',
                'meal_menus.to_time'
            )
            ->get();
        // dd($menu_list);
        return view('Sitemarshal::menu_list', compact('menu_list'));
    }

    /*
        Provide a particular detail.
    */
    public function menu_detail(Request $request)
    {
        // dd($request->all());
        $menu = MealMenu::where('meal_menus.id', $request->meal_id)
            ->join('users as u1', 'meal_menus.clientId', '=', 'u1.id')
            ->join('users as u2', 'meal_menus.vendorId', '=', 'u2.id')
            ->select(
                'meal_menus.*',
                'u1.name as client_name',
                'u1.username as client_code',
                'u2.name as vendor_name',
                'u2.username as vendor_code'
            )
            ->first();
        return view('Sitemarshal::menu_detail', compact('menu'));
    }

    /*
        Provides marshal's documents or if not found then to simply return view.
    */
    public function marshalDocuments($type)
    {
        $elements = MarshalDocs::where('marshalId', Auth::user()->id)->first();
        if($elements == null){
            return view('Sitemarshal::marshal_documents', compact('type'));
        }else{
            $type = "submitted";
            return view('Sitemarshal::marshal_documents', compact('elements', 'type'));
        }
    }
    
    public function editmarshalDocuments($type)
    {
        $elements = MarshalDocs::where('marshalId', Auth::user()->id)->first();
        return view('Sitemarshal::editmarshal_documents', compact('elements', 'type'));
    }

    /*
        Saves marshal's documents.
    */
    public function saveMarshalDocuments(Request $request)
    {
        $validate = Validator::make($request->all(), [
            'resume.*' => 'required|mimes:doc,pdf,docx,zip|max:10000',
//            'graduation.*' => 'required|mimes:doc,pdf,docx,zip|max:10000',
//            'postGraduation.*' => 'required|mimes:doc,pdf,docx,zip|max:10000',
//            'intermediate.*' => 'required|mimes:doc,pdf,docx,zip|max:10000',
//            'highSchool.*' => 'required|mimes:doc,pdf,docx,zip|max:10000',
//            'workExp.*' => 'required|mimes:doc,pdf,docx,zip|max:10000',
            'first_gov_id.*' => 'required|mimes:doc,pdf,docx,jpg,jpeg,png,zip|max:10000',
            'second_gov_id.*' => 'required|mimes:doc,pdf,docx,jpg,jpeg,png,zip|max:10000',
            'pro_pic.*' => 'required|mimes:jpg,jpeg,png|max:10000'
        ]);

        if($validate->fails()){
            return back()->with($this->errorBag($validate->errors()->all()));
        }else{
            //dd($request->all());
            $elements;
            foreach($request->all() as $key => $files){
                if($key !== "_token"){
//                    $name = pathinfo($files->getClientOriginalName(), PATHINFO_FILENAME);
//                    $extension = $files->getClientOriginalExtension();
//                    $storageName = $name . '_' . rand(10, 10000) . '.' . $extension;
//                    $store = $files->storeAs('public/documents/marshals/'.Auth::user()->id.'/', $storageName);
//                    $elements = MarshalDocs::updateOrCreate(
//                        ['marshalId' => Auth::user()->id],
//                        [$key => $storageName]
//                    );
                    
                    
                    if(is_file($files)){
                        $name = pathinfo($files->getClientOriginalName(), PATHINFO_FILENAME);
                        $extension = $files->getClientOriginalExtension();
                        $storageName = $name . '_' . rand(10, 10000) . '.' . $extension;
                        $store = $files->storeAs('public/documents/marshals/'.Auth::user()->id.'/', $storageName);
                        $elements = MarshalDocs::updateOrCreate(
                            ['marshalId' => Auth::user()->id],
                            [$key => $storageName]
                        );
                    }elseif(is_string($files)){
                        // dd($key, $files);
                        $elements = MarshalDocs::updateOrCreate(
                            ['marshalId' => Auth::user()->id],
                            [$key => $files]
                        );
                    }
                    
                }
            }
            $elements = $elements->toArray();
            $type = "submitted";
            $docredirect = $request->docredirect;
            
            if(isset($request->docredirect) && !empty($docredirect)){
              $elements = VendorDocs::where('vendorId', Auth::user()->id)->first();
              //return view('Vendor::reqDocs', compact('elements', 'type', 'docredirect'));
              return redirect('sitemarshal/submit/documents/new')->with(["message" => "Documents Updated Successfully", "alert-type" => "success"]);
            } else {
              return back()->with(["message" => "Documents Submitted Successfully", "alert-type" => "success"]);
            }
            
            // return view('Sitemarshal::reqDocs', compact('elements', 'type'));
            //return back()->with(["message" => "Documents Submitted Successfully", "alert-type" => "success"]);
        }
    }

    /*
        Provides Concern's List.
    */
    public function all_concern(int $id=null)
    {
        if($id == null){
            $concerns = MapRole::where('marshalId', Auth::user()->id)
                        ->join('raise_concerns', 'map_roles.clientId', '=', 'raise_concerns.clientId')
                        ->join('users as u1', 'raise_concerns.clientId', '=', 'u1.id')
                        ->select('raise_concerns.*', 'u1.email')
                        ->distinct()
                        ->get();
            return view('Sitemarshal::concern', compact('concerns'));
        }else{
            // dd($id);
            $concern = RaiseConcern::where('raise_concerns.id', $id)
                        ->join('users as u1', 'raise_concerns.clientId', '=', 'u1.id')
                        ->join('users as u2', 'raise_concerns.vendorEmail', '=', 'u2.email')
                        ->select('raise_concerns.id', 'clientId', 'description', 'vendorEmail', 'status', 'comment', 'images', 'videos', 'u1.email', 'u1.username as client_username', 'u2.username as vendor_username', 'u2.name as vendor_name')
                        ->first();
            $messages = ConcernMessage::where('concern_id', $id)
                        ->where('status', '!=', 'closed')
                        ->orderBy('created_at')->get();
            return view('Sitemarshal::concern', compact('concern', 'messages'));
        }
    }

    public function concern_message_input(Request $request)
    {
        \Log::info($request->all());
        try{
            $concern_msg = new ConcernMessage;
            $concern_msg->concern_id = $request->id;
            $concern_msg->status = $request->status;
            $concern_msg->sender = Auth::user()->username;
            $concern_msg->messages = $request->message;
            $concern_msg->save();
            return response()->json([
                'success' => 'Concern Message Saved Successfully!'
            ]);
        }
        catch(Exception $e){
            \Log::info($e);
        }
    }

    public function changeStatus(int $id)
    {
        // dd($id);
        $concern = RaiseConcern::where('id', $id)->first();
        $concern->status = 'Processing';
        $concern->save();
        return $this->allRelatedConcern();
    }

    public function event_list(int $event_id=null)
    {
        if(isset($event_id)){
            // dd($event_id);
            $event = RolesEvent::where('roles_events.id', $event_id)
                ->join('users as u1', 'roles_events.client_id', '=', 'u1.id')
                ->select(
                            'roles_events.id',
                            'roles_events.*',
                            'u1.name as client_name',
                            'u1.username as client_username'
                        )
                ->first();
            $event->vendor_name = User::where('id', $event->assigned_vendor)->select('name')->first();
            // dd($event);
            return view('Sitemarshal::event_detail', compact('event'));
        }else{
            $allEvents = MapRole::where('marshalId', Auth::user()->id)
                ->join('roles_events', 'map_roles.clientId', '=', 'roles_events.client_id')
                ->join('users', 'map_roles.clientId', '=', 'users.id')
                ->select('roles_events.id', 'roles_events.client_id', 'users.name as client_name', 'users.username as client_code', 'event_date', 'guest_number', 'rate_per_plate', 'decoration_needed', 'type_of_event')
                ->distinct()
                ->paginate(4);
            // dd($allEvents);
            return view('Sitemarshal::event_list', compact('allEvents'));
        }
    }

    public function feedback(int $vendorId=null, int $clientId=null)
    {
        if($vendorId == null){
            $feedbacks = MapRole::where('marshalId', Auth::user()->id)
                // ->join('feedback as f1', 'map_roles.vendorId', '=', 'f1.vendorId')
                // ->join('feedback as f2', 'map_roles.clientId', '=', 'f2.clientId')
                ->join('feedback as feed', function($join){
                    $join->on('map_roles.vendorId', '=', 'feed.vendorId')
                        ->on('map_roles.clientId', '=', 'feed.clientId');
                })
                ->join('users as u1', 'map_roles.vendorId', '=', 'u1.id')
                ->select('feed.*', 'map_roles.marshalId', 'u1.name as vendor_name', 'u1.username as vendor_username', 'u1.contactNumber as vendor_number')
                ->get();
            // dd($feedbacks->toArray());
            return view('Sitemarshal::feedback', compact('feedbacks'));
        }else{
            $menuDetails = MealMenu::where('vendorId', $vendorId)
                ->where('clientId', $clientId)
                ->orderBy('id', 'DESC')
                ->first();
            // dd($menuDetails);
            $vendorDetails = User::where('id', $vendorId)->select('id as vendor_id', 'name as vendor_name', 'username as vendor_username', 'email as vendor_email')->first();
            $clientDetails = User::where('id', $clientId)->select('id as client_id', 'name as client_name', 'username as client_username', 'email as client_email')->first();
            return view('Sitemarshal::feedback', compact('menuDetails', 'vendorDetails', 'clientDetails'));
        }
    }
}
