@extends('layouts.masterDashboard')
@section('content')
    <style>
        .mx-75{
            max-width: 75%;
        }
        div#allMsg::-webkit-scrollbar-thumb {
            border-radius: unset;
            border-top-left-radius: 10px;
            border-bottom-left-radius: 10px;
        }
        .common{
            border-radius: 5px;
            display: inline-block;
            padding: 10px;
            color: #fff;
            font-weight: lighter;
            font-size: small;
            box-shadow: 1px 1px 2px rgba(0,0,0,.3);
            margin: 5px;
            position: relative;
        }
        .common.sender{
            background: #72b8ff;
            float: left;
            clear: both;
            border-top-left-radius: 0px;
        }
        .common.receiver{
            background: #00D025;
            float: right;
            clear: both;
            border-top-right-radius: 0px;
        }
        .common.sender:before, .common.receiver:before{
            content: "";
            width: 0px;
            height: 0px;
            display: block;
            position: absolute;
            top: 0px;
        }
        .common.sender:before{
            border-left: 5px solid transparent;
            border-right: 5px solid #72b8ff;
            border-top: 5px solid #72b8ff;
            border-bottom: 5px solid transparent;
            left: -10px;
        }
        .common.receiver:before{
            border-left: 5px solid #00D025;
            border-right: 5px solid transparent;
            border-top: 5px solid #00D025;
            border-bottom: 5px solid transparent;
            right: -10px;
        }
    </style>
    <div class="row">
        <div class="col-md">
            <div class="card card-user">
                <div class="card-header pt-4" style="align-self: center;justify-content: center;width: 75%;border-bottom: none;">
                    <h3>Raise a Concern</h3>
                </div>
                <div class="card-body">
                    <div class="row d-flex justify-content-around">
                        <button class="{{ isset($concernType) && $concernType == 'existing' ? 'carrot' : 'peterriver' }} w-25" onclick="redirection('{{ url('client/existing/concern') }}');">Existing Concerns</button>
                        <button class="{{ isset($concernType) && $concernType == 'raise' ? 'carrot' : 'peterriver' }} w-25" onclick="redirection('{{ url('client/raise/concern') }}');">Generate Concerns</button>
                    </div>
                    <?php
                        // dd($concernType);
                    ?>
                    @if(isset($concernType) && $concernType == 'existing' && isset($concernList))
                    <?php //echo $shortparameter; ?>
                        <div class="container my-2">
                            <form action="{{ url('client/existing/concern') }}" method="GET">
                                <div class="d-flex justify-content-start">
                                    <select class="form-control w-25 mx-2" name="sorted" id="sorted">
                                        <option value="allconcerns" <?php if($shortparameter == "allconcerns"){ ?> selected <?php } ?>>All Concerns</option>
                                        <option value="Processing" <?php if($shortparameter == "Processing"){ ?> selected <?php } ?>>Processing</option>
                                        <option value="Resolved" <?php if($shortparameter == "Resolved"){ ?> selected <?php } ?>>Resolved</option>
                                    </select>
                                    <input type="submit" value="Sort" class="btn btn-primary mx-2 font-weight-bold">
                                </div>
                            </form>
                        </div>
                        <div class="table-responsive p-2" style="overflow-x: scroll; overflow-y: hidden;">
                            <table class="table table-hover">
                                <thead class="text-dark">
                                    <tr>
                                        <th class="text-center" scope="col">S.No.</th> 
                                        <th class="text-center" scope="col">Description of Concern</th> 
                                        <th class="text-center" scope="col">Against Vendor</th>
                                        <th class="text-center" scope="col">Status</th>
                                        <th scope="col" class="d-flex justify-content-center">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($concernList as $key => $concern)
                                        <tr>
                                            <td class="text-center" scope="row">{{ ++$key }}</td>
                                            <td class="text-center">{{ $concern->description }}</td>
                                            <td class="text-center">{{ $concern->vendorEmail }}</td>
                                            <td class="text-center">
                                                <div class="badge badge-info">{{ $concern->status }}</div>
                                            </td>
                                            <td class="d-flex justify-content-center">
                                                <div class="peterriver" style="padding: .3rem .2rem;" onclick="redirection('{{ url('client/view/concern').'/'.$concern->id }}');">View</div>
                                                @if($concern->status == "Resolved")
                                                <!--<div class="sunflower" style="padding: .3rem .2rem;">Resolved</div>-->
                                                @else
                                                <div class="sunflower" style="padding: .3rem .2rem;"onclick="redirection('{{ url('client/close/concern').'/'.$concern->id }}');">Close</div>
                                                @endif
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="7" align="center">No Concerns Raised Yet!</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    @elseif(isset($concernType) && $concernType == 'raise' && isset($vendorList))
                        <form method="POST" action="{{ url('client/raise/concern') }}" class="mt-4" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col">
                                    <div class="form-group">
                                        <label for="raised_by">Raised By</label>
                                        <input type="text" id="raised_by" class="form-control" value="{{ Auth::user()->name }}" readonly>
                                    </div>
                                </div>
                                <div class="col">
                                    <div class="form-group">
                                        <label for="mobile_no">Mobile No</label>
                                        <input type="text" id="mobile_no" class="form-control" value="{{ Auth::user()->contactNumber }}" readonly>
                                    </div>
                                </div>
                                <div class="col">
                                    <div class="form-group">
                                        <label for="description">Description of Concern</label>
                                        <select class="form-control" name="description" id="description" required>
                                            <option value="" checked>Select a Description</option>
                                            <option value="foodOrTaste">Food/Taste</option>
                                            <option value="staffBehaviour">Staff Behavior</option>
                                            <option value="hygiene">Hygiene & Sanitation</option>
                                            <option value="mealTiming">Meal Timing</option>
                                            <option value="other">Other</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col">
                                    <div class="form-group">
                                        <label for="vendorName">Choose Vendor from vendor-list</label>
                                        <select class="form-control" name="vendorName" id="vendorName" required>
                                            <option value="" checked>Select a Vendor</option>
                                            @forelse($vendorList as $vendors)
                                                <option value="{{ $vendors['email'] }}">{{ $vendors['email'] }}</option>
                                            @empty
                                                <p>No Vendors Assigned to you Yet!</p>
                                            @endforelse
                                        </select>
                                    </div>
                                </div>
                                <div class="col">
                                    <div class="form-group">
                                        <label for="comment">Comment/Remarks</label>
                                        <textarea class="form-control" id="comment" name="comment" style="resize: none;" rows="2"></textarea>
                                    </div>
                                </div>
                                <div class="col">
                                    <div class="form-group">
                                        <p>Image Upload</p>
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="imageproof" lang="es" name="imageproof[]" onchange="loadPreview(event);" multiple />
                                            <label class="custom-file-label" for="imageproof">Upload upto 3 images</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <div class="d-flex flex-wrap justify-content-center" id="preview"></div>
                                </div>
                            </div>
                            <div class="row d-flex justify-content-center">
                                <div class="response">
                                    <button type="submit" class="wetasphalt w-100" style="font-weight: bolder;font-size: medium;padding: 0.4rem 1.4rem;">Submit</button>
                                </div>
                            </div>
                        </form>
                    @elseif(isset($concernType) && $concernType == 'viewRaised' && isset($concern))
                        <?php
                            //dd($concern);
                            $imageList = isset($concern->images) ? explode(", ", $concern->images) : [];
                            $imagePath = asset('public/storage/concerns/client').'/'.Auth::user()->id.'/';
                        ?>
                        <div class="container-fluid mb-1 mt-4">
                        <div class="row">
                                <div class="col-md-6">
                                    <div class="row">
                                        <div class="col-md-12 col-sm-12">
                                            <div class="form-group">
                                                <label for="description">Description of Concern</label>
                                                <input type="text" name="description" value="{{ $concern->description }}" class="form-control" id="description" disabled />
                                            </div>
                                        </div>
                                        <div class="col-md-12 col-sm-12">
                                            <div class="form-group">
                                                <label for="vendorName">Chosen Vendor</label>
                                                <input type="text" name="vendorName" value="{{ $concern->vendor_name }} - {{ $concern->vendor_username }}" class="form-control" id="vendorName" disabled />
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12 col-sm-12">
                                            <div class="form-group">
                                                <label for="comment">Comment</label>
                                                <textarea class="form-control" id="comment" name="comment" style="resize: none;" rows="2" readonly>{{ $concern->comment }}</textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="d-flex flex-wrap justify-content-center" id="preview">
                                              <?php
                                              $checkifimage = count($imageList);
                                              if($checkifimage == 0){
                                              ?>   
                                              <div class="badge badge-info mb-4" style="font-size: 1rem;">No Images</div>
                                              <?php } else { ?>
                                                @foreach($imageList as $imageName)
                                                <?php //print_r($imageList); ?>
                                                  <img class="rounded m-2" style="box-shadow: 0 0.2rem 0.6rem rgba(0, 0, 0, 0.25) !important;" src="{{ $imagePath.$imageName }}" alt="Concerned Images.." width="150" height="100" />
                                                @endforeach
                                              <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="main-card card my-2 shadow-sm" style="height: 70%;max-height: 400px;">
                                        <div class="card-header p-2 border-bottom-0" style="background-color: #efefef !important;border-top-right-radius: 5px;border-top-left-radius: 5px;">
                                            <h5 class="text-center w-100 m-0" style="color: #000;">Discussion Board</h5>
                                        </div>
                                        <div class="card-body p-1" style="height: inherit;">
                                            <div class="flex flex-column px-2" id="allMsg" style="overflow-y: scroll;height: 100%;">
                                                <?php
                                                    // dd($concern, Auth::user()->username, $messages);
                                                ?>
                                                @forelse($messages as $message)
                                                    <div class="d-flex flex-row px-2 py-1 justify-content-{{ $message->sender !== Auth::user()->username ? 'start' : 'end' }}">
                                                        <div class="common mx-75 {{ $message->sender !== Auth::user()->username ? 'sender' : 'receiver' }}">
                                                            @if(Auth::user()->username !== $message->sender)
                                                                <div class="d-flex flex-row justify-content-start">
                                                                    <span class="text-secondary">{{ $message->sender }}</span>
                                                                </div>
                                                            @endif
                                                            <span class="text-white mr-3">
                                                                {{ $message->messages }}
                                                            </span>
                                                            <div class="d-flex flex-row justify-content-end ml-2">
                                                                <small class="text-muted">{{ date('dM H:i', strtotime($message->created_at)) }}</small>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @empty
                                                    <div class="d-flex flex-row px-2 py-1 justify-content-center">
                                                        <p class="badge" style="background: #efe7e7;color: cadetblue;">No Chats Yet!</p>
                                                    </div>
                                                @endforelse
                                            </div>
                                        </div>
                                        <div class="card-footer p-2" style="background-color: #e8e8e887 !important;border-bottom-right-radius: 5px;border-bottom-left-radius: 5px;">
                                            <div class="input-group" title="Not Working Right Now.">
                                                <div class="input-group-prepend mx-1">
                                                    <span class="input-group-text rounded" id="smile">
                                                        <i class="fa fa-smile-o" aria-hidden="true"></i>
                                                    </span>
                                                </div>
                                                <div class="form-control" id="concern_msg" dir="ltr" spellcheck="false" data-text="Enter your message..." contenteditable="true" style="border-radius: 4px; overflow-y: hidden; cursor: text; color: dimgray;"></div>
                                                <?php $newurl = url('client/concern/msg'); ?>
                                                <div class="input-group-append mx-1" onclick="sendToConcernForm('{{ $concern->id }}', '{{ $concern->status }}', '{{ $newurl }}');">
                                                    <span class="input-group-text rounded" id="send">
                                                        <i class="fa fa-send" aria-hidden="true"></i>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row d-flex justify-content-center">
                            <div class="update">
                                <div class="wetasphalt" style="font-weight: bolder;font-size: medium;padding: 0.4rem 1.4rem;" onclick="redirection('{{ url()->previous() }}');">Back</div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection