@extends('layouts.masterDashboard')
@section('content')
    <div class="row">
        <div class="col-md">
            <div class="card card-user">
                <div class="card-header pt-4 border-bottom-0 px-3">
                    <h3 class="w-100 text-center">Marshals List</h3>
                </div>
                <div class="card-body">
                    @if(isset($marshals))
                        <div class="table-responsive p-2" style="overflow-x: scroll; overflow-y: hidden;">
                            <table class="table table-hover">
                                <thead class="text-dark">
                                    <tr>
                                        <th class="text-center" scope="col">S.No.</th>
                                        <th class="text-center" scope="col">Name</th>
                                        <th class="text-center" scope="col">Mobile Number</th>
                                        <th class="text-center" scope="col">Designation</th>
                                        <th class="text-center" scope="col">Email</th>
                                        <th scope="col" class="justify-content-center" id="action">Action/Reason</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($marshals as $marshal)
                                        <?php
                                            // dd($marshal);
                                        ?>
                                        <tr>
                                            <td class="text-center" scope="row">{{ $loop->iteration }}</td>
                                            <td class="text-center">{{ $marshal->marshal_name }}</td>
                                            <td class="text-center">{{ $marshal->marshal_number }}</td>
                                            <td class="text-center">{{ $marshal->designation }}</td>
                                            <td class="text-center">{{ $marshal->marshal_email }}</td>
                                            <td class="justify-content-center">
                                                <form action="{{ url('client/marshal_detail') }}" method="POST">
                                                    @csrf
                                                    <!-- <a href="#" class="btn btn-info">View Details</a> -->
                                                    <input type="hidden" name="marshal_id" value="{{ $marshal->marshal_id }}">
                                                    <input type="submit" value="View Details" class="btn btn-info">
                                                </form>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="7" align="center">No Vendors Yet!</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection