@extends('layouts.masterDashboard')
@section('content')
    <div class="row">
        <div class="col-md">
            <div class="card card-user shadow-sm">
                <div class="card-header d-flex justify-content-center border-0 pt-4">
                    <h3>Edit Details</h3>
                </div>
                <div class="card-body py-1">
                    @if (!empty($message))
                        <div class="alert alert-success p-2">
                            {{ $message }}
                        </div>
                    @endif
                </div>
                <div class="card-body container py-2">
                    <div class="row justify-content-start">
                        @if(isset($all_qr_codes))
                            @forelse($all_qr_codes as $qr)
                                <div class="d-flex justify-content-center flex-column m-2">
                                    <img src="{{ $qr->qr_path }}" width="90" alt="QR Code" class="rounded m-1">
                                    <a class="text-center text-light text-decoration-none" href="{{ $qr->qr_path }}" target="_blank">{{ basename($qr->qr_path, '.png') }}</a>
                                </div>
                            @empty
                                <h3 class="text-danger">Something Went Wrong!!</h3>
                            @endforelse
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection