@extends('layouts.masterDashboard')
@section('content')
    <div class="row">
        <div class="col-md">
            <div class="card card-user shadow-sm">
                <div class="card-header d-flex justify-content-center border-0 pt-4">
                    <h3>Generate QR Code</h3>
                </div>
                <div class="card-body">
                    <form action="{{ url('client/ICount/I-count/generate_qr_code') }}" method="POST">
                        @csrf
                        <input type="hidden" name="client_id" value="{{ $client->client_id }}">
                        <div class="container">
                            <div class="row">
                                <div class="col form-group">
                                    <label for="qr_id">QR Code Id</label>
                                    <input type="text" class="form-control" name="qr_id" id="qr_id" value="{{ $last_qr_id }}" readonly>
                                </div>
                                <div class="col form-group">
                                    <label for="client_code">Client Code</label>
                                    <input type="text" class="form-control" name="client_code" id="client_code" value="{{ $client['client_code'] }}" readonly>
                                </div>
                                <div class="col form-group">
                                    <label for="client_code">QR Code Type</label>
                                    <select name="qr_code_type" class="form-control" id="qr_code_type" required>
                                        <option value="">Select QR Type</option>
                                        <option value="type1">Type 1</option>
                                        <option value="type2">Type 2</option>
                                        <option value="type3">Type 3</option>
                                        <option value="type4">Type 4</option>
                                    </select>
                                </div>
                                <div class="col form-group">
                                    <label for="qr_code_limit">QR Code Limit/Count</label>
                                    <input type="tel" pattern="^[0-9]$" data-toggle="tooltip" title="Number of QR codes desired.." class="form-control" name="qr_code_limit" id="qr_code_limit" required>
                                </div>
                            </div>
                            <div class="row justify-content-center">
                                <input type="submit" value="Generate QR Code" class="btn btn-primary font-weight-bold">
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection