@extends('layouts.masterDashboard')
@section('content')
    <div class="row">
        <div class="col-md">
            <div class="card card-user shadow-sm">
                <div class="card-header d-flex justify-content-center border-0 pt-4">
                    <h3>Employee Food Sale Report</h3>
                </div>
                <div class="card-body">
                    @if(isset($client_emp))
                        <form action="{{ url('client/ICount/I-count/generate_emp_diningsale_report') }}" method="POST">
                            @csrf
                            <input type="hidden" name="client_id" value="{{ $client_emp->client_id }}">
                            <input type="hidden" name="emp_database_id" value="{{ $client_emp->id }}">
                            <div class="container">
                                <div class="row">
                                    <div class="col">
                                        <div class="form-group">
                                            <label for="client_code">Client Name</label>
                                            <input type="text" name="client_code" value="{{ $client_emp->client->clientname }}" class="form-control" readonly>
                                        </div>
                                    </div>
                                    <input type="hidden" name="emp_id" value="{{ $client_emp->emp_id }}">
                                    <div class="col">
                                        <div class="form-group">
                                            <label for="client_contact_name">Employee Name</label>
                                            <input type="text" name="client_contact_name" value="{{ $client_emp->emp_name }}" class="form-control" readonly>
                                        </div>
                                    </div>
                                </div>
                                <div class="row d-flex justify-content-center">
                                    <div class="col-4">
                                        <div class="form-group">
                                            <label for="date_from">Date from</label>
                                            <div class="input-group p-0 shadow-sm datepicker date">
                                                <input class="form-control shadow-sm" id="date_from" type="text" name="date_from" placeholder="Date from" autocomplete="off" />
                                                <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                            </div>
                                            <!-- <input type="text" name="date_from" class="form-control"> -->
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <div class="form-group">
                                            <label for="date_to">Date To</label>
                                            <div class="input-group p-0 shadow-sm datepicker date">
                                                <input class="form-control shadow-sm" id="date_to" type="text" name="date_to" placeholder="Date to" autocomplete="off" />
                                                <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                            </div>
                                            <!-- <input type="text" name="date_to" class="form-control"> -->
                                        </div>
                                    </div>
                                </div>
                                <div class="row d-flex justify-content-center">
                                    <div class="col-3 d-flex justify-content-center">
                                        <div class="form-group">
                                            <input type="submit" class="btn btn-primary" value="Generate" >
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    @endif
                </div>
            </div>
        </div>
    </div>
    @section('customscript')
        <script>
            $(function () {
                // INITIALIZE DATEPICKER PLUGIN
                $('.datepicker').datepicker({
                    clearBtn: true,
                    endDate: new Date(),
                    format: "yyyy-mm-dd",
                    autoclose: true
                });
            });
        </script>
    @endsection
@endsection