@extends('layouts.masterDashboard')
@section('content')
    <div class="row">
        <div class="col-md">
            <div class="card card-user">
                <div class="card-header pt-4 border-bottom-0 px-3">
                    <h3 class="w-100 text-center">{{ isset($vendorList) ? 'Feedback' : 'Coming Soon' }}</h3>
                </div>
                <div class="card-body">
                    <?php
                        // dd($vendorList);
                    ?>
                    @if(isset($vendorList))
                        <div class="table-responsive p-2" style="overflow-x: scroll; overflow-y: hidden;">
                            <table class="table table-hover">
                                <thead class="text-dark">
                                    <tr>
                                        <th class="text-center" scope="col">S.No.</th>
                                        <th class="text-center" scope="col">Vendor</th>
                                        <th class="text-center" scope="col">Mobile Number</th>
                                        <th class="text-center" scope="col">Meal</th>
                                        <th scope="col" class="d-flex justify-content-center" id="action">Action/Reason</th>
                                        <!-- <th class="text-center" scope="col">Reason</th> -->
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($vendorList as $vendor)
                                        <?php
                                            // dd($vendor);
                                        ?>
                                        <tr>
                                            <td class="text-center" scope="row">{{ $loop->iteration }}</td>
                                            <td class="text-center">{{ $vendor->name . ' - ' . $vendor->username }}</td>
                                            <td class="text-center">{{ $vendor->contactNumber }}</td>
                                            @if($vendor->meal_menu)
                                                <td class="text-center">
                                                    <a href="{{ url('client/view/vendorMenus') . '/' . $vendor->id }}" class="peterriver w-100">
                                                        <i class="fa fa-eye"></i>
                                                    </a>
                                                </td>
                                                <td class="d-flex justify-content-center" id="actionoptions{{ $vendor->id }}">
                                                    <a href="#" title="Like" class="turquoise w-100 px-2 mr-2" style="padding: .3rem .2rem;" onclick="sendFeedReason({{ $vendor->id }}, {{ Auth::user()->id }});">
                                                        <i class="fa fa-thumbs-up"></i>
                                                    </a>
                                                    <a href="#" title="Dislike" class="sunflower w-100 px-2 mr-2" style="padding: .3rem .2rem;" onclick="viewText({{ $vendor->id }}, {{ Auth::user()->id }});">
                                                        <i class="fa fa-thumbs-down"></i>
                                                    </a>
                                                </td>
                                                <td class="text-center" id="reason{{ $vendor->id }}" style="display: none;">
                                                    <textarea class="form-control" id="textReason{{ $vendor->id }}" placeholder="Type your reason and press enter to submit.." onkeyup="javascript: if(event.keyCode == 13) sendFeedReason({{ $vendor->id }}, {{ Auth::user()->id }});"></textarea>
                                                </td>
                                            @else
                                                <td class="text-center">
                                                    <span class="badge badge-warning">No Menu</span>
                                                </td>
                                                <td class="text-center">
                                                    <span class="badge text-secondary">N/A</span>
                                                </td>
                                            @endif
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="7" align="center">No Vendors Yet!</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection