@extends('layouts.masterDashboard')
@section('content')
    <div class="row">
        <div class="col-md">
            <div class="card card-user">
                <div class="card-header pt-4" style="align-self: center;justify-content: center;width: 75%;border-bottom: none;">
                    <h3>Events</h3>
                </div>
                <div class="card-body py-0">
                    @if(isset($events) && !isset($type))
                        <div class="row d-flex justify-content-around">
                            <button class="{{ isset($events) ? 'carrot' : 'peterriver' }} w-auto" onclick="redirection('{{ url('client/existing/event') }}');">Existing Events</button>
                            <button class="{{ !isset($events) ? 'carrot' : 'peterriver' }} w-auto" onclick="redirection('{{ url('client/book/event') }}');">Book Event</button>
                        </div>
                    @endif
                    @if(isset($events))
                        <div class="table-responsive p-2" style="overflow-x: scroll; overflow-y: hidden;">
                            <table class="table table-hover">
                                <thead class="text-dark">
                                    <tr>
                                        <th class="text-center" scope="col">S.No.</th> 
                                        <th class="text-center" scope="col">Event Name</th> 
                                        <th class="text-center" scope="col">Guest Number</th>
                                        <th scope="col" class="d-flex justify-content-center">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($events as $key => $event)
                                        <tr>
                                            <td class="text-center" scope="row">{{ ++$key }}</td>
                                            <td class="text-center">{{ $event->type_of_event }}</td>
                                            <td class="text-center">{{ $event->guest_number }}</td>
                                            <td class="d-flex justify-content-center">
                                                <?php
                                                    $url = url('client/event');
                                                ?>
                                                <a href="{{ $url . '/view/' . $event->id }}" class="peterriver text-decoration-none text-white py-0">View</a>
                                                <a href="{{ $url . '/edit/' . $event->id }}" class="sunflower text-decoration-none text-white py-0">Edit</a>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="7" align="center">No Events Booked Yet!</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    @elseif(!isset($events) || (isset($eventDetail) && !empty($eventDetail) && isset($type)))
                        <form method="POST" action=<?php echo isset($type) && $type == "edit" ? url('client/editevent') : url('client/book/event') ?> class="rounded my-4 mx-2 p-4 shadow-sm" style="background-color: #f5f5f58c;">
                            @csrf
                            <?php
                                // dd($eventDetail);
                            ?>
                            @if(isset($type) && $type == "edit")
                                @method('PUT')
                                <input type="hidden" name="id" value="{{ $eventDetail['id'] }}" />
                                <input type="hidden" name="ticket" value="{{ $eventDetail['event_ticket'] }}" />
                            @endif
                            <div class="row">
                                <div class="col-md-4 col-sm-12 pr-md-1">
                                    <div class="form-group">
                                        <label for="reservationDate">Date of Event</label>
                                        <div class="input-group p-0 shadow-sm {{ (!isset($eventDetail['event_date']) && empty($eventDetail['event_date'])) ? 'datepicker date' : (isset($type) && $type == 'view' ? '' : 'datepicker date') }}">
                                            @if(isset($eventDetail['event_date']) && !empty($eventDetail['event_date']) && isset($type))
                                                @if($type == 'view')
                                                    <input type="text" class="form-control" value="{{ date('d/m/Y', $eventDetail['event_date']) }}" readonly />
                                                @elseif($type == 'edit')
                                                    <input class="form-control shadow-sm" id="reservationDate" type="text" name="reservationDate" placeholder="Choose a reservation date" value="{{ date('d/m/Y', $eventDetail['event_date']) }}" required />
                                                    <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                                @endif
                                            @else
                                                <input class="form-control shadow-sm" id="reservationDate" type="text" name="reservationDate" placeholder="Choose a reservation date" autocomplete="off" required />
                                                <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-12">
                                    <div class="form-group">
                                        <label for="guest_num">Guests Number</label>
                                        @if(isset($eventDetail['guest_number']) && !empty($eventDetail['guest_number']))
                                            <input type="text" name="guest_num" class="form-control" value="{{ $eventDetail['guest_number'] }}" <?php echo (isset($type) && $type == 'view') ? 'readonly' : '' ?> />
                                        @else
                                            <input id="guest_num" type="tel" pattern="[0-9]+" data-toggle="tooltip" value="{{ (isset($type) && $type == 'edit') ? $eventDetail['guest_number'] : '' }}" title="Number of Guests( In Numbers Only )" class="form-control shadow-sm" name="guests_number" autocomplete="off" value="" required />
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-12">
                                    <div class="form-group">
                                        <label for="plate_rate">Rates Per Plate</label>
                                        @if(isset($eventDetail['guestNumber']) && !empty($eventDetail['guestNumber']))
                                            <input class="form-control shadow-sm" name="plate_rate" value="{{ $eventDetail['ratePerPlate'] }}" <?php echo (isset($type) && $type == 'view') ? 'readonly' : '' ?> />
                                        @else
                                            <input id="plate_rate" type="tel" pattern="[0-9]+" data-toggle="tooltip" title="Rates Per Plate( In Numbers Only )" class="form-control shadow-sm" name="plate_rate" autocomplete="off" value="{{ (isset($type) && $type == 'edit') ? $eventDetail['ratePerPlate'] : '' }}" required />
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <h5 class="text-center d-flex justify-content-center"><span class="border-bottom">Type of Event</span></h5>
                                        <div class="d-flex justify-content-between flex-wrap">
                                            <?php
                                                $typeEvent = isset($eventDetail['typeOfEvent']) && !empty($eventDetail['typeOfEvent']);
                                            ?>
                                            <label class="radio mx-4 my-2">
                                                <input type="radio" name="eventType" value="corporateEvent" <?php echo (!isset($eventDetail['typeOfEvent']) && empty($eventDetail['typeOfEvent'])) ? "" : ($eventDetail['typeOfEvent'] == "corporateEvent" ? ($type == "view" ? "checked disabled" : "checked") : ($type == "edit" ? "" : "disabled")) ?> />
                                                <span>Corporate Event</span>
                                            </label>
                                            <label class="radio mx-4 my-2">
                                                <input type="radio" name="eventType" value="indoorThemeEvent" <?php echo (!isset($eventDetail['typeOfEvent']) && empty($eventDetail['typeOfEvent'])) ? "" : ($eventDetail['typeOfEvent'] == "indoorThemeEvent" ? ($type == "view" ? "checked disabled" : "checked") : ($type == "edit" ? "" : "disabled")) ?> />
                                                <span>Indoor Theme Event</span>
                                            </label>
                                            <label class="radio mx-4 my-2">
                                                <input type="radio" name="eventType" value="odc" <?php echo (!isset($eventDetail['typeOfEvent']) && empty($eventDetail['typeOfEvent'])) ? "" : ($eventDetail['typeOfEvent'] == "odc" ? ($type == "view" ? "checked disabled" : "checked") : ($type == "edit" ? "" : "disabled")) ?> />
                                                <span>ODC</span>
                                            </label>
                                            <label class="radio mx-4 my-2">
                                                <input type="radio" name="eventType" value="outdoorThemeEvent" <?php echo (!isset($eventDetail['typeOfEvent']) && empty($eventDetail['typeOfEvent'])) ? "" : ($eventDetail['typeOfEvent'] == "outdoorThemeEvent" ? ($type == "view" ? "checked disabled" : "checked") : ($type == "edit" ? "" : "disabled")) ?> />
                                                <span>Outdoor Theme Event</span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <h5 class="text-center d-flex justify-content-center"><span class="border-bottom">Decoration needed</span></h5>
                                        <div class="d-flex justify-content-around flex-wrap">
                                            <?php
                                                $decoration = isset($eventDetail['decorationNeeded']) && !empty($eventDetail['decorationNeeded']);
                                            ?>
                                            <label class="radio mx-4 my-2">
                                                <input type="radio" name="eventDecoration" value="yes" <?php echo (!isset($eventDetail['decorationNeeded']) && empty($eventDetail['decorationNeeded'])) ? "" : ($eventDetail['decorationNeeded'] == "yes" ? ($type == "view" ? "checked disabled" : "checked") : ($type == "edit" ? "" : "disabled")) ?> />
                                                <span>Yes</span>
                                            </label>
                                            <label class="radio mx-4 my-2">
                                                <input type="radio" name="eventDecoration" value="no" <?php echo (!isset($eventDetail['decorationNeeded']) && empty($eventDetail['decorationNeeded'])) ? "" : ($eventDetail['decorationNeeded'] == "no" ? ($type == "view" ? "checked disabled" : "checked") : ($type == "edit" ? "" : "disabled")) ?> />
                                                <span>No</span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @if(isset($type))
                                @if($type == 'view')
                                    <div class="row">
                                        <div class="update ml-auto mr-auto">
                                            <div class="wetasphalt" style="font-weight: bolder;font-size: medium;padding: 0.4rem 1.4rem;" onclick="redirection('{{ url()->previous() }}');">Back</div>
                                        </div>
                                    </div>
                                @elseif($type == 'edit')
                                    <div class="row d-flex justify-content-center">
                                        <div class="update">
                                            <div class="wetasphalt" style="font-weight: bolder;font-size: medium;padding: 0.4rem 1.4rem;" onclick="redirection('{{ url()->previous() }}');">Back</div>
                                        </div>
                                        <div class="update">
                                            <button type="submit" class="sunflower w-100" style="font-weight: bolder;font-size: medium;padding: 0.4rem 1.4rem;">Update</button>
                                        </div>
                                    </div>
                                @endif
                            @else
                                <div class="row">
                                    <div class="update ml-auto mr-auto">
                                        <button type="submit" class="turquoise" style="padding: .4rem 1rem;width: auto;font-size: 1rem;">Book Now</button>
                                    </div>
                                </div>
                            @endif
                        </form>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection