@extends('layouts.masterDashboard')
@section('content')
    <div class="row">
        <div class="col-md">
            <div class="card card-user">
                <div class="card-header pt-4" style="align-self: center;justify-content: center;width: 75%;border-bottom: none;">
                    <h3>View Event</h3>
                </div>
                <div class="card-body py-0">
                    @if((isset($event) && !empty($event)) && (isset($type) && $type == 'view'))
                        <?php
                            // dd($event);
                        ?>
                        <div class="row">
                            <div class="col-md-4 col-sm-12 pr-md-1">
                                <div class="form-group">
                                    <label for="reservationDate">Date of Event</label>
                                    <div class="input-group p-0 shadow-sm">
                                        <input type="text" class="form-control" value="{{ date('d/m/Y', $event->event_date) }}" readonly />
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <div class="form-group">
                                    <label for="guest_num">Number of PAX</label>
                                    <input type="text" name="guest_num" class="form-control" value="{{ $event->guest_number }}" readonly />
                                </div>
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <div class="form-group">
                                    <label for="plate_rate">Rates Per Plate</label>
                                    <input class="form-control shadow-sm" name="plate_rate" value="{{ $event->rate_per_plate }}" readonly />
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4 col-sm-12">
                                <div class="form-group">
                                    <label for="plate_rate">Type of Event</label>
                                    <input class="form-control shadow-sm" name="plate_rate" value="{{ $event->type_of_event }}" readonly />
                                </div>
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <div class="form-group">
                                    <label for="description">Description</label>
                                    <textarea name="description" id="description" class="form-control" value="{{ $event->description }}" readonly>{{ $event->description }}</textarea>
                                </div>
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <div class="form-group">
                                    <p>Suggestive Menu</p>
                                    @if(isset($event->menu_suggest))
                                        <a class="btn btn-info" target="_blank" href="{{ asset('public/storage/vendor/suggestion') . '/' . Auth::user()->id . '/' . $event->menu_suggest }}">Suggestion</a>
                                    @else
                                        <span class="text-warning">No suggestions</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <h5 class="text-center d-flex justify-content-center">
                                        <span class="border-bottom">Decoration needed</span>
                                    </h5>
                                    <div class="d-flex justify-content-around flex-wrap">
                                        <?php
                                            $decoration = isset($event->decoration_needed) && !empty($event->decoration_needed);
                                        ?>
                                        <label class="radio mx-4 my-2">
                                            <input type="radio" name="eventDecoration" value="yes" <?php echo (!isset($event->decoration_needed) && empty($event->decoration_needed)) ? "" : ($event->decoration_needed == "yes" ? ($type == "view" ? "checked disabled" : "checked") : ($type == "edit" ? "" : "disabled")) ?> />
                                            <span>Yes</span>
                                        </label>
                                        <label class="radio mx-4 my-2">
                                            <input type="radio" name="eventDecoration" value="no" <?php echo (!isset($event->decoration_needed) && empty($event->decoration_needed)) ? "" : ($event->decoration_needed == "no" ? ($type == "view" ? "checked disabled" : "checked") : ($type == "edit" ? "" : "disabled")) ?> />
                                            <span>No</span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <h5 class="d-flex justify-content-center">
                                        <span class="border-bottom">Cutlery & Crockery needed</span>
                                    </h5>
                                    <div class="d-flex justify-content-around flex-wrap">
                                        <?php
                                            $cultery = isset($event->cultry_crockery) && !empty($event->cultry_crockery);
                                        ?>
                                        <label class="radio mx-4 my-2">
                                            <input type="radio" name="cultry_crockery" value="yes" <?php echo (!isset($event->cultry_crockery) && empty($event->cultry_crockery)) ? "" : ($event->cultry_crockery == "yes" ? ($type == "view" ? "checked disabled" : "checked") : ($type == "edit" ? "" : "disabled")) ?> />
                                            <span>Yes</span>
                                        </label>
                                        <label class="radio mx-4 my-2">
                                            <input type="radio" name="cultry_crockery" value="no" <?php echo (!isset($event->cultry_crockery) && empty($event->cultry_crockery)) ? "" : ($event->cultry_crockery == "no" ? ($type == "view" ? "checked disabled" : "checked") : ($type == "edit" ? "" : "disabled")) ?> />
                                            <span>No</span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection