@extends('layouts.masterDashboard')
@section('content')
    <style>
        .multisteps-form__progress {
          display: grid;
          grid-template-columns: repeat(auto-fit, minmax(0, 1fr));
        }

        .multisteps-form__progress-btn {
          transition-property: all;
          transition-duration: 0.15s;
          transition-timing-function: linear;
          transition-delay: 0s;
          position: relative;
          padding-top: 20px;
          color: rgba(108, 117, 125, 0.7);
          text-indent: -9999px;
          border: none;
          background-color: transparent;
          outline: none !important;
          cursor: pointer;
        }

        @media (min-width: 500px) {
          .multisteps-form__progress-btn {
            text-indent: 0;
          }
        }

        .multisteps-form__panel[data-animation=slideHorz].js-active {
          transition-property: all;
          transition-duration: .25s;
          transition-timing-function: cubic-bezier(.2,1.13,.38,1.43);
          transition-delay: 0s;
          left: 0;
        }
        .multisteps-form__panel[data-animation=slideHorz] {
          left: 50px;
        }

        .multisteps-form__progress-btn:before {
          position: absolute;
          top: 0;
          left: 50%;
          display: block;
          width: 13px;
          height: 13px;
          content: '';
          -webkit-transform: translateX(-50%);
          transform: translateX(-50%);
          transition: all 0.15s linear 0s, -webkit-transform 0.15s cubic-bezier(0.05, 1.09, 0.16, 1.4) 0s;
          transition: all 0.15s linear 0s, transform 0.15s cubic-bezier(0.05, 1.09, 0.16, 1.4) 0s;
          transition: all 0.15s linear 0s, transform 0.15s cubic-bezier(0.05, 1.09, 0.16, 1.4) 0s, -webkit-transform 0.15s cubic-bezier(0.05, 1.09, 0.16, 1.4) 0s;
          border: 2px solid currentColor;
          border-radius: 50%;
          background-color: #fff;
          box-sizing: border-box;
          z-index: 3;
        }

        .multisteps-form__progress-btn:after {
          position: absolute;
          top: 5px;
          left: calc(-50% - 13px / 2);
          transition-property: all;
          transition-duration: 0.15s;
          transition-timing-function: linear;
          transition-delay: 0s;
          display: block;
          width: 100%;
          height: 2px;
          content: '';
          background-color: currentColor;
          z-index: 1;
        }

        .multisteps-form__progress-btn:first-child:after {
          display: none;
        }

        .multisteps-form__progress-btn.js-active {
          color: #007bff;
        }

        .multisteps-form__progress-btn.js-active:before {
          -webkit-transform: translateX(-50%) scale(1.2);
          transform: translateX(-50%) scale(1.2);
          background-color: currentColor;
        }

        .multisteps-form__form {
          position: relative;
        }

        .multisteps-form__panel {
          position: absolute;
          top: 0;
          left: 0;
          width: 100%;
          height: 0;
          opacity: 0;
          visibility: hidden;
        }

        .multisteps-form__panel.js-active {
          height: auto;
          opacity: 1;
          visibility: visible;
        }
    </style>
    <div class="row">
        <div class="col-md">
            <div class="card card-user shadow-sm mb-3">
                <div class="card-header d-flex justify-content-center border-0 pt-4">
                  <h3><?php echo $roleType; ?>&nbsp; - Map Details</h3>
                </div>
                <div class="card-body multisteps-form">
                    @if(isset($listDetail))
                        <!--progress bar-->
                        <div class="row">
                            <div class="col-12 col-lg-8 ml-auto mr-auto mt-1">
                                <div class="multisteps-form__progress">
                                    @switch($roleType)
                                        @case("vendor")
                                            <button class="multisteps-form__progress-btn js-active" type="button" data-toggle="tooltip" title="Click to see Client List">Client</button>
                                            <button class="multisteps-form__progress-btn" type="button" data-toggle="tooltip" title="Click to see Marshal List">Marshal</button>
                                        @break
                                        @case("client")
                                            <button class="multisteps-form__progress-btn js-active" type="button" data-toggle="tooltip" title="Click to see Vendor List">Vendor</button>
                                            <button class="multisteps-form__progress-btn" type="button" data-toggle="tooltip" title="Click to see Marshal List">Marshal</button>
                                        @break
                                        @case("sitemarshal")
                                            <button class="multisteps-form__progress-btn js-active" type="button" data-toggle="tooltip" title="Click to see Vendor List">Vendor</button>
                                            <button class="multisteps-form__progress-btn" type="button" data-toggle="tooltip" title="Click to see Client List">Client</button>
                                        @break
                                        @default
                                            Something Bad Happened
                                    @endswitch
                                </div>
                            </div>
                        </div>
                        <?php
                            // dd($listDetail);
                        ?>
                        <div class="multisteps-form__form">
                            @forelse($listDetail as $role_name => $role_detail)
                                @if($role_name == "clientId")
                                    <?php
                                        $activeDiv = ($roleType == "vendor" ? "multisteps-form__panel p-4 bg-white js-active client" : "multisteps-form__panel p-4 bg-white client");
                                    ?>
                                    <div class="{{ $activeDiv }}" data-animation="slideHorz">
                                        <div class="multisteps-form__content">
                                            <div class="row">
                                                <div class="col-12 mt-2">
                                                    <div class="card shadow-none">
                                                        <div class="card-body p-1">
                                                            <table class="table table-hover">
                                                                <thead class="text-dark">
                                                                    <tr>
                                                                        <th class="text-center" scope="col">S.No.</th>
                                                                        <th class="text-center" scope="col">Name</th>
                                                                        <th class="text-center" scope="col">Mobile No.</th>
                                                                        <th class="text-center" scope="col">Location</th>
                                                                        <th class="text-center" scope="col">Action</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody class="tab">
                                                                    @forelse($role_detail as $x => $info)
                                                                        <tr>
                                                                            <th class="text-center" scope="row">{{ $loop->iteration }}</th>
                                                                            <td class="text-center">{{ $info['name'] }}</td>
                                                                            <td class="text-center">{{ $info['contactNumber'] }}</td>
                                                                            <td class="text-center">{{ $info['address'] }}</td>
                                                                            <td class="d-flex justify-content-center">
                                                                                <div class="peterriver" onclick="viewOrEdit('{{ url('viewOrEditRole') }}', 'view', '{{ $info['clientId'] }}');">View</div>
                                                                            </td>
                                                                        </tr>
                                                                    @empty
                                                                        <p>Role Escaped!</p>
                                                                    @endforelse
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="button-row d-flex mt-4 col-12">
                                                    @if($roleType == "vendor")
                                                        <button class="wetasphalt ml-auto js-btn-next" type="button">Next</button>
                                                    @elseif($roleType == "sitemarshal")
                                                        <button class="wetasphalt js-btn-prev" type="button">Prev</button>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @elseif($role_name == "vendorId")
                                    <?php
                                        $activeDiv = ($roleType == "client" || $roleType == "sitemarshal" ? "multisteps-form__panel p-4 bg-white js-active vendor" : "multisteps-form__panel p-4 bg-white vendor");
                                    ?>
                                    <div class="{{ $activeDiv }}" data-animation="slideHorz">
                                        <div class="multisteps-form__content">
                                            <div class="row">
                                                <div class="col-12 mt-2">
                                                    <div class="card shadow-none">
                                                        <div class="card-body p-1">
                                                            <table class="table table-hover">
                                                                <thead class="text-dark">
                                                                    <tr>
                                                                        <th class="text-center" scope="col">S.No.</th>
                                                                        <th class="text-center" scope="col">Name</th>
                                                                        <th class="text-center" scope="col">Mobile No.</th>
                                                                        <th class="text-center" scope="col">Location</th>
                                                                        <th class="text-center" scope="col">Action</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody class="tab">
                                                                    @forelse($role_detail as $x => $info)
                                                                        <tr>
                                                                            <th class="text-center" scope="row">{{ $loop->iteration }}</th>
                                                                            <td class="text-center">{{ $info['name'] }}</td>
                                                                            <td class="text-center">{{ $info['contactNumber'] }}</td>
                                                                            <td class="text-center">{{ $info['address'] }}</td>
                                                                            <td class="d-flex justify-content-center">
                                                                                <div class="peterriver" onclick="viewOrEdit('{{ url('viewOrEditRole') }}', 'view', '{{ $info['vendorId'] }}');">View</div>
                                                                            </td>
                                                                        </tr>
                                                                    @empty
                                                                        <p>Role Escaped!</p>
                                                                    @endforelse
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="button-row d-flex mt-4 col-12">
                                                    @if($roleType == "sitemarshal" || $roleType == "client")
                                                        <button class="wetasphalt ml-auto js-btn-next" type="button">Next</button>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @elseif($role_name == "marshalId")
                                    <div class="multisteps-form__panel p-4 bg-white marshal" data-animation="slideHorz">
                                        <div class="multisteps-form__content">
                                            <div class="row">
                                                <div class="col-12 mt-2">
                                                    <div class="card shadow-none">
                                                        <div class="card-body p-1">
                                                            <table class="table table-hover">
                                                                <thead class="text-dark">
                                                                    <tr>
                                                                        <th class="text-center" scope="col">S.No.</th>
                                                                        <th class="text-center" scope="col">Name</th>
                                                                        <th class="text-center" scope="col">Mobile No.</th>
                                                                        <th class="text-center" scope="col">Location</th>
                                                                        <th class="text-center" scope="col">Action</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody class="tab">
                                                                    @forelse($role_detail as $x => $info)
                                                                        <tr>
                                                                            <th class="text-center" scope="row">{{ $loop->iteration }}</th>
                                                                            <td class="text-center">{{ $info['name'] }}</td>
                                                                            <td class="text-center">{{ $info['contactNumber'] }}</td>
                                                                            <td class="text-center">{{ $info['address'] }}</td>
                                                                            <td class="d-flex justify-content-center">
                                                                                <div class="peterriver" onclick="viewOrEdit('{{ url('viewOrEditRole') }}', 'view', '{{ $info['marshalId'] }}');">View</div>
                                                                            </td>
                                                                        </tr>
                                                                    @empty
                                                                        <p>Role Escaped!</p>
                                                                    @endforelse
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="button-row d-flex mt-4 col-12">
                                                    <button class="wetasphalt js-btn-prev" type="button">Prev</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            @empty
                                <p>Not Mapped Yet!</p>
                            @endforelse
                        </div>
                    @else
                        <h2>Something Went Wrong</h2>
                    @endif
                </div>
            </div>
        </div>
    </div>
    @section('customscript')
        <script src="{{ asset('public/js/progressTableForm.js') }}"></script>
        <script>
            marshals = [];
            vendors = [];
            clients = [];

            function functiontofindIndexByKeyValue(arraytosearch, key, valuetosearch){
                for (var i = 0; i < arraytosearch.length; i++) {
                    if (arraytosearch[i][key] == valuetosearch) {
                        return i;
                    }
                }
                return null;
            }

            function checkClients(val){
                clients = [];
                clients.push(val);
                createClientsTable(clients);
            }

            function createClientsTable(value){
                var clientBody = document.getElementById('client');
                clientBody.innerHTML = '';
                var td = "";
                var tr = "";
                var s_no = "";
                value.forEach((el, index) => {
                    tr = document.createElement('tr');
                    s_no = document.createElement('td');
                    s_no.appendChild(document.createTextNode(++index));
                    s_no.classList.add("text-center");
                    tr.appendChild(s_no);
                    for (var key in el) {
                        if (key !== 'currentElement' && key !== 'id'){
                            td = document.createElement('td');
                            td.appendChild(document.createTextNode(el[key]));
                            td.classList.add("text-center");
                            tr.appendChild(td);
                        }
                    }
                    clientBody.appendChild(tr);
                });
            }

            function checkVendors(val){
                if (!val.currentElement.control.checked){
                    vendors.push(val);
                } else if (val.currentElement.control.checked){
                    indexToPop = functiontofindIndexByKeyValue(vendors, "email", val['email']);
                    vendors.splice(indexToPop, 1);
                }
                createVendorsTable(vendors);
                createVendorInputs(vendors);
            }

            function createVendorsTable(value){
                var venBody = document.getElementById('vendor');
                venBody.innerHTML = '';
                var td = "";
                var tr = "";
                var s_no = "";
                value.forEach((el, index) => {
                    tr = document.createElement('tr');
                    s_no = document.createElement('td');
                    s_no.appendChild(document.createTextNode(++index));
                    s_no.classList.add("text-center");
                    tr.appendChild(s_no);
                    for (var key in el) {
                        if (key !== 'currentElement' && key !== 'id'){
                            td = document.createElement('td');
                            td.appendChild(document.createTextNode(el[key]));
                            td.classList.add("text-center");
                            tr.appendChild(td);
                        }
                    }
                    venBody.appendChild(tr);
                });
            }

            function createVendorInputs(value){
                var venBody = document.getElementById('vendorTimingFees');
                venBody.innerHTML = '';
                value.forEach((el, index) => {
                    tr = document.createElement('tr');
                    s_no = document.createElement('td');
                    s_no.appendChild(document.createTextNode(++index));
                    s_no.classList.add("text-center");
                    tr.appendChild(s_no);
                    for (var key in el) {
                        if (key !== 'currentElement' && key !== 'address' && key !== 'id'){
                            td = document.createElement('td');
                            td.appendChild(document.createTextNode(el[key]));
                            td.classList.add("text-center");
                            tr.appendChild(td);
                        }
                    }
                    td = document.createElement('td');
                    td.classList.add("text-center");
                    var input = document.createElement('input');
                    input.classList.add("form-control");
                    input.setAttribute('type', 'text');
                    var aggr = "aggregation[" + el['id'] + "]";
                    input.setAttribute('name', aggr);
                    td.appendChild(input);
                    tr.appendChild(td);
                    td = document.createElement('td');
                    td.classList.add("text-center");
                    var textarea = document.createElement('textarea');
                    textarea.classList.add("form-control");
                    var mealTime = "mealTime[" + el['id'] + "]";
                    textarea.setAttribute('name', mealTime);
                    textarea.setAttribute('placeholder', 'Meal Timings');
                    td.appendChild(textarea);
                    tr.appendChild(td);
                    venBody.appendChild(tr);
                });
            }

            function checkMarshals(val){
                if (!val.currentElement.control.checked){
                    marshals.push(val);
                } else if (val.currentElement.control.checked){
                    indexToPop = functiontofindIndexByKeyValue(marshals, "email", val['email']);
                    marshals.splice(indexToPop, 1);
                }
                createMarshalsTable(marshals);
                createMarshalInputs(marshals);
            }

            function createMarshalsTable(value){
                var marBody = document.getElementById('marshal');
                marBody.innerHTML = '';
                var td = "";
                var tr = "";
                var s_no = "";
                value.forEach((el, index) => {
                    tr = document.createElement('tr');
                    s_no = document.createElement('td');
                    s_no.appendChild(document.createTextNode(++index));
                    s_no.classList.add("text-center");
                    tr.appendChild(s_no);
                    for (var key in el) {
                        if (key !== 'currentElement' && key !== 'id'){
                            td = document.createElement('td');
                            td.appendChild(document.createTextNode(el[key]));
                            td.classList.add("text-center");
                            tr.appendChild(td);
                        }
                    }
                    marBody.appendChild(tr);
                });
            }

            function createMarshalInputs(value){
                var marBody = document.getElementById('marshalTiming');
                marBody.innerHTML = '';
                value.forEach((el, index) => {
                    tr = document.createElement('tr');
                    s_no = document.createElement('td');
                    s_no.appendChild(document.createTextNode(++index));
                    s_no.classList.add("text-center");
                    tr.appendChild(s_no);
                    for (var key in el) {
                        if (key !== 'currentElement' && key !== 'address' && key !== 'id'){
                            td = document.createElement('td');
                            td.appendChild(document.createTextNode(el[key]));
                            td.classList.add("text-center");
                            tr.appendChild(td);
                        }
                    }
                    td = document.createElement('td');
                    td.classList.add("text-center");
                    var input = document.createElement('input');
                    input.classList.add("form-control");
                    input.setAttribute('type', 'text');
                    var marTime = "marTime[" + el['id'] + "]";
                    input.setAttribute('name', marTime);
                    td.appendChild(input);
                    tr.appendChild(td);
                    marBody.appendChild(tr);
                });
            }
        </script>
    @endsection
@endsection
