@extends('layouts.masterDashboard')
@section('content')
    <div class="row">
        <div class="col-md">
            <div class="card card-user shadow-sm">
                <div class="card-header d-flex justify-content-center border-0 pt-4">
                    <h3>Enter Employee Detail & Assign QR Code</h3>
                </div>
                <div class="card-body">
                    <form action="{{ url('ICount/I-count/assign_qr') }}" method="POST">
                        @csrf
                        <input type="hidden" name="client_id" value="{{ $client['client_id'] }}">
                        <div class="container">
                            <div class="row">
                                <div class="col form-group">
                                    <label for="client_code">Client Code</label>
                                    <input type="text" class="form-control" name="client_code" id="client_code" value="{{ $client['client_code'] }}" readonly>
                                </div>
                                <div class="col form-group">
                                    <label for="emp_name">Employee Name</label>
                                    <input type="text" class="form-control" name="emp_name" id="emp_name">
                                </div>
                                <div class="col form-group">
                                    <label for="emp_id">Employee Id</label>
                                    <input type="text" class="form-control" name="emp_id" id="emp_id">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col col-md-4 form-group">
                                    <label for="designation">Designation</label>
                                    <input type="text" class="form-control" name="designation" id="designation">
                                </div>
                                <div class="col col-md-4 form-group">
                                    <label for="designation">Height (in cm)</label>
                                    <input min=0 type="number" class="form-control" name="height" id="height">
                                </div>
                                <div class="col col-md-4 form-group">
                                    <label for="designation">Weight (in Kg)</label>
                                    <input min=0 type="number" class="form-control" name="weight" id="weight">
                                </div>                                
                            </div>
                            
                            <div class="row">
                                <div class="col col-md-4 form-group">
                                    <label for="qr_code_type">Meal Category</label>
                                    <select name="qr_code_type" class="form-control" id="qr_code_type" onchange="show_related_qr(event);" required>
                                        <option value="">Select Category</option>
                                        <option value="type1">Type 1</option>
                                        <option value="type2">Type 2</option>
                                        <option value="type3">Type 3</option>
                                        <option value="type4">Type 4</option>
                                    </select>
                                </div>

                                <div class="col form-group d-none" id="div_avail_qr_code">
                                    <label for="avail_qr_code">QR Code</label>
                                    <select name="avail_qr_code" class="form-control" id="avail_qr_code">
                                        <option value="">Select QR Codes</option>
                                    </select>
                                </div>
                            </div>
                            <div class="row">
                                <h5>
                                    <span class="text-info">NOTE: </span>
                                    <span class="text-white">Leave QR Code blank only if you want to register employee without qr-code.</span>
                                </h5>
                            </div>
                            <div class="row justify-content-center">
                                <input type="submit" value="Assign QR Code" class="btn btn-primary font-weight-bold">
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        @section('customscript')
            <script>
                const array = ['type1', 'type2', 'type3', 'type4'];
                function show_related_qr(event)
                {
                    var select_qr_code = event.target.value;
                    if(array.includes(select_qr_code)){
                        $('select#avail_qr_code').empty().append('<option>Select QR Codes</option>');
                        var client_code = $("input#client_code").val();
                        var link = "{{ url('ICount/I-count/give_qr_type_detail') }}" + "/" + select_qr_code + "/" + client_code;
                        $.ajax({
                            type        : 'GET',
                            url         : link,
                            success     : function(res){
                                console.log(res);
                                res.forEach((key, index) => {
                                    var option = document.createElement("option");
                                    option.value = key.qr_id;
                                    option.appendChild(document.createTextNode(key.qr_id));
                                    document.getElementById('avail_qr_code').appendChild(option);
                                });
                            },
                            complete:function(data){
                                console.log(data);
                                $('div#div_avail_qr_code').removeClass("d-none");
                            },
                            error       : function(xhr, textStatus, errorThrown){
                                console.log(errorThrown, textStatus);
                            }
                        });
                    }else{
                        $('div#div_avail_qr_code').addClass("d-none");
                    }
                }
            </script>
        @endsection
    </div>
@endsection