@extends('layouts.masterDashboard')
@section('content')
    <div class="row">
        <div class="col-md">
            <div class="card card-user">
                <div class="card-header pt-4" style="align-self: center;justify-content: center;width: 75%;border-bottom: none;">
                    <h3>{{ isset($roleEvent) ? "Assign Vendor" : '' }}</h3>
                </div>
                <div class="card-body">
                    @if(isset($roleEvent))
                        <?php
                            // dd($roleEvent);
                        ?>
                        <form>
                            @csrf
                            <div class="row">
                                <div class="col-md-4 col-sm-12 pr-md-1">
                                    <div class="form-group">
                                        <label for="reservationDate">Date of Event</label>
                                        <div class="input-group p-0 shadow-sm">
                                            <input type="text" name="reservationDate" class="form-control" value="{{ date('d/m/Y', $roleEvent->eventDate) }}" readonly />
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-12">
                                    <div class="form-group">
                                        <label for="guestsNumber">Guests Number</label>
                                        <input type="text" name="guestsNumber" class="form-control" value="{{ $roleEvent->guestNumber }}" readonly />
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-12">
                                    <div class="form-group">
                                        <label for="plateRate">Rates Per Plate</label>
                                        <input class="form-control shadow-sm" name="plateRate" value="{{ $roleEvent->ratePerPlate }}" readonly />
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <h5 class="text-center d-flex justify-content-center"><span class="border-bottom">Type of Event</span></h5>
                                        <div class="d-flex justify-content-between flex-wrap">
                                            <label class="radio mx-4 my-2">
                                                <input type="radio" name="eventType" value="corporateEvent" <?php echo empty($roleEvent->typeOfEvent) ? "" : ($roleEvent->typeOfEvent == "corporateEvent" ? "checked disabled" : "disabled") ?> />
                                                <span>Corporate Event</span>
                                            </label>
                                            <label class="radio mx-4 my-2">
                                                <input type="radio" name="eventType" value="indoorThemeEvent" <?php echo empty($roleEvent->typeOfEvent) ? "" : ($roleEvent->typeOfEvent == "indoorThemeEvent" ? "checked disabled" : "disabled") ?> />
                                                <span>Indoor Theme Event</span>
                                            </label>
                                            <label class="radio mx-4 my-2">
                                                <input type="radio" name="eventType" value="odc" <?php echo empty($roleEvent->typeOfEvent) ? "" : ($roleEvent->typeOfEvent == "odc" ? "checked disabled" : "disabled") ?> />
                                                <span>ODC</span>
                                            </label>
                                            <label class="radio mx-4 my-2">
                                                <input type="radio" name="eventType" value="outdoorThemeEvent" <?php echo empty($roleEvent->typeOfEvent) ? "" : ($roleEvent->typeOfEvent == "outdoorThemeEvent" ? "checked disabled" : "disabled") ?> />
                                                <span>Outdoor Theme Event</span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <h5 class="text-center d-flex justify-content-center"><span class="border-bottom">Decoration needed</span></h5>
                                        <div class="d-flex justify-content-around flex-wrap">
                                            <label class="radio mx-4 my-2">
                                                <input type="radio" name="eventDecoration" value="yes" <?php echo empty($roleEvent->decorationNeeded) ? "" : ($roleEvent->decorationNeeded == "yes" ? "checked disabled" : "disabled") ?> />
                                                <span>Yes</span>
                                            </label>
                                            <label class="radio mx-4 my-2">
                                                <input type="radio" name="eventDecoration" value="no" <?php echo empty($roleEvent->decorationNeeded) ? "" : ($roleEvent->decorationNeeded == "no" ? "checked disabled" : "disabled") ?> />
                                                <span>No</span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @if(isset($vendorList))
                                <div class="row">
                                    <div class="col-md-6 col-sm-12">
                                        <div class="form-group">
                                            <h5 class="text-center d-flex justify-content-center"><span class="border-bottom">Assign Vendor</span></h5>
                                            <div class="d-flex justify-content-between flex-wrap">
                                                <label class="radio mx-4 my-2">
                                                    <input type="radio" name="vendorType" value="existingVendor" checked disabled />
                                                    <span>Choose Existing Vendor</span>
                                                </label>
                                                <label class="radio mx-4 my-2">
                                                    <input type="radio" name="vendorType" value="otherVendor" disabled />
                                                    <span>Other Vendor</span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-sm-12">
                                        <div class="form-group">
                                            <label for="existingVendor">Choose Existing Vendor</label>
                                            <input type="text" class="form-control" value="{{ isset($vendorList) ? $vendorList->name : '' }}" readonly />
                                        </div>
                                    </div>
                                </div>
                            @endif
                            <div class="row d-flex justify-content-center">
                                <div class="back">
                                    <div class="wetasphalt" style="font-weight: bolder;font-size: medium;padding: 0.4rem 1.4rem;" onclick="redirection('{{ url()->previous() }}');">Back</div>
                                </div>
                            </div>
                        </form>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <script>
        function disable(){
            $("select#existingVendor").prop('disabled', true);
            $('select#existingVendor').removeAttr('required');
        }
        function enable(){
            $("select#existingVendor").prop('disabled', false);
        }
    </script>
@endsection