@extends('layouts.masterDashboard')
@section('content')
    <div class="row">
        <div class="col-md">
            <div class="card card-user">
                <div class="card-header pt-4" style="align-self: center;justify-content: center;width: 75%;border-bottom: none;">
                    <h3>Pending Events</h3>
                </div>
                <div class="card-body">
                    @if(isset($eventList))
                        <?php
                            // dd($eventList);
                        ?>
                        <div class="table-responsive p-2" style="overflow-x: scroll; overflow-y: hidden;">
                            <table class="table table-hover">
                                <thead class="text-dark border-bottom">
                                    <tr>
                                        <th class="text-center border-bottom-0" scope="col">S.No.</th> 
                                        <th class="text-center border-bottom-0" scope="col">Client Name - Client Code</th>
                                        <th class="text-center border-bottom-0" scope="col">Vendor Name - Vendor Code</th>
                                        <th class="text-center border-bottom-0" scope="col">Date</th>
                                        <th class="text-center border-bottom-0" scope="col">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($eventList as $key => $event)
                                        <tr>
                                            <td class="text-center" scope="row">{{ $loop->iteration }}</td>
                                            <td class="text-center">{{ $event->client_name . ' - ' . $event->client_username }}</td>
                                            <td class="text-center">{{ $event->vendor_name . ' - ' . $event->vendor_username }}</td>
                                            <td class="text-center">{{ date('d/m/Y', $event->event_date) }}</td>
                                            <td class="d-flex justify-content-center">
                                                <?php
                                                    $url = $event->event_ticket . '/' . $event->assigned_vendor;
                                                ?>
                                                <a href="{{ url('events/remove').'/'.$url }}" class="peterriver text-decoration-none text-white px-2 py-0 w-auto">Delete Vendor</a>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="7" align="center">{{ !isset($type) ? "" : ($type == "newList" ? "No New Events Yet!" : ($type == "pendingList" ? "No Pending Events Yet!" : ($type == "approvedList" ? "No Approved Events Yet!" : ($type == "declineList" ? "No Declined Events Yet!" : "")))) }}</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    @endif
                </div>
                @if(isset($eventList))
                    <div class="card-footer p-0" style="align-self: center;text-align: center;border-bottom: none;border-top: none;color: #d45353;display: flex;justify-content: center;">
                        <h6>{{ $eventList->links() }}</h6>
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection