@extends('layouts.masterDashboard')
@section('content')
    <style>
      .peterriver{
        width: 120px;
      }  
    </style>
    <div class="row">
        <div class="col-md">
            <div class="card card-user" id="reloadCard">
                <div class="card-header pt-4" style="align-self: center;justify-content: center;width: 75%;border-bottom: none;">
                    <h3>{{ $type == "SiteMarshal" ? " Employee Dashboard" : $type." LIST " }}</h3>
                </div>
                <div class="border-bottom-0 px-4">
                    <div class="container">
                        <div class="row px-4 d-flex justify-content-between">
                            <div class="row">
                                <div class="badge badge-info mt-1" onclick="tgleExptBtn();" style="height:60%;">
                                    <span class="pr-1">Export as</span>
                                    <i class="fa fa-download"></i>
                                </div>
                                <ul class="flex-row px-1" id="expBtn" style="display: none;list-style-type: none;">
                                    <li class="px-1">
                                        <a href="{{ url('download/xlsx') . '/' . $type }}" title="Download as Excel" class="animated bounceInLeft badge btn-success">
                                            <span>Excel</span>
                                        </a>
                                    </li>
                                    <li class="px-1">
                                        <a href="{{ url('download/csv') . '/' . $type }}" title="Download as Csv" class="animated bounceInLeft badge btn-secondary">
                                            <span>Csv</span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                            <div class="">
                                <input type="text" onkeyup="search(event);" placeholder="Search by name.." class="form-control p-2 h-75" />
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body py-2">
                    <div class="table-responsive px-2" style="overflow-x: scroll; overflow-y: hidden;">
                        <table class="table table-hover">
                            @if(isset($type))
                                <thead class="text-dark">
                                    <tr>
                                        <th class="text-left" scope="col">S.No.</th> 
                                        <th class="text-left" scope="col">Name</th>
                                        @if(isset($type) && $type == "client")
                                            <th class="text-left" scope="col">Client Code</th>
                                            <!--<th class="text-left" scope="col">Location</th>-->
                                            <th class="text-left" scope="col">Contact Person Name</th>
                                            <th class="text-left" scope="col">Contact Person Number</th>
                                        @endif
                                        @if(isset($type) && $type == "sitemarshal")
                                            <th class="text-left" scope="col">Email</th>
                                            <th class="text-left" scope="col">Employee Id</th>
                                            <th class="text-left" scope="col">Mobile Number</th>
                                            <th class="text-left" scope="col">Designation</th>
                                        @endif
                                        @if(isset($type) && $type == "vendor")
                                            <th class="text-left" scope="col">Email</th>
                                            <th class="text-left" scope="col">Vendor Code</th>
                                            <th class="text-left" scope="col">Contact Person Name</th>
                                            <th class="text-left" scope="col">Contact Person Number</th>
                                        @endif
                                        <th class="text-left" scope="col">Action</th>
                                    </tr>
                                </thead>
                                <tbody id="role_list">
                                    <td colspan="7" align="center" id="load_data" style="display: none;">
                                        <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                                           width="24px" height="30px" viewBox="0 0 24 30" style="enable-background:new 0 0 50 50;" xml:space="preserve">
                                          <rect x="0" y="0" width="4" height="10" fill="#333">
                                            <animateTransform attributeType="xml"
                                              attributeName="transform" type="translate"
                                              values="0 0; 0 20; 0 0"
                                              begin="0" dur="0.6s" repeatCount="indefinite" />
                                          </rect>
                                          <rect x="10" y="0" width="4" height="10" fill="#333">
                                            <animateTransform attributeType="xml"
                                              attributeName="transform" type="translate"
                                              values="0 0; 0 20; 0 0"
                                              begin="0.2s" dur="0.6s" repeatCount="indefinite" />
                                          </rect>
                                          <rect x="20" y="0" width="4" height="10" fill="#333">
                                            <animateTransform attributeType="xml"
                                              attributeName="transform" type="translate"
                                              values="0 0; 0 20; 0 0"
                                              begin="0.4s" dur="0.6s" repeatCount="indefinite" />
                                          </rect>
                                        </svg>
                                    </td>
                                </tbody>
                            @endif
                        </table>
                    </div>
                </div>
                <div class="card-footer p-0 my-2 border-bottom-0 border-top-0 text-center d-flex justify-content-center" style="align-self: center;color: #d45353;">
                    <h6>{{ isset($roles) ? $roles->links() : '' }}</h6>
                    <div class="d-flex justify-content-around">
                        <button class="btn btn-light mx-2 py-1 px-2 w-auto" onclick="previous_request(this);" id="previous">
                            <i class="fa fa-angle-left"></i>
                        </button>
                        <button class="btn btn-light mx-2 py-1 px-2 w-auto" onclick="next_request(this);" id="next">
                            <i class="fa fa-angle-right"></i>
                        </button>
                        <button class="btn btn-light mx-2 p-1 px-2 font-weight-bold" onclick="last_request(this);" id="last">Last</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @section('customscript')
        <script>
            var roleType = "{{ $type }}".toLowerCase();
            var next = "";
            var previous = "";
            var last = "";
            $(function () {
                var link = "{{ url('listAll') . '/' . $type }}";
                request_role_data(link);
            });
            function search(e){
                console.log(e.target.value);
                var search = e.target.value.trim();
                if(search !== null || search !== ""){
                    var link = "{{ url('listAll') . '/' . $type }}" + "/" + search;
                    request_role_data(link);
                }
            }
            function request_role_data(link){
                $roles = $.ajax({
                    type        : 'GET',
                    url         : link,
                    beforeSend: function(){
                        $("td#load_data").css({'display': 'table-cell'});
                    },
                    success     : function(res){
                        console.log(res);
                        sort_list(res);
                        if(res.current_page == 1){
                            $('button#previous').prop('disabled', true);
                        }else{
                            $('button#previous').prop('disabled', false);
                        }
                        if(res.current_page == res.last_page){
                            $('button#next').prop('disabled', true);
                            $('button#last').prop('disabled', true);
                        }else{
                            $('button#next').prop('disabled', false);
                            $('button#last').prop('disabled', false);
                        }
                        next = res.next_page_url;
                        previous = res.prev_page_url;
                        last = res.last_page_url;
                    },
                    complete:function(data){
                        $("td#load_data").css({'display': 'none'});
                    },
                    error       : function(xhr, textStatus, errorThrown){
                        console.log(errorThrown, textStatus);
                    }
                });
            }
            function sort_list(res){
                $("tbody#role_list").empty();
                res.data.forEach((key, index) => {
                    var action_link = "";
                    var tr = document.createElement("tr");

                    var id = document.createElement("td");
                    var name = document.createElement("td");
                    id.appendChild(document.createTextNode(++index));
                    name.appendChild(document.createTextNode(key.name));
                    tr.appendChild(id);
                    tr.appendChild(name);

                    if(roleType == "client"){
                        var clientcode = document.createElement("td");
                        //var location = document.createElement("td");
                        var contactPerson = document.createElement("td");
                        var contactNumber = document.createElement("td");
                        $(clientcode).append(key.username);
                        //$(location).append(key.address);
                        $(contactPerson).append(key.contactName);
                        $(contactNumber).append(key.contactNumber);
                        tr.appendChild(clientcode);
                        //tr.appendChild(location);
                        tr.appendChild(contactPerson);
                        tr.appendChild(contactNumber);
                          action_link = "{{ url('viewAIFeedVendor/view') }}" + '/' + key.clientId;
                    }else if(roleType == "vendor"){
                        var email = document.createElement("td");
                        var vendor_code = document.createElement("td");
                        var contactPerson = document.createElement("td");
                        var contactNumber = document.createElement("td");
                        $(email).append(key.email);
                        $(vendor_code).append(key.username);
                        $(contactPerson).append(key.contactName);
                        $(contactNumber).append(key.contactNumber);
                        tr.appendChild(email);
                        tr.appendChild(vendor_code);
                        tr.appendChild(contactPerson);
                        tr.appendChild(contactNumber);
                        action_link = "{{ url('viewOrEditRole/view') }}" + '/' + key.vendorId;
                    }else if(roleType == "sitemarshal"){
                        var email = document.createElement("td");
                        var empId = document.createElement("td");
                        var mobile_no = document.createElement("td");
                        var designation = document.createElement("td");
                        $(email).append(key.email);
                        $(empId).append(key.employeeId);
                        $(mobile_no).append(key.contactNumber);
                        $(designation).append(key.designation);
                        tr.appendChild(email);
                        tr.appendChild(empId);
                        tr.appendChild(mobile_no);
                        tr.appendChild(designation);
                        action_link = "{{ url('viewOrEditRole/view') }}" + '/' + key.marshalId;
                    }
                    
                    var action = document.createElement("td");
                    $(action).append("<a class='text-decoration-none text-white peterriver p-0' href='" + action_link + "'>View Vendor</div>");
                    
                    $(tr).append(action);
                    document.getElementById('role_list').appendChild(tr);
                });
            }
            function next_request(){
                request_role_data(next);
            }
            function previous_request(){
                request_role_data(previous);
            }
            function last_request(){
                request_role_data(last);
            }
        </script>
    @endsection
@endsection
