<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\MealCountDetail;
use App\Mail\SendMail;
use App\QRScanDetail;
use App\ClientDocs;
use App\VendorDocs;
use App\MarshalDocs;
use App\ClientsEmp;
use App\QRDetail;
use App\MapRole;
use App\Marshal;
use App\Vendor;
use App\Client;
use App\User;
use Validator;
use Carbon\Carbon;
use Auth;
use App\MealRateList;

use DB;
use Excel;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    protected function errorBag(array $errors) {
        $message = ["message" => implode(" ", $errors), "alert-type" => "error"];
        return $message;
    }

    public function dash_client_allinfo($search=null)
    {
//        $clients = Client::where('qr_code_status', $yes_or_no)
//        ->join('users', 'clients.clientId', '=', 'users.id')
//        ->where('users.name', 'LIKE', "%{$search}%")
//        ->select(
//            'users.id as client_id',
//            'name as client_name',
//            'users.username as client_code',
//            'contactName as contact_person',
//            'contactNumber as client_number'
//        )
//        ->groupBy('clients.username')
//        ->orderBy('created_at', 'desc')
//        ->paginate(4);

        $clients = DB::table('map_roles')
            ->join('clients', 'map_roles.clientId', '=', 'clients.clientId')
            ->join('marshals', 'map_roles.marshalId', '=', 'marshals.marshalId')
            ->join('vendors', 'map_roles.vendorId', '=', 'vendors.vendorId')
            ->join('users', 'map_roles.clientId', '=', 'users.id')
            ->join('raise_concerns', 'map_roles.clientId', '=', 'raise_concerns.clientId')
            ->where('users.name', 'LIKE', "%{$search}%")
            ->where('raise_concerns.status', "Processing")
            //->select('users.*', 'contacts.phone', 'orders.price')
            ->select(
                    'map_roles.clientId as clientId',
                    'map_roles.marshalId as marshalId',
                    'map_roles.vendorId as vendorId',
                    'map_roles.vendor_aggregation as vendor_aggregation',
                    'clients.clientname as clientname',
                    'marshals.marshalname as marshalname',
                    'vendors.vendorname as vendorname',
                    'raise_concerns.status as raise_concerns'
//            'name as client_name',
//            'users.username as client_code',
//            'contactName as contact_person',
//            'contactNumber as client_number'
        )
            ->paginate(10);

        return $clients;
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index(Request $request, $search=null)
    {

//      if($request->ajax()){
//        return $this->dash_client_allinfo($search);
//      }

      $clients = DB::table('map_roles')
            ->join('clients', 'map_roles.clientId', '=', 'clients.clientId')
            ->join('marshals', 'map_roles.marshalId', '=', 'marshals.marshalId')
            ->join('vendors', 'map_roles.vendorId', '=', 'vendors.vendorId')
            ->join('users', 'map_roles.clientId', '=', 'users.id')
            //->join('raise_concerns', 'map_roles.clientId', '=', 'raise_concerns.clientId')
            ->where('users.name', 'LIKE', "%{$search}%")
            //->where('raise_concerns.status', "Processing")
            //->select('users.*', 'contacts.phone', 'orders.price')
            ->select(
                    'map_roles.clientId as clientId',
                    'map_roles.marshalId as marshalId',
                    'map_roles.vendorId as vendorId',
                    'map_roles.vendor_aggregation as vendor_aggregation',
                    'clients.clientname as clientname',
                    'marshals.marshalname as marshalname',
                    'vendors.vendorname as vendorname'
                    //'raise_concerns.status as raise_concerns'
//            'name as client_name',
//            'users.username as client_code',
//            'contactName as contact_person',
//            'contactNumber as client_number'
        )
            ->paginate(10);

//echo "<pre>";
//print_r($clients);
//echo "</pre>";
//exit;

      //return view('components.content');
      return view('components.content', compact('clients'));
    }

    //I-Count section
    public function iCount()
    {
        return view('components.icountsection');
    }

    protected function remove_empty_array_values($arr){
        foreach($arr as $key => $value){
            if(empty($value)){
                unset($arr[$key]);
            }
        }
        return $arr;
    }

    //FK app section
    public function fkappsection()
    {
        return view('components.fkappsection');
    }

    public function sendMail()
    {
        $data = 'This is a Test Email only..';
        try{
            $res = Mail::to('amlans3@gmail.com')
                ->send(new SendMail($data));
            // $res = Mail::send(new SendMail($data), [], function($mail){
            //     $mail->to('amlans3@gmail.com')->subject('Your Reminder!');
            // });
            return 'Email was sent';
        }catch (Exception $ex) {
            return "We've got errors!";
        }
    }

//    public function scan_detail($qr_id, $client_id, $client_code, $emp_id)
//    {
//        $meal_type = $meal_rate = $rate = "";
//        $time = Carbon::now();
//        $morning_from = Carbon::create($time->year, $time->month, $time->day, 1, 0, 0);
//        $morning_to = Carbon::create($time->year, $time->month, $time->day, 12, 0, 0);
//        $afternoon = Carbon::create($time->year, $time->month, $time->day, 16, 0, 0);
//        $evening = Carbon::create($time->year, $time->month, $time->day, 19, 0, 0);
//        $dinner = Carbon::create($time->year, $time->month, $time->day, 23, 59, 55);
//        if($time->between($morning_from, $morning_to, true)){
//            $meal_type = "morning";
//            $rate = Client::where('clientId', $client_id)
//                ->where('username', $client_code)
//                ->select('breakfast as rate')
//                ->first();
//        }elseif($time->between($morning_to, $afternoon, true)){
//            $meal_type = "afternoon";
//            $rate = Client::where('clientId', $client_id)
//                ->where('username', $client_code)
//                ->select('lunch as rate')
//                ->first();
//        }elseif($time->between($afternoon, $evening, true)){
//            $meal_type = "evening";
//            $rate = Client::where('clientId', $client_id)
//                ->where('username', $client_code)
//                ->select('evening_snacks as rate')
//                ->first();
//        }elseif($time->between($evening, $dinner, true)){
//            $meal_type = "dinner";
//            $rate = Client::where('clientId', $client_id)
//                ->where('username', $client_code)
//                ->select('dinner as rate')
//                ->first();
//        }
//        $meal_rate = isset($rate) && !empty($rate) ? $rate->rate : null;
//        $take_meal_count_detail = MealCountDetail::where('client_code', $client_code)
//            ->where('meal_type', $meal_type)
//            ->where('date', $time->toDateString())
//            ->first();
//        $meal_count = 1;
//        if(isset($take_meal_count_detail)){
//            $meal_count = ++$take_meal_count_detail->meal_count;
//        }
//        MealCountDetail::updateOrCreate(
//            [
//                'client_code' => $client_code,
//                'meal_type' => $meal_type,
//                'meal_rate' => $meal_rate,
//                'date' => $time->toDateString(),
//            ],
//            [
//                'meal_count' => $meal_count,
//                'total' => isset($take_meal_count_detail) && isset($meal_rate)
//                    ? ($meal_count * $meal_rate)
//                    : (isset($meal_rate)
//                    ? $meal_rate
//                    : 0)
//            ]
//        );
//        QRScanDetail::create([
//            'qr_id' => $qr_id,
//            'client_code' => $client_code,
//            'emp_id' => $emp_id,
//            'meal_type' => $meal_type,
//            'meal_rate' => $meal_rate,
//            'date' => $time,
//            'created_at' => $time
//        ]);
//    }

    public function scan_detail($qr_id, $client_id, $client_code, $emp_id)
    {
        $meal_type = $meal_rate = $rate = "";
        $time = Carbon::now()->timezone('Asia/Kolkata');
        $meal_count = 1;
        $fetch_dates = MealRateList::where("client_id", $client_id)
            ->where("client_code", $client_code)->get();
        if(isset($fetch_dates) && !empty($fetch_dates)){

          if(isset($fetch_dates[0]->breakfast_from) && !empty($fetch_dates[0]->breakfast_from) && isset($fetch_dates[0]->breakfast_to) && !empty($fetch_dates[0]->breakfast_to)){
            $morning_from = $time->toDateString() . " " . $fetch_dates[0]->breakfast_from . ":00";
            $morning_to = $time->toDateString() . " " . $fetch_dates[0]->breakfast_to . ":00";
          } else{
            $morning_from = "";
            $morning_to = "";
          }
//            $morning_from = $time->toDateString() . " " . $fetch_dates[0]->breakfast_from . ":00";
//            $morning_to = $time->toDateString() . " " . $fetch_dates[0]->breakfast_to . ":00";

          if(isset($fetch_dates[0]->lunch_from) && !empty($fetch_dates[0]->lunch_from) && isset($fetch_dates[0]->lunch_to) && !empty($fetch_dates[0]->lunch_to)){
            $afternoon_from = $time->toDateString() . " " . $fetch_dates[0]->lunch_from . ":00";
            $afternoon_to = $time->toDateString() . " " . $fetch_dates[0]->lunch_to . ":00";
          } else{
            $afternoon_from = "";
            $afternoon_to = "";
          }
//            $afternoon_from = $time->toDateString() . " " . $fetch_dates[0]->lunch_from . ":00";
//            $afternoon_to = $time->toDateString() . " " . $fetch_dates[0]->lunch_to . ":00";

          if(isset($fetch_dates[0]->snacks_from) && !empty($fetch_dates[0]->snacks_from) && isset($fetch_dates[0]->snacks_to) && !empty($fetch_dates[0]->snacks_to)){
            $evening_from = $time->toDateString() . " " . $fetch_dates[0]->snacks_from . ":00";
            $evening_to = $time->toDateString() . " " . $fetch_dates[0]->snacks_to . ":00";
          } else{
            $evening_from = "";
            $evening_to = "";
          }
//            $evening_from = $time->toDateString() . " " . $fetch_dates[0]->snacks_from . ":00";
//            $evening_to = $time->toDateString() . " " . $fetch_dates[0]->snacks_to . ":00";

          if(isset($fetch_dates[0]->dinner_from) && !empty($fetch_dates[0]->dinner_from) && isset($fetch_dates[0]->dinner_to) && !empty($fetch_dates[0]->dinner_to)){
            $night_from = $time->toDateString() . " " . $fetch_dates[0]->dinner_from . ":00";
            $night_to = $time->toDateString() . " " . $fetch_dates[0]->dinner_to . ":00";
          } else{
            $night_from = "";
            $night_to = "";
          }
//            $night_from = $time->toDateString() . " " . $fetch_dates[0]->dinner_from . ":00";
//            $night_to = $time->toDateString() . " " . $fetch_dates[0]->dinner_to . ":00";
          if(isset($fetch_dates[0]->others_from) && !empty($fetch_dates[0]->others_from) && isset($fetch_dates[0]->others_to) && !empty($fetch_dates[0]->others_to)){
            $others_from = $time->toDateString() . " " . $fetch_dates[0]->others_from . ":00";
            $others_to = $time->toDateString() . " " . $fetch_dates[0]->others_to . ":00";
          } else{
            $others_from = "";
            $others_to = "";
          }
        }
        $qr_type = QRDetail::where("qr_id", $qr_id)
            ->where("client_id", $client_id)
            ->where("client_code", $client_code)
            ->where("assigned_emp_id", $emp_id)
            ->get();

        $checkQRscanstatus = QRScanDetail::where("qr_id", $qr_id)
                                    ->where("client_code", $client_code)
                                    ->where("emp_id", $emp_id)
                                    ->where("date",$time->toDateString())
                                    ->orderBy('id', 'DESC')
                                    ->first();
        if(isset($checkQRscanstatus) && !empty($checkQRscanstatus)){
          $lastscantime = $checkQRscanstatus->created_at;
        }

        if(isset($qr_type) && !empty($qr_type)){
            $qr_type = $qr_type[0]->meal_category;
            $rateStringOnType = "";
            if($time->between($morning_from, $morning_to, true)){
                $meal_type = "breakfast";

                if(!empty($lastscantime)) {
                  if ((($lastscantime < $morning_from) && ($lastscantime > $morning_to)) || (($lastscantime > $morning_from) && ($lastscantime < $morning_to)) ){
                  return $mealtimefoundType = 'scanedforbreakfast';
                } else {
                    if($qr_type === "type1"){
                      $rate = $fetch_dates[0]->breakfast1;
                    }else if($qr_type === "type2"){
                        $rate = $fetch_dates[0]->breakfast2;
                    }else if($qr_type === "type3"){
                        $rate = $fetch_dates[0]->breakfast3;
                    }
                  }
                } else {
                  if($qr_type === "type1"){
                      $rate = $fetch_dates[0]->breakfast1;
                  }else if($qr_type === "type2"){
                      $rate = $fetch_dates[0]->breakfast2;
                  }else if($qr_type === "type3"){
                      $rate = $fetch_dates[0]->breakfast3;
                  }
                }
            }elseif($time->between($afternoon_from, $afternoon_to, true)){
                $meal_type = "lunch";

                if(!empty($lastscantime)) {
                  if ((($lastscantime < $afternoon_from) && ($lastscantime > $afternoon_to)) || (($lastscantime > $afternoon_from) && ($lastscantime < $afternoon_to)) ){
                  return $mealtimefoundType = 'scanedforlunch';
                } else {
                    if($qr_type === "type1"){
                    $rate = $fetch_dates[0]->lunch1;
                    }else if($qr_type === "type2"){
                        $rate = $fetch_dates[0]->lunch2;
                    }else if($qr_type === "type3"){
                        $rate = $fetch_dates[0]->lunch3;
                    }
                  }
                } else {
                  if($qr_type === "type1"){
                    $rate = $fetch_dates[0]->lunch1;
                  }else if($qr_type === "type2"){
                      $rate = $fetch_dates[0]->lunch2;
                  }else if($qr_type === "type3"){
                      $rate = $fetch_dates[0]->lunch3;
                  }
                }
            }elseif($time->between($evening_from, $evening_to, true)){
                $meal_type = "evening";

                if(!empty($lastscantime)) {
                  if ((($lastscantime < $evening_from) && ($lastscantime > $evening_to)) || (($lastscantime > $evening_from) && ($lastscantime < $evening_to)) ){
                  return $mealtimefoundType = 'scanedforevening';
                } else {
                    if($qr_type === "type1"){
                        $rate = $fetch_dates[0]->snacks1;
                    }else if($qr_type === "type2"){
                        $rate = $fetch_dates[0]->snacks2;
                    }else if($qr_type === "type3"){
                        $rate = $fetch_dates[0]->snacks3;
                    }
                  }
                } else {
                  if($qr_type === "type1"){
                      $rate = $fetch_dates[0]->snacks1;
                  }else if($qr_type === "type2"){
                      $rate = $fetch_dates[0]->snacks2;
                  }else if($qr_type === "type3"){
                      $rate = $fetch_dates[0]->snacks3;
                  }
                }
            }elseif($time->between($night_from, $night_to, true)){
                $meal_type = "dinner";

                if(!empty($lastscantime)) {
                  if ((($lastscantime < $night_from) && ($lastscantime > $night_to)) || (($lastscantime > $night_from) && ($lastscantime < $night_to)) ){
                  return $mealtimefoundType = 'scanedfordinner';
                } else {
                    if($qr_type === "type1"){
                        $rate = $fetch_dates[0]->dinner1;
                    }else if($qr_type === "type2"){
                        $rate = $fetch_dates[0]->dinner2;
                    }else if($qr_type === "type3"){
                        $rate = $fetch_dates[0]->dinner3;
                    }
                  }
                } else {
                  if($qr_type === "type1"){
                      $rate = $fetch_dates[0]->dinner1;
                  }else if($qr_type === "type2"){
                      $rate = $fetch_dates[0]->dinner2;
                  }else if($qr_type === "type3"){
                      $rate = $fetch_dates[0]->dinner3;
                  }
                }
            } elseif($time->between($others_from, $others_to, true)){
                $meal_type = "others";

                if(!empty($lastscantime)) {
                  if ((($lastscantime < $others_from) && ($lastscantime > $others_to)) || (($lastscantime > $others_from) && ($lastscantime < $others_to)) ){
                  return $mealtimefoundType = 'scanedforothers';
                } else {
                    if($qr_type === "type1"){
                      $rate = $fetch_dates[0]->others1;
                  }else if($qr_type === "type2"){
                      $rate = $fetch_dates[0]->others2;
                  }else if($qr_type === "type3"){
                      $rate = $fetch_dates[0]->others3;
                  }
                  }
                } else {
                  if($qr_type === "type1"){
                      $rate = $fetch_dates[0]->others1;
                  }else if($qr_type === "type2"){
                      $rate = $fetch_dates[0]->others2;
                  }else if($qr_type === "type3"){
                      $rate = $fetch_dates[0]->others3;
                  }
                }
            } else {
              return $mealtimefoundType = 'beyondRegisteredTime';
            }
            $meal_rate = isset($rate) ? $rate : null;
            $take_meal_count_detail = MealCountDetail::where('client_code', $client_code)
                ->where('meal_type', $meal_type)
                ->where('qr_type', $qr_type)
                ->where('date', $time->toDateString())
                ->first();
            if(isset($take_meal_count_detail)){
                $meal_count = ++$take_meal_count_detail->meal_count;
            }
            MealCountDetail::updateOrCreate(
                [
                    'client_code' => $client_code,
                    'meal_type' => $meal_type,
                    'qr_type' => $qr_type,
                    //'qr_id' => $qr_id,
                    'meal_rate' => $meal_rate,
                    'date' => $time->toDateString(),
                ],
                [
                    'meal_count' => $meal_count,
                    'total' => isset($take_meal_count_detail) && isset($meal_rate)
                        ? ($meal_count * $meal_rate)
                        : (isset($meal_rate)
                        ? $meal_rate
                        : 0)
                ]
            );
            QRScanDetail::create([
                'qr_id' => $qr_id,
                'client_code' => $client_code,
                'emp_id' => $emp_id,
                "meal_category" => $qr_type,
                'meal_type' => $meal_type,
                'meal_rate' => $meal_rate,
                'date' => $time,
                'created_at' => $time
            ]);
        }
    }

    public function qr_decode(Request $request)
    {
        \Log::info($request->all());
        $mapped_vendor = MapRole::where('vendorId', (int) $request->vendor_id)
            ->where('clientId', (int) $request->client_id)
            ->first();
        if(isset($mapped_vendor) && !empty($mapped_vendor)){
            $qr_detail = QRDetail::where('qr_id', (int) $request->qr_id)
                ->where('client_code', (string) $request->client_code)
                ->first();
            if(isset($qr_detail) && !empty($qr_detail)){
                $employee_detail = ClientsEmp::where('id', (int) $qr_detail->assigned_emp_id)
                    ->where('client_id', (int) $request->client_id)
                    ->where('client_code', (string) $request->client_code)
                    ->first();

                if(isset($employee_detail) && $qr_detail->meal_category == "type4"){
                  $client_name = User::where('username', $qr_detail->client_code)->select('name')->first();
                  $qr_information = (object)array_merge($employee_detail->toArray(), $qr_detail->toArray());
                  $qr_information->client_name = $client_name->name;
                  $qr_information->qrcode_type = $qr_detail->meal_category;
                // $qr_information->orderlink = '<a href="https://demo.finchat.tech/foodskraft/vendor/ICount/I-count/place_dining_order/'.$request->client_id.'/'.$request->vendor_id.'/'.$request->qr_id.'">CLICK HERE!!</a>';
                  $qr_information->orderlink = '<a href='.config('app.base_url').'/vendor/ICount/I-count/place_dining_order/'.$request->client_id.'/'.$request->vendor_id.'/'.$request->qr_id.'>CLICK HERE!!</a>';
                  return response()->json([
                      'type' => 'success',
                      'message' => $qr_information
                  ]);
                } elseif(isset($employee_detail)){
                    # Save QR Code Information to database
                    $scanResult = $this->scan_detail((int) $request->qr_id, (int) $request->client_id, (string) $request->client_code, (int) $qr_detail->assigned_emp_id);

                    if(isset($scanResult) && $scanResult == "beyondRegisteredTime"){
                      return response()->json([
                        'type' => 'Beyond Registered Time',
                        'message' => 'Sorry!!  The current time is not registered for scanning QR Codes!'
                      ]);
                    } elseif(isset($scanResult) && $scanResult == "scanedforbreakfast"){
                      return response()->json([
                        'type' => 'scanned for breakfast',
                        'message' => 'Sorry!! This QR code already scanned for this time & day scheduled!!'
                      ]);
                    } elseif(isset($scanResult) && $scanResult == "scanedforlunch") {
                      return response()->json([
                        'type' => 'scanned for lunch',
                        'message' => 'Sorry!! This QR code already scanned for this time & day scheduled!!'
                      ]);
                    } elseif(isset($scanResult) && $scanResult == "scanedforevening") {
                      return response()->json([
                        'type' => 'scanned for evening',
                        'message' => 'Sorry!! This QR code already scanned for this time & day scheduled!!'
                      ]);
                    } elseif(isset($scanResult) && $scanResult == "scanedfordinner") {
                      return response()->json([
                        'type' => 'scanned for dinner',
                        'message' => 'Sorry!! This QR code already scanned for this time & day scheduled!!'
                      ]);
                    } elseif(isset($scanResult) && $scanResult == "scanedforothers") {
                      return response()->json([
                        'type' => 'scanned for others',
                        'message' => 'Sorry!! This QR code already scanned for this time & day scheduled!!'
                      ]);
                    } else {
                      $client_name = User::where('username', $qr_detail->client_code)->select('name')->first();
                      $qr_information = (object)array_merge($employee_detail->toArray(), $qr_detail->toArray());
                      $qr_information->client_name = $client_name->name;
                      $qr_information->qrcode_type = $qr_detail->meal_category;
                      return response()->json([
                          'type' => 'success',
                          'message' => $qr_information
                      ]);
                    }
                }else{
                    return response()->json([
                        'type' => 'warning',
                        'message' => 'Unassigned QR Code.'
                    ]);
                }
            }else{
                return response()->json([
                    'type' => 'danger',
                    'message' => empty($qr_detail) ? 'Invalid QR Code ID' : 'hello'
                ]);
            }
            return $qr_detail;
        }else{
            return response()->json([
                'type' => 'danger',
                'message' => 'This client is not assigned to you'
            ]);
        }
    }

    protected function marshalDetails($user) {
        return Marshal::where([
            ['marshalId', '=', $user['id']],
            ['username', '=', $user['username']]
        ]);
    }

    protected function vendorDetails($user) {
        return Vendor::where([
            ['vendorId', '=', $user['id']],
            ['username', '=', $user['username']]
        ]);
    }

    protected function clientDetails($user) {
        return Client::where([
            ['clientId', '=', $user['id']],
            ['username', '=', $user['username']]
        ]);
    }

    public function view_profile()
    {
        // dd("View Profile", Auth::user());
        $user = Auth::user();
        if(isset($user)){
            $role['foodscraftRole'] = User::find(Auth::user()->id)
                ->getRoleNames()
                ->first();
            $type = "view";
            $details = [];
            $listMapfirst = [];
            $listMapfirstdata = [];
            $listMapsecond = [];
            $listMapseconddata = [];

            switch ($role['foodscraftRole']) {
                case "sitemarshal":
                    $details = $this->marshalDetails($user)->first()->toArray();
                    // Fetch mapped vendor
                    $listMapfirst = MapRole::where('marshalId', Auth::user()->id)->select('vendorId')->distinct('vendorId')->get()->toArray();
                    foreach ($listMapfirst as $listMapfirstitem) {
                        $listMapfirstdata[] = User::join('vendors', 'users.id', '=', 'vendors.vendorId')
                                ->join('map_roles', 'map_roles.vendorId', '=', 'vendors.vendorId')
                                ->where('users.id', $listMapfirstitem['vendorId'])
                                ->select()->get()->toArray();
                    }
                    // Fetch mapped client
                    $listMapsecond = MapRole::where('marshalId', Auth::user()->id)->select('clientId')->distinct('clientId')->get()->toArray();
                    foreach ($listMapsecond as $listMapseconditem) {
                        $listMapseconddata[] = User::join('clients', 'users.id', '=', 'clients.clientId')
                                ->join('map_roles', 'map_roles.clientId', '=', 'clients.clientId')
                                ->where('users.id', $listMapseconditem['clientId'])
                                ->select()->get()->toArray();
                    }
                    break;
                case "vendor":
                    $details = $this->vendorDetails($user)->first()->toArray();
                    // Fetch mapped site marshall
                    $listMapfirst = MapRole::where('vendorId', Auth::user()->id)->select('marshalId')->distinct('marshalId')->get()->toArray();
                    foreach ($listMapfirst as $listMapfirstitem) {
                        $listMapfirstdata[] = User::join('marshals', 'users.id', '=', 'marshals.marshalId')
                                ->join('map_roles', 'map_roles.marshalId', '=', 'marshals.marshalId')
                                ->where('users.id', $listMapfirstitem['marshalId'])
                                ->select()->get()->toArray();
                    }
                    // Fetch mapped client
                    $listMapsecond = MapRole::where('vendorId', Auth::user()->id)->select('clientId')->distinct('clientId')->get()->toArray();
                    foreach ($listMapsecond as $listMapseconditem) {
                        $listMapseconddata[] = User::join('clients', 'users.id', '=', 'clients.clientId')
                                ->join('map_roles', 'map_roles.clientId', '=', 'clients.clientId')
                                ->where('users.id', $listMapseconditem['clientId'])
                                ->select()->get()->toArray();
                    }
                    break;
                case "client":
                    $details = $this->clientDetails($user)->first()->toArray();
                    $client_docs = ClientDocs::where('username', $details['username'])->first();
                    if($client_docs !== null){
                        $details = array_merge($details, $client_docs->toArray());
                    }
                    // Fetch mapped site marshall
                    $listMapfirst = MapRole::where('clientId', Auth::user()->id)->select('marshalId')->distinct('marshalId')->get()->toArray();
                    foreach ($listMapfirst as $listMapfirstitem) {
                        $listMapfirstdata[] = User::join('marshals', 'users.id', '=', 'marshals.marshalId')
                                ->join('map_roles', 'map_roles.marshalId', '=', 'marshals.marshalId')
                                ->where('users.id', $listMapfirstitem['marshalId'])
                                ->select()->get()->toArray();
                    }
                    // Fetch mapped vendor
                    $listMapsecond = MapRole::where('clientId', Auth::user()->id)->select('vendorId')->distinct('vendorId')->get()->toArray();
                    foreach ($listMapsecond as $listMapseconditem) {
                        $listMapseconddata[] = User::join('vendors', 'users.id', '=', 'vendors.vendorId')
                                ->join('map_roles', 'map_roles.vendorId', '=', 'vendors.vendorId')
                                ->where('users.id', $listMapseconditem['vendorId'])
                                ->select()->get()->toArray();
                    }
                    break;
            }
            $result = array_merge($user->toArray(), array_merge($details, $role));
            if ($type == "view") {
                $docs = [];
                if ($role['foodscraftRole'] == "sitemarshal") {
                    $docs['documents'] = MarshalDocs::where('marshalId', $result['marshalId'])->get()->toArray();
                } elseif ($role['foodscraftRole'] == "vendor") {
                    $docs['documents'] = VendorDocs::where('vendorId', $result['vendorId'])->get()->toArray();
                }
                $result = array_merge($result, $docs);
            }

            if($role['foodscraftRole'] == 'client'){
              $meal_rate_list = MealRateList::where([
                  'client_id' => $result['clientId'],
                  'client_code' => $result['username']
              ])->get();
              if(isset($meal_rate_list)){
                  $result = array_merge($result, $meal_rate_list[0]->toArray());
              }
            }

            $result = (object) $result;
            // dd($result);
            if($role['foodscraftRole'] == 'client'){
                return view("profile.view.client", compact('result', 'type', 'listMapfirstdata', 'listMapseconddata'));
            }elseif($role['foodscraftRole'] == 'vendor'){
                return view("profile.view.vendor", compact('result', 'type', 'listMapfirstdata', 'listMapseconddata'));
            }elseif($role['foodscraftRole'] == 'sitemarshal'){
                return view("profile.view.marshal", compact('result', 'type', 'listMapfirstdata', 'listMapseconddata'));
            }
        }else{
            return back()->with(["message" => "User Not Found", "alert-type" => "warning"]);
        }
    }

    public function edit_profile(Request $request)
    {
        // dd("View Profile", Auth::user());
        $user = Auth::user();
        if(isset($user)){
            $role['foodscraftRole'] = User::find(Auth::user()->id)
                ->getRoleNames()
                ->first();
            $type = "edit";
            $result = [];
            switch ($role['foodscraftRole']) {
                case "sitemarshal":
                    $result = User::where('users.id', $request->marshal_id)
                        ->where('users.username', $request->marshal_username)
                        ->join('marshals', 'users.username', '=', 'marshals.username')
                        ->select('users.*', 'marshals.govId', 'marshals.expInYrs')
                        ->first();
                    return view("profile.edit.marshal", compact('result', 'type'));
                    break;
                case "vendor":
                    $result = User::where('users.id', $request->vendor_id)
                        ->where('users.username', $request->vendor_username)
                        ->join('vendors', 'users.username', '=', 'vendors.username')
                        ->select('users.*', 'vendors.contactName', 'vendors.kitchenArea', 'vendors.employeeNumber', 'vendors.yearExp', 'vendors.mealCapacity', 'vendors.cameraNumber', 'vendors.cameraMegaPixel')
                        ->first();
                    // dd($result);
                    return view("profile.edit.vendor", compact('result', 'type'));
                    break;
                case "client":
                    $result = User::where('users.id', $request->client_id)
                        ->where('users.username', $request->client_username)
                        ->join('clients', 'users.username', '=', 'clients.username')
                        ->select('users.*', 'clients.contactName', 'clients.employeeNumber', 'clients.headOffice', 'clients.clientCategory', 'clients.typeOfServices', 'clients.clientScopeCafe')
                        ->first();
                    $meal_rate_list = MealRateList::where([
                        'client_id' => $result->id,
                        'client_code' => $result->username
                    ])->first();
                    if(isset($meal_rate_list)){
                        $result = (object) array_merge($result->toArray(), $meal_rate_list->toArray());
                    }
                    return view("profile.edit.client", compact('result', 'type'));
                    break;
            }
        }else{
            return back()->with(["message" => "User Not Found", "alert-type" => "warning"]);
        }
    }

    public function update_profile(Request $request)
    {
        // dd($request->all());
      if($request->role == "client"){
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users',
            'contactName' => 'required_if:foodscraftRole,==,Client|required|array|min:1|max:3',
            'contactNumber' => 'required_if:foodscraftRole,==,Client|required|array|min:1|max:3',
            'address' => 'required_if:foodscraftRole,==,Client|required|string|max:400',
            'headOffice' => 'required_if:foodscraftRole,==,Client|required|string|max:255',
            'employeeNumber' => 'required_if:foodscraftRole,==,Client|required|numeric|min:10',
            'clientCategory' => 'required_if:foodscraftRole,==,Client|required|string|max:255',
            'typeOfServices' => 'required_if:foodscraftRole,==,Client|required|array|min:1',
            'clientScopeCafe' => 'required_if:foodscraftRole,==,Client|required|array|min:1'
        ]);
      } else {
        $validator = Validator::make($request->all(), [
//            'name' => 'required|string|max:255',
//            'contactNumber' => 'required_if:foodscraftRole,==,Vendor|required|digits:10',
//            'contactNumber' => 'required_if:foodscraftRole,==,SiteMarshal|required|digits:10',
//            'email' => 'required|string|email|max:255|unique:users',
//
//            'yearExp' => 'required_if:foodscraftRole,==,SiteMarshal|required|numeric|min:2',
//            'govId' => 'required_if:foodscraftRole,==,SiteMarshal|required|numeric|min:6',
//
//            'contactName' => 'required_if:foodscraftRole,==,Vendor|required|string|max:255',
//            'address' => 'required_if:foodscraftRole,==,Vendor|required|string|max:400',
//            'kitchenArea' => 'required_if:foodscraftRole,==,Vendor|required|numeric|min:500',
//            'employeeNumber' => 'required_if:foodscraftRole,==,Vendor|required|numeric|min:10',
//            'yearExp' => 'required_if:foodscraftRole,==,Vendor|required|numeric|min:2',
//            'mealCapacity' => 'required_if:foodscraftRole,==,Vendor|required|numeric|min:10',
//            'cameraNumber' => 'required_if:foodscraftRole,==,Vendor|required|numeric|min:2',
//            'cameraMegaPixel' => 'required_if:foodscraftRole,==,Vendor|required|numeric|min:1',
//
//            'contactName' => 'required_if:foodscraftRole,==,Client|required|array|min:1|max:3',
//            'contactNumber' => 'required_if:foodscraftRole,==,Client|required|array|min:1|max:3',
//            'address' => 'required_if:foodscraftRole,==,Client|required|string|max:400',
//            'headOffice' => 'required_if:foodscraftRole,==,Client|required|string|max:255',
//            'employeeNumber' => 'required_if:foodscraftRole,==,Client|required|numeric|min:10',
//            'clientCategory' => 'required_if:foodscraftRole,==,Client|required|string|max:255',
//            'typeOfServices' => 'required_if:foodscraftRole,==,Client|required|array|min:1',
//            'clientScopeCafe' => 'required_if:foodscraftRole,==,Client|required|array|min:1'
        ]);
      }
//        $validator = Validator::make($request->all(), [
////            'name' => 'required|string|max:255',
////            'contactNumber' => 'required_if:foodscraftRole,==,Vendor|required|digits:10',
////            'contactNumber' => 'required_if:foodscraftRole,==,SiteMarshal|required|digits:10',
////            'email' => 'required|string|email|max:255|unique:users',
////
////            'yearExp' => 'required_if:foodscraftRole,==,SiteMarshal|required|numeric|min:2',
////            'govId' => 'required_if:foodscraftRole,==,SiteMarshal|required|numeric|min:6',
////
////            'contactName' => 'required_if:foodscraftRole,==,Vendor|required|string|max:255',
////            'address' => 'required_if:foodscraftRole,==,Vendor|required|string|max:400',
////            'kitchenArea' => 'required_if:foodscraftRole,==,Vendor|required|numeric|min:500',
////            'employeeNumber' => 'required_if:foodscraftRole,==,Vendor|required|numeric|min:10',
////            'yearExp' => 'required_if:foodscraftRole,==,Vendor|required|numeric|min:2',
////            'mealCapacity' => 'required_if:foodscraftRole,==,Vendor|required|numeric|min:10',
////            'cameraNumber' => 'required_if:foodscraftRole,==,Vendor|required|numeric|min:2',
////            'cameraMegaPixel' => 'required_if:foodscraftRole,==,Vendor|required|numeric|min:1',
////
////            'contactName' => 'required_if:foodscraftRole,==,Client|required|array|min:1|max:3',
////            'contactNumber' => 'required_if:foodscraftRole,==,Client|required|array|min:1|max:3',
////            'address' => 'required_if:foodscraftRole,==,Client|required|string|max:400',
////            'headOffice' => 'required_if:foodscraftRole,==,Client|required|string|max:255',
////            'employeeNumber' => 'required_if:foodscraftRole,==,Client|required|numeric|min:10',
////            'clientCategory' => 'required_if:foodscraftRole,==,Client|required|string|max:255',
////            'typeOfServices' => 'required_if:foodscraftRole,==,Client|required|array|min:1',
////            'clientScopeCafe' => 'required_if:foodscraftRole,==,Client|required|array|min:1'
//        ]);
        if($validator->fails() && !in_array("The email has already been taken.", $validator->errors()->all())){
            return back()->with($this->errorBag($validator->errors()->all()));
        }else{
            if($request->role == "marshal"){
                User::where('users.id', $request->marshal_id)
                ->where('users.username', $request->username)
                ->update([
                    'name' => $request->name,
                    'email' => $request->email,
                    'contactNumber' => $request->contactNumber,
                ]);
                Marshal::where('marshalId', $request->marshal_id)
                    ->where('marshals.username', $request->username)
                    ->update([
                        'govId' => $request->govId,
                        'expInYrs' => $request->yearExp
                    ]);
            }
            elseif($request->role == "vendor"){
                User::where('users.id', $request->vendor_id)
                    ->where('users.username', $request->username)
                    ->update([
                        'name' => $request->name,
                        'email' => $request->email,
                        'contactNumber' => $request->contactNumber,
                        'address' => $request->address
                    ]);
                Vendor::where('vendorId', $request->vendor_id)
                    ->where('vendors.username', $request->username)
                    ->update([
                        'contactName' => $request->contactName,
                        'kitchenArea' => $request->kitchenArea,
                        'employeeNumber' => $request->employeeNumber,
                        'yearExp' => $request->yearExp,
                        'mealCapacity' => $request->mealCapacity,
                        'cameraNumber' => $request->cameraNumber,
                        'cameraMegaPixel' => $request->cameraMegaPixel
                    ]);
            }
            elseif($request->role == "client"){
                User::where('users.id', $request->client_id)
                    ->where('users.username', $request->username)
                    ->update([
                        'name' => $request->name,
                        'email' => $request->email,
                        'contactNumber' => is_array($request->contactNumber) ? implode(",", $this->remove_empty_array_values($request->contactNumber)) : $request->contactNumber,
                        'address' => $request->address
                    ]);
                Client::where('clientId', $request->client_id)
                    ->where('clients.username', $request->username)
                    ->update([
                        'contactName' => is_array($request->contactName) ? implode(",", $this->remove_empty_array_values($request->contactName)) : $request->contactName,
                        'employeeNumber' => $request->employeeNumber,
                        'headOffice' => $request->headOffice,
                        'clientCategory' => $request->clientCategory,
                        //'typeOfServices' => implode(",", $request->typeOfServices),
                        'typeOfServices' => is_array($request->typeOfServices) ? implode(",", $this->remove_empty_array_values($request->typeOfServices)) : $request->typeOfServices,
                        //'clientScopeCafe' => implode(",", $request->clientScopeCafe)
                        'clientScopeCafe' => is_array($request->clientScopeCafe) ? implode(",", $this->remove_empty_array_values($request->clientScopeCafe)) : $request->clientScopeCafe
                    ]);
                MealRateList::updateOrCreate(
                    [
                        'client_id' => $request->client_id,
                        'client_code' => $request->username
                    ],
                    [
                        'breakfast1' => $request->type1['breakfast'],
                        'lunch1' => $request->type1['lunch'],
                        'dinner1' => $request->type1['dinner'],
                        'snacks1' => $request->type1['snacks'],
                        'breakfast2' => $request->type2['breakfast'],
                        'lunch2' => $request->type2['lunch'],
                        'dinner2' => $request->type2['dinner'],
                        'snacks2' => $request->type2['snacks'],
                        'breakfast3' => $request->type3['breakfast'],
                        'lunch3' => $request->type3['lunch'],
                        'dinner3' => $request->type3['dinner'],
                        'snacks3' => $request->type3['snacks'],
                        'breakfast_from' => $request->breakfast_from,
                        'breakfast_to' => $request->breakfast_to,
                        'lunch_from' => $request->lunch_from,
                        'lunch_to' => $request->lunch_to,
                        'dinner_from' => $request->dinner_from,
                        'dinner_to' => $request->dinner_to,
                        'snacks_from' => $request->snacks_from,
                        'snacks_to' => $request->snacks_to
                    ]
                );
            }
            return redirect('view_profile')
                ->with(['message' => 'Profile Updated Successfully.', 'alert-type' => 'success']);
        }
    }


    //Import Excel Sheet
    function importexcel()
    {
      $vendorid = 26;
      $data = DB::table('calorie_item_table_backup')
              ->where('vendor_id', '=', 26)
              ->orderBy('id', 'DESC')->get();
      return view('import_excel', compact('data'));
    }

    function import(Request $request)
    {
     $this->validate($request, [
      'select_file'  => 'required|mimes:xls,xlsx'
     ]);

     $path = $request->file('select_file')->getRealPath();

     $data = Excel::load($path)->get();

     if($data->count() > 0)
     {
      foreach($data->toArray() as $key => $value)
      {
       foreach($value as $row)
       {
        $insert_data[] = array(
         'item_name'  => $row['item_name'],
         'item_code'   => $row['item_code'],
         'item_quantity'   => $row['item_quantity'],
         'item_approx_calorie'    => $row['item_approx_calorie'],
         'item_price'  => $row['item_price'],
         'vendor_id'   => $row['vendor_id']
        );
       }
      }

      if(!empty($insert_data))
      {
       DB::table('calorie_item_table_backup')->insert($insert_data);
      }
     }
     return back()->with('success', 'Excel Data Imported successfully.');
    }


}


// return response()->json([
        //         'isset' => isset($mapped_vendor),
        //         'empty' => empty($mapped_vendor),
        //         'mapped_vendor' => $mapped_vendor,
        //         'vendor_id' => (int) $request->vendor_id,
        //         'client_id' => (int) $request->client_id
        //     ]);

        // return response()->json([
            //     'qr_detail' => $qr_detail,
            //     'isset' => isset($qr_detail),
            //     'empty' => empty($qr_detail),
            //     'qr_id' => (int) $request->qr_id,
            //     'client_code' => (string) $request->client_code
            // ]);

            // return response()->json([
                //     'success' => (object)array_merge($employee_detail->toArray(), $qr_detail->toArray())
                // ]);

        // \Log::info($rate . " " . $client_id . " " . $client_code);
        // \Log::info("Morning From: " . $morning_from);
        // \Log::info("Morning To: " . $morning_to);
        // \Log::info("Afternoon: " . $afternoon);
        // \Log::info("Evening: " . $evening);
        // \Log::info("Dinner" . $dinner);
        // \Log::info("Time: " . $time);
        // \Log::info("Meal Type: " . $meal_type);
        // \Log::info("Meal Rate: " . $meal_rate);
        // \Log::info($time->between($morning_from, $morning_to, true));
        // \Log::info($time->between($morning_to, $afternoon, true));
        // \Log::info($time->between($afternoon, $evening, true));
        // \Log::info($time->between($evening, $dinner, true));
