<?php

namespace App\Helpers;

use Image;
use File;
use Mail;
use App\Loggs;
use App\User_device;
use App\User;
use Response;
use App\Requests;
use App\Modules\Email\Models\Email;
use Illuminate\Support\Facades\DB;
use Config;
use Input;
use App\OnBoarding;
use App\Chat_group_logs;
use App\Cas;
use App\Clients;
use App\Caclients;
use App\Chat_group_member_logs;
use App\Modules\Whatsapp\Models\Whatsapp;
use App\Modules\WeChat\Models\WeChat;
//use PHPMailer;
use App\OffBoarding;
use Auth;
use App\CaValidation;
use App\ClientValidation;
use App\Single_chat_logs;
use App\Event_message;
use App\DBS_otp_event_message;
use App\Event_message_text;
use App\UpdateContact;
use App\userPass;
use Illuminate\Support\Facades\Hash;
use App\GroupIdle;
use App\CaReplacement;
use App\Modules\Alert\Models\ReadedAlertLogs;
use Illuminate\Support\Facades\Crypt;
//use Illuminate\Support\Facades\Auth;
use ZipArchive;
use App\Settings;
use App\RequestOps;
use App\lastSavedID;
use App\passwordReset;
use App\passCreateHistory;
use App\passResetHistory;
use App\FilePartsModel;
use App\Filesplitqueue;
use App\Modules\ExportEod\Models\ExportEod;
use App\newGroupId;
use App\groupMembers;
use App\Helpers\EmlTemplateHelper;
use App\wechatMemberCount;
use \setasign\Fpdi\Fpdi as FPDI;
use Illuminate\Support\Facades\Cache;
use App\Role;
use App\user_role;
use App\Modules\UserGroup\Models\UserGroup;
use App\Crps;
use App\UserMaster;
use App\DbsRmMobCustemailsRecords;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

//require 'path/to/PHPMailer/src/Exception.php';
//require 'path/to/PHPMailer/src/PHPMailer.php';
//require 'path/to/PHPMailer/src/SMTP.php';
use App\WechatUsrGrpRel;
use App\Helpers\RequestVerificationHelper;
use App\Helpers\LabelHelper;

class Helper
{
    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct() {
        // parent::__construct();
        //$this->time = date('Y-m-d');
    }
    /**
     * Get CA/Client
     *
     * @param INT number
     * @return string
     */    
    public static function getDeviceName($device_id){
        $devicename = 'Device';
        $getname = User_device::select('vm_name')->where('vm_id', $device_id)->first();
        if(isset($getname->vm_name) && $getname->vm_name != ''){
            $devicename = $getname->vm_name;
        }
        return $devicename;
    }
    /**
     * Add roles to user to assign them rules
     * @param int $id user id of created user
     * @param int $assigned_roles id of inserted role
     */
    public static function roles($id, $assigned_roles) {
        $items_i = array();
        $items_i['user_id'] = $id;
        $items_i['role_id'] = $assigned_roles;
        user_role::insert($items_i);
    }
    public static function redirectBack(){
//        print_r(Auth::user());
        $redirect = "";
        if (Auth::User()->hasRole('compliance')) {
            $redirect = "admin";
        } elseif (Auth::User()->hasRole('ops_manager')){
            $redirect = "admin/grouplist";
        } elseif (Auth::User()->hasRole('arm')){
            $redirect = "admin/grouplist";
        } elseif (Auth::User()->hasRole('super_admin')){
            $redirect = "admin";
        } elseif (Auth::User()->hasRole('system_admin')){
            $redirect = "admin";
        } 
//        else{
//            Auth::logout();
//            $redirect = "";
//        }
        return $redirect;
    }
   /**
   * Check if date is valid
   *
   * @return Response
   */
    public static function isValidDate($date){
        
        $convertdate = \DateTime::createFromFormat('d/m/Y', $date);

        if($convertdate){
            return $thisdate = $convertdate->format('Y-m-d');
        }
        return false;

    }
    /**
     * @param string $text
     * @param int $maxChar
     * @param string $end
     * @param bool $force
     * @return string
     */
    public static function limitText($text, $maxChar = 30, $end = '...', $force = false)
    {
        $text = strip_tags($text);
        $maxChar = $maxChar - strlen($end);
        $newText = '';

        if (strlen($text) > $maxChar) {
            if ($force) {
                if (strlen($text) > $maxChar) {
                    return substr($text, 0, $maxChar) . $end;
                }
            } else {
                $split = explode(' ', $text);
                $i = 0;
                while (TRUE) {
                    $len = (strlen($newText) + strlen($split[$i]));
                    if ($len > $maxChar) {
                        break;
                    } else {
                        $newText = $newText . ' ' . $split[$i];
                        ++$i;
                    }
                }
                return $newText . $end;
            }
        } else {
            return $text;
        }
    }
    /**
     * getLocalizedMsgTxt 
     * @param $group object
     * @param $message object
     * 
     * @return string
     */
    public static function getLocalizedMsgTxt($group_details,$getMessage)
    {
        // for chinese language
        $im_language_preference = $group_details->im_language_preference;
        if($im_language_preference == "zh-Hans"){
            if(isset($getMessage->zh_hans)){ $fincontent = $getMessage->zh_hans; }
        } elseif ($im_language_preference == "zh-Hant"){
            if(isset($getMessage->zh_hant)){ $fincontent = $getMessage->zh_hant; }
        }else{
            if(isset($getMessage->event_content)){ $fincontent = $getMessage->event_content; }
        }
        // for chinese language  
        return $fincontent;
    }
    /**
     * Return Class for active route
     * @param $routename
     * @param $classes
     * @return string
     */
    public static function active_class($paths, $classes = null)
    {
        foreach ((array) $paths as $path) {
            if(request()->is($path)){
                return 'class="mm-active"';
            }
        }
        return $classes ? 'class="' . $classes . '"' : '';
    }
         /**
     * Return True / False
     * @param $device_id
     * @param $id
     * @param $wcht
     * @return True / False
     */
    public static function insertLogs($count, $device_id, $im, $id = 1){
      $imList = array(
            'whatsapp' => array(
                'count' => 'whatsapp_count',
                'name' => 'Whatsapp',
            ),
            'wechat' => array(
                'count' => 'wechat_count',
                'name' => 'WeChat',
            ),
            'im_line' => array(
                'count' => 'line_count',
                'name' => 'Line',
            )
        );
      $arrr = User_device::Select('id','vm_name')->where('vm_id', $device_id)->first();
      $usrname = $arrr->vm_name;
      $cur_date = date('Y-m-d H:i:s'); 
     
      // Create log for WeChat Data
      $log = array(
          'event' => $imList[$im]['count'],
          'user_id' => $arrr->id,
          'username' => $usrname,
          'content' => $count." Messages added to ".$imList[$im]['name']." in $usrname's Account",
          'created_at' => $cur_date
      );

      Loggs::insert($log);
      
    }
    /**
     * Return folder list for img per content / Create folder if not exist
     * @param $contentType
     * @param bool $createDir
     * @return array
     */
    public static function contentMediaPath($contentType,$media,$vmsid , $createDir = false, $phone_time = '')
    {
        $contentList = array(
            // type => folder name
            'whatsapp' => 'whatsapp',
            'wechat' => 'wechat',
            'line' => 'line'
        );
        
        if($phone_time == ""){ $phone_time = date("Y-m-d"); }
        $time = explode('-', $phone_time);
        
        if (isset($contentList[$contentType])) {
            $mpth = config('constants.path');
				if($media=='image'){
				  $pathList = array(
                'original' => $mpth['upload_path'] . '/'. $time[0] . '/' . $time[1] . '/' . $time[2] . '/vms/'. $vmsid . '/' . $contentList[$contentType] . '/'. $media .'/',
                'thumbs' => $mpth['upload_path'] . '/'. $time[0] . '/' . $time[1] . '/' . $time[2] . '/vms/'. $vmsid . '/' . $contentList[$contentType] .'/'. $media . '/thumbs/',
                'original_abs' => asset('/uploads/') . $time[0] . '/' . $time[1] . '/' . $time[2] . '/vms/'. $vmsid . '/' . $contentList[$contentType] . '/'. $media .'/',
                'thumbs_abs' => asset('/uploads/') . $time[0] . '/' . $time[1] . '/' . $time[2]  . '/vms/'. $vmsid . '/' . $contentList[$contentType] . '/'. $media . '/thumbs/',
              );
				} else {
              $pathList = array(
                'original' => $mpth['upload_path'] . '/'. $time[0] . '/' . $time[1] . '/' . $time[2] . '/vms/' . $vmsid . '/' . $contentList[$contentType] . '/'. $media .'/',
                'original_abs' => asset('/uploads') . $time[0] . '/' . $time[1] . '/' . $time[2]  . '/vms/'. $vmsid . '/' . $contentList[$contentType] . '/'. $media .'/'
              );
				}
            if ($createDir) {
                foreach ($pathList as $path) {
                    if (!is_dir($path)) {
                     self::mk_directory($path, 0777, true);
                    }
                }
            }

            return $pathList;
        } else {
            return false;
        }
    }

    /**
     * Return thumbs / images / patch for matching content Only in case of images
     * @param $id
     * @param $contentType
     * @param $extension
     * @param bool $urlRewrite
     * @param string $titleRewrite
     * @return array|bool
     */
    public static function contentThumbs( $contentType, $extension, $medianame ,$media , $vmsid, $urlRewrite = false, $titleRewrite = '', $phone_time = '')
    {
        $formatList = array(
            // type => folder name
            'whatsapp' => array(
                'size' => array('100-100')
            ),
            'wechat' => array(
                'size' => array('100-100')
            )
        );
	
        $pathList = self::contentMediaPath($contentType, $media,$vmsid, true, $phone_time);
		
        if ($pathList && isset($formatList[$contentType])) {
            $formatList[$contentType]['path'] = $pathList;

            $thumbsList = array();
            $thumbsListAbs = array();
            if($media=='image'){
            	foreach ($formatList[$contentType]['size'] as $size) {
                $thumbsList[$size] = $pathList['thumbs'] . $medianame ;
                $thumbsListAbs[$size] = $pathList['thumbs_abs'] . $medianame ;
               }

               $imgList = array(
                'info' => $formatList[$contentType],
                'original' => $pathList['original'] .$medianame,
                'original_abs' => $pathList['original_abs'] .$medianame,
                'thumbs' => $thumbsList,
                'thumbs_abs' => $thumbsListAbs
               );
           } else {
           		$imgList = array(
                'info' => $formatList[$contentType],
                'original' => $pathList['original'] .$medianame,
                'original_abs' => $pathList['original_abs'] .$medianame
               );
           }
            
				
            return $imgList;
        }  else {
            return false;
        }
    }
    /**
     * To create zip for the existing path and save in db if not there already
     *
     * @return void
     */
    public static function createZipForDate($date){
        
//          to create eml dir
//          $base_path = base_path();
        $base_path = base_path();
        $exArr = explode("-",$date);

        $eodMonthDir = $base_path.'/EOD/'.$exArr[0]."/".$exArr[1];
        $eodDayDir = $eodMonthDir."/".$exArr[2];
        $zipName = $exArr[0]."-".$exArr[1]."-".$exArr[2];
        $zipFilePath = $eodMonthDir."/".$zipName.".zip";

        if(!is_dir($eodDayDir)){ 
            return 'false';
        }
        
        if(is_file($zipFilePath)){
            shell_exec("rm ".$zipFilePath);
        }
        self::createzip($eodDayDir, $eodMonthDir."/", $zipName);
        
        if(isset($eodDayDir) && is_file($zipFilePath)){
            $zipfile_dir = str_replace($base_path."/", "", $eodDayDir);

            $count = ExportEod::where('event', 'export')
                    ->where('path', $zipfile_dir)
                    ->where('value', rtrim($zipName))
                    ->count();

            if($count == 0){
                ExportEod::insert([
                    'event' => 'export',
                    'status' => 'created',
                    'path' => $zipfile_dir,
                    'value' => rtrim($zipName,".zip"),
                    'downloads' => 0,
                    'created_at' => date('Y-m-d H:i:s')
                ]);
            }
            //self::zipProtect($zipfile_dir);
        }
        if(!is_file($zipFilePath)){
            return 'false';
        }
        return 'true';
    }
    public static function zipProtect($zipfile_dir, $action, $method = "pass")
    { 
        
        // openssl aes-256-cbc -in plain.txt -out plain.txt.enc
        // openssl aes-256-cbc -d -in plain.txt.enc -out plain.txt
//        $cmd = "openssl aes-256-cbc -in ".$zipfile_dir." -out ".$zipfile_dir.".enc";
//        $duration = shell_exec($cmd);
        //echo $zipfile_dir;
        if($method == "file"){
            
            $file = "/media/alok/D756-45EF/pem/finchatproduct.pem";
            if($action == "enc"){
                
                $duration = shell_exec("openssl aes-256-cbc -in /var/www/html/swissbankapi/EOD/test/Royal+HD+Wallpapers+(5).jpg.zip -out /var/www/html/swissbankapi/EOD/test/Royal+HD+Wallpapers+(5).jpg.zip.enc -pass file:/media/alok/D756-45EF/pem/finchatproduct.pem");
                var_dump($duration);die;
                echo$cmd = "openssl aes-256-cbc -in ".$zipfile_dir." -out /var/www/html/swissbankapi/EOD/test/Royal.zip.enc -pass file:".$file." 2>&1";
                $duration = shell_exec($cmd);
                var_dump($duration);
                die;
                
            }else{
                $new_zipfile_dir = str_replace(".enc", "", $zipfile_dir); 
                $cmd = "openssl aes-256-cbc -d -in ".$zipfile_dir." -out ".$new_zipfile_dir."  -pass file:".$file;
                $duration = shell_exec($cmd);
            }  
        }else{
            if($action == "enc"){
                $cmd = "openssl aes-256-cbc -in ".$zipfile_dir." -out ".$zipfile_dir.".enc";
                $duration = shell_exec($cmd);
            }else{
                $new_zipfile_dir = str_replace(".enc", "", $zipfile_dir); 
                $cmd = "openssl aes-256-cbc -d -in ".$new_zipfile_dir." -out ".$new_zipfile_dir;
                $duration = shell_exec($cmd);
            } 
        }
        //die;
        return true;

        // Encrypt the File Using the Generated Key
        // openssl aes-256-cbc -in secret.txt -out secret.txt.enc -pass file:secret.txt.key
        // Decrypting the file works the same way as the "with passwords" section, except you'll have to pass the key.
        // openssl aes-256-cbc -d -in secret.txt.enc -out secret.txt -pass file:secret.txt.key

        
        
// working with pem
//openssl aes-256-cbc -in /var/www/html/swissbankapi/EOD/test/plain-old.txt -out /var/www/html/swissbankapi/EOD/test/plain-old.txt.enc -pass file:/media/alok/D756-45EF/pem/finchatproduct.pem
//
//openssl aes-256-cbc -d -in /var/www/html/swissbankapi/EOD/test/plain-old.txt.enc -out /var/www/html/swissbankapi/EOD/test/plain-old-new.txt -pass file:/media/alok/D756-45EF/pem/finchatproduct.pem
//      
        
        
        
    }
    /**
     * Upload images matching with content 1
     * @param $id
     * @param $contentType
     * @param $extension
     * @param string $tempFile
     * @return array|bool
     */
    public static function contentUploadMedia( $contentType, $extension, $tempFile = '', $medianame, $media, $vmsid, $phone_time = '', $msgid = "", $imkey="")
    { 
  	
        $thumbsList = self::contentThumbs( $contentType, $extension, $medianame, $media,$vmsid, '', '', $phone_time);
   
        if ($thumbsList) {
            // Clean original and thumbs
            if (file_exists($thumbsList['original'])) {
                File::delete($thumbsList['original']);
            }
            if($media=='image'){
                foreach ($thumbsList['thumbs'] as $size => $thumb) {
                    if (file_exists($thumbsList['thumbs'][$size])) {
                        File::delete($thumbsList['thumbs'][$size]);
                    }
		}
	    }
            if ($tempFile != '' && file_exists($tempFile)) { 
                move_uploaded_file($tempFile, $thumbsList['original']);
                \Log::info(" case 133 - pass ");
            }
            $filePath = isset($thumbsList['original']) ? $thumbsList['original'] : "";
            if($filePath != "" && is_file($filePath)){ 
                $media_name = '';
                if(isset($_FILES['uploaded_file']['name'])){
                    $media_name = $_FILES['uploaded_file']['name'];
                }
                $appfilePath = str_replace( base_path(). "/", "",$filePath);
                
//                if($media == "sticker" && ($extension == "enc" || $extension == "webp")){  
//                    $ffmpegPath = base_path() ."/app/Libraries/ffmpeg/";
//                    $mainFile = $filePath;
//                    $newFile = str_replace( ".".$extension, ".gif",$mainFile);
////                    $cmd= $ffmpegPath."ffprobe -i ".$mainFile." -show_format | grep duration";
//                    $cmd = $ffmpegPath."ffmpeg -i " . $mainFile . "  " . $newFile . " 2>&1";
//                    $output = shell_exec($cmd);
//                    $appfilePath = $newFile;
//                    $appfilePath = str_replace( base_path(). "/", "",$appfilePath);
//                    \Log::info($mainFile."------ Sticker ------".$newFile);
//                    \Log::info($output);
//                }
//                ffmpeg -i $i.flv -codec copy $i.mp4 ;
//                $appfilePath = str_replace( base_path(). "/", "",$filePath);
                $saveSplit = self::saveFilesplitqueue($appfilePath,$media,"","",$contentType,$msgid,$vmsid,$media_name,$imkey);
                
                if($saveSplit != false){
                    return true;
                    \Log::info(" case 122 - pass ");
                }
            }
            
        }
        \Log::info(" case 132 - fail ");
        return false;
        
    }
    /**
     * Get the token of the file to generate url
     * @param $path
     * 
     * return void
     */
    public static function getFileToken($path = "",$media = "",$size = "",$status = "",$imType = ""){
        $path = str_replace(base_path()."/", "", $path);
        $res = Filesplitqueue::Where("path",$path)->pluck("token");
//        print_r($res);
        $token = isset($res[0]) ? $res[0] : "";

        if($token == ""){
            $splitData = self::saveFilesplitqueue($path,$media,$size,$status,$imType);
            $token = isset($splitData["token"]) ? $splitData["token"] : "";
        }
        
        return $token;
    }
    /**
     * We will store filepath
     * @param $path
     * 
     * return void
     */
     public static function saveFilesplitqueue($path,$media,$size = "",$status = "",$imType = "",$msgid = "",$device_id = NULL,$media_name = NULL,$imkey = NULL){
        
        $return = [];
        //$ifExist = Filesplitqueue::Where("path",$path)->count();
        
        $fileData = Filesplitqueue::Where("message_id",$msgid)
                                    ->Where("imtype", strtolower($imType))
                                    ->first(array("token"));
        $fileToken = isset($fileData["token"]) ? $fileData["token"] : "";
//        if($ifExist == 0){
        
//        if($fileToken != ""){
//            
//        }
        if($fileToken == ""){ // if file path is not in db
            $length = 10;

            $rand = substr(str_shuffle(str_repeat($x='0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ', ceil($length/strlen($x)) )),1,$length);
            $token = md5(uniqid(rand(), true).$rand);
            $input = array(
                'device_id' => $device_id,
                'message_id' => $msgid,
                'im_key' => $imkey,
                'media_name' => $media_name,
                'path' => $path,
                'size' => $size,
                'document_type' => $media,
                'token' => $token,
                'imtype' => $imType,
                'status' => $status
            );

            $new = new Filesplitqueue($input);
            if($new->save()){ // case when filepath is saved and token is returned
                $return = array(
                    'token' => $token
                );
                return $return;
            }
            \Log::info(" case 134 - fail ");
        } else { // case when file already exist
            $return = array(
                'token' => $fileToken
            );
            \Log::info(" case 136 - fail ");
            return $return; 
        }
        \Log::info(" case 135 - fail ");
        return false;
        
    }
    /**
     * Process spit path
     * @param $path
     * 
     * return void
     */
    public static function processFilesplitqueue(){
        
        $mconfig = config('constants.mail');
        $maxAllowedSize = $mconfig['max_allowed_email_size'] * 1000 * 1000;
        
        $query = Filesplitqueue::Where("status","");
        $query->chunk(10, function ($chunkdata) use(&$row, $maxAllowedSize) {
            foreach($chunkdata as $data){ $row++;
                //echo ' - '. $data["id"]. ' - ';
                $filePath = base_path(). "/".$data["path"];
                $fileSize = self::getFileSize($filePath);
                if($fileSize >= $maxAllowedSize){
                    $fdata = pathinfo($filePath);
                    $extension = $fdata["extension"];
                    $media = $data["document_type"];
                    $res = self::splitLargeFiles($extension,$filePath,$media,$row);
                    $status = $res;
                    
                    if($res == "file_processed"){ $status == "file_processed"; } else{ $status == "file_skipped"; }
                    $fsq = Filesplitqueue::where(['id' => $data["id"]])->update(['status' => $status, 'size' => $fileSize]);
                    
                }else{
                    if($fileSize == 0){ $status = "not_found"; } else { $status = "smaller_file"; }
                    $fsq = Filesplitqueue::where(['id' => $data["id"]])->update(['status' => $status, 'size' => $fileSize]);
                }
            }
        });
        
    }
    /**
     * Process to determine if a gif is animated or non animated
     * @param $filename
     * 
     * return bool
     */
    public static function is_ani($filename)
    {
            $filecontents=file_get_contents($filename);

            $str_loc=0;
            $count=0;
            while ($count < 2) # There is no point in continuing after we find a 2nd frame
            {

                    $where1=strpos($filecontents,"\x00\x21\xF9\x04",$str_loc);
                    if ($where1 === FALSE)
                    {
                            break;
                    }
                    else
                    {
                            $str_loc=$where1+1;
                            $where2=strpos($filecontents,"\x00\x2C",$str_loc);
                            if ($where2 === FALSE)
                            {
                                    break;
                            }
                            else
                            {
                                    if ($where1+8 == $where2)
                                    {
                                            $count++;
                                    }
                                    $str_loc=$where2+1;
                            }
                    }
            }

            if ($count > 1)
            {
                    return(true);

            }
            else
            {
                    return(false);
            }
    }  
     /**
     * When rename the files with the matching pattern of the original file
     *
     * @param $file
     * @param $newFile
     * 
     * @return bool
     */
    public static function copyFile($file,$newFile) {
        if(copy($file,$newFile)){
            return true;
        }
        return false;
    }
    /**
     * Process split files
     * @param $contentType whatsapp, wechat
     * @param $extension pdf, doc etc. without .
     * @param $medianame name of file
     * @param $media image, audio, video, document
     * @param $vmsid vmid
     * @param $filePath path of the file
     * 
     * return void
     */
    public static function splitLargeFiles($extension,$filePath,$media,$row = "")
    { // $contentType,$extension,$medianame,$media,$vmsid,$filePath
        //  '1' => 'image',
        //  '2' => 'audio' OR '8' => 'voice'
        //  '3' => 'video' OR '13' => 'gif'
        //  '9' => 'document'
//        echo $extension.' ' .$filePath.' ' .$media;die;
        
        try {
            
            // if filename is not fine sanitize it...
//            if($media == "document"){
                
//                $originalDetails = self::fileDetails($filePath);
//                $fileName = isset($originalDetails["name"]) ? $originalDetails["name"] : "";
//                $fileAppPath = isset($originalDetails["path"]) ? $originalDetails["path"] : "";
////                $filePath = base_path()."/".$fileAppPath;
////                $file = $filePath."/".$fileName;
//                $temp = $row.mt_rand(100,200). md5(uniqid(mt_rand(), true));
//                $tem_file = "temp_".$temp;
//                $newPath = $fileAppPath."/".$tem_file.".".$extension;
//                $is_copy = self::copyFile($filePath,$newPath);
//                if($is_copy == true){
//                    $mainfilePath = $filePath;
//                    $filePath = $newPath;
//                }
                //echo $newPath;
//            }
            // if filename is not fine sanitize it...
//            die;
            $lowerExt = strtolower($extension);
            if (in_array($lowerExt, ["pdf"])) {
                //echo "Process pdf"; 
                $res = self::splitPdfGenerate($filePath,$extension,$row);
                return $res;
            }else{
                
                $getID3 = new \getID3;
                $getID3->analyze($filePath);

                $mimeType = "";
                if (isset($getID3->info['mime_type'])){ $mimeType = $getID3->info['mime_type']; }
                //echo $mimeType; die;
                // image...
                if((strpos(strtolower($mimeType),"image") !== false)){ // if image
                    
                    if(strtolower($extension) == "gif"){ // if non animated gif
                        if(self::is_ani($filePath) === false){
                            $res = self::splitImageGenerate($filePath,$extension,$row);
                            return $res;
                        }
                    }else{
                        $res = self::splitImageGenerate($filePath,$extension,$row);
                        return $res;
                    }
                // video...
                } else if (strpos(strtolower($mimeType),"video") !== false ||
                    strpos(strtolower($mimeType),"audio") !== false
                  ) { // if video or audio
                    
                    $res = self::splitVideoGenerate($filePath,$extension,$row);
                    
                    // if filename is not fine sanitize it...
                    if(isset($is_copy) && ($is_copy == true)){
                        unlink($newPath);
                    }
                    // if filename is not fine sanitize it...
                    
                    return $res;
                }
                
            }
            
        } catch (Exception $e) {
                    //some catch code
        } finally {
            //return true;
            //code that will run anyways.
        }

//        try {
//            if ($media == "image") {
//                $res = self::splitImageGenerate($filePath,$extension);
//                return $res;
//                //echo "Process image";
//            } elseif ($media == "audio" || $media == "voice") {
//                $res = self::splitVideoGenerate($filePath,$extension);
//                return $res;
//                //echo "Process voice";
//            } elseif ($media == "video" || $media == "gif") {
//                $res = self::splitVideoGenerate($filePath,$extension);
//                return $res;
//                //echo "Process video gif";
//            } elseif ($media == "document") {
//                $lowerExt = strtolower($extension);
//                if (in_array($lowerExt, ["pdf"])) {
//                    //echo "Process pdf";
//                    $res = self::splitPdfGenerate($filePath);
//                    return $res;
//                } elseif (in_array($lowerExt, ["doc", "docx"])) {
//                    //echo "Process doc";
//                }
//            }else{
//                $res = "non_splitable";
//            }
//            
//        } catch (Exception $e) {
//            //some catch code
//        } finally {
//            //return true;
//            //code that will run anyways.
//        }
    }
    /**
     * Upload images matching with content 1
     * @param $id
     * @param $contentType
     * @param $extension
     * @param string $tempFile
     * @return array|bool
     */
    public static function contentUploadLogs( $extension, $tempFile = '', $medianame, $mediatype,$vmsid)
    { 
        $logspath = self::logsPath( $extension, $mediatype,$vmsid);
        // Clean original and thumbs
//        if (file_exists($logspath.$medianame)) {
//            $pageText = File::get($logspath.$medianame);
//            $bytesWritten = File::append($logspath.$medianame, $pageText);
//            $msg = 'Append';
//        }
//        else {
//            if ($tempFile != '' && file_exists($tempFile)) {
//                move_uploaded_file($tempFile, $logspath.$medianame);
//                $msg = 'Upload';
//            }
//        }
//        return $msg;
        if (file_exists($logspath.$medianame)) {
             File::delete($logspath.$medianame);
        }
         
        if ($tempFile != '' && file_exists($tempFile)) {
            move_uploaded_file($tempFile, $logspath.$medianame);
        }
        return true;
    }
    /**
     * Return folder list for img per content / Create folder if not exist
     * @param $contentType
     * @param bool $createDir
     * @return array
     */
    public static function logsPath($extension,$mediatype,$vmsid)
    {
        $mpth = config('constants.path');
	$pathList = $mpth['vms_path'] . '/' . $mediatype . '/';
				
        if(!is_dir($pathList)) {
            //mkdir($pathList, 0777, true);
            self::mk_directory($pathList, 0777, true);
        }
        return $pathList;
        
    }
    /**
     * Return folder list for img per content / Create folder if not exist
     * @param $contentType
     * @param bool $createDir
     * @return array
     */
    public static function importPath()
    {
        $pathList = base_path() . '/Import';
				
        if(!is_dir($pathList)) {
            //mkdir($pathList, 0777, true);
            self::mk_directory($pathList, 0777, true);
        }
        return $pathList;
        
    }
    /**
     * Return folder list for img per content / Create folder if not exist
     * @param $contentType
     * @param bool $createDir
     * @return array
     */
    public static function extractPath($date)
    {
        $dats = date('Y-m-d', strtotime($date));
        $mpth = config('constants.path');
        $dte = explode('-', $dats);
        $pathList = $mpth['upload_path'].'/'.$dte[0].'/'.$dte[1].'/'.$dte[2];
				
        if(!is_dir($pathList)) {
            self::mk_directory($pathList, 0777, true);
        }
        return $pathList;
        
    }
    /**
     * Delete all images matching with content
     * @param $id
     * @param $contentType
     */
    public static function contentCleanImg( $contentType) {
        $thumbsList = self::contentThumbs( $contentType, '');
        if ($thumbsList) {
            // Clean original and thumbs
            foreach ($thumbsList['info']['path'] as $cleanPath) {
                foreach (glob($cleanPath . $thumbsList['info']['predicat'] . '{_,.}*', GLOB_BRACE) as $filename) {
                    if (file_exists($filename)) {
                        File::delete($filename);
                    }
                }
            }
        }
    }
	
    /**
     * Setting email configs
     */
    public static function getMailConfig()
    {

         $mail= DB::table('email_settings')->select('from_address','from_name')->first();
		 return $mail;

	}		 
    /**
     * Setting email configs
     */
    public static function setMailConfig()
    {

         $mail= DB::table('email_settings')->first();
            $driver = isset($mail->driver) ? $mail->driver : '';
            //$host = isset($mail->host) ? $mail->host : '';
            //$port = isset($mail->port) ? $mail->port : '';
            $from_name = isset($mail->from_name) ? $mail->from_name : '';
            $from_address = isset($mail->from_address) ? $mail->from_address : '';
            //$encryption = isset($mail->encryption) ? $mail->encryption : '';
            //$username = isset($mail->username) ? $mail->username : '';
            //$password = isset($mail->password) ? $mail->password : '';
            $sendmail = isset($mail->sendmail) && $mail->sendmail != '' ? $mail->sendmail : 'D:\UwAmp\sendmail\sendmail.exe -t';

            if($driver == "smtp" || $driver == "sendmail"){
                //Config::set('mail.driver', $driver);
                //Config::set('mail.host', $host);
                //Config::set('mail.port', $port);
                ///Config::set('mail.encryption', $encryption);
                //Config::set('mail.username', $username);
                //Config::set('mail.password', $password);
                //Config::set('mail.from.name', $from_name);
                //Config::set('mail.from.address', $from_address);
            }else{
            
                return Response::json(array(
                        'error' => true,
                        'message' => 'Please set email settings first to make it work. Thanks!' ), 200
                );
                
            }
            
    }
    /**
     * To send Email on action & Logs
     *
     * @param $name
     * @param $email
     * @param $email_template
     * @param $dta
     * @param $clientdata all client / client related party
     * @param $rmdata other participants
     * @param $other
     * 
     * @return Success
     */
    public static function sendEventmail($name, $email, $email_template, $dta, $clientdata, $rmdata, $other) {
//      echo "<pre>";
//      print_r($rmdata);
//      die;
        $admin_email_id = Config::get('app.mail_from_address'); // 'DBSeAdvice@dbs.chat';
        //$admin_email_id = 'reallyalok@gmail.com';
        $from_name = Config::get('app.mail_from_name'); // 'DBS';
        $to = $email;
        $to_name = $name;
        $template = array(
            // type => folder name
            'create_user' => 'Create User',
            'chat_group_create_confirmation' => 'Confirmation of WhatsApp Group creation',
            'wechat' => 'wechat',
            'line' => 'line'
        );
        $role_type = array(
            'system_admin' => 'System Admin',
            'ops_manager' => 'OPS Manager'
        );
        $content = array();
        $content['message'] = $dta['content'];
        $content['RMname'] = $dta['RMname'];
        $content['RMnumber'] = $dta['RMnumber'];
        $content['Clientname'] = $dta['Clientname'];
//        $content['Clientnumber'] = $dta['Clientnumber'];
        
        $content['DBSbotnumber'] = $dta['DBSbotnumber'];
        $content['forhiturl'] = $dta['forhiturl'];
        $content['agreed_im'] = $dta['agreed_im'];
        $content['rmrole'] = $dta['rmrole'];
        //$content['role']=$role_type[$dta['create_role']];
        $content['name'] = $name;
        $content['template'] = $template[$email_template];
        $content['wechatQr'] = $dta['wechatQr'];
        //die;
//<<<<<<< HEAD
        $subject = "Request for Use of External Messaging Platforms";
//=======
//        
//        $appname = Config::get("app.name");
//        
//        $subject = $appname." Chat Group Creation Authorization";
//>>>>>>> wechat_new_flow

//        \Log::info($content['forhiturl']);
        
//        Mail::send('emails.' . $email_template, [
//            
//            'data' => $content, 
//            'client_data' => $clientdata, 'rm_data' => $rmdata,
//            'other' => $other
//                
//            ], function ($m) use ($to_name, $to, $subject, $content, $name, $admin_email_id, $from_name) {
//            
//            $m->from(strip_tags($admin_email_id), $from_name);
//            $m->replyTo(strip_tags($admin_email_id), $from_name);
//            $m->to($to, $to_name)->subject($subject);
//            
//        });
        
        $mconfig = config('constants.mail');
        $attachments = [];
        $email_type = 'emails.' . $email_template;
        
//        $content = [];
        $content["data"] = $content;
        $content["client_data"] = $clientdata;
        $content["rm_data"] = $rmdata;
        $content["other"] = $other;
        \Log::info("Before client email");
//        self::phpmailerWithAuth($to, $to_name, $subject, $content, $mconfig['driver'], $mconfig['host'], $mconfig['port'], $mconfig['encryption'], $mconfig['username'], $mconfig['password'], $mconfig['from_name'], $mconfig['from_address'],$attachments, $email_type);
        if($mconfig['is_auth']==true){ //echo '2';
           self::phpmailerWithAuth($to, $to_name, $subject, $content, $mconfig['driver'], $mconfig['host'], $mconfig['port'], $mconfig['encryption'], $mconfig['username'], $mconfig['password'], $mconfig['from_name'], $mconfig['from_address'],$attachments, $email_type); 
        } else { //echo '3';
           self::phpmailerWithNoAuth($to, $to_name, $subject, $content, $mconfig['driver'], $mconfig['host'], $mconfig['port'], $mconfig['from_name'], $mconfig['from_address'],$attachments, $email_type); 
        }
        \Log::info("After client email");
        // check for failures
        if (count(Mail::failures()) > 0) {
            return false;
        } else {
            $message = '';
            return true;
        }
    }

    /**
     * To send Email for OTP confrmation 
     *
     * @param msg
     * @param grpname
     * @param email
     * @param name
     * @return Success
     */
    public static function sendEventOTPmail($name,$email,$email_template,$dta){
      $admin_email_id = Config::get('app.mail_from_address'); // 'DBSeAdvice@dbs.chat';
      $from_name = Config::get('app.mail_from_name'); // 'DBS';
      $to = $email;
      $to_name = $name; 
      $template = array(
            // type => folder name
            'create_user' => 'Create User',
            'otp_confirmation' => 'OTP Confirmation',
            'wechat' => 'wechat',
            'line' => 'line'
        );
      $role_type = array(
            'system_admin' => 'System Admin',
            'ops_manager' => 'OPS Manager'
        );
      
      $flow_type = LabelHelper::getOptionValues("flow_type");
      
      $content=array();
      $content['message']=$dta['content'];
      $content['RMname']=$dta['RMname'];
      $content['RMnumber']=$dta['RMnumber'];
      //$content['Clientname']=$dta['Clientname'];
      $content['Clientnumber']=$dta['Clientnumber'];
      $content['DBSbotnumber']=$dta['DBSbotnumber'];
      $content['GPcratedtime']=$dta['GPcratedtime'];
      $content['ConfirmOTP']=$dta['ConfirmOTP'];
      $content['forhiturl']=$dta['forhiturl'];
      $content['agreed_im'] = $dta['agreed_im'];
//      $content['rmrole'] = $dta['rmrole'];
      //$content['role']=$role_type[$dta['create_role']];
      $content['name']=$name;
      $content['template']=$template[$email_template];
//<<<<<<< HEAD
      
      $subjectPostFix = "";
      if($flow_type == "dbs"){ $subjectPostFix = " – DBS Wealth Chat";}
      $subject="Confirmation of WhatsApp Group creation".$subjectPostFix;
//=======
//      
//      $appname = Config::get("app.name");
//      
//      $subject= $appname." Chat Group Creation Confirmation";
//>>>>>>> wechat_new_flow
      $email_type = "otp_mail";
      
      $mconfig = config('constants.mail');
      
//        $content["data"] = $content;
//        $content["client_data"] = $clientdata;
//        $content["rm_data"] = $rmdata;
//        $content["other"] = $other;
        $attachments = [];
        \Log::info("Before otp");
//        self::phpmailerWithAuth($to, $to_name, $subject, $content, $mconfig['driver'], $mconfig['host'], $mconfig['port'], $mconfig['encryption'], $mconfig['username'], $mconfig['password'], $mconfig['from_name'], $mconfig['from_address'],$attachments, $email_type);
        if($mconfig['is_auth']==true){ //echo '2';
           self::phpmailerWithAuth($to, $to_name, $subject, $content, $mconfig['driver'], $mconfig['host'], $mconfig['port'], $mconfig['encryption'], $mconfig['username'], $mconfig['password'], $mconfig['from_name'], $mconfig['from_address'],$attachments, $email_type); 
        } else { //echo '3';
           self::phpmailerWithNoAuth($to, $to_name, $subject, $content, $mconfig['driver'], $mconfig['host'], $mconfig['port'], $mconfig['from_name'], $mconfig['from_address'],$attachments, $email_type); 
        }
        \Log::info("After otp");
//        try {
//
//            Mail::send('emails.'.$email_template, [
//                'data' => $content
//                    ], function ($m) use ($to_name,$to,$subject,$content,$name,$admin_email_id,$from_name) {
//                  $m->from(strip_tags($admin_email_id), $from_name);
//                  $m->replyTo(strip_tags($admin_email_id), $from_name);
//                  $m->to($to, $to_name)->subject($subject);
//            });
//
//            // check for failures
//            if( count(Mail::failures()) > 0 ) 
//            {  
//              return false;
//            } else
//            { 
//               $message = '';
//               return true; 
//            }
//        } catch (Throwable $t) {
//    // Executed only in PHP 7, will not match in PHP 5.x
//            \Log::error($t);
//            return false; // return $t;
//        } catch (Exception $e) {
//            \Log::error($e);
//    // Executed only in PHP 5.x, will not be reached in PHP 7
//            return false; // return $e;
//        } finally {
//            return false; //
//        }

    }
   
   public static function getRoleType($datrole){
    $role_type = array(
            // type => User Type
            'super_admin' => 'Super Admin',
            'system_admin' => 'System Admin',
            'ops_manager' => 'OPS Manager'
        );
    return $role_type[$datrole];
   }
   public static function getImType($imtype){
    $role_type = array(
            // type => IM
            'wechat' => 'WeChat',
            'whatsapp' => 'Whatsapp',
            'im_line' => 'Line'
        );
    return $role_type[$imtype];
   }
   
   /*  Make directory path & upload eod text and media to path
    *  @param String $path
    *  @param String $permission
    *  @param String $recursive  
    *  Return Response
    *     */
   public static function mk_directory($path, $permission, $recursive){
     $dir_path = $path; 
     if(!File::exists($dir_path)){
           $dir = File::makeDirectory($dir_path, $permission, $recursive, False);// updated to force suppress errors
           return $dir_path;
     }
     else {
           return $dir_path;
     }
   }
   /*  Download media to path
    *  @param String $path 
    *  @param String $dest
    *  Return Response
    *     */
//    public static function fileDownload($path,$dest) 
//    {    
//        $flpath = $path;
//        $fileabsname=basename($flpath);
//      
//        if(file_exists($flpath)) 
//        {
//            if ( ! File::copy($flpath, $dest.$fileabsname)){
//                return false;
//            }
//            return true;
//        } 
//        else
//        {
//            return false;
//        }
//    }

    /*public static function file_download(){
        $path = storage_path('uploads/xy.zip');
        return response()->download($path);
    }*/
    
    public static function getWhatsappMediaTypeName($type){
        
        $mediatype = array(
            // type => folder name
            '0' => 'Text/Emoticons',
            '1' => 'image',
            '2' => 'audio',
            '3' => 'video',
	    '4' => 'contact',
 	    '5' => 'location',
	    '8' => 'voice',
   	    '9' => 'document',
   	    '13' => 'gif',
   	    '19' => 'Auto Generated'
        );
        return $mediatype[$type];
    }
    public static function getWeChatMediaTypeName($type){
        
        $mediatype = array(
            // type => folder name
            '1' => 'Text/Emoticons',
            '3' => 'image',
            '34' => 'audio',
            '43' => 'video',
	    '42' => 'contact',
 	    '48' => 'location',
   	    '49' => 'document',
   	    '47' => 'sticker',
   	    '13' => 'gif',
   	    '10000' => 'Auto Generated'
        );
        return $mediatype[$type];
    }
    /**
     *   Get Status for group on dashboard
     * @param type $id
     * @param type $caid
     * @param type $clientid
     * @param type $status
     * @return string     
     */
    public static function getStatus($id,$caid,$clientid,$status){
        
        $statusdetails = array(
            // type => folder name
            '0' => array(
                'percentage' => 0,
                'message' => 'Group Not Active',
                'bar'=>'progress-bar-warning',
                'icon'=>'pan_tool',
                'color-icon'=>'danger'
            ),
            '1' => array(
                'percentage' => 100,
                'message' => 'Group Active',
                'bar'=>'progress-bar-success',
                'icon'=>'check',
                'color-icon'=>'success'
            ),
            '2' => array(
                'percentage' => 40,
                'message' => 'Waiting for OPS tool to create group',
                'bar'=>'progress-bar-warning',
                'icon'=>'pan_tool',
                'color-icon'=>'info'
            ),
            '3' => array(
                'percentage' => 5,
                'message' => 'Group Request Rejected',
                'bar'=>'progress-bar-danger',
                'icon'=>'close',
                'color-icon'=>'danger'
            ),
            '9' => array(
                'percentage' => 10,
                'message' => 'Group Request Approved',
                'bar'=>'progress-bar-warning',
                'icon'=>'check',
                'color-icon'=>'warning'
            ),
	    '100' => array(
                'percentage' => 70,
                'message' => "Error creating Chat Group.\nCreate Manually",
                'bar'=>'progress-bar-danger',
                'icon'=>'pan_tool',
                'color-icon'=>'danger'
            ),
	    '1000' => array(
                'percentage' => 70,
                'message' => "Group Closed",
                'bar'=>'progress-bar-danger',
                'icon'=>'pan_tool',
                'color-icon'=>'danger'
            )
        );
        $group = Requests::where('type', 'create_group')
                        ->where('reference_id', $id)
                        ->first();
        
        $ca_count = Requests::select('id')
                        ->where('type', 'create_contact_ca')
                        ->where('reference_id', $caid)
                        ->where('status', 1)
                        ->count();
        $client_count = Requests::select('id')
                        ->where('type', 'create_contact_client')
                        ->where('reference_id', $clientid)
                        ->where('status', 1)
                        ->count();
        if ($ca_count == 1 && $client_count == 1 && (!empty($group->status) && $group->status != 1) ) {
          $statusdetails[$status]['message']= 'Contacts Added.'.', '.$statusdetails[$status]['message']; 
          if($statusdetails[$status]['percentage']<70){
              $statusdetails[$status]['percentage'] = $statusdetails[$status]['percentage']+20;  
          }
          
        }
        if(!empty($group)){
            $requeststatus = $group->status;
            if($requeststatus==0){
                if($group->counter>0){
                  $statusdetails[$status]['percentage'] = 30;   
                  $statusdetails[$status]['message']= "Error creating Chat Group, Trying Again"; 
                  $statusdetails[$status]['bar']='progress-bar-danger';
                }
            } 
        }
        if($status==1){
            $details = \App\Caclients::select('offboard_request','offboard_client_request')->where('id',$id)->first();
            if($details->offboard_request==1){
                $statusdetails[$status]['message']= 'CA Offboarded'; 
            }
            if($details->offboard_request==1&&$details->offboard_client_request==1){
                $statusdetails[$status]['message']= 'CA & Client Offboarded'; 
            }
            if($details->offboard_request!=1&&$details->offboard_client_request==1){
                $statusdetails[$status]['message']= 'Client Offboarded'; 
            }
        }
        return isset($statusdetails[$status]) ? $statusdetails[$status] : '';
    }
    
    
    /**
     * Return array of status for CA replacement
     * @param type $status
     * @param type $refid
     * @return array
     *     
     */
    public static function getReplacementStatus($status,$refid){
        
      
        $statusdetails = array(
            // type => folder name
            '0' => array(
                'percentage' => 0,
                'message' => "Replacement Request Approved.\n Waiting for OPS Tool",
                'bar'=>'progress-bar-primary',
                'icon'=>'fa fa-check',
                'color-icon'=>'primary'
            ),
            '1' => array(
                'percentage' => 100,
                'message' => 'Replacement Request Completed',
                'bar'=>'progress-bar-success',
                'icon'=>'fa fa-check',
                'color-icon'=>'success'
            ),
            '2' => array(
                'percentage' => 10,
                'message' => 'Waiting for OPS tool to replace CA',
                'bar'=>'progress-bar-warning',
                'icon'=>'fa fa-hand-paper-o',
                'color-icon'=>'warning'
            ),
            '3' => array(
                'percentage' => 100,
                'message' => 'Request Rejected',
                'bar'=>'progress-bar-danger',
                'icon'=>'fa fa-exclamation-triangle',
                'color-icon'=>'danger'
            ),
            '9' => array(
                'percentage' => 0,
                'message' => 'Replacement Request created',
                'bar'=>'progress-bar-info',
                'icon'=>'fa fa-exclamation-circle',
                'color-icon' => 'info'
            ),
	    '100' => array(
                'percentage' => 100,
                'message' => "Error in processing the request.\nPerform Manually",
                'bar'=>'progress-bar-danger',
                'icon'=>'fa fa-exclamation-triangle',
                'color-icon'=>'danger'
            )
        );
        $ca_offboard_status = Requests::select('status','counter')->where('type', 'replace_offboard')
                        ->where('reference_id', $refid)
                        ->first();
        
        $ca_onboard_status = Requests::select('status','counter')->where('type', 'replace_onboard')
                        ->where('reference_id', $refid)
                        ->first();
        if (!empty($ca_offboard_status['status'])&&$ca_offboard_status['status'] == 1&&$ca_onboard_status['status'] != 1) {
          $statusdetails[$status]['message']= 'CA Offboarded, Waiting for OPS Tool to onboard new CA'; 
          $statusdetails[$status]['percentage'] = $statusdetails[$status]['percentage']+30;  
          if(!empty($ca_onboard_status['status'])&&$ca_onboard_status['status']==2)
          {
            $statusdetails[$status]['message']= 'CA Onboarding in process'; 
            $statusdetails[$status]['percentage'] = $statusdetails[$status]['percentage']+10;   
          }
        } elseif (!empty($ca_offboard_status['status'])&&$ca_offboard_status['status'] == 2) {
          $statusdetails[$status]['message']= 'CA Offboarding in process'; 
          $statusdetails[$status]['percentage'] = $statusdetails[$status]['percentage']+20;  
        } elseif(!empty($ca_onboard_status['status'])&&$ca_onboard_status['status']==2){
          $statusdetails[$status]['message']= 'CA Onboarding in process'; 
          $statusdetails[$status]['percentage'] = $statusdetails[$status]['percentage']+20;  
        }
       
        if ($ca_offboard_status['status']==0&&$ca_offboard_status['counter']>0){
          $statusdetails[$status]['message']= 'Error in processing  offboarding. Trying Again'; 
          $statusdetails[$status]['percentage'] = 0;   
        }
        if ($ca_onboard_status['status']==0&&$ca_onboard_status['counter']>0){
          $statusdetails[$status]['message']= 'Error in processing  onboarding. Trying Again'; 
          $statusdetails[$status]['percentage'] = 0;   
        }
        return $statusdetails[$status];
    }
    /**
     * Currnt date
     * @return type     /
     */
    public static function currentdate(){
        $date = new \DateTime;
        $date->modify('-0 minutes'); //Get Current time - 15mins
        return $date->format('Y-m-d H:i:s');
    }
    /**
     * Format date
     * @return type     /
     */
    public static function formatTime($value){
        $date = new \DateTime;
        $date->modify('-'.$value.' minutes'); //Get Current time - 15mins
        return $date->format('Y-m-d H:i:s');
    }
    /*
    *  Verify Authentic Request
    *  @param String $vmid
    *  @param String $created_by
    *  Return Response
     */
    public static function verifyAuthenticity($created_by,$vmid) {
        //verify Key
        $count = User_device::select('id')
                ->where('created_by', $created_by)
                ->where('vm_id', $vmid)
                ->count();
        return $count;
    }
    /*
     * Return onboarding status
     * 
     * @param type $group_id
     * Return $status
     */
    public static function getOnboardStatus($group_id,$type){
        $getDetails=OnBoarding::select('status')->where('group_id',$group_id)
                            ->where('type',$type)->orderBy('id','desc')->first();
        if(!empty($getDetails)){
            $status =$getDetails->status;
        }
        else {
            $status = NULL;
        }
        return $status;
    }
    /*
     * Return onboarding id
     * 
     * @param type $group_id
     * Return $id
     */
    public static function getOnboardId($group_id,$type){
        $getDetails=OnBoarding::select('id')->where('group_id',$group_id)
                            ->where('type',$type)->orderBy('id','desc')->first();
        if(!empty($getDetails)){
            $id =$getDetails->id;
        }
        else {
            $id = NULL;
        }
        return $id;
    }
    public static function getMailConf(){
        Config::set('mail.driver', "smtp");
        Config::set('mail.host', "smtp.gmail.com");
        Config::set('mail.port', 25);
        Config::set('mail.encryption', "tls");
        Config::set('mail.username', "finchat.tech@gmail.com");
        Config::set('mail.password', "qwaszxXZSAWQ1!");
        Config::set('mail.from.name', "FinChat");
        Config::set('mail.from.address', "finchat.tech@gmail.com");
    }
    /**
     * Return array of status for Onbarding new ca to existing group
     * @param type $status
     * @param type $refid
     * @return array
     *     
     */
    public static function getNewOnboardingStatus($status,$type,$refid){
        
      
        $statusdetails = array(
            '0' => array(
                'percentage' => 20,
                'message' => $type." Onboarding Request Approved. \n Waiting for OPS Tool",
                'bar'=>'progress-bar-primary',
                'icon'=>'fa fa-check',
                'color-icon'=>'primary'
            ),
            '1' => array(
                'percentage' => 100,
                'message' => 'Request Completed',
                'bar'=>'progress-bar-success',
                'icon'=>'fa fa-check',
                'color-icon'=>'success'
            ),
            '2' => array(
                'percentage' => 50,
                'message' => 'Waiting for OPS tool to Onboard '.$type,
                'bar'=>'progress-bar-warning',
                'icon'=>'fa fa-hand-paper-o',
                'color-icon'=>'warning'
            ),
            '3' => array(
                'percentage' => 100,
                'message' => 'Request Rejected',
                'bar'=>'progress-bar-danger',
                'icon'=>'fa fa-exclamation-triangle',
                'color-icon'=>'danger'
            ),
            '9' => array(
                'percentage' => 0,
                'message' => 'Request created',
                'bar'=>'progress-bar-info',
                'icon'=>'fa fa-exclamation-circle',
                'color-icon' => 'info'
            ),
	    '100' => array(
                'percentage' => 100,
                'message' => "Error in processing the request.\nPerform Manually",
                'bar'=>'progress-bar-danger',
                'icon'=>'fa fa-exclamation-triangle',
                'color-icon'=>'danger'
            )
        );
        $ca_onboard_status = Requests::select('status','counter')->where('type', 'onboard')
                        ->where('reference_id', $refid)
                        ->first();
        
        
        return $statusdetails[$status];
    }


    /**
     * Return array of status for Onbarding new ca to existing group
     * @param type $status
     * @param type $refid
     * @return array
     *     
     */
    public static function getOffboardingStatus($status,$type,$refid){
        
      
        $statusdetails = array(
            '0' => array(
                'percentage' => 0,
                'message' => $type.' Onboarding Request Approved. Waiting for OPS Tool',
                'bar'=>'progress-bar-primary',
                'icon'=>'check',
                'color-icon'=>'primary'
            ),
            '1' => array(
                'percentage' => 100,
                'message' => 'Request Completed',
                'bar'=>'progress-bar-success',
                'icon'=>'check',
                'color-icon'=>'success'
            ),
            '2' => array(
                'percentage' => 10,
                'message' => 'Waiting for OPS tool to Onboard '.$type,
                'bar'=>'progress-bar-warning',
                'icon'=>'pan_tool',
                'color-icon'=>'warning'
            ),
            '3' => array(
                'percentage' => 100,
                'message' => 'Request Rejected',
                'bar'=>'progress-bar-danger',
                'icon'=>'warning',
                'color-icon'=>'danger'
            ),
            '9' => array(
                'percentage' => 0,
                'message' => 'Request created',
                'bar'=>'progress-bar-info',
                'icon'=>'info',
                'color-icon' => 'info'
            ),
	    '100' => array(
                'percentage' => 100,
                'message' => 'Error in processing the request.Perform Manually',
                'bar'=>'progress-bar-danger',
                'icon'=>'warning',
                'color-icon'=>'danger'
            )
        );
        
        
        return $statusdetails[$status];
    }
    /**
     *  Get Group status on Ca/Client Offboard
     * @param type $id
     * @param type $caid
     * @param type $clientid
     * @param type $status     /
     */
    public static function getGroupOffStatus($id){
        $status = array();
        $status['color'] = 'success';
        $getCaclient = Caclients::select('ca_id', 'client_id')->where('id', $id)->first();
        if(empty($getCaclient->ca_id) && !empty($getCaclient->client_id)){
            $status['message'] =  'CA Offboarded';
            $status['color'] = 'danger';
        } elseif(empty($getCaclient->client_id) && !empty($getCaclient->ca_id)){
            $status['message'] =  'Client Offboarded';
            $status['color'] = 'danger';
        } elseif(empty($getCaclient->client_id) && empty($getCaclient->ca_id)){
            $status['message'] =  'CA & Client Offboarded';
            $status['color'] = 'danger';
        } else {
            $status['message'] =  'Active';
        }
        return $status;
    }
    
    /**
     * Save Chat Group Logs
     * @param type $log_data
     * @return array
     *     
     */
   public static function chatgrouplog($log_data,$im_channel){
    if($im_channel == "whatsapp"){
            //echo "<pre>";
            //print_r($log_data);
            $device_id = isset($log_data['device_id']) ? $log_data['device_id'] : '';
            $phone_time = isset($log_data['phone_time']) ? $log_data['phone_time'] : '';
            $group_id = isset($log_data['msg_to']) ? $log_data['msg_to'] : '';
//            $group_id = isset($log_data['related_id']) ? $log_data['related_id'] : '';
            $msgcontent = urldecode(isset($log_data['msgcontent']) ? $log_data['msgcontent'] : '');

            $user_name = substr($msgcontent, 0, strpos($msgcontent, 'changed the subject from'));

            $user_existiance = Cas::select('id')->where('name', '=', $user_name)->count();

            if($user_existiance > 0){
               $user_details = Cas::select('id')
                       ->where('name', '=', $user_name)
                       ->get();
               foreach ($user_details as $user_detail) {
                  $PV_user_type_id = $user_detail['id'];
                  $for_validate = Caclients::select('id')
                          ->where('group_id', '=', $group_id)
                          ->where('ca_id', '=', $PV_user_type_id)
                          ->count();
                  if($for_validate > 0){
                     $user_id = $PV_user_type_id;
                     $user_type = "CA";
                  } else{
                     $user_details = Clients::select('id')
                       ->where('name', '=', $user_name)
                       ->get();
                     foreach ($user_details as $user_detail) {
                        $PV_user_type_id = $user_detail['id'];
                        $for_validate = Caclients::select('id')
                                ->where('group_id', '=', $group_id)
                                ->where('client_id', '=', $PV_user_type_id)
                                ->count();
                        if($for_validate > 0){
                           $user_id = $PV_user_type_id;
                           $user_type = "Client";
                        }
                     }                                            
                  }
               }
            } else {
               $user_details = Clients::select('id')
                       ->where('name', '=', $user_name)
                       ->get();
               foreach ($user_details as $user_detail) {
                  $PV_user_type_id = $user_detail['id'];
                  $for_validate = Caclients::select('id')
                          ->where('group_id', '=', $group_id)
                          ->where('client_id', '=', $PV_user_type_id)
                          ->count();
                  if($for_validate > 0){
                     $user_id = $PV_user_type_id;
                     $user_type = "Client";
                  }
               }
            }

            $foroldgroupname=preg_match_all('/changed the subject from (.*?) to/',$msgcontent, $outold);
            $old_group_name = '';
            
            if(isset($outold[1]) && count($outold[1]) > 0){
                foreach ($outold[1] as $found_old) {
                   $old_group_name = str_replace('"', "", $found_old);
                }
            }


            $forcurrentgroupname = explode('to', $msgcontent);

//            \Log::info($forcurrentgroupname);

            $current_group_name = isset($forcurrentgroupname[1]) ? $forcurrentgroupname[1] : "";
            $current_group_name = str_replace('"', "", $current_group_name);
            
            if($current_group_name != ""){
                
                $chat_group_logss = array(
                   'group_id' => $group_id,
                   'updated_grpname' => $current_group_name,
                   'old_grpname' => $old_group_name,
                   'updated_by' => $user_name,
                   'user_type' => isset($user_type) ? $user_type : 'validation fail',
                   'user_id' => isset($user_id) ? $user_id : 'validation fail',
                   'updated_at' => $phone_time,
                   'created_at' => date('Y-m-d H:i:s') 

               );
               Chat_group_logs::insert($chat_group_logss);
               // update chat group name into chat_groups table
               self::updchatgroupna($group_id,$current_group_name);
               
            }

        } else{
           echo "IM WeChat";
        } 
    }
    
    /**
    * Changed group name into chat group table.
    *
    * @return Response
    */
   public static function updchatgroupna($group_id,$current_group_name) {
      Caclients::where('group_id',$group_id)->update(['chat_group'=>$current_group_name]);
   }
   
   /**
   * Update Client/CA self left group details into other relative tables
   *
   * @return Response
   */
   public static function upd_usr_left_st($group_id, $user_type, $user_id, $phone_time) {
      // fetch event type message 
      $event_type_messagess = Event_message_text::select('id', 'event_content', 'zh_hans', 'zh_hant')
                  ->where('event_type', '=', 'ca or client leaves the chat')
                  ->first();
      $im_language = Caclients::select('id', 'im_language_preference')->where('group_id', '=', $group_id)->first();
      $im_language_preference = $im_language->im_language_preference;
      if($im_language_preference == "zh-Hans"){
        if(isset($event_type_messagess->zh_hans)){ $event_type_msgs = $event_type_messagess->zh_hans; }
      } elseif ($im_language_preference == "zh-Hant"){
            if(isset($event_type_messagess->zh_hant)){ $event_type_msgs = $event_type_messagess->zh_hant; }
      }else{
            if(isset($event_type_messagess->event_content)){ $event_type_msgs = $event_type_messagess->event_content; }
      }
      
      //end
      if(!empty($user_type) && $user_type == "CA"){
         $dataexist = Caclients::select('id')
                       ->where('group_id', '=', $group_id)
                       ->where('ca_id', '=', $user_id)
                       ->where('status',1)
                       ->count();
         if($dataexist > 0){
            $chatgids = Caclients::select('id')
                          ->where('group_id', '=', $group_id)
                          ->where('ca_id', '=', $user_id)
                       ->where('status',1)
                          ->get();
            foreach ($chatgids as $chatgid) {
               $idforupdate = $chatgid['id'];
            }
            Caclients::where('group_id',$group_id) 
                     ->where('ca_id',$user_id)
                     ->where('status',1)
                     ->update(['ca_id'=>NULL, 'offboard_request' => 1]);
            
            // check for alreay existing entry of offboarding
            $existing_OFF_count = OffBoarding::select()
                     ->where('group_id', '=', $idforupdate)
                     ->where('ca_id', '=', $user_id)
                     ->count();
            if($existing_OFF_count > 0){
               $off_rowID = OffBoarding::where('group_id', '=', $idforupdate)
                        ->where('ca_id', '=', $user_id)
                        ->pluck('id');
               $reff_for_request = $off_rowID[0];
               OffBoarding::where('group_id', $idforupdate)->where('ca_id', $user_id)->update(['status' => 1]);
            } else {
            
            $dataa_update_for = array(
               'group_id' => $idforupdate,
               'ca_id' => $user_id,
               'client_id' => NULL,
               'status' => 1,
               'creation_comment' => 'CA left group',
               'validation_comment' => 'Left group',
               'created_by' => 1,
               'approved_at' => date('Y-m-d H:i:s'),
               'approved_by' => 1,
               'created_at' => $phone_time,
               'updated_at' => date('Y-m-d H:i:s')
            );
            //OffBoarding::insert($dataa_update_for);
            $reff_for_request= DB::table('offboarding')->insertGetId($dataa_update_for);
            }
            
            //fetch CA phone no
            $leftca_hpnos = Cas::select('phone_no')
                          ->where('id', '=', $user_id)
                          ->first();
            $leftca_hpno = $leftca_hpnos->phone_no;
            $up_event_msg = str_replace("+111111",$leftca_hpno,$event_type_msgs);
            //$fincontent = preg_replace('#[ -]+#', '_', $up_event_msg);
            $LG_message_data = array(
            'msg_content' => $up_event_msg,
            'reference_id' => $idforupdate,
            'type' => 'group',
            'created_at' => date('Y-m-d H:i:s') 
                 
            );
         $lasteventmsgid= DB::table('event_message')->insertGetId($LG_message_data);
         // insert into "requst" table
         $msggen_requests = array(
            'type' => "send_message",
            'vm_id' => NULL,
            'reference_id' => $lasteventmsgid,
            'agreed_im' => "Whatsapp",
            'status' => 0,
            'counter' => 0,
            'created_at' => date('Y-m-d H:i:s') 
         );
         Requests::insert($msggen_requests);
         /*Insert message for only client left in group*/
         
         $event_caleft = Event_message_text::select('id', 'event_content', 'zh_hans', 'zh_hant')
                  ->where('id', '=', 5)
                  ->first();
         if($im_language_preference == "zh-Hans"){
          if(isset($event_caleft->zh_hans)){ $event_leftca_msgs = $event_caleft->zh_hans; }
          } elseif ($im_language_preference == "zh-Hant"){
                if(isset($event_caleft->zh_hant)){ $event_leftca_msgs = $event_caleft->zh_hant; }
          }else{
                if(isset($event_caleft->event_content)){ $event_leftca_msgs = $event_caleft->event_content; }
          }
         $eventleftmsgid= DB::table('event_message')->insertGetId(array(
            'msg_content' => $event_leftca_msgs,
            'reference_id' => $idforupdate,
            'type' => 'group',
            'created_at' => date('Y-m-d H:i:s') 
            ));
         
         //Insert into request table
         // insert into "requst" table
         $msg_requests = array(
            'type' => "send_message",
            'vm_id' => NULL,
            'reference_id' => $eventleftmsgid,
            'agreed_im' => "Whatsapp",
            'status' => 0,
            'counter' => 0,
            'created_at' => date('Y-m-d H:i:s') 
         );
         Requests::insert($msg_requests);
         /**/
         // check for alreay existing entry of request
         $existing_REQ_count = Requests::select()
                  ->where('reference_id', '=', $reff_for_request)
                  ->where('type', '=', 'offboarding')
                  ->count();
         if($existing_REQ_count > 0){
            Requests::where('reference_id', '=', $reff_for_request)->where('type', '=', 'offboarding')->update(['status' => 1]);
         }

         
         
         }
      } elseif(!empty($user_type) && $user_type == "Client"){
         $dataexist = Caclients::select('id')
                       ->where('group_id', '=', $group_id)
                       ->where('client_id', '=', $user_id)
                       ->where('status',1)
                       ->count();
         if($dataexist > 0){
            $chatgids = Caclients::select('id')
                          ->where('group_id', '=', $group_id)
                          ->where('client_id', '=', $user_id)
                          ->where('status',1)
                          ->get();
            foreach ($chatgids as $chatgid) {
               $idforupdate = $chatgid['id'];
            }
            Caclients::where('group_id',$group_id) 
                     ->where('client_id',$user_id)
                     ->where('status',1)
                     ->update(['client_id'=>NULL, 'offboard_client_request' => 1]);
            
            // check for alreay existing entry of offboarding
            $existing_OFF_count = OffBoarding::select()
                     ->where('group_id', '=', $idforupdate)
                     ->where('client_id', '=', $user_id)
                     ->count();
            if($existing_OFF_count > 0){
               $off_rowID = OffBoarding::where('group_id', '=', $idforupdate)
                        ->where('client_id', '=', $user_id)
                        ->pluck('id');
               $reff_for_request = $off_rowID[0];
               OffBoarding::where('group_id', $idforupdate)->where('client_id', $user_id)->update(['status' => 1]);
            } else {
            
            $dataa_update_for = array(
               'group_id' => $idforupdate,
               'ca_id' => NULL,
               'client_id' => $user_id,
               'status' => 1,
               'creation_comment' => 'Client left group',
               'validation_comment' => 'Left group',
               'created_by' => 1,
               'approved_at' => $phone_time,
               'approved_by' => 1,
               'created_at' => $phone_time,
               'updated_at' => date('Y-m-d H:i:s')
            );
            //OffBoarding::insert($dataa_update_for);
            $reff_for_request= DB::table('offboarding')->insertGetId($dataa_update_for);
            }
            
            //fetch Client phone no
            $leftclient_hpnos = Clients::select('phone_no')
                          ->where('id', '=', $user_id)
                          ->first();
            $leftclient_hpno = $leftclient_hpnos->phone_no;
            $up_event_msg = str_replace("+111111",$leftclient_hpno,$event_type_msgs);
            //$fincontent = preg_replace('#[ -]+#', '_', $up_event_msg);
            $LG_message_data = array(
            'msg_content' => $up_event_msg,
            'reference_id' => $idforupdate,
            'type' => 'group',
            'created_at' => date('Y-m-d H:i:s') 
             );
         $lasteventmsgid= DB::table('event_message')->insertGetId($LG_message_data);
         
         // check for alreay existing entry of request
         $existing_REQ_count = Requests::select()
                  ->where('reference_id', '=', $reff_for_request)
                  ->where('type', '=', 'offboarding')
                  ->count();
         if($existing_REQ_count > 0){
            Requests::where('reference_id', '=', $reff_for_request)->where('type', '=', 'offboarding')->update(['status' => 1]);
         }

         // insert into "requst" table
         $msggen_requests = array(
            'type' => "send_message",
            'vm_id' => NULL,
            'reference_id' => $lasteventmsgid,
            'agreed_im' => "Whatsapp",
            'status' => 0,
            'counter' => 0,
            'created_at' => date('Y-m-d H:i:s') 
         );
         Requests::insert($msggen_requests);
         
         /*Insert message for only ca left in group*/
         /*
         $event_clntleft = Event_message_text::select('id', 'event_content', 'zh_hans', 'zh_hant')
                  ->where('id', '=', 2)
                  ->first();
         $im_language = Caclients::select('id', 'im_language_preference')->where('group_id', '=', $group_id)->first();
            $im_language_preference = $im_language->im_language_preference;
            if($im_language_preference == "zh-Hans"){
              if(isset($event_clntleft->zh_hans)){ $event_leftclnt_msgs = $event_clntleft->zh_hans; }
            } elseif ($im_language_preference == "zh-Hant"){
                  if(isset($event_clntleft->zh_hant)){ $event_leftclnt_msgs = $event_clntleft->zh_hant; }
            }else{
                   $event_leftclnt_msgs = $event_clntleft->event_content; 
            }
            $leftclnt_hpno = $leftclient_hpno;
            $left_event_msg = str_replace("+111111",$leftclnt_hpno,$event_leftclnt_msgs);
            //$fincontent = preg_replace('#[ -]+#', '_', $up_event_msg);
            $lft_msg_data = array(
            'msg_content' => $left_event_msg,
            'reference_id' => $idforupdate,
            'type' => 'group',
            'created_at' => date('Y-m-d H:i:s') 
             );
         $lastemsgid= DB::table('event_message')->insertGetId($lft_msg_data);
         // insert into "requst" table
         $msg_requests = array(
            'type' => "send_message",
            'vm_id' => NULL,
            'reference_id' => $lastemsgid,
            'agreed_im' => "Whatsapp",
            'status' => 0,
            'counter' => 0,
            'created_at' => date('Y-m-d H:i:s') 
         );
         Requests::insert($msg_requests);
         */
         
         }
      } else {
         return true;
      }
       
   }
   
   /**
     * Update Client/CA Changed number into respective tables
     *
     * @return Response
     */
    public static function upd_usr_cngno_st($group_id, $user_type, $user_name, $user_id, $updated_no, $pre_no, $phone_time) {
        // fetch event type message 
        $event_type_mess = Event_message_text::select('id', 'event_content', 'zh_hans', 'zh_hant')
                ->where('event_type', '=', 'ca or client mobile number update')
                ->first();
         if ($user_type == 'CA') {
            Cas::where('id', '=', $user_id)->update(['phone_no' => trim($updated_no)]);
            $CN_contact_detail_logg = array(
                'type' => $user_type,
                'name' => $user_name,
                'new_number' => trim($updated_no),
                'existing_number' => $pre_no,
                'reference_id' => $user_id,
                'status' => 1,
                'validation_comment' => $user_type . "-" . $user_name . " change no",
                'created_at' => date('Y-m-d H:i:s')
            );
            UpdateContact::insert($CN_contact_detail_logg);

            // get chat_group id
            $chat_grp_ides = Caclients::select('id', 'im_language_preference')
                    ->where('group_id', '=', $group_id)
                    ->first();
            
            // for chinese language
            
            if($chat_grp_ides->im_language_preference == "zh-Hans"){
                $event_type_msggg = $event_type_mess->zh_hans;
            } elseif ($chat_grp_ides->im_language_preference == "zh-Hant"){
                $event_type_msggg = $event_type_mess->zh_hant;
            }else{
                $event_type_msggg = $event_type_mess->event_content;
            }
            
            // for chinese language
            
            $firstt_event_msg = str_replace("+111111", $pre_no, $event_type_msggg);
            $up_event_msg = str_replace("+222222", trim($updated_no), $firstt_event_msg);

            if (isset($chat_grp_ides->id)) {
                $idforupdate = $chat_grp_ides->id;

                $CN_message_data = array(
                    'msg_content' => $up_event_msg,
                    'reference_id' => $idforupdate,
                    'type' => 'group',
                    'created_at' => date('Y-m-d H:i:s')
                );
                $lasteventmsgid = DB::table('event_message')->insertGetId($CN_message_data);

                // insert into "requst" table
                $msggen_requests = array(
                    'type' => "send_message",
                    'vm_id' => NULL,
                    'reference_id' => $lasteventmsgid,
                    'agreed_im' => "Whatsapp",
                    'related_group_id' => $idforupdate,
                    'status' => 0,
                    'counter' => 0,
                    'created_at' => date('Y-m-d H:i:s')
                );
                Requests::insert($msggen_requests);
            }
        } else {
            Clients::where('id', '=', $user_id)->update(['phone_no' => trim($updated_no)]);
            $CN_contact_detail_logg = array(
                'type' => $user_type,
                'name' => $user_name,
                'new_number' => trim($updated_no),
                'existing_number' => $pre_no,
                'reference_id' => $user_id,
                'status' => 1,
                'validation_comment' => $user_type . "-" . $user_name . " change no",
                'created_at' => date('Y-m-d H:i:s')
            );
            UpdateContact::insert($CN_contact_detail_logg);
            
            // get chat_group id
            $chat_grp_ides = Caclients::select('id', 'im_language_preference')
                    ->where('group_id', '=', $group_id)
                    ->first();
            // for chinese language
           
            if($chat_grp_ides->im_language_preference == "zh-Hans"){
                $event_type_msggg = $event_type_mess->zh_hans;
            } elseif ($chat_grp_ides->im_language_preference == "zh-Hant"){
                $event_type_msggg = $event_type_mess->zh_hant;
            }else{
                $event_type_msggg = $event_type_mess->event_content;
            }
            
            // for chinese language
            
            $firstt_event_msg = str_replace("+111111", $pre_no, $event_type_msggg);
            $up_event_msg = str_replace("+222222", trim($updated_no), $firstt_event_msg);


            if (isset($chat_grp_ides->id)) {
                $idforupdate = $chat_grp_ides->id;

                $CN_message_data = array(
                    'msg_content' => $up_event_msg,
                    'reference_id' => $idforupdate,
                    'type' => 'group',
                    'created_at' => date('Y-m-d H:i:s')
                );
                $lasteventmsgid = DB::table('event_message')->insertGetId($CN_message_data);

                // insert into "requst" table
                $msggen_requests = array(
                    'type' => "send_message",
                    'vm_id' => NULL,
                    'reference_id' => $lasteventmsgid,
                    'agreed_im' => "Whatsapp",
                    //'related_group_id' => $idforupdate,
                    'status' => 0,
                    'counter' => 0,
                    'created_at' => date('Y-m-d H:i:s')
                );
                Requests::insert($msggen_requests);
            }
        }
    }

    /**
    * Changed group name notification at header.
    *
    * @return Response
    */
   public static function CGN_header_alert() {
     $CGNHA_dats = array();
     $CGNHA_Details = Chat_group_logs::select('id', 'updated_grpname', 'old_grpname', 'updated_by')->where('action_status', '=', 0)->get();
     foreach ($CGNHA_Details as $CGNHA_Detail) {
        $CGNHA_dataa['id'] = $CGNHA_Detail['id'];
        $CGNHA_dataa['updated_grpname'] = $CGNHA_Detail['updated_grpname'];
        $CGNHA_dataa['old_grpname'] = $CGNHA_Detail['old_grpname'];
        $CGNHA_dataa['updated_by'] = $CGNHA_Detail['updated_by'];
        
        
        //check if ops manager already view
         $grpgroupnameview = ReadedAlertLogs::select('id')
                 ->where('alert_category', '=', 'group_name_changed')
                 ->where('alert_message_id', '=', $CGNHA_dataa['id'])
                 ->where('read_by', '=', Auth::id())
                 ->count();
         if ($grpgroupnameview == 0) {
            $CGNHA_dats[] = $CGNHA_dataa;
         }
        
     }
     return $CGNHA_dats;
   }
   
   /**
    * Left Chat Group notification at header.
    *
    * @return Response
    */
   public static function LG_header_alert() {
     $LGHA_dats = array();
     $LGHA_Details = Chat_group_member_logs::select('id', 'group_id', 'user_name', 'action')
             ->where('action_status', '=', 0)
             ->where('action', '=', 'left_group')
             ->get();
     foreach ($LGHA_Details as $LGHA_Detail) {
         $LGHA_dataa['id'] = $LGHA_Detail['id'];
         $LGHA_dataa['group_id'] = $LGHA_Detail['group_id'];
         $LGHA_infos = Whatsapp::select('grpname')
                  ->where('msg_to', '=', $LGHA_dataa['group_id'])
                  ->orderBy('whatsapp_key', 'DESC')
                  ->first();
         $grpname = $LGHA_infos->grpname;
         if (strpos($grpname, '|::|') !== false) {
            $LGHA_dataa['grpname'] = substr($grpname, 0, strpos($grpname, '|::|'));
         } else {
            $LGHA_dataa['grpname'] = $grpname;
         }
         $LGHA_dataa['user_name'] = $LGHA_Detail['user_name'];
         $LGHA_dataa['action'] = $LGHA_Detail['action'];
         
         //check if ops manager already view
         $leftgrpview = ReadedAlertLogs::select('id')
                 ->where('alert_category', '=', 'ca_client_left_group')
                 ->where('alert_message_id', '=', $LGHA_dataa['id'])
                 ->where('read_by', '=', Auth::id())
                 ->count();
         if ($leftgrpview == 0) {
            $LGHA_dats[] = $LGHA_dataa;
         }
         
         
     }
     return $LGHA_dats;
   }
   
   /**
    * Change Number Chat Group notification at header.
    *
    * @return Response
    */
   public static function CN_header_alert() {
     $LGHA_dats = array();
     $LGHA_dat = Chat_group_member_logs::select('id', 'group_id', 'user_name', 'action')
             ->where('action_status', '=', 0)
             ->where('action', '=', 'change_phone_number')
             ->get();
     
     foreach ($LGHA_dat as $LGHA_da) {
         $change_Phonedataa['id'] = $LGHA_da->id;
         //check if ops manager already view
         $changephoneview = ReadedAlertLogs::select('id')
                 ->where('alert_category', '=', 'phone_number_changed')
                 ->where('alert_message_id', '=', $change_Phonedataa['id'])
                 ->where('read_by', '=', Auth::id())
                 ->count();
         if ($changephoneview == 0) {
            $LGHA_dats[] = $change_Phonedataa;
         }
         $change_Phonedataa =array();
      }
     
     return $LGHA_dats;
   }
   
   /**
    * Update phone number by Ops Manager notification at header.
    *
    * @return Response
    */
   public static function UpdatePhone_header_alert() {
     $Update_Phone_dats = array();
     $UP_Phone_Details = UpdateContact::select('id')
             ->where('status', '=', 9)
             ->get();
      foreach ($UP_Phone_Details as $UP_Phone_Detail) {
         $Up_Phonedataa['id'] = $UP_Phone_Detail->id;
         //check if ops manager already view
         $checkphupdateview = ReadedAlertLogs::select('id')
                 ->where('alert_category', '=', 'phone_number_update_request')
                 ->where('alert_message_id', '=', $Up_Phonedataa['id'])
                 ->where('read_by', '=', Auth::id())
                 ->count();
         if ($checkphupdateview == 0) {
            $Update_Phone_dats[] = $Up_Phonedataa;
         }
         $Up_Phonedataa =array();
      }

     return $Update_Phone_dats;
   }
   
   /**
    * Add new CA notification at header.
    *
    * @return Response
    */
   public static function Addca_header_alert() {
     $add_ca_dats_Details = array();
     $add_ca_dats_Detail = CaValidation::select()
                 ->where('status', '=', 0)
                 ->get();
     
      foreach ($add_ca_dats_Detail as $add_ca_dats_Detai) {
         $add_cadataa['id'] = $add_ca_dats_Detai->id;
         //check if ops manager already view
         $checkaddcaview = ReadedAlertLogs::select('id')
                 ->where('alert_category', '=', 'add_new_ca_client')
                 ->where('alert_message_id', '=', $add_cadataa['id'])
                 ->where('read_by', '=', Auth::id())
                 ->count();
         if ($checkaddcaview == 0) {
            $add_ca_dats_Details[] = $add_cadataa;
         }
         $add_cadataa =array();
      }
     
     return $add_ca_dats_Details;
   }
   
   /**
    * Add new Client notification at header.
    *
    * @return Response
    */
   public static function Addclient_header_alert() {
     $add_client_dats_Details = array();
     $add_client_dats_Detail = ClientValidation::select()
                 ->where('status', '=', 0)
                 ->get();
     foreach ($add_client_dats_Detail as $add_client_dats_Detai) {
         $add_clientdataa['id'] = $add_client_dats_Detai->id;
         //check if ops manager already view
         $checkaddclientview = ReadedAlertLogs::select('id')
                 ->where('alert_category', '=', 'add_new_ca_client')
                 ->where('alert_message_id', '=', $add_clientdataa['id'])
                 ->where('read_by', '=', Auth::id())
                 ->count();
         if ($checkaddclientview == 0) {
            $add_client_dats_Details[] = $add_clientdataa;
         }
         $add_clientdataa =array();
      }
     return $add_client_dats_Details;
   }
   
   /**
    * Offboarding CA/Client notification at header.
    *
    * @return Response
    */
   public static function offboard_header_alert() {
     $offboard_dats_Details = array();
     $offboard_dats_Detail = OffBoarding::select()
                 ->where('status', '=', 9)
                 ->get();
      
      foreach ($offboard_dats_Detail as $offboard_dats_Detai) {
         $offboard_dataa['id'] = $offboard_dats_Detai->id;
         //check if ops manager already view
         $checkoffboardview = ReadedAlertLogs::select('id')
                 ->where('alert_category', '=', 'offboard_ca_client')
                 ->where('alert_message_id', '=', $offboard_dataa['id'])
                 ->where('read_by', '=', Auth::id())
                 ->count();
         if ($checkoffboardview == 0) {
            $offboard_dats_Details[] = $offboard_dataa;
         }
         $offboard_dataa =array();
      }
     
     return $offboard_dats_Details;
   }
   
   /**
    * Onboarding CA notification at header.
    *
    * @return Response
    */
   public static function onboard_header_alert() {
     $onboard_dats_Details = array();
     $onboard_dats_Detail = OnBoarding::select()
                 ->where('status', '=', 9)
                 ->get();
     
     foreach ($onboard_dats_Detail as $onboard_dats_Detai) {
         $onboard_dataa['id'] = $onboard_dats_Detai->id;
         //check if ops manager already view
         $checkonboardview = ReadedAlertLogs::select('id')
                 ->where('alert_category', '=', 'onboard_ca')
                 ->where('alert_message_id', '=', $onboard_dataa['id'])
                 ->where('read_by', '=', Auth::id())
                 ->count();
         if ($checkonboardview == 0) {
            $onboard_dats_Details[] = $onboard_dataa;
         }
         $onboard_dataa =array();
      }
     
     return $onboard_dats_Details;
   }
   
   /**
    * CA Replacement notification at header.
    *
    * @return Response
    */
   public static function RE_header_alert() {
     $RE_dats_Details = array();
     $RE_dats_Detail = CaReplacement::select()
                 ->where('status', '=', 9)
                 ->get();
     
     foreach ($RE_dats_Detail as $RE_dats_Detai) {
         $replaceca_dataa['id'] = $RE_dats_Detai->id;
         //check if ops manager already view
         $checkonboardview = ReadedAlertLogs::select('id')
                 ->where('alert_category', '=', 'ca_replacement')
                 ->where('alert_message_id', '=', $replaceca_dataa['id'])
                 ->where('read_by', '=', Auth::id())
                 ->count();
         if ($checkonboardview == 0) {
            $RE_dats_Details[] = $replaceca_dataa;
         }
         $replaceca_dataa =array();
      }
     
     return $RE_dats_Details;
   }
   
   /**
    * Group Inactive notification at header.
    *
    * @return Response
    */
   public static function GRP_inactive_alert() {
      $grp_ina_Details = array();
      $todaydataa = DB::table('group_idle')
               ->select('group_id', DB::raw('MAX(phone_time) as phometime'))
               ->groupBy('group_id')
               ->where('action_status', '=', 0)
               ->orderBy('group_id', 'DESC')
               ->get();
      foreach ($todaydataa as $todaydata) {
         $Grp_Inactivedataa['group_id'] = $todaydata->group_id;
         $grp_ina_Detail = GroupIdle::select('id')
              ->where('group_id', '=', $Grp_Inactivedataa['group_id'])
              ->orderBy('id', 'DESC')
              ->first();
         $inactive_dataa['id'] = $grp_ina_Detail->id;
         //check if ops manager already view
         $checkgrpinactivedview = ReadedAlertLogs::select('id')
                 ->where('alert_category', '=', 'group_inactive')
                 ->where('alert_message_id', '=', $inactive_dataa['id'])
                 ->where('read_by', '=', Auth::id())
                 ->count();
         if ($checkgrpinactivedview == 0) {
            $grp_ina_Details[] = $inactive_dataa;
         }
         $inactive_dataa =array();
      }
      return $grp_ina_Details;
   }
   /**
    * Newly created groups header.
    *
    * @return Response
    */
   public static function newGroupsCount() {
        
        $newGroupsDetails = Caclients::select("id")
                ->where('status', '=', 1)
                ->where('is_new', null)
                ->orderBy('id', 'DESC')
                ->get();
        $ngcount = 0;
        foreach ($newGroupsDetails as $newGroups) {
            $newGroupdataa['id'] = $newGroups->id;
            $checkphupdateview = ReadedAlertLogs::select('id')
                    ->where('alert_category', '=', 'new_group_creation_read_request')
                    ->where('alert_message_id', '=', $newGroupdataa['id'])
                    ->where('read_by', '=', Auth::id())
                    ->count();
            if ($checkphupdateview == 0) {
                $ngcount++;
            }
        } 
        return $ngcount;
   }
   /**
    * Manually detected groups header.
    *
    * @return Response
    */
   public static function manuallyDetectedCount() {
        
        $manualGroupsDetails = newGroupId::select("id","group_id")
                ->where('status', '=', 0)
                ->orderBy('id', 'DESC')
                ->get();
        $ngcount = 0;
        foreach ($manualGroupsDetails as $manualGroups) {
            $memcount = groupMembers::Where("group_id", $manualGroups->group_id )->count();
            if($memcount > 0){
                $manualGroupdataa['id'] = $manualGroups->id;
                $checkphupdateview = ReadedAlertLogs::select('id')
                        ->where('alert_category', '=', 'manuallydetected_group_read_request')
                        ->where('alert_message_id', '=', $manualGroupdataa['id'])
                        ->where('read_by', '=', Auth::id())
                        ->count();
                if ($checkphupdateview == 0) {
                    $ngcount++;
                }
            }
        }
        return $ngcount;
   }
   /**
    * Return timestampw ith timezone    
    */
    public static function getTime(){
        $time =  'Date &amp; Time: '.date('d/m/Y H:i:s (P e)');
        return $time;
    }
    /*
     * Function notifyAttachment to save notification of an attachment
     * @param $group like 919837482569-1509348439@g.us
     * @param $imtype Whatsapp/WeChat
     * 
     * @return void
     */
    public static function notifyAttachment($group,$imtype,$attachmentType,$event_type_value = "client-ca use attachment", $exit_group_id = 0, $message_related_with = NULL){
        // echo $group. " " .$msgtype. " " .$imtype;
//        \Log::info("Im TYPe IIIIIIIIIIIIIIIIIIIIIIII" .$imtype);
        // get the id of the group from group_id ...@g.us
        \Log::info("notifyAttachment---");
//        \Log::info($group);
        $gdata = Caclients::Where("group_id",$group)
                ->first(array("id","im_language_preference","vm_id","attached_vm"));
        $group_id = isset($gdata["id"]) ? $gdata["id"] : "";
        $im_language_preference = isset($gdata["im_language_preference"]) ? $gdata["im_language_preference"] : "en";
        $groupVm = isset($gdata->vm_id) ? $gdata->vm_id : '';
        $attached_vm = isset($gdata->attached_vm) ? $gdata->attached_vm : '';
        
//          \Log::info("I - m " .$imtype. ' - group '.$group. ' - group_id '.$group_id. ' - exit group_id '.$exit_group_id);
        $msg_reference_type = 'group';
        $msg_related_with = NULL;
        if($exit_group_id > 0){ 
            $group_id = $exit_group_id;
            $msg_reference_type = $msg_related_with = 'exit_group';
        }
        
        if($event_type_value == "disclaimer-message"){
            $msg_related_with = $event_type_value;
        }
        
        if($group_id != "" ){ // proceed only 
            // get the event content from event_message_text
            $eventData = Event_message_text::Where("event_type",$event_type_value)->first(array("event_content","zh_hans","zh_hant"));
            //$event_content = isset($eventData["event_content"]) ? $eventData["event_content"] : "";
            
            // for chinese language
            
            if($im_language_preference == "zh-Hans"){ // simple chinese
                $event_content = isset($eventData["zh_hans"]) ? $eventData["zh_hans"] : "";
            } elseif ($im_language_preference == "zh-Hant"){ // traditional chinese
                $event_content = isset($eventData["zh_hant"]) ? $eventData["zh_hant"] : "";
            }else{
                $event_content = isset($eventData["event_content"]) ? $eventData["event_content"] : "";
            }
            
            // for chinese language
            
            // to put data in event_message

            $input = array(
                'vm_id' => $groupVm,
                'attached_vm' => $attached_vm,
                'msg_content' => $event_content,
                'reference_id' => $group_id,
                'type' => $msg_reference_type,
                'status' => 9
            );
            $new = new Event_message($input);
            $new->save();
            $event_message_id = $new->id;

            // to put data in request_ops
            $inputOps = array(
                'type'            => 'send_message',
                'vm_id' => $groupVm,
                'attached_vm' => $attached_vm,
                'reference_id'	=> $event_message_id,
                'agreed_im'       => $imtype,
                'status' 		=> 0 ,
                'related_group_id' => $group_id,
                'msg_related_with' => $msg_related_with,
                'counter' => 0            
            );
            $newOps = new RequestOps($inputOps);
            $newOps->save();
        }
        
    }
    /*
     * Function notifyAttachment to save notification of an attachment
     * @param $group like 919837482569-1509348439@g.us
     * @param $imtype Whatsapp/WeChat
     * 
     * @return void
     */
//    public static function notifyByGroupName($group,$imtype,$attachmentType,$event_type_value = "client-ca use attachment"){
//        
//    }
    /**
     * Send HTML for Media
     * @param $contentType
     * @param $media_type_id
     * @param $device_id
     * @param $maxAllowedSize
     * @param $media_name
     * @param $eod_path
     * @param $timeToday
     * @param $part
     * @param $subject
     * @param $groupname
     * @param $attch
     */
    public static function getMedia($contentType, $media_type_id, $device_id, $media_name, $eod_path = "", $maxAllowedSize, $year, $month, $day, $msgid = "") {
        
        try {
            
            // Code that may throw an Exception or Error.
            $mpth = config('constants.path');
            $media_name = urldecode($media_name);

            $contentList = array(
                // type => folder name
                'whatsapp' => 'whatsapp',
                'wechat' => 'wechat',
                'im_line' => 'im_line'
            );
            
            if($contentType == 'whatsapp'){
                $mediatype = array(
                    // type => folder name
                    '1' => 'image',
                    '2' => 'audio',
                    '3' => 'video',
                    '4' => 'contact',
                    '5' => 'location',
                    '8' => 'voice',
                    '9' => 'document',
                    '10' => 'video_call',
                    '13' => 'gif',
                    '20' => 'sticker'
                ); 
            } else {
                
                // to get medianame irrespective of Username and ::
                
                $expArr = explode("::",$media_name);
                $media_name = isset($expArr[1]) ? trim($expArr[1]) : $media_name;   
                $mediatype = array(
                    // type => folder name
                    '3' => 'image',
                    '34' => 'audio',
                    '43' => 'video',
                    '42' => 'contact',
                    '48' => 'location',
                    '8' => 'voice',
                    '49' => 'document',
                    '62' => 'sight',
                    '64' => 'voice_call'
                );
            }
            $media = $mediatype[$media_type_id];
            
            $result = [];
            //$result['totalsize'] = $totalSize;
            
            //if ($media_type_id != "split") {
//                $path = asset('/uploads') . '/' . $device_id . '/' . $contentType . '/' . $mediatype[$media_type_id] . '/' . $media_name;
//                $org_path = $mpth['upload_path'] . '/' .$year . '/'. $month . '/'.  $day.'/'. 'vms/' . $device_id . '/' . $contentType . '/' . $mediatype[$media_type_id] . '/' . $media_name;
//                
                // added for exception any
//                if(!is_file($org_path) && $msgid != ""){
                    
                    $fsq =  Filesplitqueue::Where("message_id",$msgid)
                            ->first(array("token","path"));   
//                  $fsq =  Filesplitqueue::Where("path","LIKE","%/".$media_name)
//                            ->first(array("token","path"));
                    $mediaPath = isset($fsq["token"]) ? url("/")."/uploads/".$fsq["token"] : "";
                    
                    return $mediaPath;
//                }
                
                // $new_path =  Filesplitqueue::Where("path",$path)->pluck("token");
//              print_r($res);
                //$token = isset($res[0]) ? $res[0] : "";
                //$str = str_replace(base_path()."/", "", $file); $media_name

//                $res =  Filesplitqueue::Where('path', 'like', '%/' . $media_name)->pluck("path");
//                $new_path = isset($res[0]) ? $res[0] : "";
//                $new_path = base_path()."/".$new_path;
//                $str = str_replace(base_path()."/", "", $file);
            //}
            if($contentType == 'whatsapp'){
             if ($media_type_id == 3) {
                $content = $org_path;
             } elseif ($media_type_id == 34) {
                $content = $org_path;
             } elseif ( $media_type_id == 43) {
                $content = $org_path;
             } elseif ($media_type_id == 49) {
                $content = $org_path;
             } elseif ($media_type_id == "split") {
                $org_path = $media_name; // set path directly
                $content = $org_path;
             } else {
                $content = 'N/A';
             }
            } else {
             if ($media_type_id == 1) {
                $content = $org_path;
             } elseif ($media_type_id == 2) {
                $content = $org_path;
             } elseif ($media_type_id == 3 || $media_type_id == 13) {
                $content = $org_path;
             } elseif ($media_type_id == 9) {
                $content = $org_path;
             } elseif ($media_type_id == "split") {
                $org_path = $media_name; // set path directly
                $content = $org_path;
             } else {
                $content = 'N/A';
             }
            }
            //if ($org_path && file_exists($org_path)) {
            if ($org_path && is_file($org_path)) {    
            
//                $downloadPath = self::mk_directory(base_path($eod_path), 0777, true);
//                if (!self::fileDownload($org_path, $downloadPath)) {
//                    return false;
//                }
                $mediasize = self::getFileSize($org_path);
                if($mediasize > $maxAllowedSize){
                    $result['totalsize'] = $mediasize;
                    $result['status'] = 'sizeexceed';
                    $result['media'] = $media;
                    $result['attach'] = ' (Not Attached. Size is bigger than allowed)';
                    $result['path'] = $org_path;
                    $result['media_name'] = $media_name;
                }else{
                    $result['status'] = 'found';
                    $result['totalsize'] = $mediasize;
                    $result['attach'] = ' (File size is )'.$mediasize;
                    $result['path'] = $org_path;
                    $result['media_name'] = $media_name;
                }

            } else {
                
                //$imgsize = self::getFileSize($org_path);
                //$result['totalsize'] = $totalSize;
                $result['status'] = 'not_found';
                $result['attach'] = ' (Not Found on server)';
                $result['path'] = $org_path;
                $result['media_name'] = $media_name;
            }

            return $result;
        } catch (Throwable $t) {
            // Executed only in PHP 7, will not match in PHP 5.x
            return $t;
        } catch (Exception $e) {
            // Executed only in PHP 5.x, will not be reached in PHP 7
            return $e;
        }
    }
    /**
     * Send HTML for Media
     * @param $media_name
     * @param $media_type
     */
    public static function getMediaOld($to_name, $to_email, $contentType, $media_type_id, $device_id, $media_name, $totalSize, $maxAllowedSize, $attachments, $eod_path, $timeToday, $part, $subject, $groupname,$attch) {
        try {
            
            // Code that may throw an Exception or Error.
            $mpth = config('constants.path');
            $media_name = urldecode($media_name);

            $contentList = array(
                // type => folder name
                'whatsapp' => 'whatsapp',
                'wechat' => 'wechat',
                'im_line' => 'im_line'
            );
            if($contentType == 'whatsapp'){
             $mediatype = array(
                // type => folder name
                '1' => 'image',
                '2' => 'audio',
                '3' => 'video',
                '4' => 'contact',
                '5' => 'location',
                '8' => 'voice',
                '9' => 'document',
                '10' => 'video_call',
                '13' => 'gif'
             ); 
            } else {
                $mediatype = array(
                // type => folder name
                '3' => 'image',
                '34' => 'audio',
                '43' => 'video',
                '42' => 'contact',
                '48' => 'location',
                '8' => 'voice',
                '49' => 'document',
                '62' => 'sight',
                '64' => 'voice_call'
            );
            }

            $result = [];
            $result['totalsize'] = $totalSize;
            
            if ($media_type_id != "split") {
                $path = asset('/uploads') . '/' . $device_id . '/' . $contentType . '/' . $mediatype[$media_type_id] . '/' . $media_name;
                $org_path = $mpth['upload_path'] . '/' . $device_id . '/' . $contentType . '/' . $mediatype[$media_type_id] . '/' . $media_name;
            }
            if($contentType == 'whatsapp'){
             if ($media_type_id == 1) {
                $content = $org_path;
             } elseif ($media_type_id == 2) {
                $content = $org_path;
             } elseif ($media_type_id == 3 || $media_type_id == 13) {
                $content = $org_path;
             } elseif ($media_type_id == 9) {
                $content = $org_path;
             } else {
                $content = 'N/A';
             }
            } else {
             if ($media_type_id == 3) {
                $content = $org_path;
             } elseif ($media_type_id == 34) {
                $content = $org_path;
             } elseif ($media_type_id == 43) {
                $content = $org_path;
             } elseif ($media_type_id == 49) {
                $content = $org_path;
             } else {
                $content = 'N/A';
             }    
            }
            //echo '--('.$org_path.')--';
            if ($org_path && file_exists($org_path)) {
                $downloadPath = self::mk_directory(base_path($eod_path), 0777, true);
                if (!self::fileDownload($org_path, $downloadPath)) {
                    return false;
                }
                $imgsize = self::getFileSize($org_path);
                // attachment path
                $attachmentpath = $org_path;
                $mediaSize = $imgsize;
                //$ttsize = $totalSize + $mediaSize;
                if ($totalSize + $mediaSize >= $maxAllowedSize&&$imgsize<$maxAllowedSize) {
                    
                    //$subject = '';
                    $textStr = [];
                    $textStr['grpname'] = $groupname;
                    $textStr['icrmpid'] = self::getIcrmPid($groupname);
                    $part = ++$part;
                    //echo $part;
                    $partmsg = '';
                    if ($part > 0) {
                        $partmsg = 'Part ' . $part . ' ';
                    }
                    $part = ++$part;
                    //print_r($attch);
                    $textStr['attached_file'] = implode(', ',$attch);
                    self::sendMail($to_name, $to_email, $attachments, $subject . ' ' . $partmsg, $textStr, $groupname, $timeToday, $part);
                    $result['totalsize'] = '';
                    $result['attachments'] = [];
                    $result['part'] = $part;
                    $result['not_attached']= '';
                    $attch[] = [];
                    $result['attchfile'] = '';
                } else {
                    if($imgsize<$maxAllowedSize){
                        if ($attachmentpath) {
                            $attachments[] = $attachmentpath;
                        }
                        $totalSize = $totalSize + $mediaSize;
                        $result['totalsize'] = $totalSize;
                        $result['attachments'] = $attachments;
                        $result['part'] = $part;
                        $result['attach'] = ' (Attached)';
                        $attch[] = $media_name;
                        $result['attchfile'] = $attch;
                       // print_r($result['attchfile']);
                    } else {
                        
                        /* I will get the split files list from data base
                         * Get file name and match filename from db to get its parts
                         * Associate its parts to the mail
                         * If no split part is found in the db make $is_splitable = 0
                         * 
                        */
                        // when file size > totalsize
                        //$file = 'x.zip';
                        $times = explode('-', date("Y-m-d H:i:s")); // test garbage set
                        $file_path = $path = 'EOD/' . $times[0] . '/' . $times[1] . '/' . $times[2] . '/photos';
                        $fileProcess = self::splitFileProcess($file_path, $file);
                        $is_splitable = isset($fileProcess['is_splitable']) ? $fileProcess[""] : 0;
                        //$is_splitable = 1; // check if file is splitable
                        if($is_splitable == 1){ // if file is splitable
                            
                            $result['is_splitable'] = $fileProcess['is_splitable']; // file is splitable
                            $result['files'] = $fileProcess['files']; // file is splitable
                            //$result['totalsize'] = $totalSize;
                            //$result['attachments'] = $attachments;
                            //$result['part'] = $part;
                            //$result['attach'] = ' (Not Attached. Size is bigger than allowed)';
                            //$result['not_attached'] = $result['attach'];
                            //$result['attchfile'] = $attch; 
                            
                            // get the parts of the media
                            // store the parts in the db
                            // mail the parts as separate mail
                        
                        // when file size > totalsize    
                        } else { // if file is not splitable
                        
                            $totalSize = $totalSize;
                            $result['is_splitable'] = $is_splitable;
                            $result['totalsize'] = $totalSize;
                            $result['attachments'] = $attachments;
                            $result['part'] = $part;
                            $result['attach'] = ' (Not Attached. Size is bigger than allowed)';
                            $result['not_attached'] = $result['attach'];
                            $result['attchfile'] = $attch; 
                            
                        }
                        
                    }
                }
                //$result['path'] = $org_path;
            } else {
                $result['totalsize'] = $totalSize;
                $result['attachments'] = $attachments;
                $result['attach'] = ' (Not Found on server)';
                $result['path'] = $org_path;
                $result['part'] = $part;
                $result['not_attached'] = $result['attach'];
            }

            return $result;
        } catch (Throwable $t) {
            // Executed only in PHP 7, will not match in PHP 5.x
            return $t;
        } catch (Exception $e) {
            // Executed only in PHP 5.x, will not be reached in PHP 7
            return $e;
        }
    }
     /**
     * Return path, name of the file
     *
     * @param $file
     * 
     * @return array
     */
    public static function fileDetails($file) {
        
        $info = new \SplFileInfo($file);
        $part = $info->getFilename();
        
        $str = str_replace(base_path()."/", "", $file);
        $path = str_replace($part, "", $str);
        $path = rtrim($path, "/");
        $data = array(
            "name" => $part,
            "path" => $path,
        );
        return $data;
        
    }

    /*
     * Function to save exceptions when any file is missed to send
     * @param array $filesArr
     * @param string $originalFile
     * @return
     */

    public static function FilePartsSave($filesArr,$originalFile) {

        $originalDetails = self::fileDetails($originalFile);
        $originalname = isset($originalDetails["name"]) ? $originalDetails["name"] : "";
        $originalpath = isset($originalDetails["path"]) ? $originalDetails["path"] : "";
        
        $inputs = [];
        foreach ($filesArr as $key => $value) {
            $fileDetails = self::fileDetails($value);
            $part = isset($fileDetails["name"]) ? $fileDetails["name"] : "";
            $path = isset($fileDetails["path"]) ? $fileDetails["path"] : "";
            if($part != ""){
                $input = [];
                $input["original"] = $originalname;
                $input["originalpath"] = $originalpath;
                $input["part"] = $part;
                $input["path"] = $path;
                $input["created_at"] = date("Y-m-d H:i:s");
                $input["updated_at"] = date("Y-m-d H:i:s");
                $inputs[] = $input;
            }
        }
        if(count($inputs) > 0){
            FilePartsModel::insert($inputs); 
        }
        unset($inputs);
        return true;
        
    }

    /*
     * Function to generate split videos if file is large
     * @param $file
     * @param $extension
     * @param $media = document/video/gif/...
     * 
     * @return true
     */

    public static function splitVideoGenerate($file, $extension, $row = "") {

        if (file_exists($file)) {
            
            $mconfig = config('constants.mail');
            $maxAllowedSize = $maxAllowedSizeGlobal = $mconfig['max_allowed_email_size'] * 1000 * 1000;
            $split_parts_revision = $mconfig['split_parts_revision'];
            
            $fileSize = Self::getFileSize($file);
            if ($fileSize >= $maxAllowedSize) { // echo "start";
                $originalDetails = Self::fileDetails($file);
                $fileName = isset($originalDetails["name"]) ? $originalDetails["name"] : "";
                $fileAppPath = isset($originalDetails["path"]) ? $originalDetails["path"] : "";
                
                $ret = "failed_process";
                
                $count = FilePartsModel::where("original", $fileName)->where("originalpath", $fileAppPath)->count();
                if ($count == 0) {
                    
                    $ffmpegPath = base_path() ."/app/Libraries/ffmpeg/";

                    list($width, $height, $type, $attr) = getimagesize($file);

                    // added to prevent spaces in the name like 02 - Luv u Zindaggi - DownloadMing.SE-1.mp3
                    $mainFile =  str_replace(" ", "\ ", $file);
// avconv method 
//                    $cmd = "avprobe " . $mainFile . " -show_format_entry duration";
//                    $duration = shell_exec($cmd);

                    
                    $cmd= $ffmpegPath."ffprobe -i ".$mainFile." -show_format | grep duration";
                    $duration_text = shell_exec($cmd);
                    $duration = str_replace("duration=", " ", $duration_text);

                    if(ceil($duration) > 0){

                        $partsFloat = $fileSize/$maxAllowedSize;
//                        
//                       echo ' -- ' .$maxAllowedSize. ' -- '.$fileSize. ' -- ';
                        $parts = ceil($partsFloat);
//                        
                        $k = 0;
                        while ($k < 100) {
                            $k++;

                            // set temp dir
                            $temp = $row.$k .mt_rand(10,100). md5(uniqid(mt_rand(), true));
                            $filePath = base_path() . "/" . $fileAppPath;
                            $new_path_split = $filePath . "/splits";
                            $new_path_temp = "";
                            $new_path_temp = $filePath . "/splits/" . $temp;
                            if (!is_dir($new_path_split)) {
                                mkdir($new_path_split, 0777, true);
                            }
                            if (!is_dir($new_path_temp)) {
                                mkdir($new_path_temp, 0777, true);
                            }
                            shell_exec('chmod 777 -R ' . $new_path_temp);
                            
                            $interval = ceil($duration / $parts);

                            $startSec = 0;
                            $tempInterval = 0;
                            for ($j = 0; $j < $parts; $j++) {

                                $startSec = $startSec + $tempInterval;
                                $endSec = $startSec + $interval;
                                $tempInterval = $interval;

                                $start = gmdate('H:i:s', $startSec);
                                $end = gmdate('H:i:s', $interval);

                                $newFile =  $new_path_temp."/".str_replace(" ", "\ ", str_replace('.'.$extension, '', $fileName))."_part_" . ($j + 1) . "." .$extension;

                                // avconv
                                //$cmd = "/usr/bin/avconv -i " . $mainFile . " -ss " . $start . " -t " . $end . " -codec copy " . $newFile . " 2>&1";
                                
                                $cmd = $ffmpegPath."ffmpeg -i " . $mainFile . " -ss " . $start . " -t " . $end . " -c copy " . $newFile . " 2>&1";
                               	$output = shell_exec($cmd);

                                //var_dump($output);
                                //\Log::info($output);

                            }
                            // set permission
                            shell_exec('chmod 777 -R ' . $new_path_temp);
                            $is_continue = "false";

                            if ($k < 100) {
                                // check images in temp dir
                                foreach (glob($new_path_temp . "/*") as $file_name) {
                                    $curFileSize = Self::getFileSize($file_name);
                                    if ($curFileSize > $maxAllowedSizeGlobal) { //  echo 'yes';
//                                    echo "<br> curFileSize    " . $curFileSize . "<br> maxAllowedSize " . $maxAllowedSize.' '.$file_name;
                                        $is_continue = "true"; // set counter to repeat the loop
                                        shell_exec("rm -r " . $new_path_temp);
                                        break;
                                    }
                                }
                            }
                            // again twice the part
                            $parts = $parts * $split_parts_revision;// die;
                            // if file is splitted at 1/100 part or all the image size < than $maxAllowedSize Break;
                            if ($is_continue == "false") {
                                $filesArr = [];
                                foreach (glob($new_path_temp . "/*") as $file_name) {
                                    $filesArr[] = $file_name;
                                }
                                $saveFiles = Self::FilePartsSave($filesArr, $file); // save the files
                                if($saveFiles == true){ $ret = "file_processed"; }
                                unset($filesArr);
                                break;
                            }
                        }
                    }
                } else {
                    $ret = "split_exists";
                }
                return $ret;
            } else {
                return "smaller_file";
            }
        } else {
            return "not_found";
        }
    }
    /*
     * Function to generate split image for a large IMAGE
     * @param $file
     * @param $extension
     * @param $media document/video/audio/gif
     * 
     * @return true
     */
    public static function splitImageGenerate($file, $extension, $row = "") {

        if(file_exists($file)){

            $mconfig = config('constants.mail');
            $maxAllowedSize = $maxAllowedSizeGlobal = $mconfig['max_allowed_email_size'] * 1000 * 1000;
            $split_parts_revision = $mconfig['split_parts_revision'];
//          $maxAllowedSize = .5 * 1000 * 1000;
        
            $fileSize = self::getFileSize($file);
            if($fileSize >= $maxAllowedSize){
                
                $originalDetails = self::fileDetails($file);
                $fileName = isset($originalDetails["name"]) ? $originalDetails["name"] : "";
                $fileAppPath = isset($originalDetails["path"]) ? $originalDetails["path"] : "";
                
                $ret = "failed_process";
                // if chunck are not already present
                $count = FilePartsModel::where("original",$fileName)->where("originalpath",$fileAppPath)->count();
                if($count == 0){

                    list($width, $height, $type, $attr) = getimagesize($file);
                    
                    // replace space to prevent skip due to shell command
                    $mainFile =  str_replace(" ", "\ ", $file);  
                    
                    $partsFloat = $fileSize/$maxAllowedSize;
                    $parts = ceil($partsFloat);
                    $k = 0;
                    while($k < 100) { $k++;

                        // set temp dir
                        $temp = $row.$k .mt_rand(10,100). md5(uniqid(mt_rand(), true));
                        $filePath = base_path()."/".$fileAppPath;
                        $new_path_temp = $filePath."/splits/".$temp;
                        if (!is_dir($new_path_temp)) {
                            mkdir($new_path_temp, 0777, true);
                            
                        }
                        shell_exec('chmod 777 -R '.$new_path_temp);
                        // set image proportion
                        $partPercent = 100/$parts;

                        // replace space to prevent skip due to shell command
                                            
                        $newFile =  $new_path_temp."/".str_replace(" ", "\ ", str_replace('.'.$extension, '', $fileName))."_part%d.".$extension;

                        // split images
//                        shell_exec("convert ".$mainFile." -crop ".$partPercent."%x100% +repage ".$newFile);
                        $cmd = "convert ".$mainFile." -crop ".$partPercent."%x100% +repage ".$newFile;
                        $log = shell_exec($cmd);
                        //\Log::info(" Log while creating image split file " .$mainFile . " is ". $log);

                        // set permission
                        shell_exec('chmod 777 -R '.$new_path_temp);
                        $is_continue = "false";

                        if($k < 100){
                            // check images in temp dir
                            foreach (glob($new_path_temp . "/*") as $file_name) {
                                $fileSize = self::getFileSize($file_name);
                                if($fileSize > $maxAllowedSizeGlobal){
                                    $is_continue = "true"; // set counter to repeat the loop
                                    shell_exec("rm -r " . $new_path_temp);
                                    break;
                                }
                            }
                        }
                        // again twice the part
                        $parts = $parts*$split_parts_revision;
                        // if file is splitted at 1/100 part or all the image size < than $maxAllowedSize Break;
                        if($is_continue == "false"){
                            $filesArr = [];
                            foreach (glob($new_path_temp . "/*") as $file_name) {
                                $filesArr[] = $file_name;
                            }
                            $saveFiles = self::FilePartsSave($filesArr,$file); // save the files
                            if($saveFiles == true){ $ret = "file_processed";}
                            unset($filesArr);
                            break;
                        }
                    }
                } else {
                    $ret = "split_exists";
                }
                
                return $ret;
                
            } else {
                return "smaller_file";
            }
        } else {
            return "not_found";
        }
    }
    /*
     * Function to generate split pdf for a large PDF
     * @param $filePath
     * @param $media document/video/gif...
     * 
     * @return true
     */
    public static function splitPdfGenerate($file, $extension = "", $row = "") { // 726500 Bytes
//    $new_pdf = new FPDI(); die;
//                                try {
//
//            $new_pdf = new \FPDI();
//
//                                    //echo "Page ".$i." split into ".$newFilePath."<br />\n";
//                                } catch (Exception $e) {
//                                    echo "yes";
//                                    //echo 'Caught exception: ',  $e->getMessage(), "\n";
//                                } finally {
//                                    echo "yes d";
//                                    //echo 'Caught exception: ',  $e->getMessage(), "\n";
//                                }
//                                echo "yaa";
//        
//        die;
        if (file_exists($file)) {

            $mconfig = config('constants.mail');
            $maxAllowedSize = $maxAllowedSizeGlobal = $mconfig['max_allowed_email_size'] * 1000 * 1000;
            $split_parts_revision = $mconfig['split_parts_revision'];
            
            $fileSize = self::getFileSize($file);
            if($fileSize >= $maxAllowedSize){
                
                $ret = "file_processed";
                
                $originalDetails = self::fileDetails($file);
                $fileName = isset($originalDetails["name"]) ? $originalDetails["name"] : "";
                $fileAppPath = isset($originalDetails["path"]) ? $originalDetails["path"] : "";

                $count = FilePartsModel::where("original",$fileName)->where("originalpath",$fileAppPath)->count();
                if($count == 0){

                    // original file path
                    $filePath = base_path()."/".$fileAppPath;
                    $file = $filePath."/".$fileName;
            //        echo "<pre>";
                    //echo $file; die;
                    if(file_exists($file)){

                        //chmod($file,777);

                        $pdf = new FPDI();
                        $pagecount = $pdf->setSourceFile($file); // total no of pages
                        $fileSize = self::getFileSize($file); // total size of the pdf

                        $pagesInOneMB = $pagecount/$fileSize; // pages per MB
                        $pagesInOneChunk = $pagesInOneMB * $maxAllowedSize; // page per chunk

            //            echo "<br>==fileSize=======".$fileSize;

                       $k = 0;
                       // while pdf generates of chunk becomes one
                        while($pagesInOneChunk > 1) { $k++;
                        
                            // max pages in one chunk     
                            $pagesInOneChunk = $pagesInOneMB * $maxAllowedSize;

                             
                            // temp folder to store its chuncks
                            $temp = $row.$k .mt_rand(10,100). md5(uniqid(mt_rand(), true));
                            $new_path_temp = $filePath."/splits/".$temp;
                            if (!is_dir($new_path_temp)) {
                                mkdir($new_path_temp, 0777, true);
                                shell_exec('chmod 777 -R '.$new_path_temp);
                            }

                            $fileUrl = $filePath."/".$fileName;
                            // chmod($fileUrl, 0777);

                            // page no of the main pdf
                            $addPage = 0;
                            $filesArr = [];

                            // no of new pdfs that will be generated
                            $timesLoop = $pagecount/$pagesInOneChunk;
                            $timesLoopCeil = ceil($timesLoop); // no of pdf will be generated

                            // floor the value to lower integer
                            $pagesInOneChunkFloor = floor($pagesInOneChunk);

//                            echo  ' maxAllowedSize ' .$maxAllowedSize.
//                                    ' NoOfPdfs ' .$timesLoopCeil.
//                                    ' pagesInOneChunk ' .$pagesInOneChunkFloor.PHP_EOL;
                           
                            // set split chunk values
                            if($pagesInOneChunkFloor <= 1){
                                $pagesInOneChunkFloor = $pagesInOneChunk = 1;
                                $timesLoopCeil = $pagecount;
                                $chunkLoop = 1;
                            }

            //                echo "<br>==pagesInOneChunk=======".$pagesInOneChunk;
            //                echo "<br>==maxAllowedSize=======".$maxAllowedSize;
            //                echo "<br> timesLoopCeil ". $timesLoopCeil;

                            // $chunkLoop =  $pagecount - ();
                            // each pdf loop
                            for ($i = 1; $i <= $timesLoopCeil; $i++) {

                                // pdf generation
                                $new_pdf = new FPDI();
                                $chunkLoop = $pagesInOneChunkFloor;
                                if($i == $timesLoopCeil){ // echo "-Last-"; echo
                                    $chunkLoop = $pagecount - $addPage;
                                }

            //                    echo "<br> addPage chunkLoop ".$addPage. " ". $chunkLoop;
                                // each chunk loop
                                for ($j = 1; $j <= $chunkLoop; $j++) {++$addPage;
                                    if($addPage <= $pagecount){
                                        //$new_pdf->AddPage();
                                        $new_pdf->setSourceFile($fileUrl);
                                        //$new_pdf->useTemplate($new_pdf->importPage($addPage));

                                        $template = $new_pdf->importPage($addPage);
                                        $size = $new_pdf->getTemplateSize($template);
                                        
                                        $orientation = $size['orientation']; //$size['height'] > $size['width'] ? 'P' : 'L';
                                        $new_pdf->AddPage($orientation, array($size['width'], $size['height']));
                                        $new_pdf->useTemplate($template);

                                    }
                                }

                                try {

            //                        $info = new \SplFileInfo($fileUrl);
            //                        $filerealname = $info->getFilename();
                                    // new pdf generation
                                    $fileNameNew = basename(strtolower($fileUrl), ".pdf");
                                    $new_filename = str_replace('.pdf', '', $fileNameNew).'_part'.$i.".pdf";

                                    $newFilePath = $new_path_temp."/".$new_filename;
                                    $new_pdf->Output($newFilePath, "F");
                                    $filesArr[$i] = $newFilePath;

                                    //echo "Page ".$i." split into ".$newFilePath."<br />\n";
                                } catch (Exception $e) {
                                    //echo 'Caught exception: ',  $e->getMessage(), "\n";
                                }
                            }
                            shell_exec('chmod 777 -R '.$new_path_temp);
                            $is_continue = "false";
//                            echo ' pagesInOneChunk ' .$pagesInOneChunk.PHP_EOL;
                            
                            if($pagesInOneChunk > 1){
                                //break;
                            //}else{
                                //echo "<br>==pagesInOneChunk=======".$pagesInOneChunk;
                                // check if all pdf are in under the size limit
                                foreach($filesArr as $k => $v){
                                    if(file_exists($v)){
                                        $pdfSize = self::getFileSize($v);
                                        if($pdfSize > $maxAllowedSizeGlobal){ // $lc++; echo " --Exceed-- ".$lc;  if($lc == 3){ die; }
            //                                echo "<br>==Exceed=======".$maxAllowedSize. " ++ ".$pdfSize;
                                            $is_continue = "true"; // delete and recreate pdfs with new maxAllowed if any pdf size exceeds 
                                             // set counter to repeat the loop
                                            //chmod($new_path_temp,0777);
                                            //shell_exec('chmod 777 -R '.$new_path_temp);
//                                           echo  ' Exceed pdfSize ' .$pdfSize.PHP_EOL;
                                            shell_exec("rm -r " . $new_path_temp);
                                            break;
                                        }
                                    }
                                }
                            }
                            // reset maxallowed size
                            $maxAllowedSize = $maxAllowedSize/$split_parts_revision;
                            // if file is splitted one page pdf or all the image size < than $maxAllowedSize Break;
                            if($is_continue == "false"){
//                                die; // to test
                                $saveFiles = self::FilePartsSave($filesArr,$fileUrl); // save the files
                                unset($filesArr);
                                if($saveFiles == true){ $ret = "file_processed";}
            //                    echo "<br>==is_continue=======".$is_continue;
                                break;
                            }
                        }
                    }
                } else {
                    $ret = "split_exists";
                }
                
                return $ret;
                
            } else {
                return "smaller_file";
            }
                    
        } else {
            return "not_found";
        }
    }
     /**
     * When single file size > totalsize
     *
     * @param meadia path
     * 
     * @return Size
     */
    public static function splitFileProcess($path,$file) {
        
        $fileData = FilePartsModel::where("original",$file)->where("originalpath",$path)->get();
        $response = [];
        $response["is_splitable"] = 0;
        if(count($fileData) > 0){
            $response["is_splitable"] = 1;
        }
        $response["files"] = $fileData;
        return $response;
    }

     /**
     * To calculate size of a media
     *
     * @param meadia path
     * 
     * @return Size
     */
    public static function getFileSize($file) {
        $filesize = 0;
        if(file_exists($file)){
            $filesize = filesize($file);
        }
        return $filesize;
    }   
    /**
     * To send mail
     *
     * @param to name
     * @param to email
     * @param array email text data
     * @param array attachment
     * @param text subject
     * 
     * @return Size
     */
    public static function sendMail($to_name, $to_email, $attachments, $subject, $content, $groupname, $timetoday, $part, $email_type = "default") {
        
        try {
//            $content = [];
            //Get Mail Settings
            
            $mconfig = config('constants.mail');
            $content['groupname'] = $groupname;
            $content['time'] = $timetoday;
            $content['part'] = $part;
            if($mconfig['is_auth']==true){
               self::phpmailerWithAuth($to_email, $to_name, $subject, $content, $mconfig['driver'], $mconfig['host'], $mconfig['port'], $mconfig['encryption'], $mconfig['username'], $mconfig['password'], $mconfig['from_name'], $mconfig['from_address'],$attachments, $email_type); 
            } else {
               self::phpmailerWithNoAuth($to_email, $to_name, $subject, $content, $mconfig['driver'], $mconfig['host'], $mconfig['port'], $mconfig['from_name'], $mconfig['from_address'],$attachments, $email_type); 
            }
            
        } catch (Exception $e) {
            return false;
        }
    }

    /**
     *  To send email using php mailer function with SMTP Auth using Username/Password
     *
     * @param type $to_email
     * @param type $to_name
     * @param type $subject
     * @param type $content
     * @param type $driver
     * @param type $host
     * @param type $port
     * @param type $encryption
     * @param type $username
     * @param type $password
     * @param type $from_name
     * @param type $from_address
     * @param type $attachments
     * @return boolean     /
     */
    public static function phpmailerWithAuth($to_email, $to_name, $subject, $content, $driver, $host, $port, $encryption, $username, $password, $from_name, $from_address, $attachments, $email_type) {
        /**
         * This example shows making an SMTP connection with authentication.
         */
        
        //SMTP needs accurate times, and the PHP time zone MUST be set
        date_default_timezone_set('Asia/Singapore');
        //require_once(app_path('Libraries/phpmailer/PHPMailerAutoload.php'));
        //Create a new PHPMailer instance
        $mail = new PHPMailer;
        $mail->CharSet="UTF-8"; // <-- Put right encoding here
        $mail->isSMTP(); //Tell PHPMailer to use SMTP
        //Enable SMTP debugging // 0 = off (for production use)// 1 = client messages // 2 = client and server messages
        $mail->SMTPDebug = 0;
        //Ask for HTML-friendly debug output
        $mail->Debugoutput = 'html';
        //Set the hostname of the mail server
        $mail->Host = $host;
        //Set the SMTP port number - likely to be 25, 465 or 587
        $mail->Port = $port;
        //Whether to use SMTP authentication
        $mail->SMTPAuth = true;
        //Username to use for SMTP authentication
        $mail->Username = $username;
        //Password to use for SMTP authentication
        $mail->Password = $password;
        
        $from_name = urldecode($from_name);
                
        //Set who the message is to be sent from
        $mail->setFrom(trim($from_address), $from_name);
        //Set an alternative reply-to address
        $mail->addReplyTo(trim($from_address), $from_name);
        //Set who the message is to be sent to
        //Set the subject line
        $mail->Subject = $subject;
        
        if (Config::get("app.env") == "local") {
            
            $isConf = Config("app.send_bcc", '');
            if ($isConf != "") {
                $isConf = explode(",",$isConf);
                foreach ($isConf as $key => $value) {
                    $mail->addBCC($value, "Bcc");
                }
                //$mail->addBCC("deep@finchat.tech", "CNCBI Group creation"); 
            }
            //Set BCC address
//            $mail->addBCC("alok@uginfosystems.com", "Alert! CNCBI Group creation");
//            $mail->addBCC("deep@finchat.tech", "Alert! CNCBI Group creation");
        }
        
        $mail->smtpConnect([
            'ssl' => [
                'verify_peer' => false,
                'verify_peer_name' => false,
                'allow_self_signed' => true
            ]
        ]);
        
        //$mail->msgHTML(view('emails.content', ['data' => $content]), dirname(__FILE__));
        $email_tpl = 'emails.content';
        if($email_type == "alert_notify"){
            $email_tpl = 'emails.alert';
            $mail->msgHTML(view($email_tpl, ['data' => $content]), dirname(__FILE__));
        } 
        elseif($email_type=="vm_notify"){
            $email_tpl = 'emails.notify';
            $mail->msgHTML(view($email_tpl, ['data' => $content]));

        }elseif($email_type=="common_tpl"){
            $email_tpl = 'emails.common_tpl';
            $mail->msgHTML(view($email_tpl, ['data' => $content]));
        }
        elseif($email_type=="add_wechat_friend"){
            $email_tpl = 'emails.add_wechat_friend';
            if(isset($content['wechatQr'])){
                $mail->AddEmbeddedImage($content['wechatQr'], 'qr_code');
            }
            $mail->msgHTML(view($email_tpl, ['data' => $content]));
        }else if($email_type == "emails.chat_group_create_confirmation"){

            $email_tpl = $email_type;
            if(isset($content['wechatQr'])){
                $mail->AddEmbeddedImage($content['wechatQr'], 'qr_code');
            }
            //\Log::info("mail test=".$content['wechatQr']);
            $mail->msgHTML(view($email_tpl, [
                        'data' => $content["data"],
                        'client_data' => $content["client_data"],
                        'rm_data' => $content["rm_data"],
                        'other' => $content["other"]
                    ]), dirname(__FILE__));
            
        } elseif($email_type == "otp_mail"){
            $email_tpl = "emails.otp_confirmation";
            $mail->msgHTML(view($email_tpl, ['data' => $content]), dirname(__FILE__));
        } else {
            $mail->msgHTML(view($email_tpl, ['data' => $content]), dirname(__FILE__));
        }
        
        //Replace the plain text body with one created manually
        $mail->AltBody = 'Email Attached';
        //Attach an image file
        foreach ($attachments as $one) {
            $mail->addAttachment($one);
        }
        
//        print_r($to_email);
//        print_r($to_name);
//        print_r($mail);
//        
        
            $mail->addAddress(trim($to_email), $to_name);
            if (!$mail->send()) {
                
                \Log::info("Failed mail");
                
                    return false;
                    
                } else {
                    \Log::info("Mail sent");
                    
                    return true;
                }
    }

    /**
     * To send email using php mailer function without using Username/Password
     * 
     * @param type $to_email
     * @param type $to_name
     * @param type $subject
     * @param type $content
     * @param type $driver
     * @param type $host
     * @param type $port
     * @param type $encryption
     * @param type $username
     * @param type $password
     * @param type $from_name
     * @param type $from_address
     * @param type $attachments
     * @return boolean
     *      
     */
    public static function phpmailerWithNoAuth($to_email, $to_name, $subject, $content, $driver, $host, $port, $from_name, $from_address, $attachments, $email_type) {
        /**
         * This example shows making an SMTP connection with authentication.
         */
        //SMTP needs accurate times, and the PHP time zone MUST be set
        date_default_timezone_set('Asia/Singapore');
        //require_once(app_path('Libraries/phpmailer/PHPMailerAutoload.php'));
        //Create a new PHPMailer instance
        $mail = new PHPMailer;
        $mail->CharSet="UTF-8"; // <-- Put right encoding here
        $mail->isSMTP(); //Tell PHPMailer to use SMTP
        //Enable SMTP debugging // 0 = off (for production use)// 1 = client messages // 2 = client and server messages
        $mail->SMTPDebug = 0;
        //Ask for HTML-friendly debug output
        $mail->Debugoutput = 'html';
        //Set the hostname of the mail server
        $mail->Host = $host;
        //Set the SMTP port number - likely to be 25, 465 or 587
        $mail->Port = $port;
        //Whether to use SMTP authentication
        $mail->SMTPAuth = false;
        //Use if tls/ssl issue
        //$mail->SMTPSecure = false;
        $from_name = urldecode($from_name);
        //Set who the message is to be sent from
        $mail->setFrom($from_address, $from_name);
        //Set an alternative reply-to address
        $mail->addReplyTo($from_address, $from_name);
        //Set who the message is to be sent to

        //Set the subject line
        $mail->Subject = $subject;
        
        $mail->smtpConnect([
            'ssl' => [
                'verify_peer' => false,
                'verify_peer_name' => false,
                'allow_self_signed' => true
            ]
        ]);
        
        //$mail->msgHTML(view('emails.content', ['data' => $content]), dirname(__FILE__));
        $email_tpl = 'emails.content';
        if($email_type == "alert_notify"){
            $email_tpl = 'emails.alert';
            $mail->msgHTML(view($email_tpl, ['data' => $content]), dirname(__FILE__));
        } 
        elseif($email_type=="vm_notify"){
            $email_tpl = 'emails.notify';
            $mail->msgHTML(view($email_tpl, ['data' => $content]));

        }elseif($email_type=="common_tpl"){
            $email_tpl = 'emails.common_tpl';

        }elseif($email_type=="add_wechat_friend"){
            $email_tpl = 'emails.add_wechat_friend';
            if(isset($content['wechatQr'])){
                $mail->AddEmbeddedImage($content['wechatQr'], 'qr_code');
            }

            $mail->msgHTML(view($email_tpl, ['data' => $content]));
        }else if($email_type == "emails.chat_group_create_confirmation"){
            
            $email_tpl = $email_type;
            $mail->msgHTML(view($email_tpl, [
                        'data' => $content["data"],
                        'client_data' => $content["client_data"],
                        'rm_data' => $content["rm_data"],
                        'other' => $content["other"]
                    ]), dirname(__FILE__));
            
        } elseif($email_type == "otp_mail"){
            $email_tpl = "emails.otp_confirmation";
            $mail->msgHTML(view($email_tpl, ['data' => $content]), dirname(__FILE__));
        } else {
            $mail->msgHTML(view($email_tpl, ['data' => $content]), dirname(__FILE__));
        }
        
        //Replace the plain text body with one created manually
        $mail->AltBody = 'Email Attached';
        //$mail->AddEmbeddedImage($content);
        //Attach an image file
        foreach ($attachments as $one) {
            $mail->addAttachment($one);
        }
        
            $mail->addAddress(trim($to_email), $to_name);
            if (!$mail->send()) {
                \Log::info("Failed mail");
                    return false;
                } else {
                    \Log::info("Mail sent");
                    return true;
                }
    }
     /**
     * Get ICRM Partner ID
     *
     * @param string group name
     * 
     * @return string
     */
    public static function getIcrmPid($grpname) {
        $icrm = "";
        $icrmpid = \App\Caclients::select('icrm_partner_id')->where('chat_group', $grpname)->where('status','!=',1000)->first();
        if(!empty($icrmpid)){ 
            $icrm = $icrmpid->icrm_partner_id;
        }
//        return $icrmpid->icrm_partner_id;
        return $icrm;
    }
     /**
     * Get CA/Client
     *
     * @param INT number
     * @return string
     */    
    public static function getUserType($number){ // CONCAT('CA - ', phone_no,'\n\r',name) as u_data 
        $details = Cas::select(DB::RAW("CONCAT('CA - ', phone_no) as u_data"))->where('phone_no','LIKE','%'.$number)->first();
        if(empty($details)){ // CONCAT('CA - ', phone_no,'\n\r',name) as u_data
            $details = Clients::select(DB::RAW("CONCAT('Client - ', phone_no) as u_data"))->where('phone_no','LIKE','%'.$number)->first();
        }
        return $details;
    }
    /**
     * Return Offboarded CA Name/GPN
     * 
     * @param type $group_id
     * @return type     /
     */
    public static function getOffboardedCa($group_id){
        $getCaDetails = DB::table('offboarding')->select('offboarding.ca_id','cas.name','cas.gpn')
                ->leftjoin('cas','offboarding.ca_id','=','cas.id')
                ->where('offboarding.group_id',$group_id)
                ->whereNotNull('offboarding.ca_id')
                ->orderBy('offboarding.id','desc')
                ->first();
        return $getCaDetails;
    }
    /**
     * Return Offboarded Clinet Name/GPN
     * 
     * @param type $group_id
     * @return type     /
     */
    public static function getOffboardedClient($group_id){
        $getGroupId = Caclients::where('id', $group_id)->first();
        $oldid = Caclients::where('group_id', $getGroupId->group_id)
                ->where('id', '!=', $group_id)->orderBy('id', 'desc')
                ->where('id', '<',$group_id)
                ->first();
        $id = $group_id;
        if(!empty($oldid) && $oldid->id!=''){
            $id = $oldid->id;
            if($oldid->client_id!=''){
               $getCaDetails = Clients::select('phone_no')->where('id', $oldid->client_id)->first();
            }
        }
        if(!isset($getCaDetails)){
            $getCaDetails = DB::table('offboarding')->select('offboarding.client_id','clients.phone_no')
                ->leftjoin('clients','offboarding.client_id','=','clients.id')
                ->where('offboarding.group_id',$id)
                ->whereNotNull('offboarding.client_id')
                ->orderBy('offboarding.id','desc')
                ->first();
        }
        return $getCaDetails;
    }
     /**
     * Get CA/Client details
     *
     * @param INT number
     * @return string
     */    
    public static function getUserForManuallGroups($number){
        $details = Cas::select(DB::RAW("CONCAT('CA - ', phone_no,'\n\r',name) as u_data"))->where('phone_no','LIKE','%'.$number)->first();
        if(empty($details)){
            $details = Clients::select(DB::RAW("CONCAT('Client - ', phone_no) as u_data"))->where('phone_no','LIKE','%'.$number)->first();
        }
        return $details;
    }
    /*
     * Return onboarding CA Name & GPN
     * 
     * @param type $group_id
     * Return $id
     */
    public static function getOnboardCA($group_id,$type){
        $getDetails=DB::table('onboarding')->select('onboarding.new_id', 'onboarding.created_by', 'onboarding.created_at', 'onboarding.validated_at', 'cas.name', 'cas.gpn', DB::RAW('CONCAT(use_c.first_name," ",use_c.last_name) as created_by_name'), DB::RAW('use_c.email as created_by_email'), DB::RAW('CONCAT(use_v.first_name," ",use_v.last_name) as validated_by_name'), DB::RAW('use_v.email as validated_by_email'))
                ->leftjoin('cas','onboarding.new_id','=','cas.id')
                ->leftjoin('users as use_c', 'onboarding.created_by', '=', 'use_c.id')
                ->leftjoin('users as use_v', 'onboarding.validated_by', '=', 'use_v.id')
                ->where('onboarding.group_id',$group_id)
                ->where('onboarding.type',$type)
                ->orderBy('onboarding.id','desc')
                ->first();
        return $getDetails;
    }
    /*
     * Return onboarding CA Name & GPN
     * 
     * @param type $group_id
     * Return $id
     */
    public static function getReplaceCA($group_id,$type){
        $getDetails=DB::table('ca_replacement')->select('ca_replacement.new_id', 'ca_replacement.created_by', 'ca_replacement.created_at', 'ca_replacement.validated_at', 'cas.name', 'cas.gpn', DB::RAW('CONCAT(use_c.first_name," ",use_c.last_name) as created_by_name'), DB::RAW('use_c.email as created_by_email'), DB::RAW('CONCAT(use_v.first_name," ",use_v.last_name) as validated_by_name'), DB::RAW('use_v.email as validated_by_email'))
                ->leftjoin('cas','ca_replacement.new_id','=','cas.id')
                ->leftjoin('users as use_c', 'ca_replacement.created_by', '=', 'use_c.id')
                ->leftjoin('users as use_v', 'ca_replacement.validated_by', '=', 'use_v.id')
                ->where('ca_replacement.group_id',$group_id)
                ->where('ca_replacement.offboard_for',$type)
                ->orderBy('ca_replacement.id','desc')
                ->first();
        return $getDetails;
    }
    /*
     * Return CA Creation & validation details from cas validation table
     * 
     * @param type $group_id
     * Return Array
     */
    public static function getCaValidationData($caid){
        $getDetails = DB::table('cas_validation')->select('cas_validation.created_at', 'cas_validation.validated_at', DB::RAW('CONCAT(use_c.first_name," ",use_c.last_name) as created_by'), DB::RAW('use_c.email as created_by_email'), DB::RAW('CONCAT(use_v.first_name," ",use_v.last_name) as validated_by'), DB::RAW('use_v.email as validated_by_email'))
                ->leftjoin('users as use_c', 'cas_validation.created_by', '=', 'use_c.id')
                ->leftjoin('users as use_v', 'cas_validation.validated_by', '=', 'use_v.id')
                ->where('cas_validation.id',$caid)
                ->first();
        return $getDetails;            
    }
    /*
     * Return CA Creation & validation details from ca table
     * 
     * @param type $group_id
     * Return Array
     */
    public static function getCaData($caid){
        $getDetails = DB::table('cas')->select('cas.created_at', 'cas.validated_at', DB::RAW('CONCAT(use_c.first_name," ",use_c.last_name) as created_by'), DB::RAW('use_c.email as created_by_email'), DB::RAW('CONCAT(use_v.first_name," ",use_v.last_name) as validated_by'), DB::RAW('use_v.email as validated_by_email'))
                ->leftjoin('users as use_c', 'cas.created_by', '=', 'use_c.id')
                ->leftjoin('users as use_v', 'cas.validated_by', '=', 'use_v.id')
                ->where('cas.id',$caid)
                ->first();
        return $getDetails;            
    }
    /*
     * Return Client Creation & validation details from cas validation table
     * 
     * @param type $group_id
     * Return Array
     */
    public static function getClientValidationData($clientid){
        $getDetails = DB::table('client_validation')->select('client_validation.created_at', 'client_validation.validated_at', DB::RAW('CONCAT(use_c.first_name," ",use_c.last_name) as created_by'), DB::RAW('use_c.email as created_by_email'), DB::RAW('CONCAT(use_v.first_name," ",use_v.last_name) as validated_by'), DB::RAW('use_v.email as validated_by_email'))
                ->leftjoin('users as use_c', 'client_validation.created_by', '=', 'use_c.id')
                ->leftjoin('users as use_v', 'client_validation.validated_by', '=', 'use_v.id')
                ->where('client_validation.id',$clientid)
                ->first();
        return $getDetails;            
    }
    /*
     * Return CA Creation & validation details from ca table
     * 
     * @param type $group_id
     * Return Array
     */
    public static function getClientData($clientid){
        $getDetails = DB::table('clients')->select('clients.created_at', 'clients.validated_at', DB::RAW('CONCAT(use_c.first_name," ",use_c.last_name) as created_by'), DB::RAW('use_c.email as created_by_email'), DB::RAW('CONCAT(use_v.first_name," ",use_v.last_name) as validated_by'), DB::RAW('use_v.email validated_by_email'))
                ->leftjoin('users as use_c', 'clients.created_by', '=', 'use_c.id')
                ->leftjoin('users as use_v', 'clients.validated_by', '=', 'use_v.id')
                ->where('clients.id',$clientid)
                ->first();
        return $getDetails;            
    }
    /*
     * Return Pending requests
     * 
     * @param No Parameter
     * Return Array
     */
    public static function getPendingrequests(){
        $return = array();
        $return['add_ca_other'] = CaValidation::select('id')->where('status',0)->where('created_by', '!=', Auth::user()->id)->count();
        $return['add_ca_byyou'] = CaValidation::select('id')->where('status',0)->where('created_by', Auth::user()->id)->count();
        $return['add_client_other'] = ClientValidation::select('id')->where('status',0)->where('created_by', '!=', Auth::user()->id)->count();
        $return['add_client_byyou'] = ClientValidation::select('id')->where('status',0)->where('created_by', Auth::user()->id)->count();
        $return['onboard_other'] = DB::table('onboarding')->select('onboarding.id', 'onboarding.type', 'onboarding.new_id', 'onboarding.group_id', 'onboarding.created_by', 'onboarding.status as offstatus', 'chat_groups.client_id as clientid')
                    ->where('onboarding.type', 'CA')
                    ->where('onboarding.created_by', '!=', Auth::user()->id)
                    ->where('onboarding.status', 9)
                    ->count();
        $return['onboard_byyou'] = DB::table('onboarding')->select('onboarding.id', 'onboarding.type', 'onboarding.new_id', 'onboarding.group_id', 'onboarding.created_by', 'onboarding.status as offstatus', 'chat_groups.client_id as clientid')
                    ->where('onboarding.type', 'CA')
                    ->where('onboarding.created_by', Auth::user()->id)
                    ->where('onboarding.status', 9)
                    ->count();
        $return['ca_offboard_other'] = DB::table('offboarding')->select('offboarding.id', 'offboarding.ca_id', 'offboarding.group_id', 'offboarding.status as offstatus', 'offboarding.created_at')
                    ->whereNotNull('offboarding.ca_id')
                    ->where('offboarding.created_by', '!=', Auth::user()->id)
                    ->where('offboarding.status', 9)
                    ->count();
        $return['client_offboard_other'] = DB::table('offboarding')->select('offboarding.id', 'offboarding.ca_id', 'offboarding.group_id', 'offboarding.status as offstatus', 'offboarding.created_at')
                    ->whereNotNull('offboarding.client_id')
                    ->where('offboarding.created_by', '!=', Auth::user()->id)
                    ->where('offboarding.status', 9)
                    ->count();
        $return['ca_offboard_byyou'] = DB::table('offboarding')->select('offboarding.id', 'offboarding.ca_id', 'offboarding.group_id', 'offboarding.status as offstatus', 'offboarding.created_at')
                    ->whereNotNull('offboarding.ca_id')
                    ->where('offboarding.created_by', Auth::user()->id)
                    ->where('offboarding.status', 9)
                    ->count();
        $return['client_offboard_byyou'] = DB::table('offboarding')->select('offboarding.id', 'offboarding.ca_id', 'offboarding.group_id', 'offboarding.status as offstatus', 'offboarding.created_at')
                    ->whereNotNull('offboarding.client_id')
                    ->where('offboarding.created_by', Auth::user()->id)
                    ->where('offboarding.status', 9)
                    ->count();
        $return['replace_other'] = DB::table('chat_groups')
                        ->select('ca_replacement.id as replace_id','ca_replacement.new_id as new_ca_id','chat_groups.id', 'chat_groups.ca_id','chat_groups.client_id','chat_groups.status as group_status', 'ca_replacement.created_by', 'ca_replacement.status as replace_status')
                        ->leftjoin('ca_replacement', 'chat_groups.id', '=', 'ca_replacement.group_id')
                        ->where('chat_groups.status', 1)
                        ->where('ca_replacement.created_by', '!=', Auth::user()->id)
                        ->where('ca_replacement.status', 9)
                        ->count();
        $return['replace_byyou'] = DB::table('chat_groups')
                        ->select('ca_replacement.id as replace_id','ca_replacement.new_id as new_ca_id','chat_groups.id', 'chat_groups.ca_id','chat_groups.client_id','chat_groups.status as group_status', 'ca_replacement.created_by', 'ca_replacement.status as replace_status')
                        ->leftjoin('ca_replacement', 'chat_groups.id', '=', 'ca_replacement.group_id')
                        ->where('chat_groups.status', 1)
                        ->where('ca_replacement.created_by', Auth::user()->id)
                        ->where('ca_replacement.status', 9)
                        ->count();
        $return['cachange_byyou'] = DB::table('contact_update')
                ->select('contact_update.*', 'contact_update.status as updatestatus', DB::RAW('CONCAT(use_c.first_name," ",use_c.last_name) as created_by'), DB::RAW('CONCAT(use_v.first_name," ",use_v.last_name) as validated_by'))
                ->leftjoin('users as use_c', 'contact_update.created_by', '=', 'use_c.id')
                ->leftjoin('users as use_v', 'contact_update.validated_by', '=', 'use_v.id')
                ->where('contact_update.created_by', Auth::user()->id)
                ->where('contact_update.type','CA')
                ->where('contact_update.status', 9)
                ->count();
        $return['cachange_byother'] = DB::table('contact_update')
                ->select('contact_update.*', 'contact_update.status as updatestatus', DB::RAW('CONCAT(use_c.first_name," ",use_c.last_name) as created_by'), DB::RAW('CONCAT(use_v.first_name," ",use_v.last_name) as validated_by'))
                ->leftjoin('users as use_c', 'contact_update.created_by', '=', 'use_c.id')
                ->leftjoin('users as use_v', 'contact_update.validated_by', '=', 'use_v.id')
                ->where('contact_update.created_by', '!=', Auth::user()->id)
                ->where('contact_update.type','CA')
                ->where('contact_update.status', 9)
                ->count();
        $return['clientchange_byyou'] = DB::table('contact_update')
                ->select('contact_update.*', 'contact_update.status as updatestatus', DB::RAW('CONCAT(use_c.first_name," ",use_c.last_name) as created_by'), DB::RAW('CONCAT(use_v.first_name," ",use_v.last_name) as validated_by'))
                ->leftjoin('users as use_c', 'contact_update.created_by', '=', 'use_c.id')
                ->leftjoin('users as use_v', 'contact_update.validated_by', '=', 'use_v.id')
                ->where('contact_update.created_by', Auth::user()->id)
                ->where('contact_update.type','Client')
                ->where('contact_update.status', 9)
                ->count();
        $return['clientchange_byother'] = DB::table('contact_update')
                ->select('contact_update.*', 'contact_update.status as updatestatus', DB::RAW('CONCAT(use_c.first_name," ",use_c.last_name) as created_by'), DB::RAW('CONCAT(use_v.first_name," ",use_v.last_name) as validated_by'))
                ->leftjoin('users as use_c', 'contact_update.created_by', '=', 'use_c.id')
                ->leftjoin('users as use_v', 'contact_update.validated_by', '=', 'use_v.id')
                ->where('contact_update.created_by', '!=', Auth::user()->id)
                ->where('contact_update.type','Client')
                ->where('contact_update.status', 9)
                ->count();
        $return['chatgroups_other'] = Caclients::select('id')->where('status',0)->where('created_by','!=', Auth::user()->id)->count();
        $return['chatgroups_byyou'] = Caclients::select('id')->where('status',0)->where('created_by', Auth::user()->id)->count();
        return $return;
    }

    
      /*
       * Get & Store whatsapp single chat messages
       * 
       * @param type $group_id
       * Return $id
       */
      public static function whatsinglechat($from, $content, $phonetime){
         $from = "+".$from;
         $CA_existence = Cas::select('id')
             ->where('phone_no', '=', $from)
             ->count();
         $Client_existence = Clients::select('id')
             ->where('phone_no', '=', $from)
             ->count();
         if($CA_existence > 0){
            $CA_details = Cas::select('id', 'name')
             ->where('phone_no', '=', $from)
             ->get();
            foreach ($CA_details as $CA_detail) {
               $caid = $CA_detail['id'];
               $caname = $CA_detail['name'];
            }
            $attached_gps = Caclients::select('group_id')
             ->where('ca_id', '=', $caid)
             ->get();
            foreach ($attached_gps as $attached_gp) {
               $cagroupid = $attached_gp['group_id'];
            
               // insert into "single_chat_logs"
               $in_single_chats = array(
                  'group_id' => $cagroupid,
                  'user_no' => $from,
                  'user_name' => $caname,
                  'user_type' => "CA",
                  'msg_content' => $content,
                  'msg_time' => $phonetime,
                  'created_at' => date('Y-m-d H:i:s') 
               );
               //Single_chat_logs::insert($in_single_chats);
               $singlechatid= DB::table('single_chat_logs')->insertGetId($in_single_chats);
               //end

               // insert into "requst" table
               $gen_requests = array(
                  'type' => "send_message",
                  'vm_id' => NULL,
                  'reference_id' => $singlechatid,
                  'agreed_im' => "Whatsapp",
                  'status' => 0,
                  'counter' => 0,
                  'created_at' => date('Y-m-d H:i:s') 
               );
               Requests::insert($gen_requests);
               //end
            }
         } elseif($Client_existence > 0) {
            $Client_details = Clients::select('id', 'name')
             ->where('phone_no', '=', $from)
             ->get();
            foreach ($Client_details as $Client_detail) {
               $clientid = $Client_detail['id'];
               $clientname = $Client_detail['name'];
            }
            $cattached_gps = Caclients::select('group_id')
             ->where('client_id', '=', $clientid)
             ->get();
            foreach ($cattached_gps as $cattached_gp) {
              $clientgroupid = $cattached_gp['group_id'];
            
               // insert into "single_chat_logs"
               $in_single_chats = array(
                  'group_id' => $clientgroupid,
                  'user_no' => $from,
                  'user_name' => $clientname,
                  'user_type' => "Client",
                  'msg_content' => $content,
                  'msg_time' => $phonetime,
                  'created_at' => date('Y-m-d H:i:s') 
               );
               //Single_chat_logs::insert($in_single_chats);
               $singlechatid= DB::table('single_chat_logs')->insertGetId($in_single_chats);
               //end

               // insert into "requst" table
               $gen_requests = array(
                  'type' => "send_message",
                  'vm_id' => NULL,
                  'reference_id' => $singlechatid,
                  'agreed_im' => "Whatsapp",
                  'status' => 0,
                  'counter' => 0,
                  'created_at' => date('Y-m-d H:i:s') 
               );
               Requests::insert($gen_requests);
               //end
            
            }
         } else {
            return true;
         }
      }
      /**
     *   Get Status for Request created to change CA Number on dashboard
     * @param type $id
     * @param type $caid
     * @param type $clientid
     * @param type $status
     * @return string     
     */
      public static function getNumberUpdateStatus($status){
          $statusdetails = array(
            '0' => array(
                'percentage' => 0,
                'message' => 'Approved.',
                'bar'=>'progress-bar-primary',
                'icon'=>'check',
                'color-icon'=>'primary'
            ),
            '1' => array(
                'percentage' => 100,
                'message' => 'Completed',
                'bar'=>'progress-bar-success',
                'icon'=>'check',
                'color-icon'=>'success'
            ),
            '2' => array(
                'percentage' => 10,
                'message' => "Waiting for OPS \n tool to Change Number",
                'bar'=>'progress-bar-warning',
                'icon'=>'pan_tool',
                'color-icon'=>'warning'
            ),
            '3' => array(
                'percentage' => 100,
                'message' => 'Rejected',
                'bar'=>'progress-bar-danger',
                'icon'=>'warning',
                'color-icon'=>'danger'
            ),
            '9' => array(
                'percentage' => 0,
                'message' => "Request created",
                'bar'=>'progress-bar-info',
                'icon'=>'info',
                'color-icon' => 'info'
            ),
            '99' => array(
                'percentage' => 100,
                'message' => "Contact not found",
                'bar'=>'progress-bar-danger',
                'icon'=>'warning',
                'color-icon'=>'danger'
            ),  
	    '100' => array(
                'percentage' => 100,
                'message' => "Error in processing.",
                'bar'=>'progress-bar-danger',
                'icon'=>'warning',
                'color-icon'=>'danger'
            )
        );
        
        
        return $statusdetails[$status];
      }

    public static function generateStrongPassword($length = 9, $add_dashes = false, $available_sets = 'luds')
    {
	$sets = array();
	if(strpos($available_sets, 'l') !== false)
		$sets[] = 'abcdefghjkmnpqrstuvwxyz';
	if(strpos($available_sets, 'u') !== false)
		$sets[] = 'ABCDEFGHJKMNPQRSTUVWXYZ';
	if(strpos($available_sets, 'd') !== false)
		$sets[] = '0123456789';
	if(strpos($available_sets, 's') !== false)
		$sets[] = '~!@#$%^&*_-+=`|(){}[]:;<>,.?/';
	$all = '';
	$password = '';
	foreach($sets as $set)
	{
		$password .= $set[array_rand(str_split($set))];
		$all .= $set;
	}
	$all = str_split($all);
	for($i = 0; $i < $length - count($sets); $i++)
		$password .= $all[array_rand($all)];
	$password = str_shuffle($password);
	if(!$add_dashes)
		return $password;
	$dash_len = floor(sqrt($length));
	$dash_str = '';
	while(strlen($password) > $dash_len)
	{
		$dash_str .= substr($password, 0, $dash_len) . '-';
		$password = substr($password, $dash_len);
	}
	$dash_str .= $password;
	return $dash_str;
    }
    
    /**
     * for existence of current password in last 6 changed passwords
     * @param type $id
     * Return true false 
     */
    public static function checkLastPasswords($id, $newpass){
        $pass = userPass::where('user_id',$id)->orderBy('id', 'desc')->take(6)->pluck('password');
        $passArry = [];
        foreach($pass as $lastpaswrds){
            if (Hash::check($newpass, $lastpaswrds))
            {
             return "Your new password should not match any of your recently used passwords.\nPlease create a new password.";
            }
        }
        return "Continue";
    }

      
   /**
    * To send group ideal mail
    * @param type $setaday
    * 
    * @return 
    */
   public static function sendgroupidelMail($setinactivedate, $case = "email", $from_email, $to_email, $dateDirectory = "") {

        try {

            $todaay = date('Y-m-d h:i:s', time());
            $currentaday = date('Y-m-d', strtotime('- 0 days', strtotime($todaay)));
            //$currentaday = '2017-08-01';
            $GRP_dats = $WechatGRP_dats = array();

            $todaydataa = DB::table('group_idle_for_email_info')
                    ->select('group_id', DB::raw('MAX(phone_time) as phometime'))
                    ->groupBy('group_id')
                    ->where('created_at', 'like', '%' . $currentaday . '%')
                    ->orderBy('group_id', 'DESC')
                    ->get();

            foreach ($todaydataa as $todaydata) {
                $dataa['group_id'] = $todaydata->group_id;
                $dataa['phone_time'] = $todaydata->phometime;
                $GRP_names_count = Caclients::select('chat_group')
                        ->where('group_id', '=', $dataa['group_id'])
                        ->count();
                if ($GRP_names_count > 0) {
                    $GRP_names = Caclients::select('chat_group', 'group_id', 'icrm_partner_id')
                            ->where('group_id', '=', $dataa['group_id'])
                            ->first();
                    
                    if (strpos($GRP_names->group_id, '@g.us') !== false) {
                        $dataa['group_name'] = $GRP_names->chat_group;
                        $dataa['icrm_partner_id'] = $GRP_names->icrm_partner_id; 
                        $GRP_dats[] = $dataa;
                        $dataa = array();
                    }
                    if (strpos($GRP_names->group_id, '@chatroom') !== false) {
                        $dataa['group_name'] = $GRP_names->chat_group;
                        $dataa['icrm_partner_id'] = $GRP_names->icrm_partner_id; 
                        $WechatGRP_dats[] = $dataa;
                        $dataa = array(); 
                    }
                }

            }

            if (count($GRP_dats) > 0 || count($WechatGRP_dats) >0) {
                
                if ($case == "eml") { // generate eml for the group inactive
                    
                    if (count($GRP_dats) > 0) {
                        $subject = "Inactive WhatsApp Chat Groups Since Last " . $setinactivedate . " Days";
                        self::grpIdleEml($subject, $GRP_dats, $currentaday, $from_email, $to_email, $setinactivedate, $dateDirectory);
                    }
                    if (count($WechatGRP_dats) >0) {
                        $subject = "Inactive WeChat Chat Groups Since Last " . $setinactivedate . " Days";
                        self::grpIdleEml($subject, $WechatGRP_dats, $currentaday, $from_email, $to_email, $setinactivedate, $dateDirectory);
                    }

                } else {
                    
                    $subject = "Inactive Chat Groups Since Last " . $setinactivedate . " Days";
                    $mconfig = config('constants.mail');
                    // fetch Ops Manager's Email ID
                    $opsmgdataa = DB::table('users')
                            ->select('users.email', 'users.first_name', 'users.last_name')
                            ->join('role_user', 'role_user.user_id', '=', 'users.id')
                            ->where(['role_id' => '3'])
                            ->get();
                    // if case is email
                    if ($mconfig['is_auth'] == true) {
                        self::phpmailerWithAuthGRP($opsmgdataa, $subject, $GRP_dats, $mconfig, $setinactivedate);
                    } else {
                        self::phpmailerWithNoAuthGRP($opsmgdataa, $subject, $GRP_dats, $mconfig, $setinactivedate);
                    }
                }
                // if case is EML
            }
        } catch (Exception $e) {
            return false;
        }
    }

    /**
    *  To generate EML for idle group
    *  To work similar to phpmailerWithAuthGRP
    *
    * @param type $opsmgdataa
    * @param type $subject
    * @param type $GRP_dats
    * @param type $mconfig
    * @return boolean     /
    */
   public static function grpIdleEml($subject, $GRP_dats, $currentaday, $from_email, $to_email, $setinactivedate, $dateDirectory = "") {
     
       try {
           
//            $mconfig = config('constants.mail');
//            print_r($dateDirectory); die;
            $base_path = base_path();

            $exdate = explode("-",$dateDirectory);
            $emlDir = $base_path."/EOD/".$exdate[0]."/".$exdate[1]."/".$exdate[2];
            //$type = $exdate[0]."-".$exdate[1]."-".$exdate[2];
            
            if (!is_dir($emlDir)) {
                mkdir($emlDir, 0777, true);
            }

//            $body = $password->reset_url;

//            $username = $mconfig['username'];
//            $from_name = $mconfig['from_name'];
            //$from_address = $mconfig['from_address'];
            $from = $from_email;//$mconfig['from_address'];
            $to = $to_email;
            // $from_email,$to_email
//            $to = $password->email;
//            $token = $password->token;

            $emlPath = $emlDir."/".$subject.".eml";
            $body = EmlTemplateHelper::grpInactiveTpl($setinactivedate,$GRP_dats);
            $emoji = EmlTemplateHelper::mainEmlTpl($emlPath,$subject,$from,$to,$body);

            $check_last_run = Settings::where('event', 'last_group_idle_run')->count();
            if ($check_last_run > 0) {
               Settings::where('event', 'last_group_idle_run')->update(['value' => date('Y-m-d')]);
               return true;
            }else {
               Settings::insert(['event' => 'last_group_idle_run', 'value' => date('Y-m-d'), 'created_at' => date('Y-m-d H:i:s')]);
               return true;
            }   
        } catch(\Exception $e){
            return false; //  $exceptions = self::displayException($e);
        }
   }
   /**
    *  Throw error exception
    *
    * @param type $e
    * @return boolean     /
    */
    public static function displayException($e){
        $error = "An error has been occured. ".
            "In File : ".$e->getFile()." ".
            "On Line : ".$e->getLine()." ".
            "Error Description: ".$e->getMessage();
        return $error;
    }
   /**
    *  To send email using php mailer function with SMTP Auth using Username/Password
    *
    * @param type $opsmgdataa
    * @param type $subject
    * @param type $GRP_dats
    * @param type $mconfig
    * @return boolean     /
    */
   public static function phpmailerWithAuthGRP($opsmgdataa, $subject, $GRP_dats, $mconfig, $setinactivedate) {
      /**
       * This example shows making an SMTP connection with authentication.
       */
      //SMTP needs accurate times, and the PHP time zone MUST be set
      date_default_timezone_set('Asia/Singapore');
      //require_once(app_path('Libraries/phpmailer/PHPMailerAutoload.php'));
      //Create a new PHPMailer instance
      $mail = new PHPMailer;
      $mail->CharSet = "UTF-8"; // <-- Put right encoding here
      $mail->isSMTP(); //Tell PHPMailer to use SMTP
      //Enable SMTP debugging // 0 = off (for production use)// 1 = client messages // 2 = client and server messages
      $mail->SMTPDebug = 0;
      //Ask for HTML-friendly debug output
      $mail->Debugoutput = 'html';
      //Set the hostname of the mail server
      $mail->Host = $mconfig['host'];
      //Set the SMTP port number - likely to be 25, 465 or 587
      $mail->Port = $mconfig['port'];
      //Whether to use SMTP authentication
      $mail->SMTPAuth = true;
      //Username to use for SMTP authentication
      $mail->Username = $mconfig['username'];
      //Password to use for SMTP authentication
      $mail->Password = $mconfig['password'];
      
      $from_name = urldecode($mconfig['from_name']);
      
      //Set who the message is to be sent from
      $mail->setFrom(trim($mconfig['from_address']), $from_name);
      //Set an alternative reply-to address
      $mail->addReplyTo(trim($mconfig['from_address']), $mconfig['from_name']);
      //Set who the message is to be sent to
      //Set the subject line
      $mail->Subject = $subject;

      $mail->msgHTML(view('emails.grpidealcontent', ['data' => $GRP_dats, 'setday' => $setinactivedate]), dirname(__FILE__));
      //Replace the plain text body with one created manually
      $mail->AltBody = 'Email Attached';
//      //Attach an image file
//      foreach ($attachments as $one) {
//         $mail->addAttachment($one);
//      }
//      echo "<pre>";
//      print_r($opsmgdataa);
//      exit;
        foreach($opsmgdataa as $Ops_dat){
          $mail->addAddress(trim($Ops_dat->email), $Ops_dat->first_name . '' . $Ops_dat->last_name);
        }
        if (!$mail->send()) {
           return false;
        } else {
            $check_last_run = Settings::where('event', 'last_group_idle_run')->count();
            if ($check_last_run > 0) {
               Settings::where('event', 'last_group_idle_run')->update(['value' => date('Y-m-d')]);
               return true;
            }else {
               Settings::insert(['event' => 'last_group_idle_run', 'value' => date('Y-m-d'), 'created_at' => date('Y-m-d H:i:s')]);
               return true;
            }       
        }
   }

   /**
    * To send email using php mailer function without using Username/Password
    * 
    * @param type $opsmgdataa
    * @param type $subject
    * @param type $GRP_dats
    * @param type $mconfig
    * @return boolean
    *      
    */
   public static function phpmailerWithNoAuthGRP($opsmgdataa, $subject, $GRP_dats, $mconfig, $setinactivedate) {
      /**
       * This example shows making an SMTP connection with authentication.
       */
      //SMTP needs accurate times, and the PHP time zone MUST be set
      date_default_timezone_set('Asia/Singapore');
      //require_once(app_path('Libraries/phpmailer/PHPMailerAutoload.php'));
      //Create a new PHPMailer instance
      $mail = new PHPMailer;
      $mail->CharSet = "UTF-8"; // <-- Put right encoding here
      $mail->isSMTP(); //Tell PHPMailer to use SMTP
      //Enable SMTP debugging // 0 = off (for production use)// 1 = client messages // 2 = client and server messages
      $mail->SMTPDebug = 0;
      //Ask for HTML-friendly debug output
      $mail->Debugoutput = 'html';
      //Set the hostname of the mail server
      $mail->Host = $mconfig['host'];
      //Set the SMTP port number - likely to be 25, 465 or 587
      $mail->Port = $mconfig['port'];
      //Whether to use SMTP authentication
      $mail->SMTPAuth = false;
      //Use if tls/ssl issue
      //$mail->SMTPSecure = false;
      $from_name = urldecode($mconfig['from_name']);
      //Set who the message is to be sent from
      $mail->setFrom($mconfig['from_address'], urldecode($from_name));
      //Set an alternative reply-to address
      $mail->addReplyTo($mconfig['from_address'], urldecode($mconfig['from_name']));
      //Set who the message is to be sent to
      //Set the subject line
      $mail->Subject = $subject;
      $mail->msgHTML(view('emails.grpidealcontent', ['data' => $GRP_dats, 'setday' => $setinactivedate]), dirname(__FILE__));
     
      //Replace the plain text body with one created manually
      $mail->AltBody = 'Email Attached';
//      //Attach an image file
//      foreach ($attachments as $one) {
//         $mail->addAttachment($one);
//      }

      foreach($opsmgdataa as $Ops_dat){
        $mail->addAddress(trim($Ops_dat->email), $Ops_dat->first_name . '' . $Ops_dat->last_name);
      }
      if (!$mail->send()) {
         return false;
      } else {
         $check_last_run = Settings::where('event', 'last_group_idle_run')->count();
         if ($check_last_run > 0) {
            Settings::where('event', 'last_group_idle_run')->update(['value' => date('Y-m-d')]);
            return true;
         }else {
            Settings::insert(['event' => 'last_group_idle_run', 'value' => date('Y-m-d'), 'created_at' => date('Y-m-d H:i:s')]);
            return true;
         }
      }
   }
   
   /*
    * Create .Zip File
    * 
    * 
    * response zip file
    */
//   public static function createzip($pathtocreatezip, $outputpath, $zipFileName, $password) { // to assign pw
    public static function createzip($pathtocreatezip, $outputpath, $zipFileName) {  
        
        $filetopath = $outputpath.'/'.$zipFileName.'.zip';

//        if(is_dir($outputpath)){
            self::mk_directory($outputpath, 0777, true);
            shell_exec('chmod 777 -R '.$outputpath);
            //$zipExec = exec("cd " . $pathtocreatezip . "; zip -r -P {$password} $outputpath/" . $zipFileName . ".zip *");

            $zipExec = exec("cd " . $pathtocreatezip . "; zip -r $outputpath/" . $zipFileName . ".zip *");

            shell_exec('chmod 777 '.$filetopath); 
//        }

        if(is_file($filetopath)){
           return "Zip Created";
        }else{
           return "Failed Create Zip"; 
        }
      
//      try {
//      } catch (Exception $e) {
//       return false;
//      }
      
   }
      /*
    * Upload .Zip File
    * 
    * 
    * response zip file
    */
   public static function uploadZip($extension, $tempFile, $filename, $path){
        $enable_upload = true;
        
        try {
            if ($tempFile != '' && file_exists($tempFile)) {
                move_uploaded_file($tempFile, $path.'/'.$filename);
                shell_exec('chmod 777 '.$path.'/'.$filename);
                return true;
            } else {
                return false;
            }
            
        }catch (\Exception $e) {
            return redirect('admin/import')->with([
                'msg' => substr($e->getMessage(), 0, 100), 
                'status' => 'warning']);
        }
   }
   /*
    * Extract .Zip File
    * 
    * 
    * response zip file
    */
    public static function extractzip($cratedzippath, $extractpath) {
        $zip = new ZipArchive();
        $zip_status = $zip->open($cratedzippath);

        if ($zip_status === true) {
            $passArray = \App\Pass_for_zip::select('password')->get();
            foreach ($passArray as $pass) {
                $password = Crypt::decryptString($pass->password);
                if ($zip->setPassword($password)) {
                    if (!$zip->extractTo($extractpath)) {
                        $msg = 2;
                    } else {
                        //echo $password;
                        $msg = 1;
                        break;
                    }
                } else {
                    $msg = 9;
                }
            }
            $zip->close();
        } else {
            $msg = 3;
        }
        return $msg;
    }

     public static function getExportedFile($date){
       $export_path = base_path().'/Export/'; 
       $path = "#";
       $getExporturl = $export_path.$date.".zip";
       
       if(File::exists($getExporturl)){
           $path = $getExporturl;
       }
       return $path;
   }
    /*
    * Extract .Zip File
    * 
    * 
    * response zip file
    */
    public static function getReadFileZip($cratedzippath) {


        $zip = new ZipArchive();
        $zip_status = $zip->open($cratedzippath);
        if ($zip_status === true) {
            $passArray = \App\Pass_for_zip::select('password')->get();
            foreach ($passArray as $pass) {
                $password = Crypt::decryptString($pass->password);

                if ($zip->setPassword($password)) {

                    if (!$zip->getFromName('readme.txt')) {
                        $msg = 2;
                    } else {
                        $msg = $zip->getFromName('readme.txt');
                    }
                    break;
                } else {
                    $msg = 9;
                }
            }

            $zip->close();
        } else {
            $msg = 3;
        }
        return $msg;
    }

     //SendResetPassEmail
   public static function sendResetEmail($password){
       try {
            //$content = [];
            //Get Mail Settings
            $attachments = array();
            $mconfig = config('constants.mail');
            $subject = "Reset Password";
            $blade = 'emails.reset_pass';
            $content['level'] = 'success';
            $content['type'] = 'password';
            $content['action_text'] = 'Reset Password';
            $content['url'] = $password->reset_url;
            if($mconfig['is_auth']==true){
               $auth = 1;
            } else {
               $auth = 0;
            }
            self::sendResetPassMail($password, $auth, $subject, $blade, $content, $mconfig['driver'], $mconfig['host'], $mconfig['port'], $mconfig['encryption'], $mconfig['username'], $mconfig['password'], $mconfig['from_name'], $mconfig['from_address'],$attachments); 
        } catch (Exception $e) {
            return false;
        }
   }
   
   public static function sendResetPassMail($password_arr, $auth, $subject, $blade, $content, $driver, $host, $port, $encryption, $username, $password, $from_name, $from_address, $attachments) {
        /**
         * This example shows making an SMTP connection with authentication.
         */
        
        //SMTP needs accurate times, and the PHP time zone MUST be set
        date_default_timezone_set('Asia/Singapore');
        //require_once(app_path('Libraries/phpmailer/PHPMailerAutoload.php'));
        //Create a new PHPMailer instance
        $mail = new PHPMailer;
        $mail->CharSet="UTF-8"; // <-- Put right encoding here
        $mail->isSMTP(); //Tell PHPMailer to use SMTP
        //Enable SMTP debugging // 0 = off (for production use)// 1 = client messages // 2 = client and server messages
        $mail->SMTPDebug = 0;
        //Ask for HTML-friendly debug output
        $mail->Debugoutput = 'html';
        //Set the hostname of the mail server
        $mail->Host = $host;
        //Set the SMTP port number - likely to be 25, 465 or 587
        $mail->Port = $port;
        //Whether to use SMTP authentication
        
        if($auth==1){
          $mail->SMTPAuth = true;
          //Username to use for SMTP authentication
          $mail->Username = $username;
          //Password to use for SMTP authentication
          $mail->Password = $password;
        } else {
          $mail->SMTPAuth = false;  
        }
        $from_name = urldecode($from_name);
        //Set who the message is to be sent from
        $mail->setFrom(trim($from_address), $from_name);
        //Set an alternative reply-to address
        $mail->addReplyTo(trim($from_address), $from_name);
        //Set who the message is to be sent to
        //Set the subject line
        $mail->Subject = $subject;
        $mail->msgHTML(view($blade, ['data' => $content]), dirname(__FILE__));
        //Replace the plain text body with one created manually
        $mail->AltBody = 'Email Attached';
        //Attach an image file
        foreach ($attachments as $one) {
            $mail->addAttachment($one);
        }
            $mail->addAddress(trim($password_arr->email), '');
            if (!$mail->send()) {
            \App\passResetHistory::where('email', $password_arr->email)->where('token', $password_arr->token)->update(['status'=>2]);
                return false;
            } else {
            \App\passResetHistory::where('email', $password_arr->email)->where('token', $password_arr->token)->update(['status'=>1]);
                return true;
            }
    }
    
    
    /**
     * Check if CA n Client active
     * @param type $refid     /
     */
    public static function checkIfContactsActive($refid, $imtype = 'whatsapp', $requests){
        $return  = false;

        $partcipant_count = 0;
     //   echo $imtype;
        if($imtype == 'whatsapp'){

             $partcipant_count_var = RequestOps::select('id', 'type', 'reference_id', 'status')
                     ->where('type', 'create_contact_client')
                     ->where('related_group_id', $refid)
                     ->where('status',"!=", 1)
                     ->count();

             if($partcipant_count_var == 0){
                 $partcipant_count = 1;
             }
             \Log::info("-partcipant_count_var-".$partcipant_count_var);

        }else{

             $groupCreateReqOpsId = $requests->id; # new parameter added...
             $partcipant_count_var = RequestOps::select('id', 'type', 'reference_id', 'status')
                     ->where('type', 'wechat_client')
                     ->where('related_group_id', $refid)
                     ->where('id', '<', $groupCreateReqOpsId)
                     ->where('status',"!=", 1)
                     ->count();
             if($partcipant_count_var == 0){ # continue...
                 $partcipant_count = 1;
             }
             \Log::info('count-'.$partcipant_count_var);

        }

        if ($partcipant_count >= 1) {
           $return = TRUE; 
        }

        return $return;
    }
    
   /**
    * Insert Whatsapp/Wechat group id Data.
    * 
    * @return \Illuminate\Http\Response
    */
   public static function saveNewGroupId($device_id, $groupname, $groupid, $imtype, $newGroupType = "") {

      # check if group name is present in chat_groups table
      $count = Caclients::select('id')
              ->where('chat_group', $groupname)
              ->where('manual_group', 0)
              ->count();
// echo 'ss';
      if (    
              $count > 0 || # for whatsapp automation group
              (
                ($newGroupType != "unauth") && (strtolower($imtype) == "wechat")
              )
              
         ) {

         $handleWlcmMsg = RequestVerificationHelper::automationGroupWelcomeMsg($device_id, $groupname, $groupid, $imtype);
         
      } else {
// echo 's';
         //New group existance update not createdby OPS
            # process if manual group
            $handleMnlGrpg = RequestVerificationHelper::manualGroupProcessing($device_id, $groupname, $groupid, $imtype);
 
      }
      return true;
   }
   
     /**
     * Check if CA n Client active
     * @param type $refid     /
     */
    public static function checkIfCaActiveByGid($refid){
        $return  = false;
        $group = Caclients::select('ca_id', 'client_id')->where('id', $refid)->first();
        //Count CA & CLIENT to create selenium group request
        $ca_count = RequestOps::select('id', 'type', 'reference_id', 'status')
                        ->where('type', 'create_contact_ca')
                        ->where('reference_id', $group->ca_id)
                        ->where('status', 1)
                        ->count();
        if($ca_count==0 || $group->ca_id== ''){
          $return = "ca not found" ;
        }
        
        if ($ca_count >= 1  && $group->ca_id != '') {
             $return = true; 
        }
        return $return;
    }
    /**
     * get New Ca id to be replaced
     * @param type $rqstid     /
     */
    public static function getNewCaReplace($rqstid){
        $newid = '';
        $caid = CaReplacement::select('new_id')->where('id', $rqstid)->first(); 
        if(isset($caid) && $caid->new_id != ''){
           $newid = $caid->new_id;
        }
        return $newid;
    }
     /**
     * Check if CA n Client active
     * @param type $refid     /
     */
    public static function checkCaActive($caid){
        $return  = 0;
        //Count CA & CLIENT to create selenium group request
        
        $ca_count = RequestOps::select('id', 'type', 'reference_id', 'status')
                        ->where('type', 'create_contact_client')
                        ->where('reference_id', $caid)
                        ->where('status', 1)
                        ->count();
        if ($ca_count >= 1) {
             $return = 1; 
        }
        return $return;
    }
     /**
     * Check if CA n Client active
     * @param type $refid     /
     */
    public static function checkClientActive($clientid){
        $return  = 0;
        //Count CLIENT to create group request
        $cl_count = RequestOps::select('id', 'type', 'reference_id', 'status')
                        ->where('type', 'create_contact_client')
                        ->where('reference_id', $clientid)
                        ->where('status', 1)
                        ->count();
        if ($cl_count >= 1) {
             $return = 1; 
        }
        return $return;
    }
    public static function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%3D', '%24', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "=", "$", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, rawurlencode($string));
    }
    /**
     *  Insert message request in Request ops table
     * @param type $msgid
     * @param type $offbrdingid
     * @param type $groupid
     * @param type $agreed_im     /
     * @param type $im_language_preference     en_us, chinese ...
     * @param type $refId 
     * @param type $type 
     * @param type $refId user_groups row id
     */
    public static function insertMessageRequest(
            $msgid, 
            $offbrdingid, 
            $groupid, 
            $agreed_im, 
            $im_language_preference = "",
            $refId = "", 
            $type = "",
            $reqOpsId = '',
            $groupData = []
            ){
        
        $getMessage = \App\Event_message_text::where('id', $msgid)->first();
        
        // for chinese language

        $vm_id = isset($groupData->vm_id) ? $groupData->vm_id : "";
        $attached_vm = isset($groupData->attached_vm) ? $groupData->attached_vm : "";
        
        if($im_language_preference == ""
                || $vm_id == "" 
                || $attached_vm == "")
            { // this condition says that no $im_language_preference is send but group_id is present
            $chat_grp_ides = Caclients::select('im_language_preference','agreed_im','vm_id','attached_vm')->where('id', $groupid)->first();
            if(isset($chat_grp_ides["im_language_preference"])){
                $im_language_preference = $chat_grp_ides["im_language_preference"];
            }
            $vm_id = isset($chat_grp_ides->vm_id) ? $chat_grp_ides->vm_id : "";
            $attached_vm = isset($chat_grp_ides->attached_vm) ? $chat_grp_ides->attached_vm : "";
        }
//        $im_language_preference;
        $msg = "";
        
        
        if($im_language_preference == "zh-Hans"){
            if(isset($getMessage->zh_hans)){ $msg = $getMessage->zh_hans; }
        } elseif ($im_language_preference == "zh-Hant"){
            if(isset($getMessage->zh_hant)){ $msg = $getMessage->zh_hant; }
        }else{
            if(isset($getMessage->event_content)){ $msg = $getMessage->event_content; }
        }
        $msg_related_with = NULL;
        // for chinese language
        
//        $msg = $getMessage->event_content;
        
        if($msgid == 1 || $msgid == 5 || $msgid == 2){
            $offid = $offbrdingid;
            $getnum = self::getOffNumber($offid); # old function
            $msg = str_replace("+111111", $getnum, $msg);
        }
        if($msgid == 11){
           $msg = str_replace("+111111", $offbrdingid, $msg);
            $userDevices = User_device::select("vm_id", "id", "whatsapp_bot_no", "wechat_bot_no")->where("vm_id", $vm_id)
            ->first();
            $bot_no = "";
            if(strtolower($agreed_im) == "whatsapp"){
                $bot_no = $userDevices->whatsapp_bot_no;
            } 
            elseif(strtolower($agreed_im) == "wechat") {
                $bot_no = $userDevices->wechat_bot_no;
            }
            $msg = str_replace("+222222", $bot_no, $msg);
            \Log::info("Bot no..........");
//           \Log::info($userDevices);
           \Log::info("Bot no..........");
        }
        $rid =  Event_message::insertGetId([
            'type' => 'group', 
            'vm_id' => $vm_id,
            'attached_vm' => $attached_vm,
            'reference_id' => $groupid, 'msg_content' => $msg, 'created_at' => date('Y-m-d H:i:s')]);
        if($msgid == 11){
            if($refId == ""){ $refId = $groupid; }
//            $msg = str_replace("+65 86571867", $getnum, $offbrdingid);

            // 'user_group_relation_id' => ,
            $otpRef = DBS_otp_event_message::insert(['type' => 'group',
                'reference_id' => $refId, 'group_id' => $groupid, 
                'msg_content' => $offbrdingid,  'created_at' => date('Y-m-d H:i:s')]);
        }
        if($reqOpsId != ''){ # where message will be linked with previous request
            $msg_related_with = 'req_ops'.$reqOpsId;
        }
//        RequestOps::insert(['type' => 'send_message',
//            'reference_id' => $rid,
//            'agreed_im' => $agreed_im,
//            'status' => 0,
//            'created_at' => date('Y-m-d H:i:s'),
//            'related_group_id' => $groupid]
//                );
        
      /*
       
       -- Create_group
        send_message - $msg_related_with = 'group_welcome_msg', updated_related_id = user_groups_id
        create_group - $msg_related_with = user_groups_id (first client/crp who accepted)
       -- Onboarding 
        when $reqOpsId > 0 ; $msg_related_with = 'req_ops'.$reqOpsId (onboard to relate previous request)
        
       */  
        
        if($msgid == 11){
            
            $status = 0;
            if($type == "create_group" || $reqOpsId = 0){
//                $status = 1;
                $msg_related_with = 'group_welcome_msg';
            }
           RequestOps::insert(['type' => 'send_message',
            'vm_id' => $vm_id,
            'attached_vm' => $attached_vm,
            'reference_id' => $rid,
            'agreed_im' => $agreed_im,
            'status' => $status,
            'updated_related_id' => $refId,
            'msg_related_with' => $msg_related_with, 
            'created_at' => date('Y-m-d H:i:s'),
            'related_group_id' => $groupid]
                );
        }else{
           RequestOps::insert(['type' => 'send_message',
            'vm_id' => $vm_id,
            'attached_vm' => $attached_vm,
            'reference_id' => $rid,
            'agreed_im' => $agreed_im,
            'status' => 0,
            'created_at' => date('Y-m-d H:i:s'),
            'related_group_id' => $groupid]
                );
        }
    }
    /**
     *  Generate otp for group and member
     * @param type $msgid
     */
    public static function generateOtpForGroupMember($groupid, $times = 0){
        
        $otppin = mt_rand(1000, 9999);
        
        $count = DBS_otp_event_message::where('group_id', $groupid)->Where('msg_content', $otppin)->count();
        if($count == 0){
            return $otppin;
        } else {    
            $times = $times + 1;
            if($times == 20){
                $otppin = time();
                return $otppin; 
            }
            $self = self::generateOtpForGroupMember($groupid,$times);
        }
        
    }
    /**
     *  Insert message request in Request ops table
     * @param type $msgid
     * @param type $offbrdingid
     * @param type $groupid
     * @param type $agreed_im     /
     */
    public static function insertconfirmOTPMessageRequest(
            $msgid, $cr_ip, $country,
            $clicktime, $groupid, $agreed_im, 
            $im_language_preference = "", $clientNO, $userGroupRelId){
        
        $getMessage = \App\Event_message_text::where('id', $msgid)->first();
        
        // for chinese language

//        if($im_language_preference == ""){ // this condition says that no $im_language_preference is send but group_id is present
            $chat_grp_ides = Caclients::select('im_language_preference', 'agreed_im', 'vm_id', 'attached_vm')->where('id', $groupid)->first();
            if(isset($chat_grp_ides["im_language_preference"])){
                $im_language_preference = $chat_grp_ides["im_language_preference"];
            }
            $agreed_im = isset($chat_grp_ides->agreed_im) ? $chat_grp_ides->agreed_im : "";
            $groupVm = isset($chat_grp_ides->vm_id) ? $chat_grp_ides->vm_id : "";
            $attached_vm = isset($chat_grp_ides->attached_vm) ? $chat_grp_ides->attached_vm : "";
//        }
        $im_language_preference;
        $msg = "";
        if($im_language_preference == "zh-Hans"){
            if(isset($getMessage->zh_hans)){ $msg = $getMessage->zh_hans; }
        } elseif ($im_language_preference == "zh-Hant"){
            if(isset($getMessage->zh_hant)){ $msg = $getMessage->zh_hant; }
        }else{
            if(isset($getMessage->event_content)){ $msg = $getMessage->event_content; }
        }
        if($msgid == 12){
           $msg = str_replace("+111111", $clicktime, $msg);
//           $msg = str_replace("+222222", $cr_ip, $msg);
//           $msg = str_replace("+333333", $country, $msg);
           $msg = str_replace("+444444", $clientNO, $msg);
        }
//        if($msgid == 11){
//            $userDevices = User_device::select("vm_id", "id", "whatsapp_bot_no", "wechat_bot_no")->where("vm_id", $groupVm)
//            ->first();
//            $bot_no = "";
//            if(strtolower($agreed_im) == "whatsapp"){
//                $bot_no = $userDevices->whatsapp_bot_no;
//            } 
//            elseif(strtolower($agreed_im) == "wechat") {
//                $bot_no = $userDevices->wechat_bot_no;
//            }
//            $msg = str_replace("+222222", $bot_no, $msg);
//        }
        $rid =  Event_message::insertGetId(['type' => 'group',
            'vm_id' => $groupVm,
            'attached_vm' => $attached_vm,
            'reference_id' => $groupid, 'msg_content' => $msg, 'created_at' => date('Y-m-d H:i:s')]);
        
        UserGroup::where('group_id', $groupid)
                ->where('id', $userGroupRelId)
                ->where('client_otp_approval', 0)
                ->update(array('client_otp_approval' => 1));
        
        RequestOps::insert(['type' => 'send_message',
            'reference_id' => $rid,
            'vm_id' => $groupVm,
            'attached_vm' => $attached_vm,
            'agreed_im' => $agreed_im,
            'status' => 0,
            'created_at' => date('Y-m-d H:i:s'),
            'related_group_id' => $groupid,
            'msg_related_with' => $userGroupRelId]
        );
    }    
    
    /**
     *  Insert message request in Request ops table
     * @param type $msgid
     * @param type $refid
     * @param type $groupid
     * @param type $agreed_im     /
     */
    public static function insertReplaceMessage($msgid, $caid, $groupid, $agreed_im, $im_language_preference = ""){
        $getMessage = \App\Event_message_text::where('id', $msgid)->first();
        
        // for chinese language

//        if($im_language_preference == ""){ // this condition says that no $im_language_preference is send but group_id is present

            $chat_grp_ides = Caclients::select('im_language_preference', 'agreed_im', 'vm_id', 'attached_vm')->where('id', $groupid)->first();
            if(isset($chat_grp_ides["im_language_preference"])){
                $im_language_preference = $chat_grp_ides["im_language_preference"];
            }
            $agreed_im = isset($chat_grp_ides->agreed_im) ? $chat_grp_ides->agreed_im : "";
            $groupVm = isset($chat_grp_ides->vm_id) ? $chat_grp_ides->vm_id : "";
            $attached_vm = isset($chat_grp_ides->attached_vm) ? $chat_grp_ides->attached_vm : "";
            
//        }
        $msg = "";
        if($im_language_preference == "zh-Hans"){
            if(isset($getMessage->zh_hans)){ $msg = $getMessage->zh_hans; }
        } elseif ($im_language_preference == "zh-Hant"){
            if(isset($getMessage->zh_hant)){ $msg = $getMessage->zh_hant; }
        }else{
            if(isset($getMessage->event_content)){ $msg = $getMessage->event_content; }
        }

        // for chinese language
        
//        $msg = $getMessage->event_content;
        
        if($msgid == 1){
            $getnum = self::getCaName($caid);
            $msg = str_replace("+111111", $getnum, $msg);
        }
        $rid =  Event_message::insertGetId(['type' => 'group',
            'vm_id' => $groupVm,
            'attached_vm' => $attached_vm,
            'reference_id' => $groupid, 'msg_content' => $msg, 'created_at' => date('Y-m-d H:i:s')]);    
        RequestOps::insert(['type' => 'send_message',
            'vm_id' => $groupVm,
            'attached_vm' => $attached_vm,
            'reference_id' => $rid,
            'agreed_im' => $agreed_im,
            'status' => 0,
            'created_at' => date('Y-m-d H:i:s'),
            'related_group_id' => $groupid]
                );
    }
    /*
     * Return Offborading CA/Client name
     * 
     * @param type $offid
     * @return type     /
     */
    public static function getOffName($offid){
        $getDetails = OffBoarding::select('ca_id', 'client_id', 'user_id')->where('id', $offid)->first();
//        if(isset($getDetails->client_id) && $getDetails->client_id != ''){
//            $getNumber = Clients::select('name')->where( 'id', $getDetails->client_id )->first();
//        } else {
//            $getNumber = Cas::select('name')->where( 'id', $getDetails->ca_id )->first();
//        }
        if(isset($getDetails->user_id) && $getDetails->user_id != ''){
//            $getNumber = User::select('name')->where( 'id', $getDetails->user_id )->first();
            $getNumber = self::getUserFromUsergroup($getDetails->user_id);
//            return $getNumber->name; # when save contact as name 
            return $getNumber->phone_no; # when save contact as phone no 
        }
        
    }
    /*
     * Return Offborading CA/Client number
     * 
     * @param type $offid
     * @return type     /
     */
    public static function getOffNumber($offid){
        $getDetails = OffBoarding::select('ca_id', 'client_id', 'user_id')->where('id', $offid)->first();
//        if(isset($getDetails->client_id) && $getDetails->client_id != ''){
//            $getNumber = Clients::select('phone_no')->where( 'id', $getDetails->client_id )->first();
//            $return = $getNumber->phone_no;
//        } else {
//            $getNumber = Cas::select('name')->where( 'id', $getDetails->ca_id )->first();
//            $return = $getNumber->name;
//        }
        if(isset($getDetails->user_id) && $getDetails->user_id != ''){
            $getNumber = User::select('phone_no')->where( 'id', $getDetails->client_id )->first();
            $return = $getNumber->phone_no;
        }
        return $return;
    }
    /*
     * Return CA Replacement CA name
     * 
     * @param type $offid
     * @return type     /
     */
    public static function getReplacedName($id, $type){
        $getDetails = CaReplacement::select('ca_id', 'new_id')->where('id', $id)->first();
        if($type == 'old'){
            $getName = Cas::select('name')->where( 'id', $getDetails->ca_id )->first();
        } else {
            $getName = Cas::select('name')->where( 'id', $getDetails->new_id )->first();
        }
        return $getName->name;
    }
    
    /*
     * Return Contact updated name
     * 
     * @param type $offid
     * @return type     /
     */
    public static function getUpdaterReqName($request){
        
        $type = $request->type;
//        
        $getDetails = UpdateContact::select('name', 'existing_number', 'new_number')
                                    ->where('id', $request->id)
                                    ->orderBy('id', "DESC")
                                    ->first();
        return $getDetails;
    }    
    /*
     * Return CA name
     * 
     * @param type $offid
     * @return type     /
     */
    public static function getCaName($id){
        //$getName = Cas::select('name')->where( 'id', $id )->first();
//        $getName = User::select('name')->where( 'id', $id )->first();
//        return $getName->name;
        $getNumber = self::getUserFromUsergroup($id);
//        return $getNumber->name; # when save contact as name 
        return $getNumber->phone_no; # when save contact as no 
    }
    /*
     * Return Onborading CA number
     * 
     * @param type $onid
     * @return type    
     */
    
    
    
    public static function getOnCaName($onid){
        //$getDetails = OnBoarding::select('new_id')->where('id', $onid)->first();
//        $getNumber = User::select('name')->where( 'id', $onid )->first();
//        return $getNumber->name;
        
        $getNumber = self::getUserFromUsergroup($onid);
//        return $getNumber->name; # when save contact as name 
        return $getNumber->phone_no; # when save contact as no 
    }
    /*
     * Return Onborading CA number
     * 
     * @param type $onid
     * @return type     /
     */
    public static function getUserFromUsergroup($onid){
        $data = UserGroup::find($onid);
//        $role = $data->role;
//        if($role == 6){
//           $user = Clients::where("id",$data->user_id)->first(); 
//        } elseif($role == 7){
//            $user = Crps::where("id",$data->user_id)->first();  
//        }else {
//            $user = User::where("id",$data->user_id)->first();  
//        }
        return $user = self::getPartcipantIdByIdAndRole($data->user_id,$data->role);
    }
    /*
     * Return last saved id for a group
     * 
     * @param type $id
     * @param type $group_id
     * @param type $im
     * @return type     /
     */
    public static function getLastSavedId($id, $group_id, $im){
        if($im == 'Whatsapp'){
            $getDetails =  lastSavedID::select('last_whatsapp_id as last_id')->where('unqe_grp_id', $id)
               ->where('chat_group', $group_id)
               ->first();
        } else {
            $getDetails =  lastSavedID::select('last_wechat_id as last_id')->where('unqe_grp_id', $id)
               ->where('chat_group', $group_id)
               ->first();
        }
        if(empty($getDetails)){
            $return = 0;
        }  else {
            $return = $getDetails->last_id;
        }
        return $return;
    }
    
    /*
    * Save password create notification
    * 
    * 
    * response save data
    */

    public static function savePasswordcreateNotification($manualtoken,$type ="") {
        $abctoken = passwordReset::get();
        foreach ($abctoken as $passtoken) {
            if (Hash::check($manualtoken, $passtoken->token)) {
                //passCreateHistory::insert(['email' => $passtoken->email, 'type' => $type, 'token' => $manualtoken, 'reset_url' => url('password/create') . '/' . $manualtoken, 'created_at' => date('Y-m-d H:i:s')]);
                passResetHistory::insert(['email' => $passtoken->email, 'type' => $type, 'token' => $manualtoken, 'reset_url' => url('password/reset') . '/' . $manualtoken, 'created_at' => date('Y-m-d H:i:s')]);
            }
        }
    }
   
   
    //SendCreatePassEmail
   public static function sendCreateEmail($crpassword){
       try {
            //$content = [];
            //Get Mail Settings
            $attachments = array();
            $mconfig = config('constants.mail');
            $subject = "Create Password";
            $blade = 'emails.create_pass';
            $content['level'] = 'success';
            $content['type'] = 'password';
            $content['action_text'] = 'Create Password';
            $content['url'] = $crpassword->reset_url;
            if($mconfig['is_auth']==true){
               $auth = 1;
            } else {
               $auth = 0;
            }
            self::sendCreatePassMail($crpassword, $auth, $subject, $blade, $content, $mconfig['driver'], $mconfig['host'], $mconfig['port'], $mconfig['encryption'], $mconfig['username'], $mconfig['password'], $mconfig['from_name'], $mconfig['from_address'],$attachments); 
        } catch (Exception $e) {
            return false;
        }
   }
   
   public static function sendCreatePassMail($password_arr, $auth, $subject, $blade, $content, $driver, $host, $port, $encryption, $username, $password, $from_name, $from_address, $attachments) {
        /**
         * This example shows making an SMTP connection with authentication.
         */
        
        //SMTP needs accurate times, and the PHP time zone MUST be set
        date_default_timezone_set('Asia/Singapore');
        //require_once(app_path('Libraries/phpmailer/PHPMailerAutoload.php'));
        //Create a new PHPMailer instance
        $mail = new PHPMailer;
        $mail->CharSet="UTF-8"; // <-- Put right encoding here
        $mail->isSMTP(); //Tell PHPMailer to use SMTP
        //Enable SMTP debugging // 0 = off (for production use)// 1 = client messages // 2 = client and server messages
        $mail->SMTPDebug = 0;
        //Ask for HTML-friendly debug output
        $mail->Debugoutput = 'html';
        //Set the hostname of the mail server
        $mail->Host = $host;
        //Set the SMTP port number - likely to be 25, 465 or 587
        $mail->Port = $port;
        //Whether to use SMTP authentication
        
        if($auth==1){
          $mail->SMTPAuth = true;
          //Username to use for SMTP authentication
          $mail->Username = $username;
          //Password to use for SMTP authentication
          $mail->Password = $password;
        } else {
          $mail->SMTPAuth = false;  
        }
        $from_name = urldecode($from_name);
        //Set who the message is to be sent from
        $mail->setFrom(trim($from_address), $from_name);
        //Set an alternative reply-to address
        $mail->addReplyTo(trim($from_address), $from_name);
        //Set who the message is to be sent to
        //Set the subject line
        $mail->Subject = $subject;
        $mail->msgHTML(view($blade, ['data' => $content]), dirname(__FILE__));
        //exit;
        //Replace the plain text body with one created manually
        $mail->AltBody = 'Email Attached';
        //Attach an image file
        foreach ($attachments as $one) {
            $mail->addAttachment($one);
        }
            $mail->addAddress(trim($password_arr->email), '');
            if (!$mail->send()) {
                \App\passCreateHistory::where('email', $password_arr->email)->where('token', $password_arr->token)->update(['status'=>2]);
                    return false;
                } else {
                \App\passCreateHistory::where('email', $password_arr->email)->where('token', $password_arr->token)->update(['status'=>1]);
                    return true;
                }
    }
    /*
     * return group name
     * 
     * @param type $id
     * @return type string
     */
    public static function GroupManualDataById($id){
//        \Log::info($id);
        $groupname = [];
        $groupnme = [];
        $details = DB::table('group_created_manually')
                ->select('group_id','group_name')
                ->where('id', $id)->first();
//        \Log::info($details);
        if(isset($details->group_id) && $details->group_id != ''){
            $groupname = $details;
            $groupnme['chat_group'] =
                    $details->group_name;
            $groupnme['group_id'] = $details->group_id;
        }
//        print_r($groupnme);
        return $groupnme;
    }
    /*
     * return group name
     * 
     * @param type $id
     * @return type string
     */
    public static function GroupNameById($id){
//        \Log::info($id);
        $groupname = [];
        $groupnme = [];
        $details = Caclients::select('chat_group','group_id')->where('id', $id)->first();
//        \Log::info($details);
        if(isset($details->chat_group) && $details->chat_group != ''){
            $groupname = $details;
            $groupnme['chat_group'] =
                    $details->chat_group;
            $groupnme['group_id'] = $details->group_id;
        }
//        print_r($groupnme);
        return $groupnme;
    }
    /**
     * Send HTML for Media
     * @param $media_name
     * @param $media_type
     */
    public static function get_media($msgid, $media_nme, $contentType, $media_type_id, $device_id, $fldr, $phonetime, $media_nme_orig = "", $request_from = "",$compliance_msg="",$original_name="") {
//        echo $media_type_id;
        try {
            $clearfix = 'message-separator clearfix';
            if($request_from == "search"){
                $clearfix = '';    
            }
// Code that may throw an Exception or Error.
            $mpth = config('constants.path');

            if(!empty($original_name)){
                $media_name = $compliance_msg;
            }else{
                $media_name = urldecode($media_nme);
            }
		
            $phnt = explode('/', date('Y/m/d', strtotime($phonetime)));
            $contentList = array(
                // type => folder name
                'whatsapp' => 'whatsapp',
                'wechat' => 'wechat',
                'im_line' => 'im_line'
            );
            if ($contentType == 'whatsapp') {
                $mediatype = array(
                    // type => folder name
                    '19' => 'system',
                    '0' => 'text_emoji',
                    '1' => 'image',
                    '2' => 'audio',
                    '3' => 'video',
                    '4' => 'contact',
                    '5' => 'location',
                    '16' => 'location',
                    '8' => 'voice',
                    '9' => 'document',
                    '10' => 'video_call',
                    '13' => 'gif',
                    '14' => 'multiple_contacts',
                    '15' => 'deleted',
                    '20' => 'sticker',
                    '11' => 'deleted'
                );
                $path = '';
                $org_path = '';
                $path = '';
                $dir_org_path = '';
                if(isset($mediatype[$media_type_id])){
                    $path = asset('/uploads') . '/' . $phnt[0] . '/' . $phnt[1] . '/' . $phnt[2] . '/vms' . '/' . $device_id . '/' . $contentType . '/' . $mediatype[$media_type_id] . '/' . $media_name;
                    $dir_org_path = $mpth['upload_path'] . '/' . $phnt[0] . '/' . $phnt[1] . '/' . $phnt[2] . '/vms' . '/' . $device_id . '/' . $contentType . '/' . $mediatype[$media_type_id] . '/' . $media_name;
                }
                # to get the path from the table
//                if(!is_file($org_path) && $msgid != ""){
                    
                    $fsq =  Filesplitqueue::Where("message_id",$msgid)
                            ->where("imtype","whatsapp")
                            ->first(array("token","path"));
                    $mediaPath = isset($fsq["path"]) ? $fsq["path"] : "";
                    $mediatoken = isset($fsq["token"]) ? $fsq["token"] : "";
                    $dir_org_path = base_path()."/".$mediaPath;
                    $path = asset('/uploads')."/".str_replace("public/uploads", '', $path);
                    
                    # for the pen test
                    $org_path = url("/")."/uploads/".$mediatoken;//$msgid."/whatsapp";
                    $path = url("/")."/uploads/".$mediatoken;//$msgid."/whatsapp";
                    
                // if media rendering by token is not working then we can use followings, changed for SocGen server issue
// For audio change <a target="_self"  href="' . $org_path . '"> to <a class="downl_img" href="' . $path . '" download>
//                    if($media_type_id == 1 ||  $media_type_id == 3 ||  $media_type_id == 13 ){
//                        $path_without_public  =  str_replace('public/', '', $mediaPath);
//                        $path_of_browser_url = asset('/uploads').'/'.$path_without_public;
//
//                        $path  = str_replace('/', '', $path_without_public);
//                    }
                    
//                }
//                $path = asset('/uploads') . '/' . $phnt[0] . '/' . $phnt[1] . '/' . $phnt[2] . '/vms' . '/' . $device_id . '/' . $contentType . '/' . $mediatype[$media_type_id] . '/' . $media_name;
//                $org_path = $mpth['upload_path'] . '/' . $phnt[0] . '/' . $phnt[1] . '/' . $phnt[2] . '/vms' . '/' . $device_id . '/' . $contentType . '/' . $mediatype[$media_type_id] . '/' . $media_name;
                if ($media_type_id == 0) {
                    $content = self::getWhatsappEmoMsg($media_nme);
                } elseif($media_type_id == 19){
                    $content = '<div class="msgtype19"> <div class="'.$clearfix.'">  <div>'.  urldecode($media_nme) .'</div> </div> </div>';
                } elseif ($media_type_id == 1) {
                    $content = '';
                    if (is_file($dir_org_path)) {
                        $content = '<a class="downl_img" href="' . $path . '" download><i class="fa fa-cloud-download" aria-hidden="true"></i></a>';
                        $content .= '<div href="javascript:void()" >
                                <img class="img-responsive" src="' . $path . '" alt="">
                            </div>';
                    } else {
                        if ($media_name !== NULL && $media_name !== "null") {
                            $content = $media_name . ' (Not uploaded yet...)';
                        } else {
                            $content = 'Image (Not uploaded yet...)';
                        }
                    }
                    
//                $content .= '<a href="' . $path . '" class="fancybox" rel="ligthbox">
//                                <img class="img-responsive" src="' . $path . '" alt="">
//                            </a>';
                } elseif ($media_type_id == 2) {

                    if (is_file($dir_org_path)) { // $media_name
                        $content = '<a target="_self"  href="' . $org_path . '">Audio (Download)</a>';
                    } else {
                        if ($media_name !== NULL && $media_name !== "null") {
                            $content = $media_name . ' (Not uploaded yet...)';
                        } else {
                            $content = 'Audio (Not uploaded yet...)';
                        }
                    }
                } elseif ($media_type_id == 3 || $media_type_id == 13) {
                    $mtype = explode('.', $media_name);
                    $typee = isset($mtype[1]) && $mtype[1] != '' ? $mtype[1] : 'mp4';
                    $content = '<video width="100%" controls>
                   <source type="video/' . $typee . '" src="' . $path . '" >
                  </video>';

            } elseif ($media_type_id == 4) {
                if ($fldr == 1) {
                    $replace_contact = str_replace('---CONTACT CARD RECEIVED--- ', '<b>CONTACT</b><br/>', $media_name);
                } else {
                    $replace_contact = str_replace('---CONTACT CARD SENT--- ', '<b>CONTACT</b><br/>', $media_name);
                }
                $content = str_replace(', ', '<br/>', $replace_contact);
            } elseif ($media_type_id == 14) {
                if ($fldr == 1) {
                    $replace_contact = str_replace('---MULTIPLE CONTACT CARD RECEIVED--- ', '<b>CONTACT</b><br/>', $media_name);
                } else {
                    $replace_contact = str_replace('---MULTIPLE CONTACT CARD SENT--- ', '<b>CONTACT</b><br/>', $media_name);
                }
                $content = str_replace(', ', '<br/>', $replace_contact);
            } elseif ($media_type_id == 5 ) {
                if ($fldr == 1) {
                    $replace_contact = str_replace('---LOCATION RECEIVED--- ', '<b>LOCATION</b><br/>', $media_name);
                } else {
                    $replace_contact = str_replace('---LOCATION SENT--- ', '<b>LOCATION</b><br/>', $media_name);
                }
                $content = str_replace(', ', '<br/>', $replace_contact);
            }elseif ($media_type_id == 16) {
                if ($fldr == 1) {
                    $replace_contact = '---LIVE LOCATION RECEIVED---';
                } else {
                    $replace_contact =  '---LIVE LOCATION SENT---';
                }
                $content = str_replace(', ', '<br/>', $replace_contact);
            } elseif ($media_type_id == 8 || $media_type_id == 10) {


                    if (strpos($media_name, 'VOICE CAll SCREEN PRESENTED') !== false) {
                        $replace_contact = str_replace('---VOICE CAll SCREEN PRESENTED --- ', '<b>Voice Call</b><br/>', $media_name);
                    } else {
                        $replace_contact = str_replace('---VIDEO CAll SCREEN PRESENTED --- ', '<b>Video Call</b><br/>', $media_name);
                    }
                    $content = str_replace(', ', '<br/>', $replace_contact);
                } elseif ($media_type_id == 9) {
                    
//                    if($media_nme_orig == ""){
//                        
//                    }
                    //echo $compliance_msg;

                    if (is_file($dir_org_path)) { // $media_name
                        
                        $display_txt = 'Document : ' . $media_name ;
//                        if($media_nme_orig != ""){
//                            $display_txt = '<i class="fa fa-cloud-download" aria-hidden="true"></i>';
//                        }
                        if($request_from == "search"){ # display ui on seach page
                            $display_txt = "Document (Download)";//'<i class="fa fa-cloud-download" aria-hidden="true"></i>';
                        } else {
                            if($media_nme_orig != ""){
                                $display_txt = $display_txt;
                            }  
                            $display_txt .= ' (Download)';
                        }
                        $content = '<a target="_self" href="' . $org_path . '" >' . $display_txt . ' </a>';
                    } else {
                        if ($media_name !== NULL && $media_name !== "null") {
                            $content = $media_name . ' (Not uploaded yet...)';
                        } else {
                            $content = 'Document (Not uploaded yet...)';
                        }
                    }
                } elseif ($media_type_id == 15 || $media_type_id == 11) {
                    $content = 'This message was deleted';
                } elseif ($media_type_id == 20) {
                    $content = 'Sticker--';
//                    echo $dir_org_path;
                    if (is_file($dir_org_path)) {
//                        $content = '<a class="downl_img" href="' . $path . '" download><i class="fa fa-cloud-download" aria-hidden="true"></i></a>';
                        $content = '<div href="javascript:void()" >
                                <img class="img-responsive" src="' . $path . '" alt="">
                            </div>';
                    } else {
                        $content = 'Sticker--';
                    }
                    
                } else {
                    $content = $media_type_id . ' - N/A';
                }
            } else {
                // to get medianame irrespective of Username and :: wechat
                $mediatype = array(
                    // type => folder name
                    '10000' => 'system',
                    '1' => 'text_emoji',
                    '3' => 'image',
                    '34' => 'audio',
                    '43' => 'video',
                    '42' => 'contact',
                    '47' => 'sticker',
                    '48' => 'location',
                    '8' => 'voice',
                    '49' => 'attachment',
                    '62' => 'sight',
                    '64' => 'voice_call'
                );
                
                $path = '';
                $org_path = '';
                // if(isset($mediatype[$media_type_id])){
                //     if(!empty($media_encrypted_name)){
                //         $path = asset('/uploads') . '/' . $phnt[0] . '/' . $phnt[1] . '/' . $phnt[2] . '/vms' . '/' . $device_id . '/' . $contentType . '/' . $mediatype[$media_type_id] . '/' . $media_encrypted_name;
                //         $org_path = $mpth['upload_path'] . '/' . $phnt[0] . '/' . $phnt[1] . '/' . $phnt[2] . '/vms' . '/' . $device_id . '/' . $contentType . '/' . $mediatype[$media_type_id] . '/' . $media_encrypted_name;
                //     }
                    
                   
                //     //if ($media_type_id == 49) {

                //     // }else{
                //     //     $org_path = $mpth['upload_path'] . '/' . $phnt[0] . '/' . $phnt[1] . '/' . $phnt[2] . '/vms' . '/' . $device_id . '/' . $contentType . '/' . $mediatype[$media_type_id] . '/' . $media_name;   
                //     // }
                // }
                //\Log::info("outside original path=".$org_path."media type=".$mediatype[$media_type_id]);
                # to get the path from the table
                //if(is_file($org_path) && $msgid != ""){
                   
                    $fsq =  Filesplitqueue::Where("message_id",$msgid)
                    ->where("device_id",$device_id)
                    ->where("imtype","wechat")
                    ->first(array("token","path"));

                    $mediaPath = isset($fsq["path"]) ? $fsq["path"] : "";
                    $mediaToken = isset($fsq["token"]) ? $fsq["token"] : "";
                    $org_path = base_path()."/".$mediaPath;
                    $path = asset('index.php/uploads')."/".str_replace("public/uploads", '', $mediaToken);
                    // \Log::info("original path=".$org_path);
                    // \Log::info("path in=".$path);
                //}
                $media_nme = urldecode($media_nme);
                if ($media_type_id == 1) {
                    $content = self::getWhatsappEmoMsg($media_nme);
                } elseif($media_type_id == 10000){ // $media_type_id == 10000 && 
//                    echo $media_nme;
                    if(empty($media_nme) || $media_nme == "" || $media_nme == NULL){ $media_nme = "Some wechat notification"; }
                    
                    $content = '<div class="msgtype19" style="font-size:11px;"> <div class="'.$clearfix.'">  <div><i>'.  rawurldecode($media_nme) .'</i></div> </div> </div>';
                } elseif ($media_type_id == 49) {
                    if($original_name){
                        $media_name=$original_name;
                    }
                    if (is_file($org_path)) {
                        $content = '<a target="_self" href="' . $path . '">File - '.$media_name.' (Download)</a>';
                    }else{
                        $content = isset($original_name)?$original_name:$media_nme;
                    }
                } elseif ($media_type_id == 34 || $media_type_id == 8) {
                    if (is_file($org_path)) {
                        $content = '<a target="_self" href="' . $path . '" download>Audio - '.$media_name.' (Download)</a>';
                    }else{
                        $content = $media_nme;
                    }
                } elseif ($media_type_id == 43) {
                    if (is_file($org_path)) {
                        $content = '<a target="_self" href="' . $path . '" download>Video - '.$media_name.' (Download)</a>';
                    }else{
                        $content = $media_nme;
                    }
                } elseif ($media_type_id == 3) {
                    $content = '';
                    if (is_file($org_path)) {
                        $content = '<a class="downl_img" href="' . $path . '"><i class="fa fa-cloud-download" aria-hidden="true"></i></a>';
                        $content .= '<div href="javascript:void()" >
                                    <img class="img-responsive" src="' . $path . '" alt="">
                                </div>';
                    } else {
                        if ($media_name !== NULL && $media_name !== "null") {
                            $content = $media_name . ' (Not uploaded yet...)';
                        } else {
                            $content = 'Image (Not uploaded yet...)';
                        }
                    }
                } else {
                    $content = rawurldecode($media_nme);//$media_type_id . 'N/A';
                }
            }
//            echo $content;
            return $content;
        } catch (Throwable $t) {
// Executed only in PHP 7, will not match in PHP 5.x
            return $t;
        } catch (Exception $e) {
// Executed only in PHP 5.x, will not be reached in PHP 7
            return $e;
        }
    }    
    
    public static function getWhatsappEmoMsg($media_nme){
        $emo_msg = trim(urldecode($media_nme));
        $msg = \App\Helpers\EmojiHelper::detect_emoji($emo_msg);
        if (count($msg) > 0) {
            foreach ($msg as $key => $value) {
                $emoCode = 'U+' . implode(" U+", $value["points_hex"]);
                $emojiArr[$emoCode] = $value["emoji"];
                if (empty($emojiBase64[$emoCode])) {
                    $query = \App\Emojimodel::Where('code', '=', $emoCode)->first(array("s_no", "code", "image_base64"));
                    if (!empty($query)) {
                        //$emoImgUrl = env("APP_URL") . "/emojis/" . $query["s_no"] . '.png';
                        $emoImgUrl = asset("/") . "/emojis/" . $query["s_no"] . '.png';
                        $emoji_attachment[] = $emoImgUrl;
                        $pos = strpos($query["image_base64"], "class=");
                        $emojiBase64[$emoCode] = "<img style='width:30px;height:30px;' width=30 src=" . $emoImgUrl . " >";
                    } else {
                        //echo $emoImgPdf[$emoCode]=$emoCode;
                    }
                }
            }
            //Sort array based on key length
            $keys = array_map('strlen', array_keys($emojiArr));
            array_multisort($keys, SORT_DESC, $emojiArr);
            //print_r($emojiBase64);
            foreach ($emojiArr as $emok => $emov) {
                if (!empty($emojiBase64[$emok])) {
                    $emo_msg = str_replace($emov, $emojiBase64[$emok], $emo_msg);
                }
            }
            $media_nme = $emo_msg;
            //}
            $content = $emo_msg;
        } else {
            $content = trim(urldecode($media_nme));
        }
        return $content;
    }
    public static function getEmoticonsArray(){

        
        $emoticonsArr = [];
        $key = 'emoticons-array';
        $minutes = 120;

//         check if value exist in cache
        if (Cache::has($key)) {
           // use cache value
           $emoticonsArr = Cache::get($key);
        }else{
//             if value is not in cache
            $emoticonsArr = \App\EmojiWechatmodel::orderByRaw('CHAR_LENGTH(code)', 'DESC')->get()->toArray();
            $emoticons = array_reverse($emoticonsArr);
            $emoticonsArr = [];

            foreach ($emoticons as $key => $value) {

                $emoticonsArr[$value["id"]]["desc"] = $value["newcode"];
                $emoticonsArr[$value["id"]]["img"] = $value["image"];
                $emoticonsArr[$value["id"]]["code"] = $value["code"];
            }
            Cache::add($key, $emoticonsArr, $minutes);
        }

        return $emoticonsArr;
    }
    public static function getEmojiWeChatMessage($message){
        $emo_msg = $message;
        $msg = \App\Helpers\EmojiHelper::detect_emoji($emo_msg);
//        return $emo_msg;
        // emoji...
        
        if (count($msg) > 0) {
           foreach ($msg as $key => $value) {
              $emoCode = 'U+' . implode(" U+", $value["points_hex"]);
              $emojiArr[$emoCode] = $value["emoji"];
              if (empty($emojiBase64[$emoCode])) {
                 $query = \App\Emojimodel::Where('code', '=', $emoCode)->first(array("s_no", "code", "image_base64"));
                 if (!empty($query)) {
                    $emoImgUrl = asset('/') . "/emojis/" . $query["s_no"] . '.png';
                    $emoji_attachment[] = $emoImgUrl;
                    $pos = strpos($query["image_base64"], "class=");
                    $emojiBase64[$emoCode] = "<img style='width:30px;height:30px;' width=30 src=" . $emoImgUrl . " >";
                 } else {
                    //echo $emoImgPdf[$emoCode]=$emoCode;
                 }
              }
           }
           //Sort array based on key length
           $keys = array_map('strlen', array_keys($emojiArr));
           array_multisort($keys, SORT_DESC, $emojiArr);
           //print_r($emojiBase64);
           foreach ($emojiArr as $emok => $emov) {
              if (!empty($emojiBase64[$emok])) {
                 $emo_msg = str_replace($emov, $emojiBase64[$emok], $emo_msg);
              }
           }
           $message = $emo_msg;
        } else {
           $emo_msg = $message;
        }

        // emoticons...

        // to check and implement sticker                        
        if (strpos($emo_msg, "---STICKER---") !== false) {
           $reg_exUrl = "/(http|https|ftp|ftps)\:\/\/[a-zA-Z0-9\-\.]+\.[a-zA-Z]{2,3}(\/\S*)?/";
           if (preg_match($reg_exUrl, $emo_msg, $url)) {
                $img_url = $url[0];
                $emo_msg = "<img alt=".$img_url." style='max-with:60%;' src='" . $img_url . "' >";
           }
        }
        return $emo_msg;
    }
    public static function getEmoticonsWeChatMessage($emo_msg, $emoticonsArr, $wechatEmojiPath){
        // emoticons...
        
//        $is_ptrn = preg_match("/\[(.*?)\]/", $emo_msg);
//        if (strpos($emo_msg, "/:") !== false || $is_ptrn != 0 ) {
            foreach ($emoticonsArr as $keyId => $valueKey) {
                $value = $valueKey["desc"];
                $img = $valueKey["img"];
                $imoDesc = "[" . ($value) . "]";
                $imoImg = $img;
                $key = $valueKey["code"];

                $imgPath = $wechatEmojiPath . $imoImg . PHP_EOL;
                // match if code found like /:)
  //                                       if (strpos($emo_msg, $key) !== false) {
                if( strpos( strtolower($emo_msg), strtolower($key) ) !== false ) {
                   $emoticons_attachment[$key] = $wechatEmojiPath . $imoImg; //$value;
                   $img = "<img style='width:30px' src='" . $wechatEmojiPath . $imoImg . "' >";
                   $emo_msg = str_replace($key, $img, $emo_msg);
                }
                // match if description found
                if (strpos(strtolower($emo_msg), strtolower($imoDesc)) !== false) {

                   $emoticons_attachment[$key] = $wechatEmojiPath . $imoImg; //$value;
                   $img = "<img style='width:30px' src='" . $wechatEmojiPath . $imoImg . "' >";
                   $emo_msg = str_ireplace($imoDesc, $img, $emo_msg);
                }
            }
//        }
        return $emo_msg;
    }
    /**
     * If Name already exists
     * 
     * @param type $string
     * @param type $length
     * @return type     /
     */
    public static function getToken($string, $length){
        $token = "";
        $codeAlphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        $codeAlphabet.= "abcdefghijklmnopqrstuvwxyz";
        $codeAlphabet.= "0123456789";
        $codeAlphabet.= str_replace("+","",$string);
        $max = strlen($codeAlphabet); // edited

        for ($i=0; $i < $length; $i++) {
           $token .= $codeAlphabet[random_int(0, $max-1)];
        }

        return $token;
    }
    
    public static function ifClientName($clientname){
        $ifcount = ClientValidation::where('name', $clientname)->count();
        return $ifcount;
    }
    
    /**
     *  Insert message request in Request ops table
     * @param type $msgid
     * @param type $offbrdingid
     * @param type $groupid
     * @param type $agreed_im     /
     */
    public static function unauthorisedMessage($msgid, $groupid, $name, $number, $agreed_im, $im_language_preference){
        
        $getMessage = \App\Event_message_text::where('id', $msgid)->first();
        
        // for chinese language
        $msg = "";
        if($im_language_preference == "zh-Hans"){
            if(isset($getMessage->zh_hans)){ $msg = $getMessage->zh_hans; }
        } elseif ($im_language_preference == "zh-Hant"){
            if(isset($getMessage->zh_hant)){ $msg = $getMessage->zh_hant; }
        }else{
            if(isset($getMessage->event_content)){ $msg = $getMessage->event_content; }
        }
        // for chinese language
        
//        $msg = $getMessage->event_content;
        if(isset($groupid)){
            $gid = $groupid;
                $getnum = self::getCaClientNumber($number, $groupid);
                $getMnumData = wechatMemberCount::where('group_id', $groupid)->where('member_number', 'like', $number)->first();
                if($getnum == 0 && empty($getMnumData)){
                    //If number not exist
                    $msg = str_replace("+111111", $number, $msg);
                    
            $chat_grp_ides = Caclients::select('im_language_preference', 'agreed_im', 'vm_id', 'attached_vm')->where('id', $gid)->first();

            $agreed_im = isset($chat_grp_ides->agreed_im) ? $chat_grp_ides->agreed_im : "";
            $groupVm = isset($chat_grp_ides->vm_id) ? $chat_grp_ides->vm_id : "";
            $attached_vm = isset($chat_grp_ides->attached_vm) ? $chat_grp_ides->attached_vm : "";
                    
                    $rid =  Event_message::insertGetId(['type' => 'group',
                        'vm_id' => $groupVm,
                        'attached_vm' => $attached_vm,
                        'reference_id' => $gid, 'msg_content' => $msg, 'created_at' => date('Y-m-d H:i:s')]);    
                    RequestOps::insert(['type' => 'send_message',
                        'reference_id' => $rid,
                        'vm_id' => $groupVm,
                        'attached_vm' => $attached_vm,
                        'agreed_im' => $agreed_im,
                        'status' => 0,
                        'created_at' => date('Y-m-d H:i:s'),
                        'related_group_id' => $gid]
                    );  
                }
            
        }
            
    }
    
    public static function getCaClientNumber($num, $gid){
        $c = 0;
        $getClient = Clients::select('id')->where( 'phone_no', 'LIKE', $num )->first();
        if(!empty($getClient)){
            $getMemberingroup = Caclients::select('id')->where('id', $gid)->where('client_id', $getClient->id)->count();
            if($getMemberingroup > 0){
                $c = $c+1;
            }
        }
        $getCa = Cas::select('id')->where( 'phone_no', 'LIKE', $num )->first();
        if(!empty($getCa)){
            $getMembersingroup = Caclients::select('id')->where('id', $gid)->where('ca_id', $getCa->id)->count();
            if($getMembersingroup > 0){
                $c = $c+1;
            }
        }  
        return $c; 
    }
    
    public static function checkEmoji($str) {
        $regexEmoticons = '/[\x{1F600}-\x{1F64F}]/u';
        preg_match($regexEmoticons, $str, $matches_emo);
        if (!empty($matches_emo[0])) {
            return false;
        }

        // Match Miscellaneous Symbols and Pictographs
        $regexSymbols = '/[\x{1F300}-\x{1F5FF}]/u';
        preg_match($regexSymbols, $str, $matches_sym);
        if (!empty($matches_sym[0])) {
            return false;
        }

        // Match Transport And Map Symbols
        $regexTransport = '/[\x{1F680}-\x{1F6FF}]/u';
        preg_match($regexTransport, $str, $matches_trans);
        if (!empty($matches_trans[0])) {
            return false;
        }

        // Match Miscellaneous Symbols
        $regexMisc = '/[\x{2600}-\x{26FF}]/u';
        preg_match($regexMisc, $str, $matches_misc);
        if (!empty($matches_misc[0])) {
            return false;
        }

        // Match Dingbats
        $regexDingbats = '/[\x{2700}-\x{27BF}]/u';
        preg_match($regexDingbats, $str, $matches_bats);
        if (!empty($matches_bats[0])) {
            return false;
        }
        
        //Deep
        // Match New Emojis
        $regexDingbats = '/[\x{1F6F7}-\x{1F9E6}]/u';
        preg_match($regexDingbats, $str, $matches_bats);
        if (!empty($matches_bats[0])) {
            return false;
        }
        

        return true;
    }
    
    /*
     * group data
     * 
     * 
     * 
     */
    public static function checkMemberCountData($catgroup, $ifCaExists){
        
        # commented on 2018-05-27  added block
        $active = 0;
        $onid = $catgroup->ref_id;
        $checkIfActive = self::ifWeChatMemberActive('CA', $onid, $catgroup->group_id); //If number to be onboarded is in active members or not
        if($checkIfActive == 1){
            $active = 1;
        }
        return $active;
        # commented on 2018-05-27  added block
        /*
        $mcount = 1;
        if($catgroup->ca_id!=''){
             $mcount = $mcount+1;
             $checkIfActive = self::ifWeChatMemberActive('CA', $catgroup->ca_id, $ifCaExists->group_id); //If number to be offboarded is in active members or not
        }
        if($catgroup->client_id!=''){
             $mcount = $mcount+1;
             $checkIfActive = self::ifWeChatMemberActive('Client', $catgroup->client_id, $ifCaExists->group_id); //If number to be offboarded is in active members or not
        }
        if($checkIfActive == ''){
                $mcount = '';
        }
        if(isset($ifCaExists->group_id) && $ifCaExists->group_id != ''){
            $getCount = wechatMemberCount::select('member_count')
                    ->where('group_id', $ifCaExists->group_id)->first();
            if(isset($getCount->member_count) && $getCount->member_count != ''){
                $mcount = $getCount->member_count;
            }
        }
        $mcount_verify = 1;
        if($catgroup->ca_id!=''){
             $mcount_verify = $mcount_verify+1;
        }
        if($catgroup->client_id!=''){
             $mcount_verify = $mcount_verify+1;
        }
        if($mcount_verify != $mcount && $catgroup->agreed_im == 'WeChat'){
                $mcount = '';
        }
        return $mcount;
        */
    }
    public static function checkOnbrdMemberCount($catgroup, $onboarddata){
        $mcount = '';
        
        if(isset($catgroup->group_id) && $catgroup->group_id != ''){
            $getCount = wechatMemberCount::select('member_count')->where('group_id', $catgroup->group_id)->first();
            if(isset($getCount->member_count) && $getCount->member_count != ''){
                $mcount = $getCount->member_count;
            }
        }
        
        return $mcount;
    }
    /*
     * Return 0 if offboarded
     * 
     * @param type $catgroup
     * @return int     /
     */
    public static function checkMemberIfOffboarded($catgroup){
        
        # commented on 2018-05-27  added block
        
        $active = 1;
        $ofid = $catgroup->ref_id;
        $getOffdata = OffBoarding::select('ca_id', 'client_id', 'user_id')->where('id',$ofid)->first();

        if($getOffdata->user_id!=''){
             $checkIfActive = self::ifWeChatMemberActive('Client', $getOffdata->user_id, $catgroup->group_id); //If number to be offboarded is in active members or not
        }
        if($checkIfActive == ''){
                $active = 0;
        }
        
        return $active;
        
        /*
        $active = 1;
        $ofid = $catgroup->ref_id;
        $getOffdata = OffBoarding::select('ca_id', 'client_id', 'user_id')->where('id',$ofid)->first();
        if($getOffdata->ca_id!=''){
             $checkIfActive = self::ifWeChatMemberActive('CA', $catgroup->ca_id, $catgroup->group_id); //If number to be offboarded is in active members or not
        }
        if($getOffdata->client_id!=''){
             $checkIfActive = self::ifWeChatMemberActive('Client', $catgroup->client_id, $catgroup->group_id); //If number to be offboarded is in active members or not
        }
        if($checkIfActive == ''){
                $active = 0;
        }
        return $active;
        */
    }
    /*
     * Return 0 if offboarded
     * 
     * @param type $catgroup
     * @return int     /
     */
    public static function checkMemberIfReplaceOff($catgroup){
        $active = 1;
        $ofid = $catgroup->ref_id;
        $getOffdata = CaReplacement::select('ca_id', 'client_id')->where('id',$ofid)->first();
        if($getOffdata->ca_id!=''){
             $checkIfActive = self::ifWeChatMemberActive('CA', $getOffdata->ca_id, $catgroup->group_id); //If number to be offboarded is in active members or not
        }
        if($checkIfActive == ''){
                $active = 0;
        }
        
        return $active;
    }
    /*
     * Return 0 if offboarded
     * 
     * @param type $catgroup
     * @return int     /
     */
    public static function checkMemberIfReplaceOn($catgroup){
        $active = 1;
        $ofid = $catgroup->ref_id;
        $getOffdata = CaReplacement::select('new_id', 'client_id')->where('id',$ofid)->first();
        if($getOffdata->new_id!=''){
             $checkIfActive = self::ifWeChatMemberActive('CA', $getOffdata->new_id, $catgroup->group_id); //If number to be offboarded is in active members or not
        }
        if($checkIfActive == ''){
                $active = 0;
        }
        
        return $active;
    }
    /*
     * Return 0 if offboarded
     * 
     * @param type $catgroup
     * @return int     /
     */
    public static function checkMemberIfOnboarded($catgroup){
        
        
        # commented on 2018-05-27  added block
        $active = 0;
        $onid = $catgroup->ref_id;
        $checkIfActive = self::ifWeChatMemberActive('CA', $onid, $catgroup->group_id); //If number to be onboarded is in active members or not
        if($checkIfActive == 1){
            $active = 1;
        }
//        $getOndata = UserGroup::select('group_id')->where('id',$onid)->first();
//        if(isset($getOndata->status) && $getOndata->status == 1){
//                $active = 1;
//        }
        \Log::info("checkMemberIfOnboarded-----");
//        \Log::info($checkIfActive);
//        \Log::info($active);
//        \Log::info($catgroup->group_id);
        \Log::info("checkMemberIfOnboarded-----");
        return $active;
        # commented on 2018-05-27  added block
        
        $active = 0;
        $onid = $catgroup->ref_id;
        $getOndata = OnBoarding::select('group_id', 'type', 'new_id')->where('id',$onid)->first();
        if($getOndata->type == 'CA'){
             $checkIfActive = self::ifWeChatMemberActive('CA', $getOndata->new_id, $catgroup->group_id); //If number to be onboarded is in active members or not
        }
        if($getOndata->type == 'Client'){
             $checkIfActive = self::ifWeChatMemberActive('Client', $getOndata->new_id, $catgroup->group_id); //If number to be onboarded is in active members or not
        }
        if($checkIfActive == 1){
                $active = 1;
        }
        
        return $active;
    }
    
    
    public static function checkMemberIfUpdConOff($catgroup){
        $active = 0;
        $updteid = $catgroup->ref_id;
        $getOffdata = UpdateContact::select('existing_number')->where('id',$updteid)->first();
        if(isset($getOffdata->existing_number) && $getOffdata->existing_number!=''){
            $getCount = wechatMemberCount::select('id')->where('group_id', $catgroup->group_id)
                ->where(function ($query) use ($getOffdata) {
                    $query->where('member_name', $getOffdata->existing_number)
                          ->orWhere('member_number', $getOffdata->existing_number);
                })->count();
            if($getCount > 0){
                $active = 1;
            } else {
                $active = '';
            }
        } else {
            $active = '';
        }
        
        return $active;
    }
    public static function checkMemberIfUpdConOnboard($catgroup){
        $active = 0;
        $updteid = $catgroup->ref_id;
        $getOffdata = UpdateContact::select('new_number')->where('id',$updteid)->first();
        if($getOffdata->new_number!=''){
            $getCount = wechatMemberCount::select('id')->where('group_id', $catgroup->group_id)
                ->where(function ($query) use ($getOffdata) {
                    $query->where('member_name', $getOffdata->new_number)
                          ->orWhere('member_number', $getOffdata->new_number);
                })->count();
            if($getCount > 0){
                $active = 1;
            } else {
                $active = 0;
            }
        } else {
            $active = 0;
        }
        
        return $active;
    }
    /*
     * Return 1 if member exist
     * 
     * @param type $user_type
     * @param type $id
     * @param type $group_id
     * @return int     /
     */
    public static function ifWeChatMemberActive($user_type, $id, $group_id){
        
        $return = '';
        
        $details = UserGroup::select('phone_no')->where('id', $id)->first();
        
        $getCount = wechatMemberCount::select('id')
                ->where('group_id', $group_id)
                ->where(function ($query) use ($details) {
                    $query->where('member_name', $details->phone_no)
                          ->orWhere('member_number', $details->phone_no);
                })
                ->count();
        if($getCount > 0){
            $return = 1;
        }
        return $return;
        
        /*
        $return = '';
        if($user_type == 'CA'){
            $details = Cas::select('org_phone_no', 'phone_no')->where('id', $id)->first();
        } else {
            $details = Clients::select('org_phone_no', 'phone_no')->where('id', $id)->first();
        }
        
        
        $getCount = wechatMemberCount::select('id')->where('group_id', $group_id)
                ->where(function ($query) use ($details) {
                    $query->where('member_name', $details->org_phone_no)
                          ->orWhere('member_number', $details->org_phone_no);
                })->count();
        if($getCount > 0){
            $return = 1;
        }
        return $return;*/
    }
    public static function deleteRequestNumber($id){
        $num = '';
        $data = UpdateContact::select('existing_number')->where('id', $id)->first();
        if(!empty($data)){
            $num  = $data->existing_number;
        }
        return $num;
    }

    //get content by tag = key id-omkar
    public static function get_tagged_content($tagged_id){
        if(empty($tagged_id)){
            return null;
        }else{
            $res=DB::table('whatsapp')->select('*')->where('key_id',$tagged_id)->first();
            return $res;
//            foreach($res as $row){
//                return urldecode($row->msgcontent);
//            }
        }
    }
    //get content by tag = key id-omkar
    public static function get_tagged_name($whatsda){
        $msg_from = '';
        if ($whatsda->folder == 0) { // received
            $msg_from = urldecode($whatsda->contact_name);
        }
        if($msg_from == ""){
            $msg_from = self::getDeviceName($whatsda->device_id);
        }
        return $msg_from;
    }

    //get userame where phone no.
    public static function get_username($phone){
        if(empty($phone)){
            return null;
        }else{
            $res=DB::table('users')->select('id','name')->where('phone_no',$phone)->first();
            if($res == null){
                $res=DB::table('clients')->select('id','name','role_id')->where('phone_no',$phone)->first();
                if($res == null){
                    $res=DB::table('crp')->select('id','name','role_id')->where('phone_no',$phone)->first();
                    if($res !== null){
                        $res->role_name = 'Client Related';
                    }
                } else {
                    $res->role_name = 'Client';
                }
            } else {
                $userThis = User::find($res->id);

                $userRoles = isset($userThis->roles) ? $userThis->roles : '';
                $userRolesData = isset($userRoles[0]) ? $userRoles[0]: array();
                $roleId = isset($userRolesData->id) ? $userRolesData->id : '';
                $role_key = User::getTitleById($roleId);

                $res->role_name = isset($role_key->display_name) ? $role_key->display_name : '';
            }
            return $res;
        }
    }
    
    //get username and phone number  where user id.
    public static function get_rm_details($id){
        
        if(isset($id)){
            $res=DB::table('users')->select('name','phone_no')->where('id',$id)->first();
            return $res;
        }
    }
    
     public static function get_user_role($id){
        
        if(empty($id)){
            return null;
        }else{
            $res=DB::table('roles')->select('display_name')->where('id',$id)->first();
            return $res;
        }
    }

    //get user_id where phone no.
    public static function get_user_id($phone){
        if(empty($phone)){
            return null;
        }else{
            $res=DB::table('users')->select('id')->where('phone_no','+'.$phone)->first();
            
            if($res == null){
                
            }
            
            return $res;
        }
    }
    //get user_id where phone no.
    public static function getPartcipantIdByIdAndRole($id,$role){
        if($role == 6 || $role == "client"){
           $user = Clients::find($id); 
        } elseif($role == 7 || $role == "crp"){
            $user = Crps::find($id); 
        }else {
            $user = User::find($id); 
        }
        return $user;
    }
    /* 
     * Get the master user is from the user master
     * 
     * 
     */
    public static function getUserMaster($id,$role){
        
        $userMaster = UserMaster::Where("participant_id", $this_user_id)
                ->Where("role", $role)
                ->Where("is_active", 1)
                ->first();
        return $userMaster;
    }
    # $userGroup row from user_groups
    # userdata user_id
    public static function getReferenceIdForUserInGroup($userGroup,$type,$userData = []){
        
//        $userMaster = self::getUserMaster($id,$role);
        if($type == "offboard"){
           $referenceId = $userGroup->id; 
        } elseif($type == "onboard"){
//            $groupId = $userGroup->id;
//            $userData = $userData->user_id;
//            $role = $userData->role;
            $referenceId = isset($userData->user_group_id) ? $userData->user_group_id : 0;
            if($referenceId == 0){
                $referenceId = isset($userData["user_group_id"]) ? $userData["user_group_id"] : 0;
            }
            
        }
        
        return $referenceId;
    }


    public static function crp_clients_users_exitance($email,$gpn,$phone_no){
      $user_count=DB::table("users")->where("email",$email)->orWhere("gpn",$gpn)->orWhere("phone_no",$phone_no)->count();
        if($user_count==0){
          $client_count=DB::table("clients")->where("email",$email)->orWhere("gpn",$gpn)->orWhere("phone_no",$phone_no)->count();
            if($client_count==0){
              $crp_count=DB::table("crp")->where("email",$email)->orWhere("gpn",$gpn)->orWhere("phone_no",$phone_no)->count();
                if($crp_count==0){
                  return true;
                }
                else{
                  $email_count=DB::table("crp")->where("email",$email)->count();
                  if($email_count>0){
                    return "email";
                  }
                  $phone_count=DB::table("crp")->where("phone_no",$phone_no)->count();
                  if($phone_count>0){
                    return "phone_no";
                  }
                  $gpn_count=DB::table("crp")->where("gpn",$gpn)->count();
                  if($gpn_count>0){
                    return "gpn";
                  }
                }
            }
            else{
               $email_count=DB::table("clients")->where("email",$email)->count();
                if($email_count>0){
                  return "email";
                }
                $phone_count=DB::table("clients")->where("phone_no",$phone_no)->count();
                if($phone_count>0){
                  return "phone_no";
                }
                $gpn_count=DB::table("clients")->where("gpn",$gpn)->count();
                if($gpn_count>0){
                  return "gpn";
                }
            }
        }else{
          $email_count=DB::table("users")->where("email",$email)->count();
          if($email_count>0){
            return "email";
          }
          $phone_count=DB::table("users")->where("phone_no",$phone_no)->count();
          if($phone_count>0){
            return "phone_no";
          }
          $gpn_count=DB::table("users")->where("gpn",$gpn)->count();
          if($gpn_count>0){
            return "gpn";
          }
        }
    }
    
    //user,client , crp tables

    /*public static function crp_clients_users_exitance($email,$gpn,$phone_no,$group_id){
      $user_count=DB::table("users")->where("email",$email)->orWhere("gpn",$gpn)->orWhere("phone_no",$phone_no)->where("group_id",$group_id)->count();
        if($user_count==0){
          $client_count=DB::table("clients")->where("email",$email)->orWhere("gpn",$gpn)->orWhere("phone_no",$phone_no)->count();
            if($client_count==0){
              $crp_count=DB::table("crp")->where("email",$email)->orWhere("gpn",$gpn)->orWhere("phone_no",$phone_no)->count();
                if($crp_count==0){
                  return true;
                }
                else{
                  $email_count=DB::table("crp")->where("email",$email)->count();
                  if($email_count>0){
                    return "email";
                  }
                  $phone_count=DB::table("crp")->where("phone_no",$phone_no)->count();
                  if($phone_count>0){
                    return "phone_no";
                  }
                  $gpn_count=DB::table("crp")->where("gpn",$gpn)->count();
                  if($gpn_count>0){
                    return "gpn";
                  }
                }
            }
            else{
               $email_count=DB::table("clients")->where("email",$email)->count();
                if($email_count>0){
                  return "email";
                }
                $phone_count=DB::table("clients")->where("phone_no",$phone_no)->count();
                if($phone_count>0){
                  return "phone_no";
                }
                $gpn_count=DB::table("clients")->where("gpn",$gpn)->count();
                if($gpn_count>0){
                  return "gpn";
                }
            }
        }else{
          $email_count=DB::table("users")->where("email",$email)->count();
          if($email_count>0){
            return "email";
          }
          $phone_count=DB::table("users")->where("phone_no",$phone_no)->count();
          if($phone_count>0){
            return "phone_no";
          }
          $gpn_count=DB::table("users")->where("gpn",$gpn)->count();
          if($gpn_count>0){
            return "gpn";
          }
        }
    }*/

    //user,client , crp tables without gpn
    public static function crp_clients_users_exitance_without_gpn_email($phone_no){
       $user_count=DB::table("users")->where("phone_no",$phone_no)->count();
        if($user_count==0){
          $client_count=DB::table("clients")->where("phone_no",$phone_no)->count();
            if($client_count==0){
              $crp_count=DB::table("crp")->where("phone_no",$phone_no)->count();
                if($crp_count==0){
                  return true;
                }
                else{
                  $phone_count=DB::table("crp")->where("phone_no",$phone_no)->count();
                  if($phone_count>0){
                    return "phone_no";
                  }
                }
            }
            else{
                $phone_count=DB::table("clients")->where("phone_no",$phone_no)->count();
                if($phone_count>0){
                  return "phone_no";
                }
            }
        }else{
          $phone_count=DB::table("users")->where("phone_no",$phone_no)->count();
          if($phone_count>0){
            return "phone_no";
          }
        }
    }

    //for crp validation exitance check in user and client table
     public static function clients_users_exitance($email,$gpn,$phone_no){
      $user_count=DB::table("users")->where("email",$email)->orWhere("gpn",$gpn)->orWhere("phone_no",$phone_no)->count();
        if($user_count==0){
          $client_count=DB::table("clients")->where("email",$email)->orWhere("gpn",$gpn)->orWhere("phone_no",$phone_no)->count();
            if($client_count==0){
               return true;
            }
            else{
               $email_count=DB::table("clients")->where("email",$email)->count();
                if($email_count>0){
                  return "email";
                }
                $phone_count=DB::table("clients")->where("phone_no",$phone_no)->count();
                if($phone_count>0){
                  return "phone_no";
                }
                $gpn_count=DB::table("clients")->where("gpn",$gpn)->count();
                if($gpn_count>0){
                  return "gpn";
                }
            }
        }else{
          $email_count=DB::table("users")->where("email",$email)->count();
          if($email_count>0){
            return "email";
          }
          $phone_count=DB::table("users")->where("phone_no",$phone_no)->count();
          if($phone_count>0){
            return "phone_no";
          }
          $gpn_count=DB::table("users")->where("gpn",$gpn)->count();
          if($gpn_count>0){
            return "gpn";
          }
        }
    }

    public static function getPhoneNumberUpdate($old_no, $current_no){
        $user_type = "";
        $user_id = 0;
        $user_name = "";
        $getUser = DB::table("users")
                ->Where("phone_no",$old_no)
                ->first(array("name","id","phone_no"));
        
        if(!empty($getUser)){
            $user_type = "user";
            $user_id = isset($getUser->id) ? $getUser->id : 0;
            $user_name = isset($getUser->name) ? $getUser->name : 0;
            $update = DB::table("users")
                    ->Where("phone_no",$old_no)
                    ->update(["phone_no" => $current_no, "old_phone_no" => $old_no]);
            \Log::info("change users contact...");
        } else {
            $getClients = DB::table("clients")
                    ->Where("phone_no",$old_no)
                    ->first(array("name","id","phone_no"));
            if(!empty($getClients)){
                $user_type = "client";
                $user_id = isset($getClients->id) ? $getClients->id : 0;
                $user_name = isset($getClients->name) ? $getClients->name : 0;
                $update = DB::table("clients")
                        ->Where("phone_no",$old_no)
                        ->update(["phone_no" => $current_no, "old_phone_no" => $old_no]);
                \Log::info("change clients contact...");
            } else {
                $getCrps = DB::table("crp")
                        ->Where("phone_no",$old_no)
                        ->first(array("name","id","phone_no"));
                if(!empty($getCrps)){
                    $user_type = "crp";
                    $user_id = isset($getCrps->id) ? $getCrps->id : 0;
                    $user_name = isset($getCrps->name) ? $getCrps->name : 0;
                    $update = DB::table("crp")
                            ->Where("phone_no",$old_no)
                            ->update(["phone_no" => $current_no, "old_phone_no" => $old_no]);
                    \Log::info("change crps contact...");
                }
            }
        }
        $update = DB::table("user_groups")->Where("phone_no",$old_no)->update(["phone_no" => $current_no]);
        if($user_id > 0){
            
            # request create contact...
            $getUgData = UserGroup::where('phone_no', trim($current_no))->first(array(
                "id", "user_id", "agreed_im", "group_id"));
            
            $updateUm = DB::table("user_master")->Where("phone_no",$old_no)
                    ->update(["phone_no" => $current_no]);
            
            if(isset($getUgData->group_id)){
                
                $usergroupId = $getUgData->id;
                $ugGroupId = $getUgData->group_id;
                $imType = "Whatsapp";
                if(strtolower($getUgData->agreed_im) == "wechat"){
                    $imType = "WeChat";
                }
                $req = RequestOps::insert(array(
                        'type' => "create_contact_client",
                        'vm_id' => NULL,
                        'reference_id' => $usergroupId,
                        'agreed_im' => $imType,
                        'status' => 0,
                        'related_group_id' => $ugGroupId,
                        'created_at' => date("Y-m-d H:i:s")
                    ));
                
            }
            
        }
        # store contact log...
        $CN_contact_detail_logg = array(
            'type' => $user_type, // "crp", "client", "user"
            'name' => $user_name, // name 
//            'user_id' => $user_id,
            'new_number' => trim($current_no), // new number
            'existing_number' => $old_no, // old number
            'reference_id' => $user_id, // id of client/user/crp
            'status' => 1, // status
            'validation_comment' => $user_type . "-" . $user_name . " change no", // comment
            'created_at' => date('Y-m-d H:i:s')
        );
        $update = UpdateContact::insert($CN_contact_detail_logg);
        
    }


    //get name where behalf of user id.
    public static function get_username_by_user_id($user_id){
        if(empty($user_id)){
            return null;
        }else{
            $res=DB::table('users')->select('name')->where('id',$user_id)->first();
            if($res == null){
                $res=DB::table('clients')->select('name')->where('name',$user_id)->first();
                if($res == null){
                    $res=DB::table('crp')->select('name')->where('name',$user_id)->first();
                    if($res !== null){
                        $res->role_name = 'Client Related';
                    }
                } else {
                    $res->role_name = 'Client';
                }
            }
            return $res;
        }
    }

    //data transfer user_groups table to remove_user_logs
     public static function user_groups_transfer_remove_group_logs($user_group_id,$phone_no = NULL, $updated_by = NULL, $status = NULL){
        
//        \Log::info("Log things ==".$user_group_id.' '.$phone_no);
        
        $row = UserGroup::where("id",$user_group_id)->first();
        if(isset($row->group_id)){
//            foreach($users_data as $row){
                $group_id_value=$row->group_id_value;
                $group_id=$row->group_id;
                $user_id=$row->user_id;
                $master_user_id=$row->master_user_id;
                if($phone_no == NULL){
                    $phone_no=$row->phone_no;
                }
                if($updated_by == NULL){
                    $updated_by=$row->updated_by;
                }
                if($status == NULL){
                    $status= 11;
                    $status=$row->status;
                }
                $role=$row->role;
//                $status=$row->status;
                $is_admin=$row->is_admin;
                $agreed_im=$row->agreed_im;
//                $updated_by=$row->updated_by;
                $assigned_by=$row->assigned_by;
//            }
            //inset into remove_user_table
            $data=array(
                "user_group_id"=>$user_group_id,
                "group_id"=>$group_id,
                "group_id_value"=>$group_id_value,
                "user_id"=>$user_id,
                "master_user_id"=>$master_user_id,
                "phone_no"=>$phone_no,
                "role"=>$role,
                "status"=>$status,
                "isadmin"=>$is_admin,
                "agreed_im"=>$agreed_im,
                "updated_by"=>$updated_by,
                "assigned_by"=>$assigned_by,
                "assigned_at"=>date('Y-m-d H:i:s'),
            );
            DB::table("remove_user_logs")->insert($data);
        }
     }

     //get name behalf of user_id and role

      public static function get_name($user_id,$role){
            $name='';
            if($role==3 || $role==5 || $role==10){
                $res=DB::table('users')->select('name')->where('id',$user_id)->first();
             $name=isset($res->name)?$res->name:"-";
            }
            else if($role==6){
                $res=DB::table('clients')->select('name')->where('id',$user_id)->first();
                $name=isset($res->name)?$res->name:"-";
            }
            else if($role==7){
                $res=DB::table('crp')->select('name')->where('id',$user_id)->first();
                $name=isset($res->name)?$res->name:"-";
            }
        return $name;
    }
    
    /*
     * reset message 
     * 
     */
    public static function resetWelcomeMessage($group_id){
        
        \Log::info('-----------resetWelcomeMessage a------');
        \Log::info($group_id);
        \Log::info('-----------resetWelcomeMessage a------');
        $status = 0;
        $isConf = Config("app.put_messages_from_ops_in_wechat",0);
        if($isConf == 1){
            $status = "Request processed. Verfication pending";
        }
        $reqUp = RequestOps::where('related_group_id',$group_id)
                 ->where('type','send_message')
                 ->where('status',0)
                 ->where('msg_related_with','group_welcome_msg')
                 ->update(['status'=> $status]);
    }
    
    /*
     * reset message 
     * 
     */
    public static function updateWechatId($reference_id, $wechat_id){
        
        $data = UserGroup::where('id', $reference_id)
                ->first(array("user_id", "role"));
        if(isset($data->user_id)){
            if($data->role == 6){
                
                $data = Clients::where('id', $data->user_id)
                ->update(['wechat_id' => $wechat_id]);
                
            }elseif($data->role == 7){
                
                $data = Crps::where('id', $data->user_id)
                ->update(['wechat_id' => $wechat_id]);
                
            }else{ 
                
                $data = User::where('id', $data->user_id)
                ->update(['wechat_id' => $wechat_id]);
                
            }
        }
        
    }

    /*get user role*/
    public static function get_user_role_by_id($user_id){
        $role=DB::table("role_user")->select("role_id")->where("user_id",$user_id)->first();
        return isset($role)?$role->role_id:false;
    }

    public static function chat_display_auth($date){
      //code 
    }

/*
    * Get Text amd Media limit and send to APK 
    * 
    */
   public static function getSendingLimitValue($limitType){
      
      $textLimit = Settings::select('value')->where('event', $limitType)->first(array("value"));
      $limit = isset($textLimit->value) ? $textLimit->value : 0;
      return $limit;
   } 

/*
    * Get Text amd Media limit and send to APK 
    * 
    */
   public static function getSendingLimit(){
      $value = [];
      $textLimit = Settings::select('value')->where('event', 'text_limit')->first();
      $mediaLimit = Settings::select('value')->where('event', 'media_limit')->first();
      $value['text_limt'] = isset($textLimit['value']) ? $textLimit['value'] : 100;
      $value['media_limit'] = isset($mediaLimit['value']) ? $mediaLimit['value'] : 1;
      return $value;
   }

   /*insert data into user_in_out_table*/
   public static function user_in_out($platform,$in_out,$device_id,$key,$related_id,$msg_content=""){

    /*whatsapp block*/
    if($platform=="whatsapp"){

        $data=["device_id"=>$device_id,"related_id"=>$related_id,"in_whatsapp_key"=>$key,"platform"=>$platform,"join_datetime"=>date('Y-m-d H:i:s')];

        /*create new group in wechat*/
        if($in_out=="new_group"){
            self::new_group_user_in_userinout($related_id,$key,$device_id,$data);
        }

        /*when added in wechat group*/
        if($in_out=="added"){
            self::added_user_in_userinout($msg_content,$related_id,$key,$device_id,$data);
        }

        /*user remove from wechat group*/
        if($in_out=="removed"){
            self::remove_user_key_update_userinout($msg_content,$related_id,$key,$device_id);
        }

        /*left from group of wechat*/
        if($in_out=="left"){
            self::left_user_key_update_userinout($msg_content,$related_id,$key,$device_id);
        }

    }

    /*for WeChat block*/
    if($platform=="wechat"){

        $data=["device_id"=>$device_id,"related_id"=>$related_id,"in_whatsapp_key"=>$key,"platform"=>$platform,"join_datetime"=>date('Y-m-d H:i:s')];
        
        /*create new group in wechat*/
        if($in_out=="new_group"){
            self::new_group_user_in_userinout($related_id,$key,$device_id,$data);
        }

        /*when added in wechat group*/
        if($in_out=="added"){
            self::added_user_in_userinout($msg_content,$related_id,$key,$device_id,$data);
        }

        /*user remove from wechat group*/
        if($in_out=="removed"){
            self::remove_user_key_update_userinout($msg_content,$related_id,$key,$device_id);
        }

        /*left from group of wechat*/
        /*if($in_out=="left"){
            self::left_user_key_update_userinout($msg_content,$related_id,$key,$device_id);
        }*/
    }

   }


   /*
   --remove user key update in user_in_out table--
   */
   private static function new_group_user_in_userinout($related_id,$key,$device_id,$data){
        $user_group_data=DB::table("user_groups")
        ->select("user_id","role")
        ->where("group_id_value",$related_id)
        ->where("status",1)
        ->whereIn("role",[3,5,10])
        ->get();
        $key_not_exists=DB::table("user_in_out")->where("in_whatsapp_key",$key)->exists();
        //\Log::info("New Group function for Insertion1----");
        if($key_not_exists===false){
            //\Log::info("New Group function for Insertion2----");
            foreach($user_group_data as $user_row){
                $user_id=isset($user_row->user_id)?$user_row->user_id:"";
                $user_role=isset($user_row->role)?$user_row->role:"";
                if(!empty($user_id) || !empty($user_role)){
                    $data=array_merge($data,array("user_id"=>$user_id,"user_role"=>$user_role));
                     DB::table("user_in_out")->insert($data);
                }
            } 
        }
   }
    /*
   --remove user key update in user_in_out table--
   */
   private static function added_user_in_userinout($msg_content,$related_id,$key,$device_id,$data){
        $msg_content=urldecode($msg_content);
        $added_no=preg_replace("/[^+0-9]/", '', $msg_content);
        $split_no=explode("+", $added_no);
        $added_user_no="+".end($split_no);
        
        $added_user=DB::table("user_groups")
        ->select("user_id","role")
        ->where("group_id_value",$related_id)
        ->where("status",1)
        ->whereIn("role",[3,5,10])
        ->where("phone_no",$added_user_no)
        ->first();
        $user_id=isset($added_user->user_id)?$added_user->user_id:"";
        $user_role=isset($added_user->role)?$added_user->role:"";
        if(!empty($user_id) || !empty($user_role)){
         
            $data=array_merge($data,array("user_id"=>$user_id,"user_role"=>$user_role));
            
            $key_not_exists=DB::table("user_in_out")->where("in_whatsapp_key",$key)->exists();

            if($key_not_exists===false){
                DB::table("user_in_out")->insert($data);
            }
        }
   }

   /*
   --remove user key update in user_in_out table--
   */
   private static function remove_user_key_update_userinout($msg_content,$related_id,$key,$device_id){

        $msg_content=urldecode($msg_content);
        $left_no=preg_replace("/[^+0-9]/", '', $msg_content);
        $split_no=explode("+", $left_no);
        $left_user_no="+".end($split_no);

        $left_user=DB::table("user_groups")
        ->select("user_id","role")
        ->where("group_id_value",$related_id)
        ->whereIn("role",[3,5,10])
        ->where("status",11)
        ->where("phone_no",$left_user_no)
        ->first();
        $user_id=isset($left_user->user_id)?$left_user->user_id:"";
        $user_role=isset($left_user->role)?$left_user->role:"";
        
        if(!empty($user_id) || !empty($user_role)){
            /*udate user_in_out table*/
            DB::table("user_in_out")
            ->where("device_id",$device_id)
            ->where("related_id",$related_id)
            ->where("user_id",$user_id)
            ->where("user_role",$user_role)
            ->whereNull("out_whatsapp_key")
            ->update(["out_whatsapp_key"=>$key,"left_datetime"=>date('Y-m-d H:i:s')]);
        }
   }

   /*
   --left user key update in user_in_out table--
   */
   private static function left_user_key_update_userinout($msg_content,$related_id,$key,$device_id){
        $msg_content=urldecode($msg_content);
            $left_user_no=preg_replace("/[^+0-9]/", '', $msg_content);

        $left_user=DB::table("user_groups")
        ->select("user_id","role")
        ->where("group_id_value",$related_id)
        ->whereIn("role",[3,5,10])
        ->where("status",11)
        ->where("phone_no",$left_user_no)
        ->first();
        $user_id=isset($left_user->user_id)?$left_user->user_id:"";
        $user_role=isset($left_user->role)?$left_user->role:"";
        if(!empty($user_id) || !empty($user_role)){
            /*udate user_in_out table*/
            DB::table("user_in_out")
            ->where("device_id",$device_id)
            ->where("related_id",$related_id)
            ->where("user_id",$user_id)
            ->where("user_role",$user_role)
            ->whereNull("out_whatsapp_key")
            ->update(["out_whatsapp_key"=>$key,"left_datetime"=>date('Y-m-d H:i:s')]);
        }
   }


   public static function getBetweenCounting($in,$out){
        $counting=[];
        if(is_array($in) && is_array($out)){
            $in_count=count($in);
            $out_count=count($out);
            if($in_count==$out_count){
                for($j=0;$j<$in_count;$j++){
                   for($i=$in[$j];$i<$out[$j];$i++){
                        $counting[]=$i;
                    }
                }
            }
        }
        return $counting;
    }

    public static function user_int_out_data($currentUserId,$platform,$related_id=""){
        $user_in_out_data="";
        if(!empty($currentUserId)){

            $role=$role = self::get_user_role_by_id($currentUserId);
            if(in_array($role,[3,5])){
                $user_in_out_data_check=DB::table("user_in_out")
                ->where("user_id",$currentUserId)
                //->whereIn("user_role",[3,5,10])
                ->whereNotNull("out_whatsapp_key")
                ->where("platform",$platform);
                if(in_array($role,[3,5,10])){
                        $user_in_out_data_check=$user_in_out_data_check->where("user_role",$role);
                        if(is_array($related_id)){
                            //if(count($related_id)>0){
                                $user_in_out_data_check=$user_in_out_data_check->whereIn("related_id",$related_id);
                            //}
                        }else{
                            //if(!empty($related_id)){
                                $user_in_out_data_check=$user_in_out_data_check->where("related_id",$related_id);
                            //}
                        }

                    }
                $user_in_out_data_check_f=$user_in_out_data_check->exists();
                if($user_in_out_data_check_f){
                    $user_in_out_data=DB::table("user_in_out")
                    ->select("in_whatsapp_key","out_whatsapp_key","related_id")
                    ->where("user_id",$currentUserId)
                    ->whereNotNull("out_whatsapp_key")
                    ->where("user_role",$role)
                    ->where("platform",$platform);
                    if(is_array($related_id)){
                            if(count($related_id)>0){
                                $user_in_out_data=$user_in_out_data->whereIn("related_id",$related_id);
                            }
                        }else{
                            if(!empty($related_id)){
                                $user_in_out_data=$user_in_out_data->where("related_id",$related_id);
                            }
                        }
                    // ->where('join_datetime', '>=', $from." 00:00:00")
                    // ->where('left_datetime', '<=', $to." 23:59:59")
                    $final_data=$user_in_out_data->get();
                    return $final_data;
                }
            } 
        }
        
    }

    public static function user_in_only($currentUserId,$platform,$related_id="",$last_key=""){

        if(!empty($currentUserId)){
            $role=$role = self::get_user_role_by_id($currentUserId);
            if(in_array($role,[3,5])){
                //user in from data
                    $after_last_out_first_key=DB::table("user_in_out")
                    ->select("in_whatsapp_key")
                    ->whereNull("out_whatsapp_key")
                    ->whereNotNull("in_whatsapp_key");
                    if(!empty($last_key)){
                        $after_last_out_first_key->where("in_whatsapp_key",">",$last_key);
                    }
                    
                    $after_last_out_first_key->where("user_id",$currentUserId);
                    if(in_array($role,[3,5,10])){
                       $after_last_out_first_key=$after_last_out_first_key->where("user_role",$role);
                       if(is_array($related_id)){
                            if(count($related_id)>0){
                                $after_last_out_first_key=$after_last_out_first_key->whereIn("related_id",$related_id);
                            }
                        }else{
                            if(!empty($related_id)){
                                $after_last_out_first_key=$after_last_out_first_key->where("related_id",$related_id);
                            }
                        }    
                    }
                    $form_entry=$after_last_out_first_key->where("platform",$platform)->first();

                    $in_whatsapp_key=isset($form_entry->in_whatsapp_key)?$form_entry->in_whatsapp_key:null;

                return $in_whatsapp_key;    
            }
        }
    }

   /*
    * Get the bot number of VM 
    * 
    */
   public static function getImBotNumber($vmDetails,$agreed_im){
       
        if(strtolower($agreed_im) == "whatsapp"){
            $bot_number = isset($vmDetails->whatsapp_bot_no) ? $vmDetails->whatsapp_bot_no : "-";//$field = "whatsapp_bot_no";
        } elseif(strtolower($agreed_im) == "wechat") {
            $bot_number = isset($vmDetails->wechat_bot_no) ? $vmDetails->wechat_bot_no : "-";//$field = "whatsapp_bot_no";//$field = "wechat_bot_no";
        }
        return $bot_number;
        
   }



   /*get group base column name*/
   public static function get_group_base_column($group_id,$text){

    if(!empty($group_id)){

        if(preg_match("/^[+0-9]+$/",$text)){
            $text=trim($text,"+");
        }
        $regExp=0;
        $data=str_split($text);
        $data=array_unique($data);
        if(in_array("%",$data) || in_array("_",$data)){
                $regExp=1;
        }

        $data_check=DB::table("user_groups")->select("user_id","role")->where("group_id_value",$group_id)->count();

        if($data_check>0){
            
            $data=DB::table("user_groups")->select("user_id","role")->where("group_id_value",$group_id)->get();
            
            /*$name_match=[];
            $phone_no_match=[];
            $email_match=[];
            $gpn_match=[];*/

            foreach ($data as $key => $value) {
                /*user name,email,gpn,phone_no matching*/
                if(in_array($value->role,[3,5,10])){

                    //username match
                    if($regExp==1){
                    $user_name_match=DB::table("users")
                    ->where('name', "REGEXP","$text")
                    ->first();
                    }else{
                    $user_name_match=DB::table("users")
                    ->where('name', "like","%$text%")
                    ->first();
                    }
                    $user_name=isset($user_name_match->name)?$user_name_match->name:null;
                    $msg= $user_name;

                    if($user_name==null){
                        //user phone_no match
                        if($regExp==1){
                             $user_phone_no_match=DB::table("users")->where('phone_no', "REGEXP","$text")->first();
                        }else{
                            $user_phone_no_match=DB::table("users")->where('phone_no', "LIKE","%$text%")->first();
                        }
                        $user_phone=isset($user_phone_no_match->phone_no)?$user_phone_no_match->phone_no:null;
                        $msg= $user_phone;

                        if($user_phone==null){
                            //user gpn match
                        $user_gpn_match=DB::table("users")->where('gpn', $text)->first();

                             $user_gpn=isset($user_gpn_match->gpn)?$user_gpn_match->gpn:null;
                             
                             $msg= $user_gpn;

                            if($user_gpn==null){
                                
                                //user email match
                                $user_email_match=DB::table("users")->where('email', $text)->first();
                                $user_email=isset($user_email_match->email)?$user_email_match->email:null;
                                $msg= $user_email;

                                if($user_email==null){
                                    $msg= "Group Name";
                                }
                            }
                        }
                    }
                              
                }
                /*user name,email,gpn,phone_no matched*/

                /*clients name,email,gpn,phone_no matching*/
                if($value->role==6){

                    //username match
                    if($regExp==1){
                         $user_name_match=DB::table("clients")
                    ->where('name', "REGEXP","$text")
                    ->first();
                    }else{
                    $user_name_match=DB::table("clients")
                    ->where('name', "like","%$text%")
                    ->first();
                    }
                    $user_name=isset($user_name_match->name)?$user_name_match->name:null;
                    $msg= $user_name;

                    if($user_name==null){
                        //user phone_no match
                        if($regExp==1){
                            $user_phone_no_match=DB::table("clients")->where('phone_no', "REGEXP","$text")->first();
                        }
                        else{
                        $user_phone_no_match=DB::table("clients")->where('phone_no', "LIKE","%$text%")->first();
                         }
                        $user_phone=isset($user_phone_no_match->phone_no)?$user_phone_no_match->phone_no:null;
                        $msg= $user_phone;

                        if($user_phone==null){
                            //user gpn match
                        $user_gpn_match=DB::table("clients")->where('gpn', $text)->first();

                             $user_gpn=isset($user_gpn_match->gpn)?$user_gpn_match->gpn:null;
                             $msg= $user_gpn;

                            if($user_gpn==null){
                                
                                //user email match
                                $user_email_match=DB::table("clients")->where('email', $text)->first();
                                $user_email=isset($user_email_match->email)?$user_email_match->email:null;
                                $msg= $user_email;
                                
                                if($user_email==null){
                                    $msg= "Group Name";
                                }
                            }
                        }
                    }    
                }
                /*clients name,email,gpn,phone_no matched*/


                /*crp name,email,gpn,phone_no matching*/
                if($value->role==7){

                    //username match
                    if($regExp==1){
                        $user_name_match=DB::table("crp")
                    ->where('name', "REGEXP","$text")
                    ->first();
                    }else{
                      $user_name_match=DB::table("crp")
                    ->where('name', "like","%$text%")
                    ->first();  
                    }
                    
                    $user_name=isset($user_name_match->name)?$user_name_match->name:null;
                    $msg= $user_name;

                    if($user_name==null){
                        //user phone_no match
                         if($regExp==1){
                            $user_phone_no_match=DB::table("crp")->where('phone_no', "REGEXP","$text")->first();
                         }else{
                            $user_phone_no_match=DB::table("crp")->where('phone_no', "LIKE","%$text%")->first();
                        }
                        $user_phone=isset($user_phone_no_match->phone_no)?$user_phone_no_match->phone_no:null;
                        $msg= $user_phone;

                        if($user_phone==null){
                            //user gpn match
                        $user_gpn_match=DB::table("crp")->where('gpn', $text)->first();

                             $user_gpn=isset($user_gpn_match->gpn)?$user_gpn_match->gpn:null;
                             
                             $msg= $user_gpn;

                            if($user_gpn==null){
                                
                                //user email match
                                $user_email_match=DB::table("crp")->where('email', $text)->first();
                                $user_email=isset($user_email_match->email)?$user_email_match->email:null;
                                
                                $msg= $user_email;
                                
                                if($user_email==null){
                                    $msg= "Group Name";
                                }
                            }
                        }
                    }      
                }
                /*crp name,email,gpn,phone_no matched*/

            }
            /*foreach end*/
            return $msg;
        }
        
    }
    
   }

   /*get last key when arm | rm is in group*/
   /*get data from where whatsapp_key not null but whatsapp_out_key null*/
   public static  function get_last_key_from_table($platform,$related_id){
        if(is_array($related_id)){
            $related_id=end($related_id);
        }
        if(!empty($platform)){
            
            $last_key=null;

            if($platform=="whatsapp"){
                
                $query=Whatsapp::select("whatsapp_key");
                if(!empty($related_id)){
                    //if(count($related_id)>0){
                     $query->whereIn("related_id",[$related_id]);
                    //}
                }
                $query->orderBy("whatsapp_key","DESC");
                $final_data=$query->first();

                $last_key=isset($final_data->whatsapp_key)?$final_data->whatsapp_key:null;
            }
            /*wechat*/
            if($platform=="wechat"){
                
                $query=WeChat::select("wechat_key");
                if(!empty($related_id)){
                    $query->whereIn("related_id",[$related_id]);
                }
                $query->orderBy("wechat_key","DESC");
                $final_data=$query->first();

                $last_key=isset($final_data->wechat_key)?$final_data->wechat_key:null;
            }

            if($last_key!==null){
                return $last_key;
            }
        }
   }
    /*
     * Onboard the client if group creation fails
     *
     */
    public static function onboardContactIfFailesInGroupCreation($data){

//        \Log::info("Response fromm ops");
//        \Log::info("OPS NO response.........");
//        \Log::info($data);
        if(!isset($data['numbersNotExist'])){
            $data['numbersNotExist'] = 'null';
        }
        if($data['numbersNotExist'] == "" || $data['numbersNotExist'] == 'null' || $data['numbersNotExist'] == null){
            
        } else {
            
            \Log::info("onboardContactIfFailesInGroupCreation fromm ops");
//            \Log::info($data);
            // client_party_number
            $numbers_not_found = $data['numbersNotExist'];
            $numbers_not_found_arr = explode(",",$numbers_not_found);
//            \Log::info($numbers_not_found);
//            \Log::info($numbers_not_found_arr);
            // block message request...
                $reqObj = RequestOps::where('id', $data['ref'])->first();
                $rel_grp_id = isset($reqObj->related_group_id) ? $reqObj->related_group_id : '';

                $msgStat = isset($data['messageStatus']) ? $data['messageStatus'] : 'true';
                if($msgStat == 'false'){ 
                    $reqObj = RequestOps::where('related_group_id', $rel_grp_id)
                            ->Where("msg_related_with","group_welcome_msg")
                            ->update(["status" => 200]);
//                    \Log::info($data['ref']."Message status".'false'. "200" . $reqObj);
                }
//                \Log::info($msgStat.'-----------------');
                

//                \Log::info($reqObj);
//                \Log::info($rel_grp_id);

                $grpData = Caclients::find($rel_grp_id);

//                \Log::info($grpData);
                foreach($numbers_not_found_arr as $num){
                    $num = trim($num);
                    if(trim($num) != "" && $num != "+"){

                        if( strpos( $num, "+" ) === false ) {
                            $num = "+".$num;
                        }
//                        \Log::info($num);
                        $valueUsrGrp = UserGroup::select('id', 'phone_no', 'user_id', 'role')
                                    ->where('group_id', $rel_grp_id)
                                    ->where('phone_no', ($num))
                                    ->first();
//                        \Log::info($valueUsrGrp);
                        if(isset($valueUsrGrp->id)){
                            
                            $checkPreviousCount = RequestOps::where('type', 'onboarding')
                                    ->where('related_group_id', $rel_grp_id)
                                    ->where('reference_id', $valueUsrGrp->id)
                                    ->count();
                            if($checkPreviousCount == 0){
                                $res["user_group_id"] = $valueUsrGrp->id;
                                $msgOpt = "false";
                                if($valueUsrGrp->role == 6 || $valueUsrGrp->role == 7){
                                    $msgOpt = "true";
                                }
                                $onBoard = UserHelper::onBoardRequest($grpData, $res, $msgOpt);  
                                \Log::info("Onboard req for fake no...");
                                $valueUsrGrpUpd = UserGroup::where('group_id', $rel_grp_id)
                                    ->where('phone_no', ($num))
                                    ->update(["status" => 0]);
                            }
                        }

                    }

                }
                $created_groups = Caclients::where('id', $rel_grp_id)
                ->update(['is_new' => 1]); 
                \Log::info("onboardContactIfFailesInGroupCreation fromm ops");
        }
    }

    /*
     * Send WeChat QR code to the user to add into its WeChat contact list
     *
     */
    public static function sendWechatQRCode($email, $phone_no) {

        $admin_email_id = Config::get('app.mail_from_address'); // 'DBSeAdvice@dbs.chat';
        //$admin_email_id = 'reallyalok@gmail.com';
        $from_name = Config::get('app.mail_from_name'); // 'DBS';
        $to = $email;
        $to_name = $email;
        /*$template = array(
            // type => folder name
            'create_user' => 'Create User',
            'chat_group_create_confirmation' => 'Chat Group Creation Authorization',
            'wechat' => 'wechat',
            'line' => 'line'
        );
        $role_type = array(
            'system_admin' => 'System Admin',
            'ops_manager' => 'OPS Manager'
        );*/
        /*$content = array();
        $content['message'] = $dta['content'];
        $content['RMname'] = $dta['RMname'];
        $content['RMnumber'] = $dta['RMnumber'];
        $content['Clientname'] = $dta['Clientname'];
//        $content['Clientnumber'] = $dta['Clientnumber'];
        $content['DBSbotnumber'] = $dta['DBSbotnumber'];
        $content['forhiturl'] = $dta['forhiturl'];
        $content['agreed_im'] = $dta['agreed_im'];
        $content['rmrole'] = $dta['rmrole'];
        $content['name'] = $name;
        $content['template'] = $template[$email_template];*/
        //die;
        $vmDeviceObj = DB::table("vm_devices")
                        ->whereNotNull("wechat_qr_file_name")
                        ->first(array("id","wechat_qr_file_name","wechat_bot_no","vm_id"));

        $subject = "FinChat : Request to add Chat Agent to your WeChat contact list";

        $mconfig = config('constants.mail');
        $attachments =[];
        $email_type = "add_wechat_friend";
        
        $content['wechatQr'] = isset($vmDeviceObj->wechat_qr_file_name) ? $vmDeviceObj->wechat_qr_file_name : '';
        $content['wechat_bot_no'] = isset($vmDeviceObj->wechat_bot_no) ? $vmDeviceObj->wechat_bot_no : '';
        $content['wechat_phone_no'] = $phone_no;
        
        if($mconfig['is_auth']==true){ 
           self::phpmailerWithAuth($to, $to_name, $subject, $content, $mconfig['driver'], $mconfig['host'], $mconfig['port'], $mconfig['encryption'], $mconfig['username'], $mconfig['password'], $mconfig['from_name'], $mconfig['from_address'],$attachments, $email_type); 
        } else { //echo '3';
           self::phpmailerWithNoAuth($to, $to_name, $subject, $content, $mconfig['driver'], $mconfig['host'], $mconfig['port'], $mconfig['from_name'], $mconfig['from_address'],$attachments, $email_type); 
        }

        // check for failures
        if (count(Mail::failures()) > 0) {
            return false;
        } else {
            $message = '';
            return true;

        }
    }
    /*Vm information table send*/
    public static function sendNotifyMail($name, $email, $data) {

        $admin_email_id = Config::get('app.mail_from_address'); // 'DBSeAdvice@dbs.chat';
        //$admin_email_id = 'reallyalok@gmail.com';
        $from_name = Config::get('app.mail_from_name'); // 'DBS';
        $to = $email;
        $to_name = $name;
        /*$template = array(
            // type => folder name
            'create_user' => 'Create User',
            'chat_group_create_confirmation' => 'Chat Group Creation Authorization',
            'wechat' => 'wechat',
            'line' => 'line'
        );
        $role_type = array(
            'system_admin' => 'System Admin',
            'ops_manager' => 'OPS Manager'
        );*/
        /*$content = array();
        $content['message'] = $dta['content'];
        $content['RMname'] = $dta['RMname'];
        $content['RMnumber'] = $dta['RMnumber'];
        $content['Clientname'] = $dta['Clientname'];
//        $content['Clientnumber'] = $dta['Clientnumber'];
        $content['DBSbotnumber'] = $dta['DBSbotnumber'];
        $content['forhiturl'] = $dta['forhiturl'];
        $content['agreed_im'] = $dta['agreed_im'];
        $content['rmrole'] = $dta['rmrole'];
        $content['name'] = $name;
        $content['template'] = $template[$email_template];*/
        //die;
        $content = array();
        foreach($data as $key=>$value){
            $content[$key]=$value;
        }
        $subject = "Alert: FinChat/Collaboration Android Emulator(s) Inactive on WIndows server";

        $mconfig = config('constants.mail');
        $attachments =[];
        $email_type = "vm_notify";


        if($mconfig['is_auth']==true){ 
           $mail = self::phpmailerWithAuth($to, $to_name, $subject, $content, $mconfig['driver'], $mconfig['host'], $mconfig['port'], $mconfig['encryption'], $mconfig['username'], $mconfig['password'], $mconfig['from_name'], $mconfig['from_address'],$attachments, $email_type); 
        } else { //echo '3';
           $mail = self::phpmailerWithNoAuth($to, $to_name, $subject, $content, $mconfig['driver'], $mconfig['host'], $mconfig['port'], $mconfig['from_name'], $mconfig['from_address'],$attachments, $email_type); 
        }

        // check for failures
//                if (count(Mail::failures()) > 0) {
        if ($mail == true) {
            \Log::info("Notify VM failed.....");
            return false;
        } else {

            \Log::info("Notify VM sent.....");
            $message = '';
            return true;
        }
    }

    /**
     * This will display bot numbers in ui
     * 
     * @return mixed
     */
    public static function getDeviceNameFromId($device_id){

        $key = 'device-name-'.$device_id;
        $minutes = 120;

        //         check if value exist in cache
        if (Cache::has($key)) {
           // use cache value
           $toUser = Cache::get($key);
        }else{
        //             if value is not in cache
            $data = User_device::select('id','vm_name')
                    ->where('vm_id', $device_id)
                    ->first();
            $toUser = isset($data["vm_name"]) ? $data["vm_name"] : 'User Device';
            Cache::add($key, $toUser, $minutes);
        }
        return $toUser;
    }
    /**
     * This will display bot numbers in ui
     * 
     * @return mixed
     */
    public static function getUserNumber($contact_name, $msg_from){

       $details = new \stdClass();
       if($contact_name!=''){
           $details->u_data = $contact_name.' ('.$msg_from.')';
       } else {
           $details->u_data = $msg_from;
       }
       return $details;
   }

   /*only test purpose mail*/
   public static function testMail($name, $email, $data) {

        $admin_email_id = Config::get('app.mail_from_address'); // 'DBSeAdvice@dbs.chat';
        //$admin_email_id = 'reallyalok@gmail.com';
        $from_name = Config::get('app.mail_from_name'); // 'DBS';
        $to = $email;
        $to_name = $name;
    
        $content = "";

        $subject = "Alert: FinChat/Collaboration Android Emulator(s) Inactive on Windows server";

        $mconfig = config('constants.mail');
        $attachments =[];
        $email_type = "vm_notify";


        if($mconfig['is_auth']==true){ 
        self::phpmailerWithAuth($to, $to_name, $subject, $content, $mconfig['driver'], $mconfig['host'], $mconfig['port'], $mconfig['encryption'], $mconfig['username'], $mconfig['password'], $mconfig['from_name'], $mconfig['from_address'],$attachments, $email_type); 
        } else { //echo '3';
        self::phpmailerWithNoAuth($to, $to_name, $subject, $content, $mconfig['driver'], $mconfig['host'], $mconfig['port'], $mconfig['from_name'], $mconfig['from_address'],$attachments, $email_type); 
        }

        // check for failures
        if (count(Mail::failures()) > 0) {
            return false;
        } else {
            $message = '';
            return true;

        }
    }


    #code add for CNCB on dated 9-12-18
    /**
      * get media extenstion
      *
      *@param string $filename 
      *
      *@return string
      */
      public static function getFileExtenstion(string $filename):string{
        if(strpos($filename,".")){
            $splitAccDot=explode(".",strtolower($filename));
            $extension=end($splitAccDot);
        }
        return isset($extension)?$extension:"";
    }

    /**
     * get attached vm id from user_devices table
     * 
     * @param string $deviceId is chat agent unique id
     * 
     * @return int
     */
    public static function getAttachedVm(string $deviceId):int{
        $data=User_device::select("id")->where("vm_id",$deviceId)->first();
        $attachedVm=(int)isset($data->id)?$data->id:0;
        return $attachedVm;
    }

     /**
      *get id from wechat_usr_grp_rel table
      *
      * @param string $groupId is unique wechat group id
      * @param string $deviceId is chat agent unique id 
      *
      * @return int   
        */
     public static function getRelatedGroupAttachedId(string $groupId,string $deviceId){
        $grpData=Caclients::select("id")
        ->where("group_id",$groupId)
        ->where("vm_id",$deviceId)
        ->first();

        $id=isset($grpData->id)?$grpData->id:0;
        return $id;
    }  

        /**
     * wechat comma convert into space for solve wechat groupname comma problem
     * 
     * @param string $grpName wechat group name
     * 
     * @return string
     */
    public static function convertWechatSearchableText(string $grpName):string{
        if(strpos($grpName,"'")){
             if(self::isPair($grpName,"'")===false){
                 $grpName=str_replace("'"," ",$grpName);
             }
         }
         elseif(strpos($grpName,'"')){
             if(self::isPair($grpName,'"')===false){
                 $grpName=str_replace('"'," ",$grpName);
             }
         }
         return $grpName;
     }

     /**
      *Show Qr code in vm
      *
      *@param string $path is qr code save path in vm_device table
      *@return string
    */
    public static function QrCodeImagePath(string $path):string{
        $publicPath=str_ireplace("/var/www/html/CNCB/public","",$path);
        return asset($publicPath);;
    }
    
    /**
     * get phone numbers from custphones
     * @param $gpn
     * @param array phoneList
     */
    public static function getPhoneNosFromCustPhones($gpn){
        
        $phArrr = DB::table('dbs_rm_mob_custphones')->select(
                'id', 'phone_type', 'phone_country_code','phone_area_code','phone_number')
                ->where('cust_cin', $gpn)
//                ->whereNotIn('phone_type', ["OFFPH","HOMEPH"])
                ->get();
        $arr = [];
        foreach ($phArrr as $key => $dbClientPhone) {
            
            if (!in_array($dbClientPhone->phone_type, ["OFFPH","HOMEPH"])) {
                $clientCc = isset($dbClientPhone->phone_country_code) ? 
                        $dbClientPhone->phone_country_code : '';
                $clientAc = isset($dbClientPhone->phone_area_code) ? 
                        $dbClientPhone->phone_area_code : '';
                $clientPn = isset($dbClientPhone->phone_number) ? 
                        $dbClientPhone->phone_number : '';

                $clientPhone = $clientCc.$clientPn;
                $clientPhone = ltrim($clientPhone, '0');
                if($clientPhone == "" || $clientPhone == NULL){
                } else {
                    if (strpos($clientPhone, "+") === false && $clientPhone != "") {
                        $clientPhone = "+".$clientPhone;
                    }
                    // $dbClientPhone->id
                    if (!in_array($clientPhone, $arr)) {
                        $arr[$dbClientPhone->id] = $clientPhone;
                    }
                }
            }
//            $value->phone_number.
//            $value
        } 
        return $arr;
    }
    /**
     * get phone numbers from import_dbs_rm
     * @param 1BANK_ID
     * @param array phoneList
     */
    public static function getPhoneNosFromImportRm($BANK_ID){
        
        $phArrr = DB::table('import_dbs_rm')->select(
                'id', 'RM_CONTACT_NUM')
                ->where('1BANK_ID', $BANK_ID)
                ->groupBy('RM_CONTACT_NUM')
                ->get();
        $phone_nos = [];
        foreach ($phArrr as $key => $dbClientPhone) {
            $clientCc = isset($dbClientPhone->RM_CONTACT_NUM) ? 
                        $dbClientPhone->RM_CONTACT_NUM : '';
            $clientCc = LabelHelper::getPhoneNumber($clientCc);
            $phone_nos[] = $clientCc;
        } 
        return $phone_nos;
    }
    /**
     * get emails from custphones
     * @param $gpn
     * @param array phoneList
     */
    public static function getEmailsFromCustEmails($gpn){
//        echo ' --'.$gpn;
        $phArrr = DB::table('dbs_rm_mob_custemails')->select(
                'id', 'official_email_address')
                ->where('cust_cin', $gpn)
//                ->orderBy('id', "DESC")  # revert email dropdown
                ->get();
        $arr = [];
//        print_r($phArrr);
        foreach ($phArrr as $key => $dbClient) {
            
            $official_email_address = isset($dbClient->official_email_address) ? 
                    $dbClient->official_email_address : '';
            
            if($official_email_address == "" || $official_email_address == NULL){
            } else {
                if (!in_array($official_email_address, $arr)) {
                    $arr[$dbClient->id] = $official_email_address;

                }
            }
        } 
        return $arr;
    }
    /**
     * get phone from custphones
     * @param $gpn
     * @param string phone
     */
    public static function getSinglePhoneFromCustPhones($c_gpn,$id){
        
        $dbClientPhone=DB::table("dbs_rm_mob_custphones")
                ->select("phone_country_code", "phone_area_code", "phone_number")
                ->where("id",$id)
                ->where("cust_cin",trim($c_gpn))
                ->first();
        $clientCc = isset($dbClientPhone->phone_country_code) ? 
                $dbClientPhone->phone_country_code : '';
        $clientAc = isset($dbClientPhone->phone_area_code) ? 
                $dbClientPhone->phone_area_code : '';
        $clientPn = isset($dbClientPhone->phone_number) ? 
                $dbClientPhone->phone_number : '';

        $clientPhone = $clientCc.$clientPn;
        $clientPhone = ltrim($clientPhone, '0');
        if($clientPhone == "" || $clientPhone == NULL){
        } else {
            if (strpos($clientPhone, "+") === false && $clientPhone != "") {
                $clientPhone = "+".$clientPhone;
            }
        }
        return $clientPhone;
    }
    /**
     * get phone from custemails
     * @param $gpn
     * @param string email
     */
    public static function getSingleEmailFromCustEmails($c_gpn, $id){
        
        $dbClient=DB::table("dbs_rm_mob_custemails")
                ->where("id",$id)
                ->where("cust_cin",trim($c_gpn))
                ->first();
        $clientCc = isset($dbClient->official_email_address) ? 
                $dbClient->official_email_address : '';
        return $clientCc;
    }
    /**
     * 
     * Log client email update
     * @param string $indicator
     * @param string $gpn
     * @param string $email
     * @param string $customer_internal_id
     * @return void
     * 
     */
    public static function logClientEmailChange($indicator, $gpn, $email, $customer_internal_id){
            $value = [

                    'cust_cin' => $gpn,
                    'indicator' => $indicator,
                    'customer_internal_id' => $customer_internal_id,
                    'official_email_address' => $email,
                    'updated_at' => date("Y-m-d H:i:s")
                ];
//            if($gpn == NULL){
//            }else{
                \Log::info("log change in email" );
                $update = DbsRmMobCustemailsRecords::updateOrCreate(
                    ['cust_cin' => $gpn, 'official_email_address' => $email],
                    $value
                );
//            }

            return true;
    }
    /**
     * 
     * Store client email data
     * @param string $indicator
     * @param string $gpn
     * @param string $email
     * @param string $customer_internal_id
     * @return void
     * 
     */
    public static function custEmailData($indicator, $gpn, $email, $customer_internal_id){
            $value = [

                    'cust_cin' => $gpn,
                    'indicator' => $indicator,
                    'customer_internal_id' => $customer_internal_id,
                    'official_email_address' => $email
                ];

            $update = DbsRmMobCustemails::updateOrCreate(
                ['cust_cin' => $gpn, 'official_email_address' => $email],
                $value

            );
            return true;
    }
}//end class

