<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithHeadings;

class UsersExport implements FromArray, ShouldAutoSize, WithHeadings
{

    protected $users;

    public function __construct(array $users)
    {
        $this->users = $users;
    }

    public function array(): array
    {
        return $this->users;
    }

    public function headings(): array
    {
        return [
            // 'S.No.',
            'Name of the Client',
            'Email',
            'Username',
            'Contact Number',
            'Address',
            'Contact Person',
            'Staff No.',
            'Head Office',
            'Client Category',
            'Type of Services',
            'Client Scope Cafe',
            'Payment Terms',
            'Type Service Suggestion',
            'Client Scope Suggestion',
            'Created_at'
        ];
    }
}
