<?php namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Foundation\Auth\RegistersUsers;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;
use Spatie\Permission\Models\Role;
use Illuminate\Http\Request;
use App\Mail\SendMail;
use DB;;
use File;
use DateTime;
use DatePeriod;
use DateInterval;

use App\ClientDocs;
use App\VendorDocs;


class VendorDocuments extends Command {

    /**
     * The console command name.
     *
     * @var string
     */
    protected $signature = 'vendor:documents';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct() {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle() {
//        \Log::info("client:agreement" . date("Y-m-d H:i:s"));
        $this->vendorDocEndNotify();
    }
    

    //Client Agreement End Date Notification Cron Function
    public function dateDiffInDays($currentDate, $client_agreement_end_date) {
      // Calculating the difference in timestamps 
      $diff = strtotime($client_agreement_end_date) - strtotime($currentDate); 
      
      // 1 day = 24 hours 
      // 24 * 60 * 60 = 86400 seconds 
      return abs(round($diff / 86400)); 
    }
    
    //Send Email Process
    protected function sendExpiryNotificationMail($type, $fkAdminEmailID, $clintEmailID, $subject, $additional_data)
    {
      $existingData = array(
          'type' => $type,
          'subject' => $subject,
          'mailId' => $fkAdminEmailID,
          'ccmailId' => $clintEmailID,
          'note' => 'This is a Test Email only..',
      );
      $data = array_merge($existingData, $additional_data);
      $res = Mail::to($fkAdminEmailID)
              //->cc(['name1@domain.com','name2@domain.com'])
              ->cc($clintEmailID)
              ->send(new SendMail($data));
      //\Log::info("Send Client Agreement Expiry Mail");
    }
    
    //Vendor Documnet Expiry cron notification function
    public function vendorDocEndNotify() {
      $currentDate = date('Y-m-d');
      $vendors = VendorDocs::distinct('vendorId')
              ->select('vendorId', 'fssai_expiry_date', 'gst_expiry_date', 'pancard_expiry_date', 'cr_expiry_date', 'pf_expiry_date', 'labourLicense_expiry_date', 'workerHealth_expiry_date', 'foodTestReport_expiry_date', 'waterTestReport_expiry_date', 'pestControlReport_expiry_date', 'kitchenAuditReport_expiry_date', 'policeVerificationReport_expiry_date')
              ->get();
      
      foreach($vendors as $vendor){
        $vendorId = $vendor['vendorId'];
        $fssai_expiry_date = $vendor['fssai_expiry_date'];
        $gst_expiry_date = $vendor['gst_expiry_date'];
        $pancard_expiry_date = $vendor['pancard_expiry_date'];
        $cr_expiry_date = $vendor['cr_expiry_date'];
        $pf_expiry_date = $vendor['pf_expiry_date'];
        $labourLicense_expiry_date = $vendor['labourLicense_expiry_date'];
        $workerHealth_expiry_date = $vendor['workerHealth_expiry_date'];
        $foodTestReport_expiry_date = $vendor['foodTestReport_expiry_date'];
        $waterTestReport_expiry_date = $vendor['waterTestReport_expiry_date'];
        $pestControlReport_expiry_date = $vendor['pestControlReport_expiry_date'];
        $kitchenAuditReport_expiry_date = $vendor['kitchenAuditReport_expiry_date'];
        $policeVerificationReport_expiry_date = $vendor['policeVerificationReport_expiry_date'];
        
        if(isset($fssai_expiry_date) && !empty($fssai_expiry_date)){
          //echo "pradeep1";
          //$fssai_expiry_date =  date("Y-m-d", strtotime($fssai_expiry_date));
          $vendorDocumentName['docName'] = "FSSAI Document";
          $diffdays = $this->dateDiffInDays($currentDate, $fssai_expiry_date);
          if($diffdays<=15){
            //Fetch FoodsKraft Admin Email
            $fkAdminData = DB::table('model_has_roles')
                            ->join('users', 'model_has_roles.role_id', '=', 'users.id')
                            ->select('users.email')
                            ->first();
            $fkAdminEmailID = $fkAdminData->email;
            
            //Fetch Vendor Email 
            $vendorData = DB::table('users')
                    ->join('vendors', 'users.id', '=', 'vendors.vendorId')
                    ->select('users.name', 'users.username', 'users.contactNumber', 'users.email', 'users.address', 'vendors.contactName')
                    ->where('users.id', '=', $vendorId)
                    ->first();
            $vendorEmailID = $vendorData->email;
            
            $mail_info['vendor'] = [];
            array_push($mail_info['vendor'], $vendorData);
            
            $mail_info['vendorDocumnetName'] = [];
            array_push($mail_info['vendorDocumnetName'], $vendorDocumentName);  
            
//            echo "<pre>";
//            print_r($mail_info);
//            echo "</pre>";
//            exit;
             
            //Send Notification Email
            $this->sendExpiryNotificationMail('expireVendorDoc', $fkAdminEmailID, $vendorEmailID, 'Vendor Document Expiry Notification!', $mail_info);
            
          } 
        } 
        if(isset($gst_expiry_date) && !empty($gst_expiry_date)){
          //echo "pradeep2";
          //$gst_expiry_date =  date("Y-m-d", strtotime($gst_expiry_date));
          $vendorDocumentName['docName'] = "GST Document";
          $diffdays = $this->dateDiffInDays($currentDate, $gst_expiry_date);
          if($diffdays<=15){
            //Fetch FoodsKraft Admin Email
            $fkAdminData = DB::table('model_has_roles')
                            ->join('users', 'model_has_roles.role_id', '=', 'users.id')
                            ->select('users.email')
                            ->first();
            $fkAdminEmailID = $fkAdminData->email;
            
            //Fetch Vendor Email 
            $vendorData = DB::table('users')
                    ->join('vendors', 'users.id', '=', 'vendors.vendorId')
                    ->select('users.name', 'users.username', 'users.contactNumber', 'users.email', 'users.address', 'vendors.contactName')
                    ->where('users.id', '=', $vendorId)
                    ->first();
            $vendorEmailID = $vendorData->email;
            
            $mail_info['vendor'] = [];
            array_push($mail_info['vendor'], $vendorData);
            
            $mail_info['vendorDocumnetName'] = [];
            array_push($mail_info['vendorDocumnetName'], $vendorDocumentName);  
            
//            echo "<pre>";
//            print_r($mail_info);
//            echo "</pre>";
//            exit;
             
            //Send Notification Email
            $this->sendExpiryNotificationMail('expireVendorDoc', $fkAdminEmailID, $vendorEmailID, 'Vendor Document Expiry Notification!', $mail_info);
            
          } 
        } 
        if(isset($pancard_expiry_date) && !empty($pancard_expiry_date)){
          
          //$fssai_expiry_date =  date("Y-m-d", strtotime($fssai_expiry_date));
          $vendorDocumentName['docName'] = "Pan Card Document";
          $diffdays = $this->dateDiffInDays($currentDate, $pancard_expiry_date);
          if($diffdays<=15){
            //Fetch FoodsKraft Admin Email
            $fkAdminData = DB::table('model_has_roles')
                            ->join('users', 'model_has_roles.role_id', '=', 'users.id')
                            ->select('users.email')
                            ->first();
            $fkAdminEmailID = $fkAdminData->email;
            
            //Fetch Vendor Email 
            $vendorData = DB::table('users')
                    ->join('vendors', 'users.id', '=', 'vendors.vendorId')
                    ->select('users.name', 'users.username', 'users.contactNumber', 'users.email', 'users.address', 'vendors.contactName')
                    ->where('users.id', '=', $vendorId)
                    ->first();
            $vendorEmailID = $vendorData->email;
            
            $mail_info['vendor'] = [];
            array_push($mail_info['vendor'], $vendorData);
            
            $mail_info['vendorDocumnetName'] = [];
            array_push($mail_info['vendorDocumnetName'], $vendorDocumentName);  
            
//            echo "<pre>";
//            print_r($mail_info);
//            echo "</pre>";
//            exit;
             
            //Send Notification Email
            $this->sendExpiryNotificationMail('expireVendorDoc', $fkAdminEmailID, $vendorEmailID, 'Vendor Document Expiry Notification!', $mail_info);
            
          } 
        } 
        if(isset($cr_expiry_date) && !empty($cr_expiry_date)){
          
          //$fssai_expiry_date =  date("Y-m-d", strtotime($fssai_expiry_date));
          $vendorDocumentName['docName'] = "Company Registration Document";
          $diffdays = $this->dateDiffInDays($currentDate, $cr_expiry_date);
          if($diffdays<=15){
            //Fetch FoodsKraft Admin Email
            $fkAdminData = DB::table('model_has_roles')
                            ->join('users', 'model_has_roles.role_id', '=', 'users.id')
                            ->select('users.email')
                            ->first();
            $fkAdminEmailID = $fkAdminData->email;
            
            //Fetch Vendor Email 
            $vendorData = DB::table('users')
                    ->join('vendors', 'users.id', '=', 'vendors.vendorId')
                    ->select('users.name', 'users.username', 'users.contactNumber', 'users.email', 'users.address', 'vendors.contactName')
                    ->where('users.id', '=', $vendorId)
                    ->first();
            $vendorEmailID = $vendorData->email;
            
            $mail_info['vendor'] = [];
            array_push($mail_info['vendor'], $vendorData);
            
            $mail_info['vendorDocumnetName'] = [];
            array_push($mail_info['vendorDocumnetName'], $vendorDocumentName);  
            
//            echo "<pre>";
//            print_r($mail_info);
//            echo "</pre>";
//            exit;
             
            //Send Notification Email
            $this->sendExpiryNotificationMail('expireVendorDoc', $fkAdminEmailID, $vendorEmailID, 'Vendor Document Expiry Notification!', $mail_info);
            
          } 
        } 
        if(isset($pf_expiry_date) && !empty($pf_expiry_date)){
          
          //$fssai_expiry_date =  date("Y-m-d", strtotime($fssai_expiry_date));
          $vendorDocumentName['docName'] = "PF Document";
          $diffdays = $this->dateDiffInDays($currentDate, $pf_expiry_date);
          if($diffdays<=15){
            //Fetch FoodsKraft Admin Email
            $fkAdminData = DB::table('model_has_roles')
                            ->join('users', 'model_has_roles.role_id', '=', 'users.id')
                            ->select('users.email')
                            ->first();
            $fkAdminEmailID = $fkAdminData->email;
            
            //Fetch Vendor Email 
            $vendorData = DB::table('users')
                    ->join('vendors', 'users.id', '=', 'vendors.vendorId')
                    ->select('users.name', 'users.username', 'users.contactNumber', 'users.email', 'users.address', 'vendors.contactName')
                    ->where('users.id', '=', $vendorId)
                    ->first();
            $vendorEmailID = $vendorData->email;
            
            $mail_info['vendor'] = [];
            array_push($mail_info['vendor'], $vendorData);
            
            $mail_info['vendorDocumnetName'] = [];
            array_push($mail_info['vendorDocumnetName'], $vendorDocumentName);  
            
//            echo "<pre>";
//            print_r($mail_info);
//            echo "</pre>";
//            exit;
             
            //Send Notification Email
            $this->sendExpiryNotificationMail('expireVendorDoc', $fkAdminEmailID, $vendorEmailID, 'Vendor Document Expiry Notification!', $mail_info);
            
          } 
        } 
        if(isset($labourLicense_expiry_date) && !empty($labourLicense_expiry_date)){
          
          //$fssai_expiry_date =  date("Y-m-d", strtotime($fssai_expiry_date));
          $vendorDocumentName['docName'] = "Labour License Document";
          $diffdays = $this->dateDiffInDays($currentDate, $labourLicense_expiry_date);
          if($diffdays<=15){
            //Fetch FoodsKraft Admin Email
            $fkAdminData = DB::table('model_has_roles')
                            ->join('users', 'model_has_roles.role_id', '=', 'users.id')
                            ->select('users.email')
                            ->first();
            $fkAdminEmailID = $fkAdminData->email;
            
            //Fetch Vendor Email 
            $vendorData = DB::table('users')
                    ->join('vendors', 'users.id', '=', 'vendors.vendorId')
                    ->select('users.name', 'users.username', 'users.contactNumber', 'users.email', 'users.address', 'vendors.contactName')
                    ->where('users.id', '=', $vendorId)
                    ->first();
            $vendorEmailID = $vendorData->email;
            
            $mail_info['vendor'] = [];
            array_push($mail_info['vendor'], $vendorData);
            
            $mail_info['vendorDocumnetName'] = [];
            array_push($mail_info['vendorDocumnetName'], $vendorDocumentName);  
            
//            echo "<pre>";
//            print_r($mail_info);
//            echo "</pre>";
//            exit;
             
            //Send Notification Email
            $this->sendExpiryNotificationMail('expireVendorDoc', $fkAdminEmailID, $vendorEmailID, 'Vendor Document Expiry Notification!', $mail_info);
            
          } 
        } 
        if(isset($workerHealth_expiry_date) && !empty($workerHealth_expiry_date)){
          
          //$fssai_expiry_date =  date("Y-m-d", strtotime($fssai_expiry_date));
          $vendorDocumentName['docName'] = "Worker Health";
          $diffdays = $this->dateDiffInDays($currentDate, $workerHealth_expiry_date);
          if($diffdays<=15){
            //Fetch FoodsKraft Admin Email
            $fkAdminData = DB::table('model_has_roles')
                            ->join('users', 'model_has_roles.role_id', '=', 'users.id')
                            ->select('users.email')
                            ->first();
            $fkAdminEmailID = $fkAdminData->email;
            
            //Fetch Vendor Email 
            $vendorData = DB::table('users')
                    ->join('vendors', 'users.id', '=', 'vendors.vendorId')
                    ->select('users.name', 'users.username', 'users.contactNumber', 'users.email', 'users.address', 'vendors.contactName')
                    ->where('users.id', '=', $vendorId)
                    ->first();
            $vendorEmailID = $vendorData->email;
            
            $mail_info['vendor'] = [];
            array_push($mail_info['vendor'], $vendorData);
            
            $mail_info['vendorDocumnetName'] = [];
            array_push($mail_info['vendorDocumnetName'], $vendorDocumentName);  
            
//            echo "<pre>";
//            print_r($mail_info);
//            echo "</pre>";
//            exit;
             
            //Send Notification Email
            $this->sendExpiryNotificationMail('expireVendorDoc', $fkAdminEmailID, $vendorEmailID, 'Vendor Document Expiry Notification!', $mail_info);
            
          } 
        } 
        if(isset($foodTestReport_expiry_date) && !empty($foodTestReport_expiry_date)){
          
          //$foodTestReport_expiry_date =  date("Y-m-d", strtotime($foodTestReport_expiry_date));
          $vendorDocumentName['docName'] = "Food Test Report";
          $diffdays = $this->dateDiffInDays($currentDate, $foodTestReport_expiry_date);
          if($diffdays<=15){
            //Fetch FoodsKraft Admin Email
            $fkAdminData = DB::table('model_has_roles')
                            ->join('users', 'model_has_roles.role_id', '=', 'users.id')
                            ->select('users.email')
                            ->first();
            $fkAdminEmailID = $fkAdminData->email;
            
            //Fetch Vendor Email 
            $vendorData = DB::table('users')
                    ->join('vendors', 'users.id', '=', 'vendors.vendorId')
                    ->select('users.name', 'users.username', 'users.contactNumber', 'users.email', 'users.address', 'vendors.contactName')
                    ->where('users.id', '=', $vendorId)
                    ->first();
            $vendorEmailID = $vendorData->email;
            
            $mail_info['vendor'] = [];
            array_push($mail_info['vendor'], $vendorData);
            
            $mail_info['vendorDocumnetName'] = [];
            array_push($mail_info['vendorDocumnetName'], $vendorDocumentName);  
            
//            echo "<pre>";
//            print_r($mail_info);
//            echo "</pre>";
//            exit;
             
            //Send Notification Email
            $this->sendExpiryNotificationMail('expireVendorDoc', $fkAdminEmailID, $vendorEmailID, 'Vendor Document Expiry Notification!', $mail_info);
            
          } 
        } 
        if(isset($waterTestReport_expiry_date) && !empty($waterTestReport_expiry_date)){
          
          //$fssai_expiry_date =  date("Y-m-d", strtotime($fssai_expiry_date));
          $vendorDocumentName['docName'] = "Water Test Report";
          $diffdays = $this->dateDiffInDays($currentDate, $waterTestReport_expiry_date);
          if($diffdays<=15){
            //Fetch FoodsKraft Admin Email
            $fkAdminData = DB::table('model_has_roles')
                            ->join('users', 'model_has_roles.role_id', '=', 'users.id')
                            ->select('users.email')
                            ->first();
            $fkAdminEmailID = $fkAdminData->email;
            
            //Fetch Vendor Email 
            $vendorData = DB::table('users')
                    ->join('vendors', 'users.id', '=', 'vendors.vendorId')
                    ->select('users.name', 'users.username', 'users.contactNumber', 'users.email', 'users.address', 'vendors.contactName')
                    ->where('users.id', '=', $vendorId)
                    ->first();
            $vendorEmailID = $vendorData->email;
            
            $mail_info['vendor'] = [];
            array_push($mail_info['vendor'], $vendorData);
            
            $mail_info['vendorDocumnetName'] = [];
            array_push($mail_info['vendorDocumnetName'], $vendorDocumentName);  
            
//            echo "<pre>";
//            print_r($mail_info);
//            echo "</pre>";
//            exit;
             
            //Send Notification Email
            $this->sendExpiryNotificationMail('expireVendorDoc', $fkAdminEmailID, $vendorEmailID, 'Vendor Document Expiry Notification!', $mail_info);
            
          } 
        } 
        if(isset($pestControlReport_expiry_date) && !empty($pestControlReport_expiry_date)){
          
          //$fssai_expiry_date =  date("Y-m-d", strtotime($fssai_expiry_date));
          $vendorDocumentName['docName'] = "Pest Control Report";
          $diffdays = $this->dateDiffInDays($currentDate, $pestControlReport_expiry_date);
          if($diffdays<=15){
            //Fetch FoodsKraft Admin Email
            $fkAdminData = DB::table('model_has_roles')
                            ->join('users', 'model_has_roles.role_id', '=', 'users.id')
                            ->select('users.email')
                            ->first();
            $fkAdminEmailID = $fkAdminData->email;
            
            //Fetch Vendor Email 
            $vendorData = DB::table('users')
                    ->join('vendors', 'users.id', '=', 'vendors.vendorId')
                    ->select('users.name', 'users.username', 'users.contactNumber', 'users.email', 'users.address', 'vendors.contactName')
                    ->where('users.id', '=', $vendorId)
                    ->first();
            $vendorEmailID = $vendorData->email;
            
            $mail_info['vendor'] = [];
            array_push($mail_info['vendor'], $vendorData);
            
            $mail_info['vendorDocumnetName'] = [];
            array_push($mail_info['vendorDocumnetName'], $vendorDocumentName);  
            
//            echo "<pre>";
//            print_r($mail_info);
//            echo "</pre>";
//            exit;
             
            //Send Notification Email
            $this->sendExpiryNotificationMail('expireVendorDoc', $fkAdminEmailID, $vendorEmailID, 'Vendor Document Expiry Notification!', $mail_info);
            
          } 
        } 
        if(isset($kitchenAuditReport_expiry_date) && !empty($kitchenAuditReport_expiry_date)){
          
          //$fssai_expiry_date =  date("Y-m-d", strtotime($fssai_expiry_date));
          $vendorDocumentName['docName'] = "Kitchen Audit Report";
          $diffdays = $this->dateDiffInDays($currentDate, $kitchenAuditReport_expiry_date);
          if($diffdays<=15){
            //Fetch FoodsKraft Admin Email
            $fkAdminData = DB::table('model_has_roles')
                            ->join('users', 'model_has_roles.role_id', '=', 'users.id')
                            ->select('users.email')
                            ->first();
            $fkAdminEmailID = $fkAdminData->email;
            
            //Fetch Vendor Email 
            $vendorData = DB::table('users')
                    ->join('vendors', 'users.id', '=', 'vendors.vendorId')
                    ->select('users.name', 'users.username', 'users.contactNumber', 'users.email', 'users.address', 'vendors.contactName')
                    ->where('users.id', '=', $vendorId)
                    ->first();
            $vendorEmailID = $vendorData->email;
            
            $mail_info['vendor'] = [];
            array_push($mail_info['vendor'], $vendorData);
            
            $mail_info['vendorDocumnetName'] = [];
            array_push($mail_info['vendorDocumnetName'], $vendorDocumentName);  
            
//            echo "<pre>";
//            print_r($mail_info);
//            echo "</pre>";
//            exit;
             
            //Send Notification Email
            $this->sendExpiryNotificationMail('expireVendorDoc', $fkAdminEmailID, $vendorEmailID, 'Vendor Document Expiry Notification!', $mail_info);
            
          } 
        } 
        if(isset($policeVerificationReport_expiry_date) && !empty($policeVerificationReport_expiry_date)){
          
          //$fssai_expiry_date =  date("Y-m-d", strtotime($fssai_expiry_date));
          $vendorDocumentName['docName'] = "Police Verification Report";
          $diffdays = $this->dateDiffInDays($currentDate, $policeVerificationReport_expiry_date);
          if($diffdays<=15){
            //Fetch FoodsKraft Admin Email
            $fkAdminData = DB::table('model_has_roles')
                            ->join('users', 'model_has_roles.role_id', '=', 'users.id')
                            ->select('users.email')
                            ->first();
            $fkAdminEmailID = $fkAdminData->email;
            
            //Fetch Vendor Email 
            $vendorData = DB::table('users')
                    ->join('vendors', 'users.id', '=', 'vendors.vendorId')
                    ->select('users.name', 'users.username', 'users.contactNumber', 'users.email', 'users.address', 'vendors.contactName')
                    ->where('users.id', '=', $vendorId)
                    ->first();
            $vendorEmailID = $vendorData->email;
            
            $mail_info['vendor'] = [];
            array_push($mail_info['vendor'], $vendorData);
            
            $mail_info['vendorDocumnetName'] = [];
            array_push($mail_info['vendorDocumnetName'], $vendorDocumentName);  
            
//            echo "<pre>";
//            print_r($mail_info);
//            echo "</pre>";
//            exit;
             
            //Send Notification Email
            $this->sendExpiryNotificationMail('expireVendorDoc', $fkAdminEmailID, $vendorEmailID, 'Vendor Document Expiry Notification!', $mail_info);
            
          } 
        } 
//        else {
//          echo "It is ok for now!!";
//          echo "<br/>";
//        }
      }
    }

}