<?php if(isset($project)): ?>

<?php $__env->startSection("title"); ?> <?php echo e($project->title); ?> <?php $__env->stopSection(); ?>
<?php $__env->startSection("meta_keywords"); ?> <?php echo e($project->meta_keywords); ?> <?php $__env->stopSection(); ?>
<?php $__env->startSection("meta_description"); ?> <?php echo e($project->meta_description); ?> <?php $__env->stopSection(); ?>

<?php if(isset($project->image)): ?>
<?php $__env->startSection("share_image"); ?>assets/project/meta/<?php echo e($project->image); ?><?php $__env->stopSection(); ?>
<?php endif; ?>


<?php $__env->startSection("additional"); ?> <?php echo $project->additional; ?> <?php $__env->stopSection(); ?>

<?php endif; ?>

<?php $__env->startSection('content'); ?>

<main>

    <div class="slider-area" <?php if(isset($project->banner)): ?> style="background-image: url(<?php echo e(asset('assets/project/banner/'.$project->banner)); ?>);" <?php endif; ?>>
        <div class="slider-height2 slider-bg4 hero-overly d-flex align-items-center">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-xl-5 col-lg-6 col-md-6">
                        <div class="hero-caption hero-caption2">
                            <h2><?php echo e($project->title); ?></h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
	


    <section class="volunteer pt-100">
        <div class="container">
            <div class="feature-style-one">
                <div class="row">
                    <div class="col-md-6 col-sm-12">
                        <div class="image">
                            <figure>
                                <img src="<?php echo e(asset('assets/project/grid/'.$project->image)); ?>" alt="<?php echo e($project->title); ?>">
                            </figure>
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <div class="content-sec">
                            <div class="solve-area-content">
                                <div class="section-title v2 text-left mb-1-9">
                                    <span class="sm-title">Empowering</span>
                                    <h2 class="mb-0 h1"><?php echo e($project->title); ?></h2>
                                </div>
                                <?php echo $project->details; ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
	


	
	<?php if($project->slug=="sports"): ?>
	
	<div class="container  pt-100">
				
                <div class="form-sec bg-1 p-4">
                    <div class="section-tittle text-center mb-60">
                        <h2>Sports Event Entry / <span1 class="text-theme"> Registration Form</span1> 
                        </h2>
                    </div>

                    <div class="default-form-area">
                        <form id="contact-form" name="contact_form" class="default-form"
                            action="<?php echo e(url('sports-form')); ?>" method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
							<div class="row">
    <div class="col-md-12 col-sm-12 col-xs-12">
        <div class="default-form-bg">
            <div class="row clearfix w-100">
                <div class="col-md-4 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <label for="name">Sports Name *</label>
                        <input type="text" name="sports_name" class="form-control" value="" placeholder="Sports Name *" required="" aria-required="true">
                    </div>
                </div>
             
                <div class="col-md-4 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <label for="class">Team Name</label>
                        <input type="text" name="team_name" class="form-control" value="" placeholder="Team Name">
                    </div>
                </div>

                <div class="col-md-4 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <label for="class">Captain Name</label>
                        <input type="text" name="captain_name" class="form-control" value="" placeholder="Captain Name">
                    </div>
                </div>

                <div class="col-md-4 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <label for="phone">Phone Number *</label>
                        <input type="text" name="phone" id="mobile" class="form-control" value="" placeholder="Phone Number *" required>
                        <span id="mobileError" style="color: red;"></span>
                    </div>
                </div>

                <div class="col-md-4 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <label for="email">Email Id *</label>
                        <input type="email" name="email" id="email" class="form-control required email" value="" placeholder="Email Id *" required="" aria-required="true">
                        <span id="emailError" style="color: red;"></span>
                    </div>
                </div>


                <div class="col-md-4 col-sm-6 col-xs-12">
                    
                    <div class="form-group">
                        <label for="address">Address*</label>
                        <input type="text" name="address" class="form-control" value="" placeholder="Address" required>
                    </div>
                </div>
				
                <div class="col-md-4 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <label for="state">Select State *</label>
                        <select name="state" id="state" class="form-control" value="" required="" aria-required="true">
                            <option value="">Select State*</option>
                            <!-- Options for states here -->
							 <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($state->state_id); ?>"><?php echo e($state->state_title); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>

                <div class="col-md-4 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <label for="district">Select District *</label>
                        <select name="district" id="district" class="form-control" value="" required="" aria-required="true">
                            <option value="">Select District*</option>
                            <!-- Options for districts here -->
                        </select>
                    </div>
                </div>

                <div class="col-md-4 col-sm-6 col-xs-12">
					<div class="form-group">
                        <label for="fileInput">Payment Entry Fee*</label>
                        <div class="custom-file">
                            <input type="number" name="entry_fee" class="form-control" id="fileInput" placeholder="Payment Entry Fee" required>
                        </div>
                    </div>
					
                </div>

            </div>
        </div>
    </div>
</div>
							

                            <div class="col-md-12 col-sm-12 col-xs-12 mt-3">
                                <div class="form-group center">
                                    <button class="thm-btn" type="submit" data-loading-text="Please wait...">submit
                                        now</button>
                                </div>
                            </div>
							<!--<div class="col-md-12 col-sm-12 col-xs-12">-->
							<!--	<p>-->
							<!--		<b>नोट:</b> पेमेंट करने के लिए नीचे दिए गए बार कोड या upi का प्रयोग करे व स्क्रीनशॉट अपलोड कर-->
							<!--	</p>-->
       <!--                 	</div>-->

                        </form>
                    </div>
                </div>
            </div>
	
	<?php endif; ?>
	
	<?php if($project->slug=="agriculture"): ?>
	
	<div class="container  pt-100">
				
                <div class="form-sec bg-1 p-4">
                    <div class="section-tittle text-center mb-60">
                        <h2>Corp / Product Sell <span1 class="text-theme"> Registration Form</span1> 
                        </h2>
                    </div>

                    <div class="default-form-area">
                        <form id="contact-form" name="contact_form" class="default-form"
                            action="<?php echo e(url('agriculture-form')); ?>" method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
							<div class="row">
    <div class="col-md-12 col-sm-12 col-xs-12">
        <div class="default-form-bg">
            <div class="row clearfix w-100">
                <div class="col-md-4 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <label for="name">Farmer/Producer/Trader Name *</label>
                        <input type="text" name="name" class="form-control" value="" placeholder="Farmer/Producer/Trader Name *" required="" aria-required="true">
                    </div>
                </div>
             
                <div class="col-md-4 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <label for="class">Father's / Husband Name</label>
                        <input type="text" name="fh_name" class="form-control" value="" placeholder="Father's / Husband Name">
                    </div>
                </div>

                <div class="col-md-4 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <label for="class">Aadhar Number*</label>
                        <input type="text" name="adhar_no" id="aadhar" class="form-control" value="" placeholder="Aadhar Number*" required>
						<span id="AadharError" style="color: red;"></span>
                    </div>
                </div>

                <div class="col-md-4 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <label for="phone">Phone Number *</label>
                        <input type="text" name="phone" id="mobile" class="form-control" value="" placeholder="Phone Number *" required>
                        <span id="mobileError" style="color: red;"></span>
                    </div>
                </div>

               
<div class="col-md-4 col-sm-6 col-xs-12">
                    
                    <div class="form-group">
                        <label for="address">Address*</label>
                        <input type="text" name="address" class="form-control" value="" placeholder="Address" required>
                    </div>
                </div>

                <div class="col-md-4 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <label for="state">Select State *</label>
                        <select name="state" id="state" class="form-control" value="" required="" aria-required="true">
                            <option value="">Select State*</option>
                            <!-- Options for states here -->
							 <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($state->state_id); ?>"><?php echo e($state->state_title); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>

                <div class="col-md-4 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <label for="district">Select District *</label>
                        <select name="district" id="district" class="form-control" value="" required="" aria-required="true">
                            <option value="">Select District*</option>
                            <!-- Options for districts here -->
                        </select>
                    </div>
                </div>

                <div class="col-md-4 col-sm-6 col-xs-12">
					<div class="form-group">
                        <label for="fileInput">Crop/Product Name*</label>
                        <div class="custom-file">
                            <input type="text" name="corps_name" class="form-control" id="fileInput" placeholder="Crop/Product Name" required>
                        </div>
                    </div>
					
                </div>

                <div class="col-md-4 col-sm-6 col-xs-12">
					<div class="form-group">
                        <label for="fileInput">Quantity*</label>
                        <div class="custom-file">
                            <input type="number" name="quantity" class="form-control" id="fileInput" placeholder="Quantity*" required>
                        </div>
                    </div>
					
                </div>
                
            </div>
        </div>
    </div>
</div>


                            <div class="col-md-12 col-sm-12 col-xs-12 mt-3">
                                <div class="form-group center">
                                    <button class="thm-btn" type="submit" data-loading-text="Please wait...">submit
                                        now</button>
                                </div>
                            </div>
							
							<!--<div class="col-md-12 col-sm-12 col-xs-12">-->
							<!--	<p>-->
							<!--		<b>नोट:</b> पेमेंट करने के लिए नीचे दिए गए बार कोड या upi का प्रयोग करे व स्क्रीनशॉट अपलोड कर-->
							<!--	</p>-->
       <!--                 	</div>-->

                        </form>
                    </div>
                </div>
            </div>
	
	<?php endif; ?>
	
	
	 
    <div class="join-us-area section-padding bg-1 mt-3">
      <div class="container">
        <div class="row align-items-center">
         
          <div class="col-xl-4 col-lg-4 col-md-7 col-sm-7">
            <div class="joning-img">
              <img src="<?php echo e(asset('assets/img/gallery/joining1.jpg')); ?>" alt="" class="w-100">
            </div>
          </div>
          <div class="col-xl-3 col-lg-3 col-md-5 col-sm-5">
            <div class="joning-img">
              <img src="<?php echo e(asset('assets/img/gallery/joining2.jpg')); ?>" alt="" class="w-100">
            </div>
          </div>
           <div class=" offset-xl-1 col-xl-4 col-lg-6 col-md-10">
            <div class="joing-details">
              <div class="section-tittle">
                <h2>Join with Us</h2>
              </div>
              <p>The legal definition of a charitable organization (and of charity) varies between countries and in some
                instances regions of the country. The regulation, the tax treatment, and the way.</p>
              <a href="<?php echo e(url('volunteer')); ?>" class="btn about-btn">
            Become A Volunteer
            <i class="flaticon-right"></i>
          </a>
            </div>
          </div>
        </div>
      </div>
    </div>
	
</main>

    
<?php if($project->slug=="sports" || $project->slug=="agriculture"): ?>
      <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script>
    var jq = jQuery.noConflict();
</script>

 <script>
        jq(document).ready(function() {
            jq("form").submit(function(event) {
                var email = jq("#email").val();
                var mobile = jq("#mobile").val();
                var emailPattern = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4}$/;
                var mobilePattern = /^[0-9]{10}$/;
				
				<?php if($project->slug=="agriculture"): ?>
                var aadhar = jq("#aadhar").val();
                var aadharPattern = /^[0-9]{12}$/;
                jq("#AadharError").text("");
				if (!aadharPattern.test(aadhar)) {
                    event.preventDefault();
                    jq("#AadharError").text("Invalid aadhar number format");
                }
				<?php else: ?>

                jq("#emailError").text("");
                if (!emailPattern.test(email)) {
                    event.preventDefault();
                    jq("#emailError").text("Invalid email format");
                }
  <?php endif; ?>

                jq("#mobileError").text("");

                if (!mobilePattern.test(mobile)) {
                    event.preventDefault();
                    jq("#mobileError").text("Invalid mobile number format");
                }
            });
        });
    </script>

<script>
    jq(document).ready(function() {
        jq("#state").change(function() {
            var state_id = jq("#state").val();
            jq.get("<?php echo e(url('district?state_id=')); ?>"+state_id).done(function(data) {
                jq("#district").html(data);
            });
        });
    });
    </script> 
  <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\gmm\resources\views/project-details.blade.php ENDPATH**/ ?>