

<?php if(isset($dynamic)): ?>

    <?php $__env->startSection('title'); ?>
        <?php echo e($dynamic->title); ?>

    <?php $__env->stopSection(); ?>
    <?php $__env->startSection('meta_keywords'); ?>
        <?php echo e($dynamic->meta_keywords); ?>

    <?php $__env->stopSection(); ?>
    <?php $__env->startSection('meta_description'); ?>
        <?php echo e($dynamic->meta_description); ?>

    <?php $__env->stopSection(); ?>
    <?php if(isset($dynamic->image)): ?>
        <?php $__env->startSection('share_image'); ?>
            assets/dynamic/meta/<?php echo e($dynamic->image); ?>

        <?php $__env->stopSection(); ?>
    <?php endif; ?>


    <?php $__env->startSection('additional'); ?>
        <?php echo $dynamic->additional; ?>

    <?php $__env->stopSection(); ?>

<?php endif; ?>

<?php $__env->startSection('content'); ?>
    <main>


        <div class="slider-area">
            <div class="slider-height2 slider-bg4 hero-overly d-flex align-items-center">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-xl-5 col-lg-6 col-md-6">
                            <div class="hero-caption hero-caption2">
                                <h2>Donate</h2>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <section class="donate sec-padd">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="content-sec">
                            <div class="donate-content">
                                <div class="section-title v2 text-left mb-1-9">
                                    <span class="sm-title">Donate Now</span>
                                    <h2 class="mb-0 h1">Support Education</h2>
                                </div>
                                <p>Your generous contribution can make a significant difference in the lives of aspiring
                                    students. By donating to the GMM EDUCATIONAL TRUST AND WELFARE ASSOCIATION Scholarship
                                    Program, you become an essential part of our mission to provide equal opportunities for
                                    education.</p>
                                <p>Every donation counts, no matter the amount. Your support can change the trajectory of a
                                    young person's life, opening doors to a brighter future.</p>

                                <div class="donate-btn">
                                    <a href="#donate" class=" default-btn">Donate Now</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="donate-img">
                            <img src="<?php echo e(asset('assets/img/donate/2.jpg')); ?>" alt="">
                        </div>
                    </div>
                </div>

            </div>
        </section>

        <section class="bg-1 p-4 ">

            <div class="container">
                <div class="row">
                    <div class="section-tittle text-center mb-60">
                        <h2>DONAR
                            <span1 class="text-theme"> DETAILS </span1>
                        </h2>
                    </div>

                    
                    <div class="default-form-area">
                        <form id="contact-form" name="contact_form" class="default-form" action="<?php echo e(url('donate')); ?>"
                            method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="row clearfix">
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    <div class="form-group">
                                        <label for="name">Your Name *</label>
                                        <input type="text" name="name" class="form-control" value=""
                                            placeholder="Your Name *" required="" aria-required="true">
                                    </div>
                                </div>

                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    <div class="form-group">
                                        <label for="mobile">Phone Number</label>
                                        <input type="text" name="phone" id="mobile" class="form-control"
                                            value="" placeholder="Phone Number" required>
                                        <span id="mobileError" style="color: red;"></span>
                                    </div>
                                </div>

                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    <div class="form-group">
                                        <label for="email">Email Id *</label>
                                        <input type="email" name="email" id="email"
                                            class="form-control required email" value="" placeholder="Email Id *"
                                            required="" aria-required="true">
                                        <span id="emailError" style="color: red;"></span>
                                    </div>
                                </div>

                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    <div class="form-group">
                                        <label for="address">Address</label>
                                        <input type="text" name="address" class="form-control" value=""
                                            placeholder="Address" required>
                                    </div>
                                </div>

                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    <div class="form-group">
                                        <label for="city">City</label>
                                        <input type="text" name="city" class="form-control" value=""
                                            placeholder="City" required>
                                    </div>
                                </div>

                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    <div class="form-group">
                                        <label for="fileInput">Payment Reciept:</label>
                                        <input type="file" name="reciept" class="form-control" id="fileInput"
                                            value="" placeholder="Image" required>
                                    </div>
                                </div>

                                <div class="col-md-12 col-sm-12 col-xs-12">
                                    <div class="checkbox">
                                        <label>
                                            <input type="checkbox" required> Check this box to hide your personal info in
                                            our donators list
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-12 col-sm-12 col-xs-12">
                                    <div class="checkbox form-group">
                                        <label>
                                            <input type="checkbox" required> I give my consent for authorized
                                            representatives of GMM EDUCATIONAL TRUST AND WELFARE ASSOCIATION to contact me
                                            occasionally by mobile and email for informing on the latest developments and
                                            updated offerings.
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="card p-4" style="height: 100%">
                                        <img src="<?php echo e(asset($settings->upi_qr_code)); ?>" class="card-img-top"
                                            alt="GMM EDUCATIONAL TRUST AND WELFARE ASSOCIATION QR">
                                        <div class="card-body">
                                            <p class="card-text text-center">Scan QR Code for Payment</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-8">
                                    <div class="card" style="height: 100%">
                                        <div class="card-body p-4">
                                            <h2 class="display-4">Payment Details for GMM EDUCATIONAL TRUST AND WELFARE
                                                ASSOCIATION</h2>
                                            <br>
                                            <h5 class="card-title pb-2"><strong>Account Number:</strong> <?php echo e($settings->account_number); ?></h5>
                                            <h5 class="card-title pb-2"><strong>Ifsc Code:</strong><?php echo e($settings->ifsc_code); ?> </h5>
                                            <h5 class="card-title pb-2"><strong>Branch Name:</strong> <?php echo e($settings->branch_name); ?> </h5>
                                            <h5 class="card-title pb-2"><strong>Account Holder Name:</strong> <?php echo e($settings->account_holder); ?></h5>
                                            <h5 class="card-title pb-2"><strong>UPI ID:</strong> <?php echo e($settings->upi_id); ?></h5>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12 col-sm-12 col-xs-12 center">
                                    <div class="form-group mt-3">
                                        <button class="thm-btn" type="submit"
                                            data-loading-text="Please wait...">Submit</button>
                                    </div>
                                </div>
                                <div class="col-md-12 col-sm-12 col-xs-12">
                                    <p>
                                        <b>नोट:</b> पेमेंट करने के लिए नीचे दिए गए बार कोड या upi का प्रयोग करे व स्क्रीनशॉट
                                        अपलोड कर
                                    </p>
                                </div>
                            </div>
                        </form>
                    </div>
                    

                </div>
            </div>
        </section>



    </main>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/jquery-datetimepicker/2.5.20/jquery.datetimepicker.min.css">

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-datetimepicker/2.5.20/jquery.datetimepicker.full.min.js">
    </script>
    <script>
        var jq = jQuery.noConflict();
    </script>
    <script>
        jq(document).ready(function() {
            jq("form").submit(function(event) {
                var email = jq("#email").val();
                var mobile = jq("#mobile").val();
                var emailPattern = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4}$/;
                var mobilePattern = /^[0-9]{10}$/;

                jq("#emailError").text("");
                jq("#mobileError").text("");

                if (!emailPattern.test(email)) {
                    event.preventDefault();
                    jq("#emailError").text("Invalid email format");
                }

                if (!mobilePattern.test(mobile)) {
                    event.preventDefault();
                    jq("#mobileError").text("Invalid mobile number format");
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\gmm\resources\views/donate.blade.php ENDPATH**/ ?>