

<?php $__env->startSection('title'); ?>
    Membership List
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Membership List</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#"> Home </a></li>
                            <li class="breadcrumb-item active"> Membership List </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <!-- Content Header (Page header) -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 mb-4 mt-0">

                        <div class="card card-primary">
                            <div class="card-header">
                                <h2 class="card-title">Membership List</h2>
                            </div>
                            <div class="card-body">
                                <table class="table table-bordered table-striped display">
                                    <thead>
                                        <tr>
                                            <th>S.No.</th>
                                            <th>Name</th>
                                            
                                            <th>Email</th>
                                            <th>Mobile Number</th>
                                            <th>DOB</th>
                                            <th>PAN Number</th>
                                            <th>Aadhar Number</th>
                                            <th>Joined On</th>
                                            <th>Status</th>
                                            <th>Address</th>
                                            
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $memberships; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($key + 1); ?>.</td>
                                                <td><?php echo e($member['name']); ?></td>
                                                <td><?php echo e($member['email']); ?></td>
                                                <td><?php echo e($member['phone']); ?></td>
                                                <td><?php echo e($member['dob'] ?? '-'); ?></td>
                                                <td><?php echo e($member['pan_number']); ?></td>
                                                <td><?php echo e($member['aadhaar_number']); ?></td>
                                                <td><?php echo e($member['created_at']->format('d/m/Y')); ?></td>

                                                <td>
                                                    <span
                                                        class="badge 
                                                        <?php echo e($member->status == 'active' ? 'badge-success' : ($member->status == 'rejected' ? 'badge-danger' : 'badge-warning')); ?>">
                                                        <?php echo e(ucfirst($member->status)); ?>

                                                    </span>
                                                </td>

                                                <td><?php echo e($member['address']); ?></td>
                                                
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(config('app.admin.view') . '.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/enexademo/public_html/gmmedu/resources/views/admin/reports/membership.blade.php ENDPATH**/ ?>