

<?php $__env->startSection('title', 'Generate ID Card'); ?>

<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">

        <!-- Page Header -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Generate Volunteer ID Card</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(url('/admin/dashboard')); ?>">Dashboard</a></li>
                            <li class="breadcrumb-item active">Generate ID Card</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <!-- Main Content -->
        <section class="content">
            <div class="container-fluid">

                <div class="card p-4">
                    <!-- Show ID Card -->
                    <?php if($volunteer): ?>
                        <div class="card-container mt-4">

                            <!-- FRONT -->
                            <div id="idcard-front" class="id-card id-card-front">
                                <div class="header">
                                    <img src="<?php echo e(asset('logo-1726730459.webp')); ?>" alt="Organization Logo" class="logo">
                                </div>
                                <div class="title">Volunteer ID Card</div>
                                <div class="photo">
                                    <img src="<?php echo e($volunteer->image ?? asset('images/default-profile.png')); ?>"
                                        alt="Profile Photo">
                                </div>
                                <div class="details">
                                    <p class="name"><?php echo e($volunteer->name); ?></p>
                                    <p>Registration ID : <?php echo e($volunteer->rid); ?></p>
                                    <p>Phone : <?php echo e($volunteer->phone); ?></p>
                                    <p>Email : <?php echo e($volunteer->email); ?></p>
                                    <p>Issued On :
                                        <?php echo e($volunteer->issue_date ?? ($volunteer->created_at ? $volunteer->created_at->format('d-m-Y') : '')); ?>

                                    </p>
                                </div>
                                <div class="watermark">Official ID</div>
                            </div>

                            <!-- BACK -->
                            <div id="idcard-back" class="id-card id-card-back">
                                <div class="content">
                                    <p><strong>GMM EDUCATIONAL TRUST AND WELFARE ASSOCIATION</strong></p>
                                    <p>Website: www.gmmedutrust.in</p>
                                    <h5>Contact us through</h5>
                                    <p>Email: gmmeducationaltrustwelfareasso@gmail.com</p>
                                    <p>Phone: +91 9431448178</p>
                                    <p>This card is property of the organization and must be returned upon request.</p>
                                </div>
                                <div class="barcode"></div>
                                <div class="watermark">Official ID</div>
                            </div>
                        </div>

                        <div class="text-center mt-4">
                            <button id="download-idcard" class="btn btn-success">Download ID Card</button>
                        </div>

                        <script src="https://cdn.jsdelivr.net/npm/html2canvas@1.4.1/dist/html2canvas.min.js"></script>
                        <script>
                            document.getElementById('download-idcard').addEventListener('click', function() {
                                var container = document.createElement('div');
                                container.style.display = 'flex';
                                container.style.gap = '20px';
                                container.style.background = '#e8ecef';
                                container.style.padding = '40px';
                                container.appendChild(document.getElementById('idcard-front').cloneNode(true));
                                container.appendChild(document.getElementById('idcard-back').cloneNode(true));
                                document.body.appendChild(container);
                                html2canvas(container, {
                                    backgroundColor: '#e8ecef'
                                }).then(function(canvas) {
                                    var link = document.createElement('a');
                                    link.download = 'volunteer_id_card.png';
                                    link.href = canvas.toDataURL();
                                    link.click();
                                    document.body.removeChild(container);
                                });
                            });
                        </script>
                    <?php elseif(request('id')): ?>
                        <div class="alert alert-danger mt-4">Volunteer not found.</div>
                    <?php endif; ?>

                </div>
            </div>
        </section>
    </div>

    <style>
        body {
            background-color: #f8f9fa;
            font-family: 'Segoe UI', sans-serif;
        }

        .card-container {
            display: flex;
            gap: 20px;
            justify-content: center;
            margin-top: 30px;
            flex-wrap: wrap;
        }

        .id-card {
            width: 300px;
            height: 400px;
            border-radius: 20px;
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
            overflow: hidden;
            background-color: white;
            padding: 15px;
            position: relative;
            color: #fff;
        }

        .id-card-front {
            background: linear-gradient(180deg, #2a6db8, #54b6d2);
        }

        .id-card-back {
            background: linear-gradient(180deg, #54b6d2, #2a6db8);
        }

        .id-card .header {
            text-align: center;
            margin-bottom: 10px;
            background-color: #00000075;
            width: fit-content;
            margin: auto;
        }

        .id-card .logo {
            width: 45px;
            filter: brightness(0) invert(1);
        }

        .id-card .title {
            text-align: center;
            font-size: 14px;
            font-weight: 500;
            text-transform: uppercase;
            letter-spacing: 1.5px;
            margin: 8px 0;
        }

        .id-card .photo {
            width: 90px;
            height: 90px;
            border-radius: 12px;
            background: #fff;
            margin: 0 auto 15px;
            overflow: hidden;
            border: 2px solid rgba(255, 255, 255, 0.2);
        }

        .id-card .photo img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .id-card .details {
            text-align: center;
            font-size: 12px;
            line-height: 1.4;
        }

        .id-card .name {
            font-size: 16px;
            font-weight: 700;
            text-transform: uppercase;
            margin: 5px 0;
        }

        .id-card .details p:not(.name) {
            font-size: 14.5px;
            font-weight: 500;
            text-align: start;
            padding-left: 10px;
            padding-top: 10px;
            margin: 4px 0;
        }

        .id-card .watermark {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-45deg);
            opacity: 0.08;
            font-size: 28px;
            font-weight: 700;
            pointer-events: none;
            text-transform: uppercase;
        }

        .id-card-back .content {
            text-align: center;
            font-size: 11px;
            margin: 20px 0;
            line-height: 1.5;
        }

        .id-card-back .barcode {
            width: 90px;
            height: 35px;
            background: #fff;
            border-radius: 5px;
            margin: 15px auto;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(config('app.admin.view') . '.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\gmm\resources\views/idcard.blade.php ENDPATH**/ ?>