

<?php $__env->startSection('title'); ?>
    Agriculture List
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Agriculture List</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#"> Home </a></li>
                            <li class="breadcrumb-item active"> Agriculture List </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <!-- Content Header (Page header) -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 mb-4 mt-0">

                        <div class="card card-primary">
                            <div class="card-header">
                                <h2 class="card-title">Agriculture List</h2>

                            </div>
                            <div class="card-body">
                                <table class="table table-bordered table-striped display">
                                    <thead>
                                        <tr>
                                            <th>S.No.</th>
                                            <th>Father's / Husband Name</th>
                                            <th>Aadhar Number</th>
                                            <th>Mobile Number</th>
                                            <th>Address</th>
                                            <th>Crop/Product Name</th>
                                            <th>Quantity</th>
                                            <th>Addon</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $agriculture; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $agriculture): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($key + 1); ?>.</td>
                                                <td><?php echo e($agriculture['name']); ?></td>
                                                <td><?php echo e($agriculture['fh_name']); ?></td>
                                                <td><?php echo e($agriculture['adhar_no']); ?></td>
                                                <td><?php echo e($agriculture['phone']); ?></td>
                                                <td><?php echo e($agriculture['address']); ?></td>
                                                <td><?php echo e($agriculture['corps_name']); ?></td>
                                                <td><?php echo e($agriculture['quantity']); ?></td>

                                                <td><?php echo e($agriculture['created_at']->format('d/m/Y')); ?></td>
                                                <td>
                                                    <a class="btn btn-info btn-sm my-1"
                                                        href="<?php echo e(config('app.admin.url') . 'agriculture/show/' . encrypt($agriculture->id)); ?>"
                                                        title="Show"><i class="fa fa-eye"></i></a>

                                                    <a class="btn btn-danger btn-sm my-1"
                                                        href="<?php echo e(config('app.admin.url') . 'agriculture/destroy/' . encrypt($agriculture->id)); ?>"
                                                        title="Delete"><i class="fa fa-trash"></i></a>
                                                </td>

                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>


                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(config('app.admin.view') . '.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/enexademo/public_html/gmmedu/resources/views/admin/reports/agriculture.blade.php ENDPATH**/ ?>