

<?php $__env->startSection('title', 'Membership Receipt'); ?>

<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <section class="content-header">
            <h4>Membership Receipt</h4>
        </section>

        <section class="content">
            <div class="container-fluid">
                <?php if($donation && $donation->payment_type === 'membership'): ?>
                    <div class="d-flex justify-content-center">
                        <!-- Wrap receipt inside #membership-receipt for PDF -->
                        <div id="membership-receipt" class="card p-4" style="width: 700px; border:1px solid #ccc;">
                            <!-- Header with Logo & Organization Name -->
                            <div class="d-flex align-items-center mb-3" style="padding-bottom:10px;">
                                <!-- Logo -->
                                <div style="flex:0 0 auto; background-color: #000; border-radius: 50%;">
                                    <img src="<?php echo e(asset('logo-1726730459.webp')); ?>" alt="Logo" style="height:60px;">
                                </div>
                                <!-- Organization Name -->
                                <div class="flex-grow-1 text-center">
                                    <h4 class="mb-0">GMM Educational Trust And Welfare Association</h4>
                                </div>
                                <!-- Empty space for right side balance -->
                                <div style="flex:0 0 auto; width:60px;"></div>
                            </div>

                            <div class="text-center mb-3">
                                <h5 class="mb-0">Membership Payment Receipt</h5>
                                <small class="text-muted">Acknowledgement Slip</small>
                                <hr>
                            </div>

                            <table class="table table-sm table-bordered mb-0">
                                <tr>
                                    <td><strong>Name</strong></td>
                                    <td><?php echo e($user->name); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Email</strong></td>
                                    <td><?php echo e($user->email); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Phone</strong></td>
                                    <td><?php echo e($user->phone ?? 'N/A'); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Amount Paid</strong></td>
                                    <td>₹<?php echo e($donation->amount); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Payment Type</strong></td>
                                    <td><?php echo e(ucfirst($donation->payment_type)); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>UTR Number</strong></td>
                                    <td><?php echo e($donation->utr_number); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Status</strong></td>
                                    <td>
                                        <?php if($donation->status === 'confirmed'): ?>
                                            <span>Confirmed</span>
                                        <?php elseif($donation->status === 'pending'): ?>
                                            <span class="badge bg-warning text-dark">Pending</span>
                                        <?php else: ?>
                                            <span class="badge bg-danger">Rejected</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Date</strong></td>
                                    <td><?php echo e($donation->created_at->format('d-m-Y')); ?></td>
                                </tr>
                            </table>

                            <div class="text-center mt-3">
                                <small class="text-muted">This is a system generated slip.</small>
                            </div>
                        </div>

                    </div>

                    <!-- Action / Message depending on status -->
                    <div class="text-center mt-3">
                        <?php if($donation->status === 'confirmed'): ?>
                            <button onclick="downloadMembershipPDF()" class="btn btn-primary">
                                <i class="fa fa-download"></i> Download PDF
                            </button>
                        <?php elseif($donation->status === 'pending'): ?>
                            <div class="alert alert-info mt-3">
                                Your membership payment is under review. Please wait for <strong>24–48 hours</strong> for
                                confirmation.
                            </div>
                        <?php elseif($donation->status === 'rejected'): ?>
                            <div class="alert alert-danger mt-3">
                                Sorry, your membership payment has been <strong>rejected</strong>.
                                Please <span><a href="/contact">contact support</a></span> if you believe this is a mistake.
                            </div>
                        <?php endif; ?>
                    </div>
                <?php else: ?>
                    <div class="card p-4">
                        <?php if(!$membershipApplied): ?>
                            <div class="alert alert-warning mb-0">
                                You have not applied for membership yet.
                                <a href="<?php echo e(url('/master/membership')); ?>">Apply now</a>.
                            </div>
                        <?php elseif($membershipApplied && !$donation): ?>
                            <div class="alert alert-warning mb-0">
                                You have not paid for membership yet.
                                <a href="<?php echo e(url('/master/donation?type=membership&amount=' . (int) $membershipFee)); ?>">Pay
                                    for membership</a>.
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>

            </div>
        </section>
    </div>

    <!-- JS for html2pdf -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>
    <script>
        function downloadMembershipPDF() {
            const element = document.getElementById("membership-receipt");
            html2pdf().set({
                margin: 0.3,
                filename: 'membership-receipt.pdf',
                image: {
                    type: 'jpeg',
                    quality: 0.95
                },
                html2canvas: {
                    scale: 2
                },
                jsPDF: {
                    unit: 'in',
                    format: 'A4',
                    orientation: 'portrait'
                }
            }).from(element).save();
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(config('app.admin.view') . '.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\gmm\resources\views/admin/membership_receipt.blade.php ENDPATH**/ ?>