

<?php $__env->startSection('title', 'Donate Now'); ?>

<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">

        <!-- Page Header -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Donate Now</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Panel</a></li>
                            <li class="breadcrumb-item active">Donate</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <!-- Main Content -->
        <section class="content">
            <div class="container-fluid">

                <!-- Changed from card-success → card-primary -->
                <div class="card card-primary shadow">
                    <div class="card-header">
                        <h3 class="card-title">Make a Donation</h3>
                    </div>

                    <form action="<?php echo e(url('master/donation')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="card-body row">

                            <!-- QR Code & Payment Details -->
                            <div class="col-md-12 mb-4">
                                <div class="row d-flex align-items-center">
                                    <!-- QR Code -->
                                    <div class="col-md-6 text-center">
                                        <label><strong>Scan this QR Code to Pay</strong></label>
                                        <div>
                                            <img src="<?php echo e(asset($settings->upi_qr_code)); ?>" alt="Donation QR" class="img-fluid"
                                                style="max-width: 250px; border: 2px solid #ccc; border-radius: 10px;">
                                        </div>
                                    </div>

                                    <!-- Payment Details -->
                                    <div class="col-md-6">
                                        <div
                                            class="border rounded p-4 bg-light h-100 d-flex flex-column justify-content-center">
                                            <h5 class="mb-3"><strong>Payment Details</strong></h5>
                                            <p class="mb-2"><strong>Account Holder:</strong> <?php echo e($settings->account_holder); ?></p>
                                            <p class="mb-2"><strong>Bank Name:</strong> <?php echo e($settings->bank_name); ?></p>
                                            <p class="mb-2"><strong>Account Number:</strong> <?php echo e($settings->account_number); ?></p>
                                            <p class="mb-2"><strong>IFSC Code:</strong> <?php echo e($settings->ifsc_code); ?></p>
                                            <p class="mb-2"><strong>Branch Name:</strong> <?php echo e($settings->branch_name); ?></p>
                                            <p class="mb-0"><strong>UPI ID:</strong> <?php echo e($settings->upi_id); ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="payment_type">Type of Payment *</label>
                                    <select class="form-control" id="payment_type" name="payment_type" required disabled>
                                        <option value="membership" <?php if(session('type') || request('type') === 'membership'): ?> selected <?php endif; ?>>
                                            Membership Fee
                                        </option>
                                        <option value="donation" <?php if(!session('type') && request('type') !== 'membership'): ?> selected <?php endif; ?>>
                                            Donation
                                        </option>
                                    </select>
                                    <!-- hidden input to submit actual value since disabled won't post -->
                                    <input type="hidden" name="payment_type"
                                        value="<?php echo e(session('type') || request('type') === 'membership' ? 'membership' : 'donation'); ?>">
                                </div>
                            </div>


                            <!-- Amount Input -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="amount">Amount *</label>
                                    <input type="number" class="form-control" id="amount" name="amount"
                                        value="<?php echo e(session('amount') ?? request('amount')); ?>"
                                        <?php if(session('type') || request('type')): ?> readonly <?php endif; ?> required>

                                </div>
                            </div>

                            <!-- UTR Input -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="utr_number">UTR Number *</label>
                                    <input type="text" class="form-control" id="utr_number" name="utr_number"
                                        placeholder="Enter UTR Number" required>
                                </div>
                            </div>

                            <!-- Screenshot Upload -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="screenshot">Upload Payment Screenshot *</label>
                                    <input type="file" class="form-control" id="screenshot" name="screenshot"
                                        accept="image/*" required>
                                </div>
                            </div>

                        </div>

                        <!-- Changed btn-success → btn-primary -->
                        <div class="card-footer text-center">
                            <button type="submit" class="btn btn-primary">Submit Donation</button>
                        </div>
                    </form>
                </div>

            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(config('app.admin.view') . '.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\gmm\resources\views/admin/donation.blade.php ENDPATH**/ ?>