

<?php $__env->startSection('title'); ?>
    Dashboard
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="content-wrapper">

    <!-- Page Header -->
    <section class="content-header mb-4">
        <div class="container-fluid d-flex justify-content-between align-items-center">
            <h2 class="fw-bold text-dark mb-0">Dashboard</h2>
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item"><a href="#">Panel</a></li>
                <li class="breadcrumb-item active">Dashboard</li>
            </ol>
        </div>
    </section>

    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
        .content-wrapper {
            min-height: 100vh;
            padding: 25px;
            background: #f3f4f6; /* clean light background */
        }

        /* Premium Card */
        .premium-card {
            background: #fff;
            border-radius: 14px;
            box-shadow: 0 2px 12px rgba(0,0,0,0.06);
            padding: 28px 20px;
            transition: all 0.2s ease;
        }
        .premium-card:hover {
            box-shadow: 0 6px 18px rgba(0,0,0,0.08);
            transform: translateY(-3px);
        }

        /* Icon circle */
        .icon-circle {
            width: 56px;
            height: 56px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 22px;
            color: #fff;
            margin: 0 auto 14px;
        }
        .bg-volunteer { background: #2563eb; } /* premium blue */
        .bg-donation { background: #dc2626; }  /* premium red */
        .bg-activity { background: #059669; }  /* premium green */

        /* Counter */
        .counter {
            font-size: 34px;
            font-weight: 700;
            color: #111827;
            margin-bottom: 6px;
        }

        /* Labels */
        .card-label {
            font-size: 14px;
            font-weight: 500;
            color: #6b7280;
        }

        /* Section titles */
        .section-title {
            font-size: 18px;
            font-weight: 600;
            color: #111827;
            margin-bottom: 20px;
            border-left: 4px solid #6366f1;
            padding-left: 12px;
        }

        /* Buttons */
        .btn-premium {
            background: #111827;
            color: #fff;
            border: none;
            border-radius: 8px;
            padding: 6px 14px;
            font-size: 13px;
            font-weight: 500;
            transition: background 0.2s ease;
        }
        .btn-premium:hover {
            background: #374151;
            color: #fff;
        }
    </style>

    <!-- Main Content -->
    <section class="content">
        <div class="container-fluid">

            <!-- Welcome -->
            <div class="row mb-5">
                <div class="col-12 text-center">
                    <h1 class="fw-bold text-dark">Welcome to GMM EDUCATIONAL TRUST AND WELFARE ASSOCIATION 👋</h1>
                    <p class="text-secondary">Here’s a quick overview of your organization’s performance.</p>
                </div>
            </div>

            <!-- Today’s Summary -->
            <div class="row mb-5">
                <div class="col-12">
                    <h4 class="section-title">Today’s Overview</h4>
                </div>

                <div class="col-md-4 mb-4">
                    <div class="premium-card text-center">
                        <div class="icon-circle bg-volunteer"><i class="fas fa-user-friends"></i></div>
                        <div class="counter"><?php echo e($todayVolunteers); ?></div>
                        <div class="card-label">Volunteers Registered</div>
                    </div>
                </div>

                <div class="col-md-4 mb-4">
                    <div class="premium-card text-center">
                        <div class="icon-circle bg-donation"><i class="fas fa-hand-holding-usd"></i></div>
                        <div class="counter"><?php echo e($todayDonations); ?></div>
                        <div class="card-label">Donations Received</div>
                    </div>
                </div>

                <div class="col-md-4 mb-4">
                    <div class="premium-card text-center">
                        <div class="icon-circle bg-activity"><i class="fas fa-calendar-alt"></i></div>
                        <div class="counter"><?php echo e($todayMemberships); ?></div>
                        <div class="card-label">Memberships Applied</div>
                    </div>
                </div>
            </div>

            <!-- Totals -->
            <div class="row">
                <div class="col-12">
                    <h4 class="section-title">Total Records</h4>
                </div>

                <div class="col-xl-4 col-lg-6 col-md-6 mb-4">
                    <div class="premium-card text-center">
                        <div class="icon-circle bg-volunteer"><i class="fas fa-users"></i></div>
                        <div class="counter"><?php echo e($volunteersCount); ?></div>
                        <div class="card-label">Total Volunteers</div>
                        <a href="volunteer" class="btn btn-premium mt-3">View Report</a>
                    </div>
                </div>

                <div class="col-xl-4 col-lg-6 col-md-6 mb-4">
                    <div class="premium-card text-center">
                        <div class="icon-circle bg-donation"><i class="fas fa-donate"></i></div>
                        <div class="counter"><?php echo e($donationsCount); ?></div>
                        <div class="card-label">Total Donations</div>
                        <a href="donation-list" class="btn btn-premium mt-3">View Report</a>
                    </div>
                </div>

                <div class="col-xl-4 col-lg-6 col-md-6 mb-4">
                    <div class="premium-card text-center">
                        <div class="icon-circle bg-activity"><i class="fas fa-id-card"></i></div>
                        <div class="counter"><?php echo e($membershipsCount); ?></div>
                        <div class="card-label">Total Memberships</div>
                        <a href="membership-list" class="btn btn-premium mt-3">View Report</a>
                    </div>
                </div>
            </div>

        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(config('app.admin.view') . '.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/enexademo/public_html/gmmedu/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>