

<?php $__env->startSection('title', 'Membership Form'); ?>

<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">

        <!-- Page Header -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Apply for Membership</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Panel</a></li>
                            <li class="breadcrumb-item active">Membership</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <!-- Main Content -->
        <section class="content">
            <div class="container-fluid">

                
                <?php if($membership): ?>
                    <?php if($donation && $donation->status === 'confirmed'): ?>
                        <div class="alert alert-success">
                            You already have successfully applied for a membership.
                        </div>
                    <?php elseif($donation && $donation->status === 'pending'): ?>
                        <div class="alert alert-info">
                            You have successfully applied for membership. Please wait 24-48 hours to get confirmed.
                        </div>
                    <?php else: ?>
                        <div class="alert alert-warning">
                            You have already applied for membership but membership fee is not paid, Please pay ASAP.
                            <a href="<?php echo e(url('/master/donation?type=membership&amount=' . (int) $membershipFee)); ?>" class="btn btn-sm btn-primary ml-2">Pay Now</a>
                        </div>
                    <?php endif; ?>
                <?php else: ?>
                    
                    <div class="card card-primary shadow">
                        <div class="card-header">
                            <h3 class="card-title">Membership Registration Form</h3>
                        </div>

                        <form action="<?php echo e(url('master/membership')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="card-body row">

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="name">Full Name</label>
                                        <input type="text" class="form-control" id="name" name="name"
                                            value="<?php echo e($volunteer->name ?? ''); ?>" readonly>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="email">Email</label>
                                        <input type="email" class="form-control" id="email" name="email"
                                            value="<?php echo e($volunteer->email ?? ''); ?>" readonly>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="mobile">Phone Number</label>
                                        <input type="text" class="form-control" id="mobile" name="phone"
                                            value="<?php echo e($volunteer->phone ?? ''); ?>" readonly>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="dob">Date of Birth</label>
                                        <input type="date" class="form-control" id="dob" name="dob"
                                            value="<?php echo e($volunteer->dob ?? ''); ?>" readonly>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="qualification">Qualification</label>
                                        <input type="text" class="form-control" id="qualification" name="qualification"
                                            value="<?php echo e($volunteer->qualification ?? ''); ?>" readonly>
                                    </div>
                                </div>

                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="address">Address</label>
                                        <textarea name="address" id="address" class="form-control" rows="2" readonly><?php echo e($volunteer->address ?? ''); ?></textarea>
                                    </div>
                                </div>

                                <!-- PAN Card Field -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="pan_number">PAN Number *</label>
                                        <input type="text" class="form-control" id="pan_number" name="pan_number"
                                            value="<?php echo e(old('pan_number')); ?>" placeholder="Enter PAN Card Number"
                                            maxlength="10" style="text-transform: uppercase;" required>
                                    </div>
                                </div>

                                <!-- Aadhaar Card Field -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="aadhaar_number">Aadhaar Number *</label>
                                        <input type="text" class="form-control" id="aadhaar_number" name="aadhaar_number"
                                            value="<?php echo e(old('aadhaar_number')); ?>" placeholder="Enter Aadhaar Card Number"
                                            maxlength="12" required>
                                    </div>
                                </div>

                                <!-- Why Join Field (Optional) -->
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="why_join">Why do you want to become a member?</label>
                                        <textarea name="why_join" id="why_join" class="form-control" rows="3" placeholder="Write a few lines..."><?php echo e(old('why_join')); ?></textarea>
                                    </div>
                                </div>

                            </div>

                            <div class="card-footer text-center">
                                <button type="submit" class="btn btn-primary">Submit Membership</button>
                            </div>
                        </form>
                    </div>
                <?php endif; ?>

            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        // Aadhaar → only digits, max 12
        document.getElementById('aadhaar_number')?.addEventListener('input', function() {
            this.value = this.value.replace(/[^0-9]/g, ''); // only numbers
            if (this.value.length > 12) {
                this.value = this.value.slice(0, 12);
            }
        });

        // PAN → only A-Z & 0-9, auto uppercase, max 10
        document.getElementById('pan_number')?.addEventListener('input', function() {
            this.value = this.value.toUpperCase().replace(/[^A-Z0-9]/g, '').slice(0, 10);
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(config('app.admin.view') . '.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\gmm\resources\views/admin/membership.blade.php ENDPATH**/ ?>