@extends("layouts.master")

@isset($dynamic)

@section("title") {{ $dynamic->title }} @endsection
@section("meta_keywords") {{ $dynamic->meta_keywords }} @endsection
@section("meta_description") {{ $dynamic->meta_description }} @endsection

@isset($dynamic->image))
@section("share_image")assets/dynamic/meta/{{ $dynamic->image }}@endsection
@endisset


@section("additional") {!! $dynamic->additional !!} @endsection

@endisset

@section('content')


<main>

    <div class="slider-area">
        <div class="slider-height2 slider-bg4 hero-overly d-flex align-items-center" @isset($dynamic->banner) style="background-image: url({{ asset('assets/dynamic/banner/'.$dynamic->banner) }});" @endisset>
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-xl-5 col-lg-6 col-md-6">
                        <div class="hero-caption hero-caption2">
                            <h2>Announcement</h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    

    
    <section class="section-padding news-section">
      <div class="container">
        <div class="section-title">
          <h2>Latest <span1 class="text-theme">Announcements</span1></h2>
          <p>GMM EDUCATIONAL TRUST AND WELFARE ASSOCIATION is making a difference in people's lives. Read about our latest news and events that
            showcase our impactful initiatives.</p>
        </div>

        <div class="row">
            
                @foreach ($news as $item)
          <div class="col-lg-4 col-md-6">
            <article class="blog_item">
              <div class="blog_item_img">
                <img class="card-img rounded-0" loading="lazy" src="{{ asset('/assets/news/grid/' . $item->image) }}" alt="{{ $item->title }}">
                {{--<div class="blog_item_date">
                  <h3>{{ $item->created_at->format("d") }}</h3>
                  <p>{{ $item->created_at->format("M") }}</p>
                </div>--}}
              </div>
              <div class="blog_details" style="padding:30px !important">
                <h2 class="blog-head" style="color: #2d2d2d;">12 {{ $item->title }}</h2>
                <p>{{ $item->shortDescription() }}</p>
                <a href="{{ url('announcements/' . $item->slug) }}">Read More</a>

              </div>
            </article>
          </div>
          
        @endforeach
    </div>
      </div>
    </section>

</main>
@endsection       