@extends("layouts.master")

@isset($news)

@section("title") {{ $news->title }} @endsection
@section("meta_keywords") {{ $news->meta_keywords }} @endsection
@section("meta_description") {{ $news->meta_description }} @endsection

@isset($news->image)
@section("share_image")assets/news/meta/{{ $news->image }}@endsection
@endisset


@section("additional") {!! $news->additional !!} @endsection

@endisset

@section('content')

<main>

    <div class="slider-area" @isset($news->banner) style="background-image: url({{ asset('assets/news/banner/'.$news->banner) }});" @endisset>
        <div class="slider-height2 slider-bg4 hero-overly d-flex align-items-center">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-xl-8 col-lg-10 col-md-6">
                        <div class="hero-caption hero-caption2">
                            <h2>{{ $news->title }}</h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <section class="volunteer sec-padd">
        <div class="container">
            <div class="feature-style-one">
                <div class="row">
                    <div class="col-md-6 col-sm-12">
                        <div class="image">
                            <figure>
                                <img src="{{ asset('assets/news/details/'.$news->image) }}" alt="{{ $news->title }}">
                            </figure>
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <div class="content-sec">
                            <div class="solve-area-content">
                                <div class="section-title v2 text-left mb-1-9">
                                    <span class="sm-title">News</span>
                                    <h2 class="mb-0 h1">{{ $news->title }}</h2>
                                </div>
                                {!! $news->details !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

</main>
@endsection