@extends('layouts.master')

@isset($dynamic)

    @section('title')
        {{ $dynamic->title }}
    @endsection
    @section('meta_keywords')
        {{ $dynamic->meta_keywords }}
    @endsection
    @section('meta_description')
        {{ $dynamic->meta_description }}
    @endsection

    @isset($dynamic->image))
        @section('share_image')
            assets/dynamic/meta/{{ $dynamic->image }}
        @endsection
    @endisset


    @section('additional')
        {!! $dynamic->additional !!}
    @endsection

@endisset

@section('content')
    <main>

        <div class="slider-area">
            <div class="slider-height2 slider-bg4 hero-overly d-flex align-items-center"
                @isset($dynamic->banner) style="background-image: url({{ asset('assets/dynamic/banner/' . $dynamic->banner) }});" @endisset>
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-xl-5 col-lg-6 col-md-6">
                            <div class="hero-caption hero-caption2">
                                <h2>Our Gallery</h2>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <section class="section-padding news-section">
            <div class="container">
                <div class="section-title">
                    <h2>Our <span1 class="text-theme">Gallery</span1>
                    </h2>
                    <p>GMM EDUCATIONAL TRUST AND WELFARE ASSOCIATION is making a difference in people's lives.</p>
                </div>

                <div class="row">
                    @foreach ($gallery as $item)
                        <div class="col-lg-3 col-md-6 col-sm-6">
                            <div class="single-gallery-box">
                                <img src="public/assets/gallery/{{ $item->image }}" alt="{{ $item->title }}">

                                <a href="public/assets/gallery/{{ $item->image }}" class="gallery-btn"
                                    data-imagelightbox="popup-btn">
                                    <i class="fa fa-search"></i>
                                </a>
                            </div>
                            <h3 class="mb-4">{{ $item->title }}</h3>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>

    </main>
@endsection
